/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import erogenousbeef.bigreactors.common.multiblock.IPowerGenerator;
import erogenousbeef.bigreactors.common.multiblock.IPowerProvider;
import erogenousbeef.bigreactors.common.multiblock.PowerSystem;
import erogenousbeef.bigreactors.common.multiblock.tileentity.PowerTapHandler;
import it.zerono.mods.zerocore.api.multiblock.rectangular.RectangularMultiblockTileEntityBase;
import it.zerono.mods.zerocore.util.WorldHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.energy.IEnergyStorage;

public class PowerTapForgeHandler
extends PowerTapHandler
implements IEnergyStorage {
    @CapabilityInject(value=IEnergyStorage.class)
    private static Capability<IEnergyStorage> CAPAP_FORGE_ENERGYSTORAGE = null;
    private IEnergyStorage _consumer = null;

    public PowerTapForgeHandler(RectangularMultiblockTileEntityBase part) {
        super(part);
    }

    @Override
    public boolean isProviderConnected() {
        return null != this._consumer;
    }

    @Override
    public long onProvidePower(long units) {
        if (null == this._consumer) {
            return units;
        }
        int maxUnits = (int)Math.min(units, Integer.MAX_VALUE);
        int consumed = this._consumer.receiveEnergy(maxUnits, false);
        return maxUnits - consumed;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        IPowerGenerator generator = this.getPowerGenerator(null);
        return null == generator ? 0 : (int)generator.extractEnergy(Math.min((long)maxExtract, PowerSystem.RedstoneFlux.maxCapacity), simulate);
    }

    public int getEnergyStored() {
        IPowerGenerator generator = this.getPowerGenerator(null);
        return null == generator ? 0 : (int)Math.min(generator.getEnergyStored(), PowerSystem.RedstoneFlux.maxCapacity);
    }

    public int getMaxEnergyStored() {
        IPowerGenerator generator = this.getPowerGenerator(null);
        return null == generator ? 0 : (int)Math.min(generator.getEnergyCapacity(), PowerSystem.RedstoneFlux.maxCapacity);
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    @Override
    public void checkForConnections(IBlockAccess world, BlockPos position) {
        boolean wasConnected = this._consumer != null;
        EnumFacing approachDirection = this._part.getOutwardFacing();
        if (null == approachDirection) {
            wasConnected = false;
            this._consumer = null;
        } else {
            this._consumer = null;
            TileEntity te = world.func_175625_s(position.func_177972_a(approachDirection));
            approachDirection = approachDirection.func_176734_d();
            if (null != te && !(te instanceof IPowerProvider) && null != CAPAP_FORGE_ENERGYSTORAGE && te.hasCapability(CAPAP_FORGE_ENERGYSTORAGE, approachDirection)) {
                this._consumer = (IEnergyStorage)te.getCapability(CAPAP_FORGE_ENERGYSTORAGE, approachDirection);
            }
        }
        boolean isConnected = this._consumer != null;
        World partWorld = this._part.func_145831_w();
        if (wasConnected != isConnected && WorldHelper.calledByLogicalClient((World)partWorld)) {
            WorldHelper.notifyBlockUpdate((World)partWorld, (BlockPos)this._part.getWorldPosition(), null, null);
        }
    }
}

