/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.helpers;

import erogenousbeef.bigreactors.api.data.ReactantData;
import erogenousbeef.bigreactors.api.registry.Reactants;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.helpers.FuelContainer;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorControlRod;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorFuelRod;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FuelAssembly {
    private TileEntityReactorControlRod _controlRod;
    private FuelRodData[] _fuelRods;
    private EnumFacing _cachedOutwardFacing;
    private float _totalFuelQuota;
    private float _totalWasteQuota;
    private int _fuelColor = 0;
    private int _wasteColor = 0;
    private static final EnumFacing[] RADIATE_DIRECTIONS_X_AXIS = new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH, EnumFacing.DOWN, EnumFacing.SOUTH};
    private static final EnumFacing[] RADIATE_DIRECTIONS_Y_AXIS = EnumFacing.field_176754_o;
    private static final EnumFacing[] RADIATE_DIRECTIONS_Z_AXIS = new EnumFacing[]{EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.WEST, EnumFacing.UP};

    public FuelAssembly(TileEntityReactorControlRod controlRod) {
        if (null == controlRod || !this.build(controlRod)) {
            throw new IllegalStateException("Invalid fuel assembly");
        }
    }

    public TileEntityReactorControlRod getControlRod() {
        return this._controlRod;
    }

    public EnumFacing.Axis getAxis() {
        return this._cachedOutwardFacing.func_176740_k();
    }

    public EnumFacing[] getRadiateDirections() {
        switch (this.getAxis()) {
            case X: {
                return RADIATE_DIRECTIONS_X_AXIS;
            }
            default: {
                return RADIATE_DIRECTIONS_Y_AXIS;
            }
            case Z: 
        }
        return RADIATE_DIRECTIONS_Z_AXIS;
    }

    public int getFueldRodsCount() {
        return this._fuelRods.length;
    }

    public FuelRodData getFuelRodData(int rodIndex) {
        return rodIndex >= 0 && rodIndex < this._fuelRods.length ? this._fuelRods[rodIndex] : null;
    }

    @SideOnly(value=Side.CLIENT)
    public int getFuelColor() {
        return this._fuelColor;
    }

    @SideOnly(value=Side.CLIENT)
    public int getWasteColor() {
        return this._wasteColor;
    }

    public float getFuelQuota() {
        return this._totalFuelQuota;
    }

    public float getWasteQuota() {
        return this._totalWasteQuota;
    }

    public float getFuelRodFuelQuota() {
        return this._totalFuelQuota / (float)this.getFueldRodsCount();
    }

    public float getFuelRodWasteQuota() {
        return this._totalWasteQuota / (float)this.getFueldRodsCount();
    }

    public void updateReactants(FuelContainer data) {
        int color = this.getReactantColor(data.getFuelType());
        this._fuelColor = -1 == color ? 12368464 : color | 0xFF000000;
        color = this.getReactantColor(data.getWasteType());
        this._wasteColor = -1 == color ? 5083829 : color | 0xFF000000;
    }

    private int getReactantColor(String reactantName) {
        if (null == reactantName || reactantName.isEmpty()) {
            return -1;
        }
        ReactantData reactant = Reactants.getReactant(reactantName);
        return null == reactant ? -1 : reactant.getColor();
    }

    public void updateQuota(FuelContainer data, int fuelRodsTotalCount) {
        float fuel = data.getFuelAmount();
        float waste = data.getWasteAmount();
        int fuelRoundCount = this.getFueldRodsCount();
        this._totalFuelQuota = fuel / (float)fuelRodsTotalCount * (float)fuelRoundCount;
        this._totalWasteQuota = waste / (float)fuelRodsTotalCount * (float)fuelRoundCount;
        if (EnumFacing.Axis.Y == this.getAxis()) {
            float rodCapacity = 4000.0f;
            float remainingWaste = this._totalWasteQuota;
            float remainingFuel = this._totalFuelQuota;
            for (int i = 0; i < fuelRoundCount; ++i) {
                float fuelAmount;
                float wasteAmount;
                if (remainingWaste > 0.0f) {
                    wasteAmount = Math.min(remainingWaste, 4000.0f);
                    remainingWaste -= wasteAmount;
                } else {
                    wasteAmount = 0.0f;
                }
                if (remainingFuel > 0.0f) {
                    fuelAmount = Math.min(remainingFuel, 4000.0f - wasteAmount);
                    remainingFuel -= fuelAmount;
                } else {
                    fuelAmount = 0.0f;
                }
                this._fuelRods[i].update(fuelAmount, wasteAmount);
            }
        } else {
            float fuelPerRod = this._totalFuelQuota / (float)fuelRoundCount;
            float wastePerRod = this._totalWasteQuota / (float)fuelRoundCount;
            for (int i = 0; i < fuelRoundCount; ++i) {
                this._fuelRods[i].update(fuelPerRod, wastePerRod);
            }
        }
    }

    private boolean build(TileEntityReactorControlRod controlRod) {
        MultiblockReactor reactor = controlRod.getReactorController();
        this._controlRod = controlRod;
        this._cachedOutwardFacing = controlRod.getOutwardFacing();
        if (null == reactor || null == this._cachedOutwardFacing) {
            return false;
        }
        BlockPos minCoord = reactor.getMinimumCoord();
        BlockPos maxCoord = reactor.getMaximumCoord();
        BlockPos lookupPosition = controlRod.getWorldPosition();
        EnumFacing lookupDirection = this._cachedOutwardFacing.func_176734_d();
        int fuelRodsCount = 0;
        switch (this.getAxis()) {
            case X: {
                fuelRodsCount = maxCoord.func_177958_n() - minCoord.func_177958_n() - 1;
                break;
            }
            case Y: {
                fuelRodsCount = maxCoord.func_177956_o() - minCoord.func_177956_o() - 1;
                lookupPosition = new BlockPos(lookupPosition.func_177958_n(), minCoord.func_177956_o(), lookupPosition.func_177952_p());
                lookupDirection = EnumFacing.UP;
                break;
            }
            case Z: {
                fuelRodsCount = maxCoord.func_177952_p() - minCoord.func_177952_p() - 1;
            }
        }
        fuelRodsCount = Math.abs(fuelRodsCount);
        World world = controlRod.func_145831_w();
        this._fuelRods = new FuelRodData[fuelRodsCount];
        for (int i = 0; i < fuelRodsCount; ++i) {
            TileEntity te = world.func_175625_s(lookupPosition = lookupPosition.func_177972_a(lookupDirection));
            if (!(te instanceof TileEntityReactorFuelRod)) {
                return false;
            }
            this._fuelRods[i] = new FuelRodData((TileEntityReactorFuelRod)te);
            ((TileEntityReactorFuelRod)te).linkToAssembly(this);
        }
        return true;
    }

    public class FuelRodData {
        public final TileEntityReactorFuelRod Rod;
        private float _fuelAmount;
        private float _wasteAmount;

        public FuelRodData(TileEntityReactorFuelRod rod) {
            this.Rod = rod;
            this._fuelAmount = 0.0f;
            this._wasteAmount = 0.0f;
        }

        public float getFuelAmount() {
            return this._fuelAmount;
        }

        public float getWasteAmount() {
            return this._wasteAmount;
        }

        public void update(float fuelAmount, float wasteAmount) {
            this._fuelAmount = fuelAmount;
            this._wasteAmount = wasteAmount;
        }
    }
}

