/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common;

import erogenousbeef.bigreactors.api.registry.Reactants;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.MetalType;
import erogenousbeef.bigreactors.common.block.BlockBR;
import erogenousbeef.bigreactors.common.block.BlockBRGenericFluid;
import erogenousbeef.bigreactors.common.item.ItemBase;
import erogenousbeef.bigreactors.init.BrBlocks;
import erogenousbeef.bigreactors.init.BrItems;
import erogenousbeef.bigreactors.utils.intermod.IMCHelper;
import erogenousbeef.bigreactors.utils.intermod.ModHelperBase;
import erogenousbeef.bigreactors.utils.intermod.ModHelperComputerCraft;
import erogenousbeef.bigreactors.utils.intermod.ModHelperMekanism;
import it.zerono.mods.zerocore.lib.IModInitializationHandler;
import it.zerono.mods.zerocore.util.ItemHelper;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CommonProxy
implements IModInitializationHandler {
    public BlockBR register(BlockBR block) {
        GameRegistry.register((IForgeRegistryEntry)block);
        block.func_149647_a(BigReactors.TAB);
        block.onPostRegister();
        return block;
    }

    public BlockBRGenericFluid register(BlockBRGenericFluid block) {
        GameRegistry.register((IForgeRegistryEntry)block);
        block.func_149647_a(BigReactors.TAB);
        block.onPostRegister();
        return block;
    }

    public ItemBase register(ItemBase item) {
        GameRegistry.register((IForgeRegistryEntry)item);
        item.func_77637_a(BigReactors.TAB);
        item.onPostRegister();
        return item;
    }

    public void register(Class<? extends TileEntity> tileEntityClass) {
        GameRegistry.registerTileEntity(tileEntityClass, (String)("bigreactors" + tileEntityClass.getSimpleName()));
    }

    public void onPreInit(FMLPreInitializationEvent event) {
    }

    public void onInit(FMLInitializationEvent event) {
        this.sendInterModAPIMessages();
    }

    public void onPostInit(FMLPostInitializationEvent event) {
        if (BigReactors.CONFIG.autoAddUranium) {
            Reactants.registerSolid("ingotUranium", "yellorium");
        }
        this.registerWithOtherMods();
    }

    private void sendInterModAPIMessages() {
        ItemStack yelloriteOre = new ItemStack((Block)BrBlocks.brOre, 1);
        MetalType[] metals = MetalType.values();
        int length = metals.length;
        ItemStack[] ingots = new ItemStack[length];
        ItemStack[] dusts = new ItemStack[length];
        for (int i = 0; i < length; ++i) {
            ingots[i] = BrItems.ingotMetals.createItemStack(metals[i], 1);
            dusts[i] = BrItems.dustMetals.createItemStack(metals[i], 1);
        }
        ItemStack doubledYelloriumDust = BrItems.dustMetals.createItemStack(MetalType.Yellorium, 2);
        if (Loader.isModLoaded((String)"MineFactoryReloaded")) {
            IMCHelper.MFR.addOreToMiningLaserFocus(yelloriteOre, 2);
            IMCHelper.MFR.setMiningLaserFocusPreferredOre(yelloriteOre, 9);
        }
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            if (ItemHelper.stackIsValid((ItemStack)doubledYelloriumDust)) {
                IMCHelper.AE2.addGrinderRecipe(yelloriteOre, doubledYelloriumDust, 4);
            }
            for (int i = 0; i < ingots.length; ++i) {
                if (ingots[i] == null || dusts[i] == null) continue;
                IMCHelper.AE2.addGrinderRecipe(ingots[i], dusts[i], 2);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerIcons(TextureStitchEvent.Pre event) {
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void setIcons(TextureStitchEvent.Post event) {
    }

    void registerWithOtherMods() {
        ModHelperBase.detectMods();
        ModHelperBase modHelper = new ModHelperComputerCraft();
        modHelper.register();
        modHelper = new ModHelperMekanism();
        modHelper.register();
    }
}

