/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.lib;

import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import com.brandon3055.draconicevolution.network.PacketPlaySound;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.Bootstrap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class DESoundHandler {
    public static final Map<String, SoundEvent> SOUND_EVENTS = new HashMap<String, SoundEvent>();
    public static final SoundEvent energyBolt;
    public static final SoundEvent fusionComplete;
    public static final SoundEvent fusionRotation;
    public static final SoundEvent charge;
    public static final SoundEvent discharge;
    public static final SoundEvent boom;
    public static final SoundEvent beam;
    public static final SoundEvent portal;
    public static final SoundEvent shieldUp;
    public static final SoundEvent fusionExplosion;
    public static final SoundEvent chaosChamberAmbient;
    public static final SoundEvent coreSound;
    public static final SoundEvent shieldStrike;
    public static final SoundEvent electricBuzz;
    public static final SoundEvent sunDialEffect;

    private static SoundEvent getRegisteredSoundEvent(String id) {
        SoundEvent soundevent = new SoundEvent(new ResourceLocation(id));
        if (soundevent == null) {
            throw new IllegalStateException("Invalid Sound requested: " + id);
        }
        SOUND_EVENTS.put(id, soundevent);
        return soundevent;
    }

    public static SoundEvent getSound(String id) {
        if (SOUND_EVENTS.containsKey(id)) {
            return SOUND_EVENTS.get(id);
        }
        if (SoundEvent.field_187505_a.func_148741_d((Object)ResourceHelperDE.getResourceRAW(id))) {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)ResourceHelperDE.getResourceRAW(id));
        }
        return null;
    }

    public static void playSoundFromServer(World world, Vec3D pos, SoundEvent soundIn, SoundCategory category, float volume, float pitch, boolean distanceDelay, double range) {
        DESoundHandler.playSoundFromServer(world, pos.x, pos.y, pos.z, soundIn, category, volume, pitch, distanceDelay, range);
    }

    public static void playSoundFromServer(World world, double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch, boolean distanceDelay, double range) {
        Object o = ReflectionHelper.getPrivateValue(SoundEvent.class, (Object)soundIn, (String[])new String[]{"field_187506_b", "soundName"});
        if (o instanceof ResourceLocation) {
            o = o.toString();
        }
        if (o instanceof String) {
            String soundId = (String)o;
            String categoryName = category.func_187948_a();
            DraconicEvolution.network.sendToAllAround((IMessage)new PacketPlaySound(x, y, z, soundId, categoryName, volume, pitch, distanceDelay), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), x, y, z, range));
        }
    }

    static {
        if (!Bootstrap.func_179869_a()) {
            throw new RuntimeException("Accessed Sounds before Bootstrap!");
        }
        energyBolt = DESoundHandler.getRegisteredSoundEvent("draconicevolution:energy_bolt");
        fusionComplete = DESoundHandler.getRegisteredSoundEvent("draconicevolution:fusion_complete");
        fusionRotation = DESoundHandler.getRegisteredSoundEvent("draconicevolution:fusion_rotation");
        charge = DESoundHandler.getRegisteredSoundEvent("draconicevolution:charge");
        discharge = DESoundHandler.getRegisteredSoundEvent("draconicevolution:discharge");
        boom = DESoundHandler.getRegisteredSoundEvent("draconicevolution:boom");
        beam = DESoundHandler.getRegisteredSoundEvent("draconicevolution:beam");
        portal = DESoundHandler.getRegisteredSoundEvent("draconicevolution:portal");
        shieldUp = DESoundHandler.getRegisteredSoundEvent("draconicevolution:shield_up");
        fusionExplosion = DESoundHandler.getRegisteredSoundEvent("draconicevolution:fusion_explosion");
        chaosChamberAmbient = DESoundHandler.getRegisteredSoundEvent("draconicevolution:chaos_chamber_ambient");
        coreSound = DESoundHandler.getRegisteredSoundEvent("draconicevolution:core_sound");
        shieldStrike = DESoundHandler.getRegisteredSoundEvent("draconicevolution:shield_strike");
        electricBuzz = DESoundHandler.getRegisteredSoundEvent("draconicevolution:electric_buzz");
        sunDialEffect = DESoundHandler.getRegisteredSoundEvent("draconicevolution:sun_dial_effect");
    }
}

