/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.raytracer.RayTracer;
import com.brandon3055.brandonscore.inventory.BlockToStackHelper;
import com.brandon3055.brandonscore.inventory.InventoryDynamic;
import com.brandon3055.brandonscore.lib.PairKV;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.api.itemconfig.AOEConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.BooleanConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.IItemConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.IntegerConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.ItemConfigFieldRegistry;
import com.brandon3055.draconicevolution.api.itemconfig.ToolConfigHelper;
import com.brandon3055.draconicevolution.api.itemupgrade.UpgradeHelper;
import com.brandon3055.draconicevolution.entity.EntityLootCore;
import com.brandon3055.draconicevolution.items.tools.ToolBase;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.network.play.server.SPacketEntityTeleport;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public abstract class MiningToolBase
extends ToolBase {
    protected static final Set SHOVEL_OVERRIDES = Sets.newHashSet((Object[])new Block[]{Blocks.field_150435_aG, Blocks.field_150346_d, Blocks.field_150458_ak, Blocks.field_150349_c, Blocks.field_150351_n, Blocks.field_150391_bh, Blocks.field_150354_m, Blocks.field_150433_aE, Blocks.field_150431_aC, Blocks.field_150425_aM, Blocks.field_185774_da});
    protected static final Set PICKAXE_OVERRIDES = Sets.newHashSet((Object[])new Object[]{Blocks.field_150408_cc, Blocks.field_150365_q, Blocks.field_150347_e, Blocks.field_150319_E, Blocks.field_150484_ah, Blocks.field_150482_ag, Blocks.field_150334_T, Blocks.field_150318_D, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150432_aD, Blocks.field_150339_S, Blocks.field_150366_p, Blocks.field_150368_y, Blocks.field_150369_x, Blocks.field_150439_ay, Blocks.field_150341_Y, Blocks.field_150424_aL, Blocks.field_150403_cj, Blocks.field_150448_aq, Blocks.field_150450_ax, Blocks.field_150322_A, Blocks.field_180395_cM, Blocks.field_150348_b, Blocks.field_150333_U, Blocks.field_150430_aB, Blocks.field_150456_au, Blocks.field_150343_Z, Material.field_151576_e, Material.field_151573_f, Material.field_151574_g, Material.field_151592_s, Material.field_151594_q});
    protected static final Set AXE_OVERRIDES = Sets.newHashSet((Object[])new Object[]{Blocks.field_150344_f, Blocks.field_150342_X, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150486_ae, Blocks.field_150423_aK, Blocks.field_150428_aP, Blocks.field_150440_ba, Blocks.field_150468_ap, Blocks.field_150471_bO, Blocks.field_150452_aw, Material.field_151585_k, Material.field_151584_j, Material.field_151569_G, Material.field_151575_d, Material.field_151568_F, Material.field_151580_n, Material.field_76233_E});
    protected Set<Object> effectiveBlocks = new HashSet<Object>();
    protected float baseMiningSpeed = 1.0f;
    protected int baseAOE = 0;

    public MiningToolBase(double attackDamage, double attackSpeed, Set effectiveBlocks) {
        super(attackDamage, attackSpeed);
        this.effectiveBlocks.addAll(effectiveBlocks);
    }

    @Override
    public List<String> getValidUpgrades(ItemStack stack) {
        List<String> list = super.getValidUpgrades(stack);
        list.add("digSpeed");
        list.add("digAOE");
        return list;
    }

    @Override
    public ItemConfigFieldRegistry getFields(ItemStack stack, ItemConfigFieldRegistry registry) {
        super.getFields(stack, registry);
        registry.register(stack, new IntegerConfigField("digSpeed", 100, 1, 100, "config.field.digSpeed.description", IItemConfigField.EnumControlType.SLIDER).setExtension("%"));
        registry.register(stack, new BooleanConfigField("aoeSafeMode", false, "config.field.aoeSafeMode.description"));
        registry.register(stack, new BooleanConfigField("showDigAOE", false, "config.field.showDigAOE.description"));
        int maxAOE = this.baseAOE + UpgradeHelper.getUpgradeLevel(stack, "digAOE");
        registry.register(stack, new AOEConfigField("digAOE", 0, 0, maxAOE, "config.field.digAOE.description"));
        if (this.getToolTier(stack) > 0) {
            int depth = maxAOE * 2 + 1;
            registry.register(stack, new IntegerConfigField("digDepth", 0, 0, depth, "config.field.digDepth.description", IItemConfigField.EnumControlType.SLIDER));
        }
        return registry;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        int rad = this.getDigAOE(stack);
        int depth = this.getDigDepth(stack);
        int totalBlocks = rad * depth;
        if (this.getEnergyStored(stack) < this.energyPerOperation * totalBlocks) {
            return super.onBlockStartBreak(stack, pos, player);
        }
        if (rad > 0 || depth > 0) {
            return this.breakAOEBlocksNew(stack, pos, rad, depth, player);
        }
        return super.onBlockStartBreak(stack, pos, player);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        this.modifyEnergy(stack, -this.energyPerOperation);
        return super.func_179218_a(stack, worldIn, state, pos, entityLiving);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (this.getEnergyStored(stack) < this.energyPerOperation) {
            return 1.0f;
        }
        if (this.isToolEffective(stack, state)) {
            return this.getEfficiency(stack);
        }
        return 1.0f;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return this.isToolEffective(stack, state);
    }

    public boolean checkEnchantTypeValid(EnumEnchantmentType type) {
        return type == EnumEnchantmentType.DIGGER || type == EnumEnchantmentType.ALL;
    }

    public boolean breakAOEBlocks(ItemStack stack, BlockPos pos, int breakRadius, int breakDepth, EntityPlayer player) {
        IBlockState blockState = player.field_70170_p.func_180495_p(pos);
        if (!this.isToolEffective(stack, blockState)) {
            return false;
        }
        float refStrength = ForgeHooks.blockStrength((IBlockState)blockState, (EntityPlayer)player, (World)player.field_70170_p, (BlockPos)pos);
        PairKV<BlockPos, BlockPos> aoe = this.getMiningArea(pos, player, breakRadius, breakDepth);
        ArrayList aoeBlocks = Lists.newArrayList((Iterable)BlockPos.func_177980_a((BlockPos)((BlockPos)aoe.getKey()), (BlockPos)((BlockPos)aoe.getValue())));
        if (ToolConfigHelper.getBooleanField("aoeSafeMode", stack)) {
            for (BlockPos block : aoeBlocks) {
                if (player.field_70170_p.func_175623_d(block) || player.field_70170_p.func_175625_s(block) == null) continue;
                if (player.field_70170_p.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("msg.de.baseSafeAOW.txt", new Object[0]));
                } else {
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketBlockChange(((EntityPlayerMP)player).field_70170_p, block));
                }
                return true;
            }
        }
        for (BlockPos block : aoeBlocks) {
            this.breakExtraBlock(stack, player.field_70170_p, block, player, refStrength, new HashMap<Block, Integer>());
        }
        List items = player.field_70170_p.func_72872_a(EntityItem.class, new AxisAlignedBB((BlockPos)aoe.getKey(), ((BlockPos)aoe.getValue()).func_177982_a(1, 1, 1)));
        for (EntityItem item : items) {
            if (player.field_70170_p.field_72995_K) continue;
            item.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketEntityTeleport((Entity)item));
            item.func_174867_a(0);
            if (!DEConfig.rapidDespawnAOEMinedItems) continue;
            item.lifespan = 100;
        }
        player.field_70170_p.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)blockState));
        return true;
    }

    protected void breakExtraBlock(ItemStack stack, World world, BlockPos pos, EntityPlayer player, float refStrength, Map<Block, Integer> blockMap) {
        if (world.func_175623_d(pos)) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!this.isToolEffective(stack, state)) {
            return;
        }
        float strength = ForgeHooks.blockStrength((IBlockState)state, (EntityPlayer)player, (World)world, (BlockPos)pos);
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos) || refStrength / strength > 10.0f) {
            return;
        }
        if (player.field_71075_bZ.field_75098_d) {
            block.func_176208_a(world, pos, state, player);
            if (block.removedByPlayer(state, world, pos, player, false)) {
                block.func_176206_d(world, pos, state);
            }
            if (!world.field_72995_K) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
            } else if (field_77697_d.nextInt(10) == 0) {
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
            }
            return;
        }
        if (!world.field_72995_K) {
            int xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((EntityPlayerMP)player).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)pos);
            if (xp == -1) {
                return;
            }
            TileEntity tileEntity = world.func_175625_s(pos);
            if (block.removedByPlayer(state, world, pos, player, true)) {
                block.func_176206_d(world, pos, state);
                block.func_180657_a(world, player, pos, state, tileEntity, stack);
                block.func_180637_b(world, pos, xp);
            }
            stack.func_179548_a(world, state, pos, player);
            EntityPlayerMP mpPlayer = (EntityPlayerMP)player;
            mpPlayer.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        } else {
            if (field_77697_d.nextInt(10) == 0) {
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
            }
            if (block.removedByPlayer(state, world, pos, player, true)) {
                block.func_176206_d(world, pos, state);
            }
            stack.func_179548_a(world, state, pos, player);
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, pos, Minecraft.func_71410_x().field_71476_x.field_178784_b));
        }
    }

    public boolean breakAOEBlocksNew(ItemStack stack, BlockPos pos, int breakRadius, int breakDepth, EntityPlayer player) {
        IBlockState blockState = player.field_70170_p.func_180495_p(pos);
        if (!this.isToolEffective(stack, blockState)) {
            return false;
        }
        InventoryDynamic inventoryDynamic = new InventoryDynamic();
        float refStrength = ForgeHooks.blockStrength((IBlockState)blockState, (EntityPlayer)player, (World)player.field_70170_p, (BlockPos)pos);
        PairKV<BlockPos, BlockPos> aoe = this.getMiningArea(pos, player, breakRadius, breakDepth);
        ArrayList aoeBlocks = Lists.newArrayList((Iterable)BlockPos.func_177980_a((BlockPos)((BlockPos)aoe.getKey()), (BlockPos)((BlockPos)aoe.getValue())));
        if (ToolConfigHelper.getBooleanField("aoeSafeMode", stack)) {
            for (Object block : aoeBlocks) {
                if (player.field_70170_p.func_175623_d((BlockPos)block) || player.field_70170_p.func_175625_s((BlockPos)block) == null) continue;
                if (player.field_70170_p.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("msg.de.baseSafeAOW.txt", new Object[0]));
                } else {
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketBlockChange(((EntityPlayerMP)player).field_70170_p, (BlockPos)block));
                }
                return true;
            }
        }
        player.field_70170_p.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)blockState));
        for (Object block : aoeBlocks) {
            this.breakExtraBlockNew(stack, player.field_70170_p, (BlockPos)block, player, refStrength, inventoryDynamic);
        }
        List items = player.field_70170_p.func_72872_a(EntityItem.class, new AxisAlignedBB((BlockPos)aoe.getKey(), ((BlockPos)aoe.getValue()).func_177982_a(1, 1, 1)));
        for (EntityItem item : items) {
            if (player.field_70170_p.field_72995_K || item.field_70128_L) continue;
            InventoryUtils.insertItem((IInventory)inventoryDynamic, (ItemStack)item.func_92059_d(), (boolean)false);
            item.func_70106_y();
        }
        if (!player.field_70170_p.field_72995_K) {
            EntityLootCore lootCore = new EntityLootCore(player.field_70170_p, inventoryDynamic);
            lootCore.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            player.field_70170_p.func_72838_d((Entity)lootCore);
        }
        return true;
    }

    protected void breakExtraBlockNew(ItemStack stack, World world, BlockPos pos, EntityPlayer player, float refStrength, InventoryDynamic inventory) {
        if (world.func_175623_d(pos)) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!this.isToolEffective(stack, state)) {
            return;
        }
        float strength = ForgeHooks.blockStrength((IBlockState)state, (EntityPlayer)player, (World)world, (BlockPos)pos);
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos) || refStrength / strength > 10.0f) {
            return;
        }
        if (player.field_71075_bZ.field_75098_d) {
            if (world.field_72995_K && field_77697_d.nextInt(10) == 0) {
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
            }
            block.func_176208_a(world, pos, state, player);
            if (block.removedByPlayer(state, world, pos, player, false)) {
                block.func_176206_d(world, pos, state);
            }
            if (!world.field_72995_K) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
            }
            return;
        }
        if (!world.field_72995_K) {
            int xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((EntityPlayerMP)player).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)pos);
            if (xp == -1) {
                EntityPlayerMP mpPlayer = (EntityPlayerMP)player;
                mpPlayer.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
                return;
            }
            stack.func_179548_a(world, state, pos, player);
            BlockToStackHelper.breakAndCollectWithPlayer((World)world, (BlockPos)pos, (InventoryDynamic)inventory, (EntityPlayer)player, (int)xp);
        } else {
            if (field_77697_d.nextInt(10) == 0) {
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
            }
            if (block.removedByPlayer(state, world, pos, player, true)) {
                block.func_176206_d(world, pos, state);
            }
            stack.func_179548_a(world, state, pos, player);
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, pos, Minecraft.func_71410_x().field_71476_x.field_178784_b));
        }
    }

    public PairKV<BlockPos, BlockPos> getMiningArea(BlockPos pos, EntityPlayer player, int breakRadius, int breakDepth) {
        RayTraceResult traceResult = RayTracer.retrace((EntityPlayer)player, (double)4.5);
        if (traceResult == null || traceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new PairKV((Object)pos, (Object)pos);
        }
        int sideHit = traceResult.field_178784_b.func_176745_a();
        int xMax = breakRadius;
        int xMin = breakRadius;
        int yMax = breakRadius;
        int yMin = breakRadius;
        int zMax = breakRadius;
        int zMin = breakRadius;
        int yOffset = 0;
        switch (sideHit) {
            case 0: {
                yMax = breakDepth;
                yMin = 0;
                zMax = breakRadius;
                break;
            }
            case 1: {
                yMin = breakDepth;
                yMax = 0;
                zMax = breakRadius;
                break;
            }
            case 2: {
                xMax = breakRadius;
                zMin = 0;
                zMax = breakDepth;
                yOffset = breakRadius - 1;
                break;
            }
            case 3: {
                xMax = breakRadius;
                zMax = 0;
                zMin = breakDepth;
                yOffset = breakRadius - 1;
                break;
            }
            case 4: {
                xMax = breakDepth;
                xMin = 0;
                zMax = breakRadius;
                yOffset = breakRadius - 1;
                break;
            }
            case 5: {
                xMin = breakDepth;
                xMax = 0;
                zMax = breakRadius;
                yOffset = breakRadius - 1;
            }
        }
        if (breakRadius == 0) {
            yOffset = 0;
        }
        return new PairKV((Object)pos.func_177982_a(-xMin, yOffset - yMin, -zMin), (Object)pos.func_177982_a(xMax, yOffset + yMax, zMax));
    }

    public void setHarvestLevel(String toolClass, int level) {
        if (toolClass.equals("pickaxe") && level >= 0) {
            this.effectiveBlocks.addAll(PICKAXE_OVERRIDES);
        }
        if (toolClass.equals("shovel") && level >= 0) {
            this.effectiveBlocks.addAll(SHOVEL_OVERRIDES);
        }
        if (toolClass.equals("axe") && level >= 0) {
            this.effectiveBlocks.addAll(AXE_OVERRIDES);
        }
        super.setHarvestLevel(toolClass, level);
    }

    public float getEfficiency(ItemStack stack) {
        float speedSetting = (float)ToolConfigHelper.getIntegerField("digSpeed", stack) / 100.0f;
        return this.baseMiningSpeed * (float)(UpgradeHelper.getUpgradeLevel(stack, "digSpeed") + 1) * speedSetting;
    }

    public int getDigAOE(ItemStack stack) {
        return ToolConfigHelper.getIntegerField("digAOE", stack);
    }

    public int getDigDepth(ItemStack stack) {
        return ToolConfigHelper.getIntegerField("digDepth", stack);
    }

    public boolean isToolEffective(ItemStack stack, IBlockState state) {
        if (this.getEnergyStored(stack) < this.energyPerOperation) {
            return false;
        }
        for (String type : stack.func_77973_b().getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(type, state) && !this.effectiveBlocks.contains(state.func_177230_c()) && !this.effectiveBlocks.contains(state.func_185904_a())) continue;
            return true;
        }
        return false;
    }
}

