/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.armor;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.api.itemconfig.BooleanConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.IItemConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.IntegerConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.ItemConfigFieldRegistry;
import com.brandon3055.draconicevolution.api.itemconfig.ToolConfigHelper;
import com.brandon3055.draconicevolution.api.itemupgrade.UpgradeHelper;
import com.brandon3055.draconicevolution.client.model.ModelDraconicArmor;
import com.brandon3055.draconicevolution.integration.ModHelper;
import com.brandon3055.draconicevolution.items.armor.WyvernArmor;
import com.brandon3055.draconicevolution.items.tools.ToolStats;
import java.util.Collection;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DraconicArmor
extends WyvernArmor {
    private static ItemArmor.ArmorMaterial draconicMaterial = EnumHelper.addArmorMaterial((String)"draconicArmor", (String)"draconicevolution:draconic_armor", (int)-1, (int[])new int[]{3, 6, 8, 3}, (int)20, (SoundEvent)SoundEvents.field_187716_o, (float)3.0f);
    @SideOnly(value=Side.CLIENT)
    public ModelBiped model;

    public DraconicArmor(int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(draconicMaterial, renderIndexIn, equipmentSlotIn);
        this.baseProtectionPoints = 512.0f;
        this.baseRecovery = 4.0f;
    }

    public DraconicArmor(ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(materialIn, renderIndexIn, equipmentSlotIn);
        this.baseProtectionPoints = 512.0f;
        this.baseRecovery = 4.0f;
    }

    @Override
    public int getMaxUpgradeLevel(ItemStack stack, String upgrade) {
        return 3;
    }

    @Override
    public ItemConfigFieldRegistry getFields(ItemStack stack, ItemConfigFieldRegistry registry) {
        int i;
        int u;
        if (this.field_77881_a == EntityEquipmentSlot.HEAD) {
            registry.register(stack, new BooleanConfigField("armorNV", false, "config.field.armorNV.description"));
            registry.register(stack, new BooleanConfigField("armorNVLock", false, "config.field.armorNVLock.description"));
        }
        if (this.field_77881_a == EntityEquipmentSlot.CHEST) {
            registry.register(stack, new IntegerConfigField("armorFSpeedModifier", 0, 0, 600, "config.field.armorFSpeedModifier.description", IItemConfigField.EnumControlType.SLIDER).setPrefix("+").setExtension("%"));
            registry.register(stack, new IntegerConfigField("armorVFSpeedModifier", 0, 0, 600, "config.field.armorVFSpeedModifier.description", IItemConfigField.EnumControlType.SLIDER).setPrefix("+").setExtension("%"));
            registry.register(stack, new BooleanConfigField("armorInertiaCancel", false, "config.field.armorInertiaCancel.description"));
            registry.register(stack, new BooleanConfigField("armorFlightLock", false, "config.field.armorFlightLock.description"));
        }
        if (this.field_77881_a == EntityEquipmentSlot.LEGS) {
            u = UpgradeHelper.getUpgradeLevel(stack, "moveSpeed");
            i = 200 + 100 * u + Math.max(u - 1, 0) * 100 + Math.max(u - 2, 0) * 100;
            registry.register(stack, new IntegerConfigField("armorSpeedModifier", 0, 0, i, "config.field.armorSpeedModifier.description", IItemConfigField.EnumControlType.SLIDER).setPrefix("+").setExtension("%"));
        }
        if (this.field_77881_a == EntityEquipmentSlot.FEET) {
            u = UpgradeHelper.getUpgradeLevel(stack, "jumpBoost");
            i = 200 + 100 * u + Math.max(u - 1, 0) * 100 + Math.max(u - 2, 0) * 100;
            registry.register(stack, new IntegerConfigField("armorJumpModifier", 0, 0, i, "config.field.armorSpeedModifier.description", IItemConfigField.EnumControlType.SLIDER).setPrefix("+").setExtension("%"));
            registry.register(stack, new BooleanConfigField("armorHillStep", true, "config.field.armorHillStep.description"));
        }
        if (this.field_77881_a == EntityEquipmentSlot.FEET || this.field_77881_a == EntityEquipmentSlot.LEGS || this.field_77881_a == EntityEquipmentSlot.CHEST) {
            registry.register(stack, new BooleanConfigField("sprintBoost", false, "config.field.sprintBoost.description"));
        }
        return registry;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (DEConfig.disable3DModels) {
            return super.getArmorModel(entityLiving, itemStack, armorSlot, _default);
        }
        if (this.model == null) {
            this.model = this.field_77881_a == EntityEquipmentSlot.HEAD ? new ModelDraconicArmor(1.0f, true, false, false, false) : (this.field_77881_a == EntityEquipmentSlot.CHEST ? new ModelDraconicArmor(1.0f, false, true, false, false) : (this.field_77881_a == EntityEquipmentSlot.LEGS ? new ModelDraconicArmor(1.0f, false, false, true, false) : new ModelDraconicArmor(1.0f, false, false, false, true)));
            this.model.field_78116_c.field_78806_j = this.field_77881_a == EntityEquipmentSlot.HEAD;
            this.model.field_178720_f.field_78806_j = this.field_77881_a == EntityEquipmentSlot.HEAD;
            this.model.field_78115_e.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST || this.field_77881_a == EntityEquipmentSlot.LEGS;
            this.model.field_178724_i.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST;
            this.model.field_178723_h.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST;
            this.model.field_178722_k.field_78806_j = this.field_77881_a == EntityEquipmentSlot.LEGS || this.field_77881_a == EntityEquipmentSlot.FEET;
            boolean bl = this.model.field_178721_j.field_78806_j = this.field_77881_a == EntityEquipmentSlot.LEGS || this.field_77881_a == EntityEquipmentSlot.FEET;
        }
        if (entityLiving == null) {
            return this.model;
        }
        this.model.field_78117_n = entityLiving.func_70093_af();
        this.model.field_78093_q = entityLiving.func_184218_aH();
        this.model.field_78091_s = entityLiving.func_70631_g_();
        this.model.field_178720_f.field_78806_j = this.field_77881_a == EntityEquipmentSlot.HEAD;
        this.model.field_78115_e.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST || this.field_77881_a == EntityEquipmentSlot.LEGS;
        this.model.field_178724_i.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST;
        this.model.field_178723_h.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST;
        this.model.field_178722_k.field_78806_j = this.field_77881_a == EntityEquipmentSlot.LEGS || this.field_77881_a == EntityEquipmentSlot.FEET;
        this.model.field_178721_j.field_78806_j = this.field_77881_a == EntityEquipmentSlot.LEGS || this.field_77881_a == EntityEquipmentSlot.FEET;
        return this.model;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (stack.func_77973_b() == DEFeatures.draconicHelm) {
            Potion nv;
            if (world.field_72995_K) {
                return;
            }
            if (this.getEnergyStored(stack) >= 5000 && this.clearNegativeEffects((Entity)player)) {
                this.modifyEnergy(stack, -5000);
            }
            if ((nv = Potion.func_180142_b((String)"night_vision")) == null) {
                return;
            }
            if (ToolConfigHelper.getBooleanField("armorNV", stack) && (player.field_70170_p.func_175724_o(new BlockPos((int)Math.floor(player.field_70165_t), (int)player.field_70163_u + 1, (int)Math.floor(player.field_70161_v))) < 0.1f || ToolConfigHelper.getBooleanField("armorNVLock", stack))) {
                player.func_70690_d(new PotionEffect(nv, 419, 0, false, false));
            } else if (player.func_70644_a(nv)) {
                player.func_184589_d(nv);
            }
        }
    }

    public boolean clearNegativeEffects(Entity par3Entity) {
        boolean flag = false;
        if (par3Entity.field_70173_aa % 20 == 0 && par3Entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)par3Entity;
            Collection potions = player.func_70651_bq();
            if (player.func_70027_ad()) {
                player.func_70066_B();
            }
            for (PotionEffect potion : potions) {
                if (!potion.func_188419_a().func_76398_f()) continue;
                if (potion.func_76453_d().equals("effect.digSlowDown") && ModHelper.isHoldingCleaver(player)) break;
                player.func_184589_d(potion.func_188419_a());
                flag = true;
                break;
            }
        }
        return flag;
    }

    @Override
    public boolean hasHillStep(ItemStack stack, EntityPlayer player) {
        return ToolConfigHelper.getBooleanField("armorHillStep", stack);
    }

    @Override
    public float getFireResistance(ItemStack stack) {
        return 1.0f;
    }

    @Override
    public boolean[] hasFlight(ItemStack stack) {
        return new boolean[]{true, ToolConfigHelper.getBooleanField("armorFlightLock", stack), ToolConfigHelper.getBooleanField("armorInertiaCancel", stack)};
    }

    @Override
    public float getFlightSpeedModifier(ItemStack stack, EntityPlayer player) {
        float modifier = (float)ToolConfigHelper.getIntegerField("armorFSpeedModifier", stack) / 100.0f;
        if (ToolConfigHelper.getBooleanField("sprintBoost", stack) && !BrandonsCore.proxy.isSprintKeyDown()) {
            modifier /= 5.0f;
        }
        return modifier;
    }

    @Override
    public float getFlightVModifier(ItemStack stack, EntityPlayer player) {
        float modifier = (float)ToolConfigHelper.getIntegerField("armorVFSpeedModifier", stack) / 100.0f;
        if (ToolConfigHelper.getBooleanField("sprintBoost", stack) && !BrandonsCore.proxy.isSprintKeyDown()) {
            modifier /= 5.0f;
        }
        return modifier;
    }

    @Override
    public int getEnergyPerProtectionPoint() {
        return 1000;
    }

    @Override
    protected int getCapacity(ItemStack stack) {
        int level = UpgradeHelper.getUpgradeLevel(stack, "rfCap");
        if (level == 0) {
            return ToolStats.DRACONIC_BASE_CAPACITY;
        }
        return ToolStats.DRACONIC_BASE_CAPACITY * (int)Math.pow(2.0, level + 1);
    }

    @Override
    protected int getMaxReceive(ItemStack stack) {
        return 1000000;
    }
}

