/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.shaders;

import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.render.shader.pipeline.CCShaderPipeline;
import codechicken.lib.render.shader.pipeline.attribute.IShaderOperation;
import com.brandon3055.draconicevolution.DEConfig;
import gnu.trove.map.hash.TObjectFloatHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.opengl.ARBShaderObjects;

public class DEShaders {
    public static int reactorOpID;
    public static ShaderProgram reactor;
    public static ShaderProgram reactorShield;
    public static ReactorOperation reactorOp;
    public static int reactorBeamOpID;
    public static ShaderProgram reactorBeamI;
    public static ShaderProgram reactorBeamO;
    public static ShaderProgram reactorBeamE;
    public static ReactorBeamOperation reactorBeamOp;
    public static int crystalOpID;
    public static ShaderProgram energyCrystal;
    public static ECrystalOperation eCrystalOp;
    public static int explosionOverlayOpID;
    public static ShaderProgram explosionOverlay;
    public static ExplosionOverlayOp explosionOverlayOp;
    public static int explosionWaveOpID;
    public static ShaderProgram explosionBlastWave;
    public static ShaderProgram explosionLeadingWave;
    public static ShaderProgram explosionCoreEffect;
    public static ExplosionWaveOp explosionWaveOp;

    public static void initReactorShader() {
        if (reactor != null) {
            reactor.cleanup();
        }
        reactorOpID = CCShaderPipeline.registerOperation();
        reactor = new ShaderProgram();
        reactor.attachFrag("/assets/draconicevolution/shaders/reactor.frag");
        reactorOp = new ReactorOperation();
        reactor.attachShaderOperation((IShaderOperation)reactorOp);
        reactor.validate();
    }

    public static void initReactorShieldShader() {
        if (reactorShield != null) {
            reactorShield.cleanup();
        }
        reactorShield = new ShaderProgram();
        reactorShield.attachFrag("/assets/draconicevolution/shaders/reactor_shield.frag");
        reactorShield.attachShaderOperation((IShaderOperation)reactorOp);
        reactorShield.validate();
    }

    public static void initReactorBeams() {
        if (reactorBeamI != null) {
            reactorBeamI.cleanup();
        }
        reactorBeamOpID = CCShaderPipeline.registerOperation();
        reactorBeamI = new ShaderProgram();
        reactorBeamI.attachFrag("/assets/draconicevolution/shaders/reactor_beam_i.frag");
        reactorBeamOp = new ReactorBeamOperation();
        reactorBeamI.attachShaderOperation((IShaderOperation)reactorBeamOp);
        reactorBeamI.validate();
        if (reactorBeamO != null) {
            reactorBeamO.cleanup();
        }
        reactorBeamO = new ShaderProgram();
        reactorBeamO.attachFrag("/assets/draconicevolution/shaders/reactor_beam_o.frag");
        reactorBeamO.attachShaderOperation((IShaderOperation)reactorBeamOp);
        reactorBeamO.validate();
        if (reactorBeamE != null) {
            reactorBeamE.cleanup();
        }
        reactorBeamE = new ShaderProgram();
        reactorBeamE.attachFrag("/assets/draconicevolution/shaders/reactor_beam_e.frag");
        reactorBeamE.attachShaderOperation((IShaderOperation)reactorBeamOp);
        reactorBeamE.validate();
    }

    public static void initEnergyCrystalShader() {
        if (energyCrystal != null) {
            energyCrystal.cleanup();
        }
        crystalOpID = CCShaderPipeline.registerOperation();
        energyCrystal = new ShaderProgram();
        energyCrystal.attachFrag("/assets/draconicevolution/shaders/energy_crystal.frag");
        energyCrystal.attachVert("/assets/draconicevolution/shaders/energy_crystal.vert");
        eCrystalOp = new ECrystalOperation();
        energyCrystal.attachShaderOperation((IShaderOperation)eCrystalOp);
        energyCrystal.validate();
    }

    public static void initExplosionOverlay() {
        if (explosionOverlay != null) {
            explosionOverlay.cleanup();
        }
        explosionOverlayOpID = CCShaderPipeline.registerOperation();
        explosionOverlay = new ShaderProgram();
        explosionOverlay.attachFrag("/assets/draconicevolution/shaders/explosion_overlay.frag");
        explosionOverlayOp = new ExplosionOverlayOp();
        explosionOverlay.attachShaderOperation((IShaderOperation)explosionOverlayOp);
        explosionOverlay.validate();
    }

    public static void initExplosionWave() {
        if (explosionBlastWave != null) {
            explosionBlastWave.cleanup();
        }
        if (explosionLeadingWave != null) {
            explosionLeadingWave.cleanup();
        }
        explosionWaveOpID = CCShaderPipeline.registerOperation();
        explosionBlastWave = new ShaderProgram();
        explosionBlastWave.attachFrag("/assets/draconicevolution/shaders/explosion_blast_wave.frag");
        explosionWaveOp = new ExplosionWaveOp();
        explosionBlastWave.attachShaderOperation((IShaderOperation)explosionWaveOp);
        explosionBlastWave.validate();
        explosionLeadingWave = new ShaderProgram();
        explosionLeadingWave.attachFrag("/assets/draconicevolution/shaders/explosion_leading_wave.frag");
        explosionLeadingWave.attachShaderOperation((IShaderOperation)explosionWaveOp);
        explosionLeadingWave.validate();
        explosionCoreEffect = new ShaderProgram();
        explosionCoreEffect.attachFrag("/assets/draconicevolution/shaders/explosion_core_effect.frag");
        explosionCoreEffect.attachShaderOperation((IShaderOperation)explosionWaveOp);
        explosionCoreEffect.validate();
    }

    public static boolean useShaders() {
        return OpenGlHelper.field_148824_g && DEConfig.useShaders;
    }

    static {
        DEShaders.initReactorShader();
        DEShaders.initReactorShieldShader();
        DEShaders.initEnergyCrystalShader();
        DEShaders.initReactorBeams();
        DEShaders.initExplosionOverlay();
        DEShaders.initExplosionWave();
    }

    public static class ExplosionWaveOp
    implements IShaderOperation {
        float time = 0.0f;
        float scale = 0.0f;
        float alpha = 1.0f;

        public boolean load(ShaderProgram program) {
            return true;
        }

        public void operate(ShaderProgram program) {
            int t = program.getUniformLoc("time");
            ARBShaderObjects.glUniform1fARB((int)t, (float)this.time);
            int s = program.getUniformLoc("scale");
            ARBShaderObjects.glUniform1fARB((int)s, (float)this.scale);
            int a = program.getUniformLoc("alpha");
            ARBShaderObjects.glUniform1fARB((int)a, (float)this.alpha);
        }

        public int operationID() {
            return reactorOpID;
        }

        public void setTime(float time) {
            this.time = time;
        }

        public void setScale(float scale) {
            this.scale = scale;
        }

        public void setAlpha(float alpha) {
            this.alpha = alpha;
        }
    }

    public static class ExplosionOverlayOp
    implements IShaderOperation {
        float screenX = 0.0f;
        float screenY = 0.0f;
        float intensity = 0.0f;

        public boolean load(ShaderProgram program) {
            return true;
        }

        public void operate(ShaderProgram program) {
            int pos = program.getUniformLoc("screenPos");
            ARBShaderObjects.glUniform2fARB((int)pos, (float)this.screenX, (float)this.screenY);
            int intensity = program.getUniformLoc("intensity");
            ARBShaderObjects.glUniform1fARB((int)intensity, (float)this.intensity);
            int screenSize = program.getUniformLoc("screenSize");
            ARBShaderObjects.glUniform2fARB((int)screenSize, (float)Minecraft.func_71410_x().field_71443_c, (float)Minecraft.func_71410_x().field_71440_d);
        }

        public int operationID() {
            return reactorOpID;
        }

        public void setScreenPos(float x, float y) {
            this.screenX = x;
            this.screenY = y;
        }

        public void setIntensity(float intensity) {
            this.intensity = intensity;
        }
    }

    public static class ECrystalOperation
    implements IShaderOperation {
        public int type = 0;
        public float animation = 0.0f;
        public float angleX = 0.0f;
        public float angleY = 0.0f;
        public float mipmap = 1.0f;
        private final TObjectFloatHashMap<ShaderProgram> timeCache = new TObjectFloatHashMap();
        private final TObjectFloatHashMap<ShaderProgram> mipmapCache = new TObjectFloatHashMap();
        private final TObjectIntHashMap<ShaderProgram> typeCache = new TObjectIntHashMap();
        private final TObjectFloatHashMap<ShaderProgram> angleCache = new TObjectFloatHashMap();

        public boolean load(ShaderProgram program) {
            return true;
        }

        public void operate(ShaderProgram program) {
            if (this.animation != this.timeCache.get((Object)program)) {
                int time = program.getUniformLoc("time");
                ARBShaderObjects.glUniform1fARB((int)time, (float)this.animation);
                this.timeCache.put((Object)program, this.animation);
            }
            if (this.mipmap != this.mipmapCache.get((Object)program)) {
                int mipmap = program.getUniformLoc("mipmap");
                ARBShaderObjects.glUniform1fARB((int)mipmap, (float)this.mipmap);
                this.mipmapCache.put((Object)program, this.mipmap);
            }
            if (this.type != this.typeCache.get((Object)program)) {
                int type = program.getUniformLoc("type");
                ARBShaderObjects.glUniform1iARB((int)type, (int)this.type);
                this.typeCache.put((Object)program, this.type);
            }
            if (this.angleX * this.angleY != this.angleCache.get((Object)program)) {
                int angle = program.getUniformLoc("angle");
                ARBShaderObjects.glUniform2fARB((int)angle, (float)this.angleX, (float)this.angleY);
                this.angleCache.put((Object)program, this.angleX * this.angleY);
            }
        }

        public int operationID() {
            return crystalOpID;
        }

        public void setAnimation(float animation) {
            this.animation = animation;
        }

        public void setType(int type) {
            this.type = type;
        }

        public void setAngle(float angleX, float angleY) {
            this.angleX = angleX;
            this.angleY = angleY;
        }

        public void setMipmap(float mipmap) {
            this.mipmap = mipmap;
        }
    }

    public static class ReactorBeamOperation
    implements IShaderOperation {
        public float power = 0.0f;
        public float animation = 0.0f;
        public float fade = 0.0f;
        public float startup = 0.0f;

        public boolean load(ShaderProgram program) {
            return true;
        }

        public void operate(ShaderProgram program) {
            int time = program.getUniformLoc("time");
            ARBShaderObjects.glUniform1fARB((int)time, (float)this.animation);
            int intensity = program.getUniformLoc("power");
            ARBShaderObjects.glUniform1fARB((int)intensity, (float)this.power);
            int fade = program.getUniformLoc("fade");
            ARBShaderObjects.glUniform1fARB((int)fade, (float)this.fade);
            int startup = program.getUniformLoc("startup");
            ARBShaderObjects.glUniform1fARB((int)startup, (float)this.startup);
        }

        public int operationID() {
            return reactorOpID;
        }

        public void setAnimation(float animation) {
            this.animation = animation;
        }

        public void setPower(float power) {
            this.power = power;
        }

        public void setFade(float fade) {
            this.fade = fade;
        }

        public void setStartup(float startup) {
            this.startup = startup;
        }
    }

    public static class ReactorOperation
    implements IShaderOperation {
        public float intensity = 0.0f;
        public float animation = 0.0f;

        public boolean load(ShaderProgram program) {
            return true;
        }

        public void operate(ShaderProgram program) {
            int time = program.getUniformLoc("time");
            ARBShaderObjects.glUniform1fARB((int)time, (float)this.animation);
            int intensity = program.getUniformLoc("intensity");
            ARBShaderObjects.glUniform1fARB((int)intensity, (float)this.intensity);
        }

        public int operationID() {
            return reactorOpID;
        }

        public void setAnimation(float animation) {
            this.animation = animation;
        }

        public void setIntensity(float intensity) {
            this.intensity = intensity;
        }
    }
}

