/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client;

import codechicken.lib.model.loader.CCBakedModelLoader;
import codechicken.lib.model.loader.IBakedModelLoader;
import codechicken.lib.render.CCRenderEventHandler;
import codechicken.lib.texture.TextureUtils;
import com.brandon3055.draconicevolution.CommonProxy;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandler;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.blocks.reactor.ReactorEffectHandler;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.DETextureCache;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.WikiDocManager;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.keybinding.KeyBindings;
import com.brandon3055.draconicevolution.client.keybinding.KeyInputHandler;
import com.brandon3055.draconicevolution.client.model.ArmorModelHelper;
import com.brandon3055.draconicevolution.client.model.DEBakedModelProvider;
import com.brandon3055.draconicevolution.client.render.entity.LayerContributorWings;
import com.brandon3055.draconicevolution.client.render.entity.RenderChaosGuardian;
import com.brandon3055.draconicevolution.client.render.entity.RenderCustomArrow;
import com.brandon3055.draconicevolution.client.render.entity.RenderDragonHeart;
import com.brandon3055.draconicevolution.client.render.entity.RenderEntityChaosVortex;
import com.brandon3055.draconicevolution.client.render.entity.RenderGuardianCrystal;
import com.brandon3055.draconicevolution.client.render.entity.RenderGuardianProjectile;
import com.brandon3055.draconicevolution.client.render.entity.RenderLootCore;
import com.brandon3055.draconicevolution.entity.EntityChaosGuardian;
import com.brandon3055.draconicevolution.entity.EntityChaosImplosion;
import com.brandon3055.draconicevolution.entity.EntityCustomArrow;
import com.brandon3055.draconicevolution.entity.EntityDragonHeart;
import com.brandon3055.draconicevolution.entity.EntityGuardianCrystal;
import com.brandon3055.draconicevolution.entity.EntityGuardianProjectile;
import com.brandon3055.draconicevolution.entity.EntityLootCore;
import com.brandon3055.draconicevolution.lib.DEImageHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;

public class ClientProxy
extends CommonProxy {
    private static final boolean debug = DraconicEvolution.debug;
    public static String downloadLocation;
    public static LayerContributorWings layerWings;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        OBJLoader.INSTANCE.addDomain("draconicevolution");
        CCBakedModelLoader.registerLoader((IBakedModelLoader)DEBakedModelProvider.INSTANCE);
        DraconicEvolution.featureParser.registerRendering();
        DEImageHandler.init(event);
        TextureUtils.addIconRegister((TextureUtils.IIconRegister)new ArmorModelHelper());
        TextureUtils.addIconRegister((TextureUtils.IIconRegister)new DETextureCache());
        this.registerRendering();
        WikiDocManager.initialize();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        MinecraftForge.EVENT_BUS.register((Object)new KeyInputHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        KeyBindings.init();
        this.registerRenderIDs();
        CCRenderEventHandler.init();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        for (RenderPlayer renderPlayer : Minecraft.func_71410_x().func_175598_ae().getSkinMap().values()) {
            layerWings = new LayerContributorWings(renderPlayer);
            renderPlayer.func_177094_a((LayerRenderer)layerWings);
        }
    }

    public void registerRendering() {
        RenderingRegistry.registerEntityRenderingHandler(EntityChaosGuardian.class, (IRenderFactory)new RenderChaosGuardian.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityDragonHeart.class, (IRenderFactory)new RenderDragonHeart.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityGuardianProjectile.class, (IRenderFactory)new RenderGuardianProjectile.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityGuardianCrystal.class, (IRenderFactory)new RenderGuardianCrystal.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityChaosImplosion.class, (IRenderFactory)new RenderEntityChaosVortex.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityCustomArrow.class, (IRenderFactory)new RenderCustomArrow.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityLootCore.class, (IRenderFactory)new RenderLootCore.Factory());
    }

    public void registerRenderIDs() {
    }

    @Override
    public void registerParticles() {
        DEParticles.registerClient();
    }

    public boolean isOp(String paramString) {
        return Minecraft.func_71410_x().field_71441_e.func_72912_H().func_76077_q().func_77145_d();
    }

    @Override
    public ENetFXHandler createENetFXHandler(TileCrystalBase tile) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            return super.createENetFXHandler(tile);
        }
        return tile.createClientFXHandler();
    }

    @Override
    public ReactorEffectHandler createReactorFXHandler(TileReactorCore tile) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            return super.createReactorFXHandler(tile);
        }
        return new ReactorEffectHandler(tile);
    }

    @Override
    public ISound playISound(ISound sound) {
        FMLClientHandler.instance().getClient().func_147118_V().func_147682_a(sound);
        return sound;
    }
}

