/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity.flowgate;

import com.brandon3055.brandonscore.api.IDataRetainerTile;
import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.lib.IChangeListener;
import com.brandon3055.brandonscore.network.PacketTileMessage;
import com.brandon3055.brandonscore.network.wrappers.SyncableBool;
import com.brandon3055.brandonscore.network.wrappers.SyncableByte;
import com.brandon3055.brandonscore.network.wrappers.SyncableInt;
import com.brandon3055.brandonscore.network.wrappers.SyncableObject;
import com.brandon3055.draconicevolution.blocks.machines.FlowGate;
import com.brandon3055.draconicevolution.blocks.tileentity.flowgate.TileFluxGate;
import com.brandon3055.draconicevolution.integration.computers.ArgHelper;
import com.brandon3055.draconicevolution.integration.computers.IDEPeripheral;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileFlowGate
extends TileBCBase
implements IDataRetainerTile,
ITickable,
IChangeListener,
IDEPeripheral {
    protected int transferThisTick = 0;
    public final SyncableInt minFlow = new SyncableInt(0, true, false);
    public final SyncableInt maxFlow = new SyncableInt(0, true, false);
    public final SyncableInt flowOverride = new SyncableInt(0, true, false);
    public final SyncableBool flowOverridden = new SyncableBool(false, true, false);
    public final SyncableByte rsSignal = new SyncableByte(-1, true, false);

    public TileFlowGate() {
        this.registerSyncableObject((SyncableObject)this.minFlow, false);
        this.registerSyncableObject((SyncableObject)this.maxFlow, false);
        this.registerSyncableObject((SyncableObject)this.flowOverridden, true);
        this.registerSyncableObject((SyncableObject)this.rsSignal, true);
        this.registerSyncableObject((SyncableObject)this.flowOverride, true);
        this.setShouldRefreshOnBlockChange();
    }

    public void func_73660_a() {
        this.detectAndSendChanges();
        this.transferThisTick = 0;
    }

    public String getName() {
        return "tile.draconicevolution:" + (this instanceof TileFluxGate ? "flux_gate" : "fluid_gate") + ".name";
    }

    public abstract String getUnits();

    @SideOnly(value=Side.CLIENT)
    public void setMin(String value) {
        this.sendPacketToServer(new PacketTileMessage((TileBCBase)this, 0, value, false));
    }

    @SideOnly(value=Side.CLIENT)
    public void setMax(String value) {
        this.sendPacketToServer(new PacketTileMessage((TileBCBase)this, 1, value, false));
    }

    public int getFlow() {
        if (this.flowOverridden.value) {
            return this.flowOverride.value;
        }
        if (this.rsSignal.value == -1) {
            this.rsSignal.value = (byte)this.field_145850_b.func_175687_A(this.field_174879_c);
        }
        return this.minFlow.value + (int)((double)this.rsSignal.value / 15.0 * (double)(this.maxFlow.value - this.minFlow.value));
    }

    public void receivePacketFromClient(PacketTileMessage packet, EntityPlayerMP client) {
        PlayerInteractEvent.RightClickBlock event = new PlayerInteractEvent.RightClickBlock((EntityPlayer)client, EnumHand.MAIN_HAND, client.func_184614_ca(), this.field_174879_c, EnumFacing.UP, Vec3d.field_186680_a);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (this.flowOverridden.value || event.isCanceled() || packet.stringValue == null || packet.stringValue.equals("")) {
            return;
        }
        try {
            long l = Long.parseLong(packet.stringValue);
            if (l < 0L) {
                l = 0L;
            } else if (l > Integer.MAX_VALUE) {
                l = Integer.MAX_VALUE;
            }
            if (packet.getIndex() == 0) {
                this.minFlow.value = (int)l;
            } else if (packet.getIndex() == 1) {
                this.maxFlow.value = (int)l;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public TileEntity getTarget() {
        return this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.getDirection()));
    }

    public EnumFacing getDirection() {
        IBlockState state = this.getState(this.func_145838_q());
        return (EnumFacing)state.func_177229_b((IProperty)FlowGate.FACING);
    }

    public void onNeighborChange() {
        this.rsSignal.value = (byte)this.field_145850_b.func_175687_A(this.field_174879_c);
    }

    public void writeRetainedData(NBTTagCompound dataCompound) {
        for (SyncableObject syncableObject : this.syncableObjectMap.values()) {
            if (syncableObject == this.flowOverridden || syncableObject == this.rsSignal || syncableObject == this.flowOverride) continue;
            syncableObject.toNBT(dataCompound);
        }
    }

    public void readRetainedData(NBTTagCompound dataCompound) {
        for (SyncableObject syncableObject : this.syncableObjectMap.values()) {
            if (syncableObject == this.flowOverridden || syncableObject == this.rsSignal) continue;
            syncableObject.fromNBT(dataCompound);
        }
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"getFlow", "setOverrideEnabled", "getOverrideEnabled", "setFlowOverride", "setSignalHighFlow", "getSignalHighFlow", "setSignalLowFlow", "getSignalLowFlow"};
    }

    @Override
    public Object[] callMethod(String method, ArgHelper args) {
        if (method.equals("getFlow")) {
            return new Object[]{this.getFlow()};
        }
        if (method.equals("setOverrideEnabled")) {
            this.flowOverridden.value = args.checkBoolean(0);
        } else {
            if (method.equals("getOverrideEnabled")) {
                return new Object[]{this.flowOverridden};
            }
            if (method.equals("setFlowOverride")) {
                this.flowOverride.value = args.checkInteger(0);
            } else if (method.equals("setSignalHighFlow")) {
                this.maxFlow.value = args.checkInteger(0);
            } else {
                if (method.equals("getSignalHighFlow")) {
                    return new Object[]{this.maxFlow.value};
                }
                if (method.equals("setSignalLowFlow")) {
                    this.minFlow.value = args.checkInteger(0);
                } else if (method.equals("getSignalLowFlow")) {
                    return new Object[]{this.minFlow.value};
                }
            }
        }
        return new Object[0];
    }
}

