/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.api.IMultiBlock;
import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.lib.Vec3I;
import com.brandon3055.brandonscore.network.wrappers.SyncableObject;
import com.brandon3055.brandonscore.network.wrappers.SyncableVec3I;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.blocks.ParticleGenerator;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCoreStabilizer;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyPylon;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyStorageCore;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class TileInvisECoreBlock
extends TileBCBase
implements IMultiBlock {
    public final SyncableVec3I coreOffset = new SyncableVec3I(new Vec3I(0, -1, 0), true, false, true);
    public String blockName = "";

    public TileInvisECoreBlock() {
        this.registerSyncableObject((SyncableObject)this.coreOffset, true);
    }

    public boolean isStructureValid() {
        return this.getController() != null && this.getController().isStructureValid();
    }

    public boolean isController() {
        return false;
    }

    public IMultiBlock getController() {
        TileEntity tile = this.field_145850_b.func_175625_s(this.getCorePos());
        if (tile instanceof IMultiBlock) {
            return (IMultiBlock)tile;
        }
        this.revert();
        return null;
    }

    public boolean hasSatelliteStructures() {
        return false;
    }

    public LinkedList<IMultiBlock> getSatelliteControllers() {
        return null;
    }

    public boolean validateStructure() {
        IMultiBlock master = this.getController();
        if (master == null) {
            this.revert();
            return false;
        }
        return master.validateStructure();
    }

    public boolean onTileClicked(EntityPlayer player, IBlockState state) {
        IMultiBlock controller = this.getController();
        if (controller instanceof TileEnergyCoreStabilizer) {
            ((TileEnergyCoreStabilizer)controller).onTileClicked(this.field_145850_b, this.field_174879_c, state, player);
        } else if (controller instanceof TileEnergyStorageCore) {
            ((TileEnergyStorageCore)controller).onStructureClicked(this.field_145850_b, this.field_174879_c, state, player);
        } else if (controller instanceof TileEnergyPylon) {
            ((TileEnergyPylon)controller).isOutputMode.value = !((TileEnergyPylon)controller).isOutputMode.value;
        }
        return true;
    }

    public void revert() {
        if (this.blockName.equals("draconicevolution:particle_generator")) {
            this.field_145850_b.func_175656_a(this.field_174879_c, DEFeatures.particleGenerator.func_176223_P().func_177226_a((IProperty)ParticleGenerator.TYPE, (Comparable)((Object)"stabilizer")));
            return;
        }
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(this.blockName));
        if (block != null) {
            this.field_145850_b.func_175656_a(this.field_174879_c, block.func_176223_P());
        } else {
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
    }

    public void setController(IMultiBlock controller) {
        if (controller instanceof TileEntity) {
            this.coreOffset.vec = new Vec3I(this.field_174879_c.func_177973_b((Vec3i)((TileEntity)controller).func_174877_v()));
        }
    }

    private BlockPos getCorePos() {
        return this.field_174879_c.func_177982_a(-this.coreOffset.vec.x, -this.coreOffset.vec.y, -this.coreOffset.vec.z);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("BlockName", this.blockName);
        this.coreOffset.toNBT(compound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.blockName = pkt.func_148857_g().func_74779_i("BlockName");
        this.coreOffset.fromNBT(pkt.func_148857_g());
    }

    public void writeExtraNBT(NBTTagCompound compound) {
        compound.func_74778_a("BlockName", this.blockName);
    }

    public void readExtraNBT(NBTTagCompound compound) {
        this.blockName = compound.func_74779_i("BlockName");
    }
}

