/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.util.CCDirection;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import com.brandon3055.brandonscore.api.IMultiBlock;
import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.blocks.TileEnergyBase;
import com.brandon3055.brandonscore.client.particle.BCEffectHandler;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.Vec3I;
import com.brandon3055.brandonscore.network.wrappers.SyncableBool;
import com.brandon3055.brandonscore.network.wrappers.SyncableByte;
import com.brandon3055.brandonscore.network.wrappers.SyncableObject;
import com.brandon3055.brandonscore.network.wrappers.SyncableVec3I;
import com.brandon3055.brandonscore.utils.LinkedHashList;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.api.IExtendedRFStorage;
import com.brandon3055.draconicevolution.blocks.machines.EnergyPylon;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyStorageCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TileInvisECoreBlock;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.integration.computers.ArgHelper;
import com.brandon3055.draconicevolution.integration.computers.IDEPeripheral;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEnergyPylon
extends TileBCBase
implements IEnergyReceiver,
IEnergyProvider,
ITickable,
IMultiBlock,
IExtendedRFStorage,
IDEPeripheral {
    public final SyncableBool isOutputMode = new SyncableBool(false, true, false, true);
    public final SyncableBool structureValid = new SyncableBool(false, true, false, true);
    public final SyncableVec3I coreOffset = new SyncableVec3I(new Vec3I(0, -1, 0), true, false, false);
    public final SyncableBool sphereOnTop = new SyncableBool(true, false, false, false);
    private final SyncableBool hasCoreLock = new SyncableBool(false, true, false, false);
    private final SyncableByte particleRate = new SyncableByte(0, true, false, false);
    private TileEnergyStorageCore core = null;
    private int coreSelection = 0;
    private int tick = 0;
    private int lastCompOverride = 0;

    public TileEnergyPylon() {
        this.registerSyncableObject((SyncableObject)this.isOutputMode, true);
        this.registerSyncableObject((SyncableObject)this.structureValid, true);
        this.registerSyncableObject((SyncableObject)this.coreOffset, true);
        this.registerSyncableObject((SyncableObject)this.sphereOnTop, true);
        this.registerSyncableObject((SyncableObject)this.hasCoreLock, true);
        this.registerSyncableObject((SyncableObject)this.particleRate, false);
        this.setShouldRefreshOnBlockChange();
    }

    public void func_73660_a() {
        int extracted;
        this.detectAndSendChanges();
        if (!this.field_145850_b.field_72995_K && this.particleRate.value > 0) {
            this.particleRate.detectAndSendChanges((TileBCBase)this, null, true);
        }
        if (!(this.structureValid.value && this.hasCoreLock.value && this.getCore() != null && this.getCore().active.value)) {
            return;
        }
        if (this.tick++ % 10 == 0 && this.getExtendedCapacity() > 0L) {
            this.updateComparators();
        }
        if (!this.field_145850_b.field_72995_K && this.isOutputMode.value && (extracted = this.getCore().extractEnergy(TileEnergyBase.sendEnergyToAll((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c, (int)this.getEnergyStored(null)), false)) > 0) {
            this.particleRate.value = (byte)Math.min(20, extracted < 500 && extracted > 0 ? 1 : extracted / 500);
        }
        if (this.field_145850_b.field_72995_K) {
            this.spawnParticles();
        }
        if (this.particleRate.value > 1 || this.particleRate.value > 0 && this.field_145850_b.field_73012_v.nextInt(2) == 0) {
            this.particleRate.value = (byte)(this.particleRate.value - 2);
        }
    }

    public void updateComparators() {
        int cOut = (int)((double)this.getExtendedStorage() / (double)this.getExtendedCapacity() * 15.0);
        if (cOut != this.lastCompOverride) {
            this.lastCompOverride = cOut;
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
        }
    }

    private TileEnergyStorageCore getCore() {
        if (this.hasCoreLock.value) {
            BlockPos corePos = this.field_174879_c.func_177973_b((Vec3i)this.coreOffset.vec.getPos());
            Chunk coreChunk = this.field_145850_b.func_175726_f(corePos);
            if (!coreChunk.func_177410_o()) {
                this.core = null;
                return null;
            }
            TileEntity tileAtPos = coreChunk.func_177424_a(corePos, Chunk.EnumCreateEntityType.CHECK);
            if (tileAtPos == null || this.core == null || tileAtPos != this.core) {
                TileEntity tile = this.field_145850_b.func_175625_s(corePos);
                if (tile instanceof TileEnergyStorageCore) {
                    this.core = (TileEnergyStorageCore)tile;
                } else {
                    this.core = null;
                    this.hasCoreLock.value = false;
                }
            }
        }
        return this.core;
    }

    private List<TileEnergyStorageCore> findActiveCores() {
        LinkedHashList list = new LinkedHashList();
        int yMod = this.sphereOnTop.value ? 18 : -18;
        int range = 18;
        Iterable positions = BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(-range, -range + yMod, -range), (BlockPos)this.field_174879_c.func_177982_a(range, range + yMod, range));
        for (BlockPos blockPos : positions) {
            TileEntity tile;
            if (this.field_145850_b.func_180495_p(blockPos).func_177230_c() != DEFeatures.energyStorageCore || !((tile = this.field_145850_b.func_175625_s(blockPos)) instanceof TileEnergyStorageCore) || !((TileEnergyStorageCore)tile).active.value) continue;
            list.add((TileEnergyStorageCore)tile);
        }
        return list;
    }

    public void selectNextCore() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        List<TileEnergyStorageCore> cores = this.findActiveCores();
        if (cores.size() == 0) {
            this.core = null;
            this.hasCoreLock.value = false;
            return;
        }
        if (this.coreSelection >= cores.size()) {
            this.coreSelection = 0;
        }
        TileEnergyStorageCore selectedCore = cores.get(this.coreSelection);
        this.coreOffset.vec = new Vec3I(this.field_174879_c.func_177973_b((Vec3i)selectedCore.func_174877_v()));
        this.core = selectedCore;
        this.hasCoreLock.value = true;
        this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
        ++this.coreSelection;
        if (this.hasCoreLock.value) {
            this.drawParticleBeam();
        }
        this.updateBlock();
    }

    public boolean validateStructure() {
        if (!this.structureValid.value) {
            if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, 1, 0)).func_177230_c() == Blocks.field_150359_w) {
                this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(0, 1, 0), DEFeatures.invisECoreBlock.func_176223_P());
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 1, 0));
                if (tile instanceof TileInvisECoreBlock) {
                    ((TileInvisECoreBlock)tile).blockName = "minecraft:glass";
                    ((TileInvisECoreBlock)tile).setController(this);
                }
                this.sphereOnTop.value = true;
                this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)EnergyPylon.FACING, (Comparable)CCDirection.UP));
            } else if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, -1, 0)).func_177230_c() == Blocks.field_150359_w) {
                this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(0, -1, 0), DEFeatures.invisECoreBlock.func_176223_P());
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, -1, 0));
                if (tile instanceof TileInvisECoreBlock) {
                    ((TileInvisECoreBlock)tile).blockName = "minecraft:glass";
                    ((TileInvisECoreBlock)tile).setController(this);
                }
                this.sphereOnTop.value = false;
                this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)EnergyPylon.FACING, (Comparable)CCDirection.DOWN));
            } else {
                this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)EnergyPylon.FACING, (Comparable)CCDirection.UNKNOWN));
                return false;
            }
        }
        this.structureValid.value = this.isStructureValid();
        if (this.structureValid.value && !this.hasCoreLock.value) {
            this.selectNextCore();
        } else if (!this.structureValid.value && this.hasCoreLock.value) {
            this.hasCoreLock.value = false;
        }
        if (this.hasCoreLock.value && this.field_145850_b.field_72995_K) {
            this.drawParticleBeam();
        }
        return this.structureValid.value;
    }

    public boolean isStructureValid() {
        return !(!this.isGlass(this.field_174879_c.func_177982_a(0, 1, 0)) && !this.isGlass(this.field_174879_c.func_177982_a(0, -1, 0)) || this.isGlass(this.field_174879_c.func_177982_a(0, 1, 0)) && this.isGlass(this.field_174879_c.func_177982_a(0, -1, 0)));
    }

    private boolean isGlass(BlockPos pos) {
        TileEntity tile = this.field_145850_b.func_175625_s(pos);
        return tile instanceof TileInvisECoreBlock && ((TileInvisECoreBlock)tile).blockName.equals("minecraft:glass");
    }

    private void drawParticleBeam() {
        if (this.getCore() == null) {
            return;
        }
        BlockPos thisPos = this.field_174879_c.func_177982_a(0, this.sphereOnTop.value ? 1 : -1, 0);
        Vec3D coreVec = Vec3D.getDirectionVec((Vec3D)new Vec3D(thisPos).add(0.5, 0.5, 0.5), (Vec3D)new Vec3D(this.getCore().func_174877_v()).add(0.5, 0.5, 0.5));
        double coreDistance = Utils.getDistanceAtoB((Vec3D)new Vec3D(thisPos).add(0.5, 0.5, 0.5), (Vec3D)new Vec3D(this.getCore().func_174877_v().func_177963_a(0.5, 0.5, 0.5)));
        for (int i = 0; i < 100; ++i) {
            double location = (double)i / 100.0;
            Vec3D particlePos = new Vec3D(thisPos).add(0.5, 0.5, 0.5);
            particlePos.add(coreVec.x * coreDistance * location, coreVec.y * coreDistance * location, coreVec.z * coreDistance * location);
            double speed = 0.02f;
            double offset = 0.2f;
            double randX = this.field_145850_b.field_73012_v.nextDouble() - 0.5;
            double randY = this.field_145850_b.field_73012_v.nextDouble() - 0.5;
            double randZ = this.field_145850_b.field_73012_v.nextDouble() - 0.5;
            BCEffectHandler.spawnFX((int)DEParticles.LINE_INDICATOR, (World)this.field_145850_b, (Vec3D)particlePos.add(randX * offset, randY * offset, randZ * offset), (Vec3D)new Vec3D(randX * speed, randY * speed, randZ * speed), (int[])new int[]{150, 0, 255});
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles() {
        Random rand = this.field_145850_b.field_73012_v;
        if (this.getCore() == null || this.particleRate.value <= 0) {
            return;
        }
        if (this.particleRate.value > 20) {
            this.particleRate.value = (byte)20;
        }
        if (this.particleRate.value > 10) {
            for (int i = 0; i <= this.particleRate.value / 10; ++i) {
                Vec3D spawn = this.getParticleSpawn(rand);
                Vec3D dest = this.getParticleDest(rand);
                BCEffectHandler.spawnFX((int)DEParticles.ENERGY_PARTICLE, (World)this.field_145850_b, (Vec3D)spawn, (Vec3D)dest, (int[])new int[]{0, 200, 255, 200});
            }
        } else if (rand.nextInt(Math.max(1, 10 - this.particleRate.value)) == 0) {
            Vec3D spawn = this.getParticleSpawn(rand);
            Vec3D dest = this.getParticleDest(rand);
            BCEffectHandler.spawnFX((int)DEParticles.ENERGY_PARTICLE, (World)this.field_145850_b, (Vec3D)spawn, (Vec3D)dest, (int[])new int[]{0, 200, 255, 200});
        }
    }

    @SideOnly(value=Side.CLIENT)
    private Vec3D getParticleSpawn(Random random) {
        if (this.isOutputMode.value) {
            double range = this.getCore().tier.value;
            return new Vec3D(this.getCore().func_174877_v()).add((double)(random.nextFloat() - 0.5f) * range, (double)(random.nextFloat() - 0.5f) * range, (double)(random.nextFloat() - 0.5f) * range);
        }
        return this.sphereOnTop.value ? new Vec3D(this.field_174879_c).add(0.5, 1.5, 0.5) : new Vec3D(this.field_174879_c).add(0.5, -0.5, 0.5);
    }

    @SideOnly(value=Side.CLIENT)
    private Vec3D getParticleDest(Random random) {
        if (this.isOutputMode.value) {
            return this.sphereOnTop.value ? new Vec3D(this.field_174879_c).add(0.5, 1.5, 0.5) : new Vec3D(this.field_174879_c).add(0.5, -0.5, 0.5);
        }
        double range = (double)this.getCore().tier.value / 2.0;
        return new Vec3D(this.getCore().func_174877_v()).add((double)(random.nextFloat() - 0.5f) * range, (double)(random.nextFloat() - 0.5f) * range, (double)(random.nextFloat() - 0.5f) * range);
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public boolean isController() {
        return true;
    }

    public boolean hasSatelliteStructures() {
        return false;
    }

    public IMultiBlock getController() {
        return this;
    }

    public LinkedList<IMultiBlock> getSatelliteControllers() {
        return null;
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        if (!(this.hasCoreLock.value && this.isOutputMode.value && this.getCore() != null && this.getCore().active.value)) {
            return 0;
        }
        int extracted = this.getCore().extractEnergy(maxExtract, simulate);
        if (!simulate && extracted > 0) {
            this.particleRate.value = (byte)Math.min(20, extracted < 500 && extracted > 0 ? 1 : extracted / 500);
        }
        return extracted;
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (!this.hasCoreLock.value || this.isOutputMode.value || this.getCore() == null || !this.getCore().active.value) {
            return 0;
        }
        int received = this.getCore().receiveEnergy(maxReceive, simulate);
        if (!simulate && received > 0) {
            this.particleRate.value = (byte)Math.min(20, received < 500 && received > 0 ? 1 : received / 500);
        }
        return received;
    }

    public int getEnergyStored(EnumFacing from) {
        if (!this.hasCoreLock.value) {
            return 0;
        }
        return (int)Math.min(this.getCore().getExtendedStorage(), Integer.MAX_VALUE);
    }

    public int getMaxEnergyStored(EnumFacing from) {
        if (!this.hasCoreLock.value || this.getCore() == null) {
            return 0;
        }
        return (int)Math.min(this.getCore().getExtendedCapacity(), Integer.MAX_VALUE);
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return this.hasCoreLock.value;
    }

    @Override
    public long getExtendedStorage() {
        if (!this.hasCoreLock.value || this.getCore() == null) {
            return 0L;
        }
        return this.getCore().getExtendedStorage();
    }

    @Override
    public long getExtendedCapacity() {
        if (!this.hasCoreLock.value || this.getCore() == null) {
            return 0L;
        }
        return this.getCore().getExtendedCapacity();
    }

    @Override
    public String getPeripheralName() {
        return "draconic_rf_storage";
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"getEnergyStored", "getMaxEnergyStored", "getTransferPerTick"};
    }

    @Override
    public Object[] callMethod(String method, ArgHelper args) {
        if (method.equals("getEnergyStored")) {
            return new Object[]{this.getExtendedStorage()};
        }
        if (method.equals("getMaxEnergyStored")) {
            return new Object[]{this.getExtendedCapacity()};
        }
        if (method.equals("getTransferPerTick")) {
            if (!this.hasCoreLock.value || this.getCore() == null) {
                return new Object[0];
            }
            return new Object[]{this.getCore().transferRate.value};
        }
        return new Object[0];
    }
}

