/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.reactor;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.render.item.IItemRenderer;
import com.brandon3055.brandonscore.blocks.BlockBCore;
import com.brandon3055.brandonscore.config.Feature;
import com.brandon3055.brandonscore.config.ICustomRender;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.client.render.item.RenderItemReactorComponent;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileReactorCore;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ReactorCore
extends BlockBCore
implements ITileEntityProvider,
ICustomRender {
    private static final AxisAlignedBB NO_AABB = new AxisAlignedBB(0.5, 0.5, 0.5, 0.5, 0.5, 0.5);

    public ReactorCore() {
        this.setIsFullCube(false);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileReactorCore();
    }

    public float func_176195_g(IBlockState blockState, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileReactorCore) {
            return ((TileReactorCore.ReactorState)((TileReactorCore)tile).reactorState.value).isShieldActive() ? -1.0f : super.func_176195_g(blockState, world, pos);
        }
        return super.func_176195_g(blockState, world, pos);
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileReactorCore) {
            return ((TileReactorCore.ReactorState)((TileReactorCore)tile).reactorState.value).isShieldActive() ? 6000000.0f : super.getExplosionResistance(world, pos, exploder, explosion);
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRenderer(Feature feature) {
        ClientRegistry.bindTileEntitySpecialRenderer(TileReactorCore.class, (TileEntitySpecialRenderer)new RenderTileReactorCore());
        ModelRegistryHelper.registerItemRenderer((Item)Item.func_150898_a((Block)this), (IItemRenderer)new RenderItemReactorComponent());
    }

    public boolean registerNormal(Feature feature) {
        return false;
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return NO_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileReactorCore && ((TileReactorCore.ReactorState)((TileReactorCore)tile).reactorState.value).isShieldActive()) {
            return field_185506_k;
        }
        return super.func_180646_a(blockState, worldIn, pos);
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileReactorCore && ((TileReactorCore.ReactorState)((TileReactorCore)tile).reactorState.value).isShieldActive()) {
            return;
        }
        super.onBlockExploded(world, pos, explosion);
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        TileEntity tile;
        RayTraceResult result = super.func_180636_a(blockState, worldIn, pos, start, end);
        if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK && (tile = worldIn.func_175625_s(pos)) instanceof TileReactorCore && ((TileReactorCore.ReactorState)((TileReactorCore)tile).reactorState.value).isShieldActive()) {
            result = new RayTraceResult(RayTraceResult.Type.MISS, result.field_72307_f, result.field_178784_b, pos);
        }
        return result;
    }
}

