/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.lexicon.page;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.internal.IGuiLexiconEntry;
import vazkii.botania.api.lexicon.LexiconPage;
import vazkii.botania.api.lexicon.multiblock.Multiblock;
import vazkii.botania.api.lexicon.multiblock.MultiblockSet;
import vazkii.botania.client.core.handler.MultiblockRenderHandler;
import vazkii.botania.client.core.helper.RenderHelper;

public class PageMultiblock
extends LexiconPage {
    private static final ResourceLocation multiblockOverlay = new ResourceLocation("botania:textures/gui/multiblockOverlay.png");
    GuiButton button;
    final MultiblockSet set;
    final Multiblock mb;
    int ticksElapsed;

    public PageMultiblock(String unlocalizedName, MultiblockSet set) {
        super(unlocalizedName);
        this.mb = set.getForFacing(EnumFacing.SOUTH);
        this.set = set;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderScreen(IGuiLexiconEntry gui, int mx, int my) {
        TextureManager render = Minecraft.func_71410_x().field_71446_o;
        render.func_110577_a(multiblockOverlay);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179118_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ((GuiScreen)gui).func_73729_b(gui.getLeft(), gui.getTop(), 0, 0, gui.getWidth(), gui.getHeight());
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        float maxX = 90.0f;
        float maxY = 60.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(gui.getLeft() + gui.getWidth() / 2), (float)(gui.getTop() + 90), (float)(gui.getZLevel() + 100.0f));
        float diag = (float)Math.sqrt(this.mb.getXSize() * this.mb.getXSize() + this.mb.getZSize() * this.mb.getZSize());
        float height = this.mb.getYSize();
        float scaleX = 90.0f / diag;
        float scaleY = 60.0f / height;
        float scale = -Math.min(scaleY, scaleX);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)-20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)gui.getElapsedTicks(), (float)0.0f, (float)1.0f, (float)0.0f);
        MultiblockRenderHandler.renderMultiblockOnPage(this.mb);
        GlStateManager.func_179121_F();
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        boolean unicode = font.func_82883_a();
        String s = TextFormatting.BOLD + I18n.func_135052_a((String)this.getUnlocalizedName(), (Object[])new Object[0]);
        font.func_78264_a(true);
        font.func_78276_b(s, gui.getLeft() + gui.getWidth() / 2 - font.func_78256_a(s) / 2, gui.getTop() + 16, 0);
        font.func_78264_a(unicode);
        GlStateManager.func_179091_B();
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
        int x = gui.getLeft() + 15;
        int y = gui.getTop() + 25;
        Minecraft.func_71410_x().func_175599_af().func_175042_a(new ItemStack(Blocks.field_150417_aV), x, y);
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
        if (mx >= x && mx < x + 16 && my >= y && my < y + 16) {
            ArrayList<String> mats = new ArrayList<String>();
            mats.add(I18n.func_135052_a((String)"botaniamisc.materialsRequired", (Object[])new Object[0]));
            for (ItemStack stack : this.mb.materials) {
                String size = "" + stack.field_77994_a;
                if (size.length() < 2) {
                    size = "0" + size;
                }
                mats.add(" " + TextFormatting.AQUA + size + " " + TextFormatting.GRAY + stack.func_82833_r());
            }
            RenderHelper.renderTooltip(mx, my, mats);
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void onOpened(IGuiLexiconEntry gui) {
        this.button = new GuiButton(101, gui.getLeft() + 30, gui.getTop() + gui.getHeight() - 50, gui.getWidth() - 60, 20, this.getButtonStr());
        gui.getButtonList().add(this.button);
    }

    @SideOnly(value=Side.CLIENT)
    private String getButtonStr() {
        return I18n.func_135052_a((String)(MultiblockRenderHandler.currentMultiblock == this.set ? "botaniamisc.unvisualize" : "botaniamisc.visualize"), (Object[])new Object[0]);
    }

    @Override
    public void onClosed(IGuiLexiconEntry gui) {
        gui.getButtonList().remove(this.button);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onActionPerformed(IGuiLexiconEntry gui, GuiButton button) {
        if (button == this.button) {
            if (MultiblockRenderHandler.currentMultiblock == this.set) {
                MultiblockRenderHandler.setMultiblock(null);
            } else {
                MultiblockRenderHandler.setMultiblock(this.set);
            }
            button.field_146126_j = this.getButtonStr();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateScreen() {
        ++this.ticksElapsed;
    }
}

