/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.api.corporea.InvWithLocation;
import vazkii.botania.common.core.helper.InventoryHelper;
import vazkii.botania.common.entity.EntitySpark;
import vazkii.botania.common.item.ModItems;

public class EntityCorporeaSpark
extends Entity
implements ICorporeaSpark {
    private static final int SCAN_RANGE = 8;
    private static final String TAG_MASTER = "master";
    private static final String TAG_NETWORK = "network";
    private static final String TAG_INVIS = "invis";
    private static final DataParameter<Boolean> MASTER = EntityDataManager.func_187226_a(EntityCorporeaSpark.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> NETWORK = EntityDataManager.func_187226_a(EntityCorporeaSpark.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> INVISIBILITY = EntityDataManager.func_187226_a(EntityCorporeaSpark.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ITEM_DISPLAY_TICKS = EntityDataManager.func_187226_a(EntityCorporeaSpark.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<ItemStack>> DISPLAY_STACK = EntityDataManager.func_187226_a(EntityCorporeaSpark.class, (DataSerializer)DataSerializers.field_187196_f);
    private ICorporeaSpark master;
    private List<ICorporeaSpark> connections = new ArrayList<ICorporeaSpark>();
    private List<ICorporeaSpark> relatives = new ArrayList<ICorporeaSpark>();
    private boolean firstTick = true;

    public EntityCorporeaSpark(World world) {
        super(world);
        this.field_70178_ae = true;
    }

    protected void func_70088_a() {
        this.func_70105_a(0.1f, 0.5f);
        this.field_70180_af.func_187214_a(INVISIBILITY, (Object)0);
        this.field_70180_af.func_187214_a(MASTER, (Object)false);
        this.field_70180_af.func_187214_a(NETWORK, (Object)0);
        this.field_70180_af.func_187214_a(ITEM_DISPLAY_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(DISPLAY_STACK, (Object)Optional.absent());
    }

    @Nonnull
    public ItemStack getPickedResult(RayTraceResult target) {
        return this.isMaster() ? new ItemStack(ModItems.corporeaSpark, 1, 1) : new ItemStack(ModItems.corporeaSpark);
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70071_h_() {
        int displayTicks;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        InvWithLocation inv = this.getSparkInventory();
        if (inv == null) {
            this.dropAndKill();
            return;
        }
        if (this.isMaster()) {
            this.master = this;
        }
        if (this.firstTick) {
            if (this.isMaster()) {
                this.restartNetwork();
            } else {
                this.findNetwork();
            }
            this.firstTick = false;
        }
        if (this.master != null && (((Entity)this.master).field_70128_L || this.master.getNetwork() != this.getNetwork())) {
            this.master = null;
        }
        if ((displayTicks = this.getItemDisplayTicks()) > 0) {
            this.setItemDisplayTicks(displayTicks - 1);
        } else if (displayTicks < 0) {
            this.setItemDisplayTicks(displayTicks + 1);
        }
    }

    private void dropAndKill() {
        this.func_70099_a(new ItemStack(ModItems.corporeaSpark, 1, this.isMaster() ? 1 : 0), 0.0f);
        this.func_70106_y();
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.connections.remove(this);
        this.restartNetwork();
    }

    @Override
    public void registerConnections(ICorporeaSpark master, ICorporeaSpark referrer, List<ICorporeaSpark> connections) {
        List<ICorporeaSpark> sparks = this.getNearbySparks();
        this.relatives.clear();
        for (ICorporeaSpark spark : sparks) {
            if (spark == null || connections.contains(spark) || spark.getNetwork() != this.getNetwork() || spark.isMaster() || ((Entity)spark).field_70128_L) continue;
            connections.add(spark);
            this.relatives.add(spark);
            spark.registerConnections(master, this, connections);
        }
        this.master = master;
        this.connections = connections;
    }

    private List<ICorporeaSpark> getNearbySparks() {
        List ret = this.field_70170_p.func_175647_a(Entity.class, new AxisAlignedBB(this.field_70165_t - 8.0, this.field_70163_u - 8.0, this.field_70161_v - 8.0, this.field_70165_t + 8.0, this.field_70163_u + 8.0, this.field_70161_v + 8.0), Predicates.instanceOf(ICorporeaSpark.class));
        return ret;
    }

    private void restartNetwork() {
        this.connections = new ArrayList<ICorporeaSpark>();
        this.relatives = new ArrayList<ICorporeaSpark>();
        if (this.master != null) {
            ICorporeaSpark oldMaster = this.master;
            this.master = null;
            oldMaster.registerConnections(oldMaster, this, new ArrayList<ICorporeaSpark>());
        }
    }

    private void findNetwork() {
        List<ICorporeaSpark> sparks = this.getNearbySparks();
        if (sparks.size() > 0) {
            for (ICorporeaSpark spark : sparks) {
                ICorporeaSpark master;
                if (spark.getNetwork() != this.getNetwork() || ((Entity)spark).field_70128_L || (master = spark.getMaster()) == null) continue;
                this.master = master;
                this.restartNetwork();
                break;
            }
        }
    }

    private static void displayRelatives(EntityPlayer player, List<ICorporeaSpark> checked, ICorporeaSpark spark) {
        if (spark == null) {
            return;
        }
        List<ICorporeaSpark> sparks = spark.getRelatives();
        if (sparks.isEmpty()) {
            EntitySpark.particleBeam(player, (Entity)spark, (Entity)spark.getMaster());
        } else {
            for (ICorporeaSpark endSpark : sparks) {
                if (checked.contains(endSpark)) continue;
                EntitySpark.particleBeam(player, (Entity)spark, (Entity)endSpark);
                checked.add(endSpark);
                EntityCorporeaSpark.displayRelatives(player, checked, endSpark);
            }
        }
    }

    @Override
    public InvWithLocation getSparkInventory() {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)(this.field_70163_u - 1.0));
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        return InventoryHelper.getInventoryWithLocation(this.field_70170_p, new BlockPos(x, y, z), EnumFacing.UP);
    }

    @Override
    public List<ICorporeaSpark> getConnections() {
        return this.connections;
    }

    @Override
    public List<ICorporeaSpark> getRelatives() {
        return this.relatives;
    }

    @Override
    public void onItemExtracted(ItemStack stack) {
        this.setItemDisplayTicks(10);
        this.setDisplayedItem(stack);
    }

    @Override
    public void onItemsRequested(List<ItemStack> stacks) {
        if (!stacks.isEmpty()) {
            this.setItemDisplayTicks(-10);
            this.setDisplayedItem(stacks.get(0));
        }
    }

    @Override
    public ICorporeaSpark getMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.field_70180_af.func_187227_b(MASTER, (Object)master);
    }

    @Override
    public boolean isMaster() {
        return (Boolean)this.field_70180_af.func_187225_a(MASTER);
    }

    public void setNetwork(EnumDyeColor network) {
        this.field_70180_af.func_187227_b(NETWORK, (Object)network.func_176765_a());
    }

    @Override
    public EnumDyeColor getNetwork() {
        return EnumDyeColor.func_176764_b((int)((Integer)this.field_70180_af.func_187225_a(NETWORK)));
    }

    public int getItemDisplayTicks() {
        return (Integer)this.field_70180_af.func_187225_a(ITEM_DISPLAY_TICKS);
    }

    public void setItemDisplayTicks(int ticks) {
        this.field_70180_af.func_187227_b(ITEM_DISPLAY_TICKS, (Object)ticks);
    }

    public Optional<ItemStack> getDisplayedItem() {
        return (Optional)this.field_70180_af.func_187225_a(DISPLAY_STACK);
    }

    public void setDisplayedItem(ItemStack stack) {
        this.field_70180_af.func_187227_b(DISPLAY_STACK, (Object)Optional.fromNullable((Object)stack));
    }

    public boolean func_184230_a(EntityPlayer player, ItemStack stack, EnumHand hand) {
        if (stack != null) {
            int color;
            if (stack.func_77973_b() == ModItems.twigWand) {
                if (player.func_70093_af()) {
                    if (!player.field_70170_p.field_72995_K) {
                        this.dropAndKill();
                        if (this.isMaster()) {
                            this.restartNetwork();
                        }
                    } else {
                        player.func_184609_a(hand);
                    }
                    return true;
                }
                if (!player.field_70170_p.field_72995_K) {
                    EntityCorporeaSpark.displayRelatives(player, new ArrayList<ICorporeaSpark>(), this.master);
                }
                return true;
            }
            if (stack.func_77973_b() == ModItems.dye && (color = stack.func_77952_i()) != this.getNetwork().func_176765_a()) {
                if (!this.field_70170_p.field_72995_K) {
                    this.setNetwork(EnumDyeColor.func_176764_b((int)color));
                    if (this.master != null) {
                        this.restartNetwork();
                    } else {
                        this.findNetwork();
                    }
                    --stack.field_77994_a;
                } else {
                    player.func_184609_a(hand);
                }
            }
        }
        return this.doPhantomInk(stack);
    }

    public boolean doPhantomInk(ItemStack stack) {
        if (stack != null && stack.func_77973_b() == ModItems.phantomInk && !this.field_70170_p.field_72995_K) {
            int invis = (Integer)this.field_70180_af.func_187225_a(INVISIBILITY);
            this.field_70180_af.func_187227_b(INVISIBILITY, (Object)(~invis & 1));
            return true;
        }
        return false;
    }

    protected void func_70037_a(@Nonnull NBTTagCompound cmp) {
        this.setMaster(cmp.func_74767_n(TAG_MASTER));
        this.setNetwork(EnumDyeColor.func_176764_b((int)cmp.func_74762_e(TAG_NETWORK)));
        this.field_70180_af.func_187227_b(INVISIBILITY, (Object)cmp.func_74762_e(TAG_INVIS));
    }

    protected void func_70014_b(@Nonnull NBTTagCompound cmp) {
        cmp.func_74757_a(TAG_MASTER, this.isMaster());
        cmp.func_74768_a(TAG_NETWORK, this.getNetwork().func_176765_a());
        cmp.func_74768_a(TAG_INVIS, ((Integer)this.field_70180_af.func_187225_a(INVISIBILITY)).intValue());
    }
}

