/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.recipe.RecipePureDaisy;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileEntity;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.lexicon.LexiconData;

public class SubTilePureDaisy
extends SubTileEntity {
    private static final String TAG_POSITION = "position";
    private static final String TAG_TICKS_REMAINING = "ticksRemaining";
    private static final BlockPos[] POSITIONS = new BlockPos[]{new BlockPos(-1, 0, -1), new BlockPos(-1, 0, 0), new BlockPos(-1, 0, 1), new BlockPos(0, 0, 1), new BlockPos(1, 0, 1), new BlockPos(1, 0, 0), new BlockPos(1, 0, -1), new BlockPos(0, 0, -1)};
    int positionAt = 0;
    final int[] ticksRemaining = new int[]{-1, -1, -1, -1, -1, -1, -1, -1};

    @Override
    public void onUpdate() {
        super.onUpdate();
        ++this.positionAt;
        if (this.positionAt == POSITIONS.length) {
            this.positionAt = 0;
        }
        BlockPos acoords = POSITIONS[this.positionAt];
        BlockPos coords = this.supertile.func_174877_v().func_177971_a((Vec3i)acoords);
        World world = this.supertile.func_145831_w();
        if (!world.func_175623_d(coords)) {
            IBlockState state = world.func_180495_p(coords);
            RecipePureDaisy recipe = null;
            for (RecipePureDaisy recipe_ : BotaniaAPI.pureDaisyRecipes) {
                if (!recipe_.matches(world, coords, this, state)) continue;
                recipe = recipe_;
                break;
            }
            if (recipe != null) {
                if (this.ticksRemaining[this.positionAt] == -1) {
                    this.ticksRemaining[this.positionAt] = recipe.getTime();
                }
                int n = this.positionAt;
                this.ticksRemaining[n] = this.ticksRemaining[n] - 1;
                Botania.proxy.sparkleFX((double)coords.func_177958_n() + Math.random(), (double)coords.func_177956_o() + Math.random(), (double)coords.func_177952_p() + Math.random(), 1.0f, 1.0f, 1.0f, (float)Math.random(), 5);
                if (this.ticksRemaining[this.positionAt] <= 0) {
                    this.ticksRemaining[this.positionAt] = -1;
                    if (recipe.set(world, coords, this)) {
                        for (int i = 0; i < 25; ++i) {
                            double x = (double)coords.func_177958_n() + Math.random();
                            double y = (double)coords.func_177956_o() + Math.random() + 0.5;
                            double z = (double)coords.func_177952_p() + Math.random();
                            Botania.proxy.wispFX(x, y, z, 1.0f, 1.0f, 1.0f, (float)Math.random() / 2.0f);
                        }
                        if (ConfigHandler.blockBreakParticles) {
                            this.supertile.func_145831_w().func_175718_b(2001, coords, Block.func_176210_f((IBlockState)recipe.getOutputState()));
                        }
                    }
                }
            } else {
                this.ticksRemaining[this.positionAt] = -1;
            }
        }
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.toBlockPos(), 1);
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound cmp) {
        this.positionAt = cmp.func_74762_e(TAG_POSITION);
        if (this.supertile.func_145831_w() != null && !this.supertile.func_145831_w().field_72995_K) {
            for (int i = 0; i < this.ticksRemaining.length; ++i) {
                this.ticksRemaining[i] = cmp.func_74762_e(TAG_TICKS_REMAINING + i);
            }
        }
    }

    @Override
    public void writeToPacketNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_POSITION, this.positionAt);
        for (int i = 0; i < this.ticksRemaining.length; ++i) {
            cmp.func_74768_a(TAG_TICKS_REMAINING + i, this.ticksRemaining[i]);
        }
    }

    @Override
    public LexiconEntry getEntry() {
        return LexiconData.pureDaisy;
    }
}

