/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.wiki;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.apache.commons.lang3.text.WordUtils;
import vazkii.botania.api.wiki.IWikiProvider;

public class SimpleWikiProvider
implements IWikiProvider {
    private final String name;
    private final String urlBase;
    private final String replacement;
    private final boolean lowercase;

    public SimpleWikiProvider(String name, String urlBase) {
        this(name, urlBase, "%20");
    }

    public SimpleWikiProvider(String name, String urlBase, boolean lowercase) {
        this(name, urlBase, "%20", lowercase);
    }

    public SimpleWikiProvider(String name, String urlBase, String replacement) {
        this.name = name;
        this.urlBase = urlBase;
        this.replacement = replacement;
        this.lowercase = false;
    }

    public SimpleWikiProvider(String name, String urlBase, String replacement, boolean lowercase) {
        this.name = name;
        this.urlBase = urlBase;
        this.replacement = replacement;
        this.lowercase = lowercase;
    }

    @Override
    public String getBlockName(World world, RayTraceResult pos, EntityPlayer player) {
        BlockPos bPos = pos.func_178782_a();
        IBlockState state = world.func_180495_p(bPos);
        ItemStack stack = state.func_177230_c().getPickBlock(state, pos, world, bPos, player);
        if (stack == null || stack.func_77973_b() == null) {
            stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_180651_a(state));
        }
        if (stack.func_77973_b() == null) {
            return null;
        }
        String name = stack.func_82833_r();
        if (name == null || name.isEmpty()) {
            return null;
        }
        return name;
    }

    @Override
    public String getWikiURL(World world, RayTraceResult pos, EntityPlayer player) {
        String name = this.getBlockName(world, pos, player);
        if (name == null) {
            return null;
        }
        if (this.lowercase) {
            return String.format(this.urlBase, name.toLowerCase().replaceAll(" ", this.replacement));
        }
        return String.format(this.urlBase, WordUtils.capitalizeFully((String)name).replaceAll(" ", this.replacement));
    }

    @Override
    public String getWikiName(World world, RayTraceResult pos, EntityPlayer player) {
        return this.name;
    }
}

