/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.util;

import fi.dy.masa.itemscroller.ItemScroller;
import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.event.InputEventHandler;
import fi.dy.masa.itemscroller.recipes.RecipeStorage;
import fi.dy.masa.itemscroller.util.ItemType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiMerchant;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotMerchantResult;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.lwjgl.input.Mouse;

public class InventoryUtils {
    public static final Field fieldSelectedMerchantRecipe = ReflectionHelper.findField(GuiMerchant.class, (String[])new String[]{"field_147041_z", "selectedMerchantRecipe"});
    public static final ItemStack EMPTY_STACK = null;

    public static String getStackString(ItemStack stack) {
        if (!InventoryUtils.isStackEmpty(stack)) {
            return String.format("[%s @ %d - display: %s - NBT: %s] (%s)", stack.func_77973_b().getRegistryName(), stack.func_77960_j(), stack.func_82833_r(), stack.func_77978_p() != null ? stack.func_77978_p().toString() : "<no NBT>", stack.toString());
        }
        return "<empty>";
    }

    public static boolean isValidSlot(Slot slot, GuiContainer gui, boolean requireItems) {
        return gui.field_147002_h != null && gui.field_147002_h.field_75151_b != null && slot != null && gui.field_147002_h.field_75151_b.contains(slot) && (!requireItems || slot.func_75216_d()) && !Configs.SLOT_BLACKLIST.contains(slot.getClass().getName());
    }

    public static boolean isCraftingSlot(GuiContainer gui, Slot slot) {
        return slot != null && Configs.getCraftingGridSlots(gui, slot) != null;
    }

    public static boolean inventoryExistsAbove(Slot slot, Container container) {
        for (Slot slotTmp : container.field_75151_b) {
            if (slotTmp.field_75221_f >= slot.field_75221_f || InventoryUtils.areSlotsInSameInventory(slot, slotTmp)) continue;
            return true;
        }
        return false;
    }

    public static boolean canShiftPlaceItems(GuiContainer gui) {
        if (!GuiScreen.func_146272_n() || Mouse.getEventButton() != 0) {
            return false;
        }
        Slot slot = gui.getSlotUnderMouse();
        ItemStack stackCursor = gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        return slot != null && !InventoryUtils.isStackEmpty(stackCursor) && InventoryUtils.isValidSlot(slot, gui, false) && !slot.func_75216_d() && slot.func_75214_a(stackCursor);
    }

    public static boolean tryMoveItems(GuiContainer gui, RecipeStorage recipes, boolean scrollingUp) {
        Slot slot = gui.getSlotUnderMouse();
        if (slot == null || !InventoryUtils.isStackEmpty(gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o())) {
            return false;
        }
        boolean villagerHandling = Configs.enableScrollingVillager && gui instanceof GuiMerchant && slot instanceof SlotMerchantResult;
        boolean craftingHandling = Configs.enableScrollingCrafting && InventoryUtils.isCraftingSlot(gui, slot);
        boolean isCtrlDown = GuiContainer.func_146271_m();
        boolean isShiftDown = GuiContainer.func_146272_n();
        boolean moveToOtherInventory = scrollingUp;
        if (Configs.useSlotPositionAwareScrollDirection) {
            boolean above = InventoryUtils.inventoryExistsAbove(slot, gui.field_147002_h);
            boolean bl = moveToOtherInventory = above == scrollingUp;
        }
        if (Configs.reverseScrollDirectionSingle && !isShiftDown || Configs.reverseScrollDirectionStacks && isShiftDown) {
            moveToOtherInventory = !moveToOtherInventory;
        }
        if (!InventoryUtils.isValidSlot(slot, gui, !villagerHandling && !craftingHandling)) {
            if (craftingHandling && moveToOtherInventory) {
                recipes.storeCraftingRecipeToCurrentSelection(gui, slot);
            }
            return false;
        }
        if (craftingHandling) {
            return InventoryUtils.tryMoveItemsCrafting(gui, slot, recipes, moveToOtherInventory, isShiftDown, isCtrlDown);
        }
        if (villagerHandling) {
            return InventoryUtils.tryMoveItemsVillager((GuiMerchant)gui, slot, moveToOtherInventory, isShiftDown);
        }
        if (!Configs.enableScrollingSingle && !isShiftDown && !isCtrlDown || !Configs.enableScrollingStacks && isShiftDown && !isCtrlDown || !Configs.enableScrollingMatchingStacks && !isShiftDown && isCtrlDown || !Configs.enableScrollingEverything && isShiftDown && isCtrlDown) {
            return false;
        }
        if (isShiftDown) {
            if (isCtrlDown) {
                InventoryUtils.tryMoveStacks(slot, gui, false, moveToOtherInventory, false);
            } else {
                InventoryUtils.tryMoveStacks(slot, gui, true, moveToOtherInventory, true);
            }
            return true;
        }
        if (isCtrlDown) {
            InventoryUtils.tryMoveStacks(slot, gui, true, moveToOtherInventory, false);
            return true;
        }
        ItemStack stack = slot.func_75211_c();
        if (moveToOtherInventory) {
            return InventoryUtils.tryMoveSingleItemToOtherInventory(slot, gui);
        }
        if (InventoryUtils.getStackSize(stack) < slot.func_178170_b(stack)) {
            return InventoryUtils.tryMoveSingleItemToThisInventory(slot, gui);
        }
        return false;
    }

    public static void dropStacks(GuiContainer gui, ItemStack stackReference, Slot sourceInvSlot) {
        if (sourceInvSlot != null && !InventoryUtils.isStackEmpty(stackReference)) {
            Container container = gui.field_147002_h;
            stackReference = stackReference.func_77946_l();
            for (Slot slot : container.field_75151_b) {
                if (!InventoryUtils.areSlotsInSameInventory(slot, sourceInvSlot) || !InventoryUtils.areStacksEqual(slot.func_75211_c(), stackReference)) continue;
                InventoryUtils.dropStack(gui, slot.field_75222_d);
            }
        }
    }

    public static boolean tryMoveItemsVillager(GuiMerchant gui, Slot slot, boolean moveToOtherInventory, boolean isShiftDown) {
        if (isShiftDown) {
            if (!moveToOtherInventory) {
                InventoryUtils.tryMoveItemsToMerchantBuySlots(gui, true);
            } else if (slot.func_75216_d()) {
                InventoryUtils.tryMoveStacks(slot, (GuiContainer)gui, true, true, true);
            } else {
                InventoryUtils.tryMoveStacks(slot, (GuiContainer)gui, false, true, false);
            }
        } else if (!moveToOtherInventory) {
            InventoryUtils.tryMoveItemsToMerchantBuySlots(gui, false);
        } else if (slot.func_75216_d()) {
            InventoryUtils.moveOneSetOfItemsFromSlotToOtherInventory((GuiContainer)gui, slot);
        }
        return false;
    }

    public static boolean tryMoveSingleItemToOtherInventory(Slot slot, GuiContainer gui) {
        int targetSlot;
        ItemStack stackOrig = slot.func_75211_c();
        Container container = gui.field_147002_h;
        if (!InventoryUtils.isStackEmpty(gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o()) || !slot.func_82869_a((EntityPlayer)gui.field_146297_k.field_71439_g) || InventoryUtils.getStackSize(stackOrig) > 1 && !slot.func_75214_a(stackOrig)) {
            return false;
        }
        if (InventoryUtils.getStackSize(stackOrig) <= stackOrig.func_77976_d()) {
            return InventoryUtils.clickSlotsToMoveSingleItemByShiftClick(gui, slot.field_75222_d);
        }
        ItemStack stack = stackOrig.func_77946_l();
        InventoryUtils.setStackSize(stack, 1);
        ItemStack[] originalStacks = InventoryUtils.getOriginalStacks(container);
        slot.func_75215_d(stack);
        container.func_82846_b((EntityPlayer)gui.field_146297_k.field_71439_g, slot.field_75222_d);
        if (!slot.func_75216_d() && (targetSlot = InventoryUtils.getTargetSlot(container, originalStacks)) >= 0) {
            ((Slot)container.field_75151_b.get(targetSlot)).func_75209_a(1);
            InventoryUtils.restoreOriginalStacks(container, originalStacks);
            return InventoryUtils.clickSlotsToMoveSingleItem(gui, slot.field_75222_d, targetSlot);
        }
        slot.func_75215_d(stackOrig);
        return false;
    }

    public static boolean tryMoveAllButOneItemToOtherInventory(Slot slot, GuiContainer gui) {
        EntityPlayerSP player = gui.field_146297_k.field_71439_g;
        ItemStack stackOrig = slot.func_75211_c().func_77946_l();
        if (InventoryUtils.getStackSize(stackOrig) == 1 || InventoryUtils.getStackSize(stackOrig) > stackOrig.func_77976_d() || !slot.func_82869_a((EntityPlayer)player) || !slot.func_75214_a(stackOrig)) {
            return true;
        }
        InventoryUtils.rightClickSlot(gui, slot.field_75222_d);
        ItemStack stackInCursor = player.field_71071_by.func_70445_o();
        if (InventoryUtils.isStackEmpty(stackInCursor)) {
            return false;
        }
        int stackInCursorSizeOrig = InventoryUtils.getStackSize(stackInCursor);
        int tempSlotNum = -1;
        for (Slot slotTmp : gui.field_147002_h.field_75151_b) {
            ItemStack stackInSlot;
            if (slotTmp.field_75222_d == slot.field_75222_d || !slotTmp.func_75214_a(stackInCursor) || !InventoryUtils.isStackEmpty(stackInSlot = slotTmp.func_75211_c()) && !InventoryUtils.areStacksEqual(stackInSlot, stackInCursor)) continue;
            InventoryUtils.rightClickSlot(gui, slotTmp.field_75222_d);
            stackInCursor = player.field_71071_by.func_70445_o();
            if (!InventoryUtils.isStackEmpty(stackInCursor) && InventoryUtils.getStackSize(stackInCursor) >= stackInCursorSizeOrig) continue;
            tempSlotNum = slotTmp.field_75222_d;
            break;
        }
        InventoryUtils.leftClickSlot(gui, slot.field_75222_d);
        if (tempSlotNum != -1) {
            InventoryUtils.shiftClickSlot(gui, slot.field_75222_d);
            InventoryUtils.rightClickSlot(gui, tempSlotNum);
            InventoryUtils.rightClickSlot(gui, slot.field_75222_d);
            if (!InventoryUtils.isStackEmpty(player.field_71071_by.func_70445_o())) {
                InventoryUtils.leftClickSlot(gui, tempSlotNum);
            }
            return true;
        }
        return false;
    }

    public static boolean tryMoveSingleItemToThisInventory(Slot slot, GuiContainer gui) {
        Container container = gui.field_147002_h;
        ItemStack stackOrig = slot.func_75211_c();
        if (!slot.func_75214_a(stackOrig)) {
            return false;
        }
        for (int slotNum = container.field_75151_b.size() - 1; slotNum >= 0; --slotNum) {
            Slot slotTmp = (Slot)container.field_75151_b.get(slotNum);
            ItemStack stackTmp = slotTmp.func_75211_c();
            if (InventoryUtils.areSlotsInSameInventory(slotTmp, slot) || InventoryUtils.isStackEmpty(stackTmp) || !slotTmp.func_82869_a((EntityPlayer)gui.field_146297_k.field_71439_g) || InventoryUtils.getStackSize(stackTmp) != 1 && !slotTmp.func_75214_a(stackTmp) || !InventoryUtils.areStacksEqual(stackTmp, stackOrig)) continue;
            return InventoryUtils.clickSlotsToMoveSingleItem(gui, slotTmp.field_75222_d, slot.field_75222_d);
        }
        return false;
    }

    public static void tryMoveStacks(Slot slot, GuiContainer gui, boolean matchingOnly, boolean toOtherInventory, boolean firstOnly) {
        Container container = gui.field_147002_h;
        ItemStack stackReference = slot.func_75211_c();
        for (Slot slotTmp : container.field_75151_b) {
            if (slotTmp.field_75222_d == slot.field_75222_d || InventoryUtils.areSlotsInSameInventory(slotTmp, slot) != toOtherInventory || !slotTmp.func_75216_d() || matchingOnly && !InventoryUtils.areStacksEqual(stackReference, slotTmp.func_75211_c())) continue;
            boolean success = InventoryUtils.shiftClickSlotWithCheck(gui, slotTmp.field_75222_d);
            if (!success && Configs.enableScrollingStacksFallback) {
                InventoryUtils.clickSlotsToMoveItemsFromSlot(slotTmp, gui, toOtherInventory);
            }
            if (!firstOnly) continue;
            return;
        }
        if (toOtherInventory && !InventoryUtils.shiftClickSlotWithCheck(gui, slot.field_75222_d)) {
            InventoryUtils.clickSlotsToMoveItemsFromSlot(slot, gui, toOtherInventory);
        }
    }

    private static void tryMoveItemsToMerchantBuySlots(GuiMerchant gui, boolean fillStacks) {
        MerchantRecipeList list = gui.func_147035_g().func_70934_b((EntityPlayer)gui.field_146297_k.field_71439_g);
        int index = 0;
        try {
            index = fieldSelectedMerchantRecipe.getInt(gui);
        }
        catch (IllegalAccessException e) {
            ItemScroller.logger.warn("Failed to get the value of GuiMerchant.selectedMerchantRecipe");
        }
        if (list == null || list.size() <= index) {
            return;
        }
        MerchantRecipe recipe = (MerchantRecipe)list.get(index);
        if (recipe == null) {
            return;
        }
        ItemStack buy1 = recipe.func_77394_a();
        ItemStack buy2 = recipe.func_77396_b();
        if (!InventoryUtils.isStackEmpty(buy1)) {
            InventoryUtils.fillBuySlot((GuiContainer)gui, 0, buy1, fillStacks);
        }
        if (!InventoryUtils.isStackEmpty(buy2)) {
            InventoryUtils.fillBuySlot((GuiContainer)gui, 1, buy2, fillStacks);
        }
    }

    public static void fillBuySlot(GuiContainer gui, int slotNum, ItemStack buyStack, boolean fillStacks) {
        Slot slot = gui.field_147002_h.func_75139_a(slotNum);
        ItemStack existingStack = slot.func_75211_c();
        if (!InventoryUtils.isStackEmpty(existingStack) && !InventoryUtils.areStacksEqual(buyStack, existingStack)) {
            InventoryUtils.shiftClickSlot(gui, slotNum);
        }
        if (InventoryUtils.isStackEmpty(existingStack = slot.func_75211_c()) || InventoryUtils.areStacksEqual(buyStack, existingStack)) {
            InventoryUtils.moveItemsFromInventory(gui, slotNum, (IInventory)gui.field_146297_k.field_71439_g.field_71071_by, buyStack, fillStacks);
        }
    }

    public static void storeOrLoadRecipe(GuiContainer gui, int index) {
        Slot slot = gui.getSlotUnderMouse();
        RecipeStorage recipes = InputEventHandler.instance().getRecipes();
        if (GuiScreen.func_146272_n() && slot != null && InventoryUtils.isCraftingSlot(gui, slot)) {
            if (slot.func_75216_d()) {
                recipes.storeCraftingRecipe(index, gui, slot);
            } else {
                recipes.clearRecipe(index);
            }
        } else {
            recipes.changeSelectedRecipe(index);
            if (slot != null && !InventoryUtils.isStackEmpty(recipes.getSelectedRecipe().getResult())) {
                InventoryUtils.tryMoveItemsToCraftingGridSlots(gui, slot, recipes, false);
            }
        }
    }

    private static boolean tryMoveItemsCrafting(GuiContainer gui, Slot slot, RecipeStorage recipes, boolean moveToOtherInventory, boolean isShiftDown, boolean isCtrlDown) {
        block11: {
            block13: {
                block9: {
                    block12: {
                        block10: {
                            if (!isShiftDown) break block9;
                            if (moveToOtherInventory) break block10;
                            if (Configs.craftingScrollingStoreRecipeOnFill && slot.func_75216_d()) {
                                recipes.storeCraftingRecipeToCurrentSelection(gui, slot);
                            }
                            if (InventoryUtils.isStackEmpty(recipes.getSelectedRecipe().getResult())) break block11;
                            InventoryUtils.tryMoveItemsToCraftingGridSlots(gui, slot, recipes, true);
                            break block11;
                        }
                        if (!slot.func_75216_d()) break block12;
                        recipes.storeCraftingRecipeToCurrentSelection(gui, slot);
                        if (isCtrlDown) {
                            InventoryUtils.craftAsManyItemsAsPossible(gui, slot, recipes);
                        } else {
                            InventoryUtils.shiftClickSlot(gui, slot.field_75222_d);
                        }
                        break block11;
                    }
                    Configs.SlotRange range = Configs.getCraftingGridSlots(gui, slot);
                    if (range == null) break block11;
                    int i = 0;
                    int s = range.getFirst();
                    while (i < range.getSlotCount()) {
                        InventoryUtils.shiftClickSlot(gui, s);
                        ++i;
                        ++s;
                    }
                    break block11;
                }
                if (moveToOtherInventory) break block13;
                if (Configs.craftingScrollingStoreRecipeOnFill && slot.func_75216_d()) {
                    recipes.storeCraftingRecipeToCurrentSelection(gui, slot);
                }
                if (InventoryUtils.isStackEmpty(recipes.getSelectedRecipe().getResult())) break block11;
                InventoryUtils.tryMoveItemsToCraftingGridSlots(gui, slot, recipes, false);
                break block11;
            }
            if (slot.func_75216_d()) {
                recipes.storeCraftingRecipeToCurrentSelection(gui, slot);
                InventoryUtils.moveOneSetOfItemsFromSlotToOtherInventory(gui, slot);
            } else {
                Configs.SlotRange range = Configs.getCraftingGridSlots(gui, slot);
                if (range != null) {
                    int i = 0;
                    int s = range.getFirst();
                    while (i < range.getSlotCount()) {
                        InventoryUtils.shiftClickSlot(gui, s);
                        ++i;
                        ++s;
                    }
                }
            }
        }
        return false;
    }

    private static void craftAsManyItemsAsPossible(GuiContainer gui, Slot slot, RecipeStorage recipes) {
        ItemStack result = recipes.getSelectedRecipe().getResult();
        for (int failSafe = 1024; failSafe > 0 && slot.func_75216_d() && InventoryUtils.areStacksEqual(slot.func_75211_c(), result); --failSafe) {
            InventoryUtils.shiftClickSlot(gui, slot.field_75222_d);
            if (slot.func_75216_d() && InventoryUtils.areStacksEqual(slot.func_75211_c(), result)) break;
            InventoryUtils.tryMoveItemsToCraftingGridSlots(gui, slot, recipes, true);
        }
    }

    private static boolean clearCraftingGridOfItems(GuiContainer gui, Configs.SlotRange range, RecipeStorage recipes, boolean nonMatchingOnly) {
        int numSlots = gui.field_147002_h.field_75151_b.size();
        int i = 0;
        for (int slotNum = range.getFirst(); i < range.getSlotCount() && i < recipes.getSelectedRecipe().getRecipeLength() && slotNum < numSlots; ++i, ++slotNum) {
            Slot slotTmp = gui.field_147002_h.func_75139_a(slotNum);
            if (slotTmp == null || !slotTmp.func_75216_d() || nonMatchingOnly && InventoryUtils.areStacksEqual(recipes.getSelectedRecipe().getRecipe()[i], slotTmp.func_75211_c())) continue;
            InventoryUtils.shiftClickSlot(gui, slotNum);
            if (!slotTmp.func_75216_d()) continue;
            return false;
        }
        return true;
    }

    private static boolean tryMoveItemsToCraftingGridSlots(GuiContainer gui, Slot slot, RecipeStorage recipes, boolean fillStacks) {
        Container container = gui.field_147002_h;
        int numSlots = container.field_75151_b.size();
        Configs.SlotRange range = Configs.getCraftingGridSlots(gui, slot);
        if (range != null && range.getLast() < numSlots && recipes.getSelectedRecipe().getRecipeLength() <= range.getSlotCount()) {
            if (!InventoryUtils.clearCraftingGridOfItems(gui, range, recipes, true)) {
                return false;
            }
            Slot slotGridFirst = container.func_75139_a(range.getFirst());
            Map<ItemType, List<Integer>> ingredientSlots = ItemType.getSlotsPerItem(recipes.getSelectedRecipe().getRecipe());
            for (Map.Entry<ItemType, List<Integer>> entry : ingredientSlots.entrySet()) {
                ItemStack ingredientReference = entry.getKey().getStack();
                List<Integer> recipeSlots = entry.getValue();
                ArrayList<Integer> targetSlots = new ArrayList<Integer>();
                for (int s : recipeSlots) {
                    targetSlots.add(s + range.getFirst());
                }
                if (fillStacks) {
                    InventoryUtils.fillCraftingGrid(gui, slotGridFirst, ingredientReference, targetSlots);
                    continue;
                }
                InventoryUtils.moveOneRecipeItemIntoCraftingGrid(gui, slotGridFirst, ingredientReference, targetSlots);
            }
        }
        return false;
    }

    public static void fillCraftingGrid(GuiContainer gui, Slot slotGridFirst, ItemStack ingredientReference, List<Integer> targetSlots) {
        Container container = gui.field_147002_h;
        EntityPlayerSP player = gui.field_146297_k.field_71439_g;
        int slotNum = -1;
        int slotReturn = -1;
        int sizeOrig = 0;
        if (InventoryUtils.isStackEmpty(ingredientReference)) {
            return;
        }
        while ((slotNum = InventoryUtils.getSlotNumberOfLargestMatchingStackFromDifferentInventory(container, slotGridFirst, ingredientReference)) >= 0) {
            if (slotReturn == -1) {
                slotReturn = slotNum;
            }
            InventoryUtils.leftClickSlot(gui, slotNum);
            ItemStack stackCursor = player.field_71071_by.func_70445_o();
            if (!InventoryUtils.areStacksEqual(ingredientReference, stackCursor)) break;
            sizeOrig = InventoryUtils.getStackSize(stackCursor);
            InventoryUtils.dragSplitItemsIntoSlots(gui, targetSlots);
            stackCursor = player.field_71071_by.func_70445_o();
            if (!InventoryUtils.isStackEmpty(stackCursor)) {
                if (InventoryUtils.getStackSize(stackCursor) >= sizeOrig) break;
                InventoryUtils.leftClickSlot(gui, slotReturn);
                if (!InventoryUtils.isStackEmpty(player.field_71071_by.func_70445_o())) {
                    slotReturn = slotNum;
                    InventoryUtils.leftClickSlot(gui, slotReturn);
                }
            }
            if (InventoryUtils.isStackEmpty(player.field_71071_by.func_70445_o())) continue;
            break;
        }
        if (slotNum >= 0 && !InventoryUtils.isStackEmpty(player.field_71071_by.func_70445_o())) {
            InventoryUtils.leftClickSlot(gui, slotNum);
        }
    }

    public static void rightClickCraftOneStack(GuiContainer gui) {
        Slot slot = gui.getSlotUnderMouse();
        InventoryPlayer inv = gui.field_146297_k.field_71439_g.field_71071_by;
        ItemStack stackCursor = inv.func_70445_o();
        if (slot == null || !slot.func_75216_d() || !InventoryUtils.isStackEmpty(stackCursor) && !InventoryUtils.areStacksEqual(slot.func_75211_c(), stackCursor)) {
            return;
        }
        int sizeLast = 0;
        while (true) {
            InventoryUtils.rightClickSlot(gui, slot.field_75222_d);
            stackCursor = inv.func_70445_o();
            if (InventoryUtils.isStackEmpty(stackCursor) || InventoryUtils.getStackSize(stackCursor) <= sizeLast || InventoryUtils.getStackSize(stackCursor) >= stackCursor.func_77976_d() || !InventoryUtils.areStacksEqual(slot.func_75211_c(), stackCursor)) break;
            sizeLast = InventoryUtils.getStackSize(stackCursor);
        }
    }

    private static int putSingleItemIntoSlots(GuiContainer gui, List<Integer> targetSlots, int startIndex) {
        int slotNum;
        ItemStack stackInCursor = gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        if (InventoryUtils.isStackEmpty(stackInCursor)) {
            return 0;
        }
        int numSlots = gui.field_147002_h.field_75151_b.size();
        int numItems = InventoryUtils.getStackSize(stackInCursor);
        int loops = Math.min(numItems, targetSlots.size() - startIndex);
        int count = 0;
        for (int i = 0; i < loops && (slotNum = targetSlots.get(startIndex + i).intValue()) < numSlots; ++i) {
            InventoryUtils.rightClickSlot(gui, slotNum);
            ++count;
        }
        return count;
    }

    public static void moveOneSetOfItemsFromSlotToOtherInventory(GuiContainer gui, Slot slot) {
        List<Integer> slots;
        InventoryUtils.leftClickSlot(gui, slot.field_75222_d);
        ItemStack stackCursor = gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        if (!InventoryUtils.isStackEmpty(stackCursor) && !InventoryUtils.moveItemFromCursorToSlots(gui, slots = InventoryUtils.getSlotNumbersOfMatchingStacksFromDifferentInventory(gui.field_147002_h, slot, stackCursor, true))) {
            slots = InventoryUtils.getSlotNumbersOfEmptySlotsFromDifferentInventory(gui.field_147002_h, slot);
            InventoryUtils.moveItemFromCursorToSlots(gui, slots);
        }
    }

    public static void moveOneRecipeItemIntoCraftingGrid(GuiContainer gui, Slot slotGridFirst, ItemStack ingredientReference, List<Integer> targetSlots) {
        int filled;
        Container container = gui.field_147002_h;
        int slotNum = -1;
        int slotCount = targetSlots.size();
        for (int index = 0; index < slotCount && (slotNum = InventoryUtils.getSlotNumberOfSmallestStackFromDifferentInventory(container, slotGridFirst, ingredientReference, slotCount)) >= 0; index += filled) {
            InventoryUtils.leftClickSlot(gui, slotNum);
            if (!InventoryUtils.areStacksEqual(ingredientReference, gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o())) break;
            filled = InventoryUtils.putSingleItemIntoSlots(gui, targetSlots, index);
            if (filled >= 1) continue;
            break;
        }
        if (slotNum >= 0 && !InventoryUtils.isStackEmpty(gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o())) {
            InventoryUtils.leftClickSlot(gui, slotNum);
        }
    }

    private static boolean moveItemFromCursorToSlots(GuiContainer gui, List<Integer> slotNumbers) {
        InventoryPlayer inv = gui.field_146297_k.field_71439_g.field_71071_by;
        for (int slotNum : slotNumbers) {
            InventoryUtils.leftClickSlot(gui, slotNum);
            if (!InventoryUtils.isStackEmpty(inv.func_70445_o())) continue;
            return true;
        }
        return false;
    }

    private static void moveItemsFromInventory(GuiContainer gui, int slotTo, IInventory invSrc, ItemStack stackTemplate, boolean fillStacks) {
        Container container = gui.field_147002_h;
        for (Slot slot : container.field_75151_b) {
            if (slot == null || slot.field_75224_c != invSrc || !InventoryUtils.areStacksEqual(stackTemplate, slot.func_75211_c())) continue;
            if (fillStacks) {
                if (InventoryUtils.clickSlotsToMoveItems(gui, slot.field_75222_d, slotTo)) continue;
                break;
            }
            InventoryUtils.clickSlotsToMoveSingleItem(gui, slot.field_75222_d, slotTo);
            break;
        }
    }

    private static int getSlotNumberOfLargestMatchingStackFromDifferentInventory(Container container, Slot slotReference, ItemStack stackReference) {
        int slotNum = -1;
        int largest = 0;
        for (Slot slot : container.field_75151_b) {
            int stackSize;
            if (InventoryUtils.areSlotsInSameInventory(slot, slotReference) || !slot.func_75216_d() || !InventoryUtils.areStacksEqual(stackReference, slot.func_75211_c()) || (stackSize = InventoryUtils.getStackSize(slot.func_75211_c())) <= largest) continue;
            slotNum = slot.field_75222_d;
            largest = stackSize;
        }
        return slotNum;
    }

    private static int getSlotNumberOfSmallestStackFromDifferentInventory(Container container, Slot slotReference, ItemStack stackReference, int idealSize) {
        int slotNum = -1;
        int smallest = Integer.MAX_VALUE;
        for (Slot slot : container.field_75151_b) {
            int stackSize;
            if (InventoryUtils.areSlotsInSameInventory(slot, slotReference) || !slot.func_75216_d() || !InventoryUtils.areStacksEqual(stackReference, slot.func_75211_c()) || (stackSize = InventoryUtils.getStackSize(slot.func_75211_c())) >= smallest || stackSize < idealSize) continue;
            slotNum = slot.field_75222_d;
            smallest = stackSize;
        }
        if (slotNum == -1) {
            int largest = 0;
            for (Slot slot : container.field_75151_b) {
                int stackSize;
                if (InventoryUtils.areSlotsInSameInventory(slot, slotReference) || !slot.func_75216_d() || !InventoryUtils.areStacksEqual(stackReference, slot.func_75211_c()) || (stackSize = InventoryUtils.getStackSize(slot.func_75211_c())) <= largest) continue;
                slotNum = slot.field_75222_d;
                largest = stackSize;
            }
        }
        return slotNum;
    }

    private static List<Integer> getSlotNumbersOfMatchingStacksFromDifferentInventory(Container container, Slot slotReference, ItemStack stackReference, boolean preferPartial) {
        ArrayList<Integer> slots = new ArrayList<Integer>(64);
        for (int i = container.field_75151_b.size() - 1; i >= 0; --i) {
            Slot slot = container.func_75139_a(i);
            if (slot == null || !slot.func_75216_d() || InventoryUtils.areSlotsInSameInventory(slot, slotReference) || !InventoryUtils.areStacksEqual(slot.func_75211_c(), stackReference)) continue;
            if (InventoryUtils.getStackSize(slot.func_75211_c()) < stackReference.func_77976_d() == preferPartial) {
                slots.add(0, slot.field_75222_d);
                continue;
            }
            slots.add(slot.field_75222_d);
        }
        return slots;
    }

    private static List<Integer> getSlotNumbersOfEmptySlotsFromDifferentInventory(Container container, Slot slotReference) {
        ArrayList<Integer> slots = new ArrayList<Integer>(64);
        for (int i = container.field_75151_b.size() - 1; i >= 0; --i) {
            Slot slot = container.func_75139_a(i);
            if (slot == null || slot.func_75216_d() || InventoryUtils.areSlotsInSameInventory(slot, slotReference)) continue;
            slots.add(slot.field_75222_d);
        }
        return slots;
    }

    public static boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        return ItemStack.func_179545_c((ItemStack)stack1, (ItemStack)stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    private static boolean areSlotsInSameInventory(Slot slot1, Slot slot2) {
        return slot1.isSameInventory(slot2);
    }

    private static ItemStack[] getOriginalStacks(Container container) {
        ItemStack[] originalStacks = new ItemStack[container.field_75151_b.size()];
        for (int i = 0; i < originalStacks.length; ++i) {
            originalStacks[i] = ItemStack.func_77944_b((ItemStack)((Slot)container.field_75151_b.get(i)).func_75211_c());
        }
        return originalStacks;
    }

    private static void restoreOriginalStacks(Container container, ItemStack[] originalStacks) {
        for (int i = 0; i < originalStacks.length; ++i) {
            ItemStack stackSlot = container.func_75139_a(i).func_75211_c();
            if (InventoryUtils.areStacksEqual(stackSlot, originalStacks[i]) && (InventoryUtils.isStackEmpty(stackSlot) || InventoryUtils.getStackSize(stackSlot) == InventoryUtils.getStackSize(originalStacks[i]))) continue;
            container.func_75141_a(i, originalStacks[i]);
        }
    }

    private static int getTargetSlot(Container container, ItemStack[] originalStacks) {
        List slots = container.field_75151_b;
        for (int i = 0; i < originalStacks.length; ++i) {
            ItemStack stackOrig = originalStacks[i];
            ItemStack stackNew = ((Slot)slots.get(i)).func_75211_c();
            if ((!InventoryUtils.isStackEmpty(stackOrig) || InventoryUtils.isStackEmpty(stackNew)) && (InventoryUtils.isStackEmpty(stackOrig) || InventoryUtils.isStackEmpty(stackNew) || InventoryUtils.getStackSize(stackNew) != InventoryUtils.getStackSize(stackOrig) + 1)) continue;
            return i;
        }
        return -1;
    }

    private static void clickSlotsToMoveItemsFromSlot(Slot slotFrom, GuiContainer gui, boolean toOtherInventory) {
        EntityPlayerSP player = gui.field_146297_k.field_71439_g;
        InventoryUtils.leftClickSlot(gui, slotFrom.field_75222_d);
        if (InventoryUtils.isStackEmpty(player.field_71071_by.func_70445_o())) {
            return;
        }
        for (Slot slotDst : gui.field_147002_h.field_75151_b) {
            ItemStack stackDst = slotDst.func_75211_c();
            if (InventoryUtils.areSlotsInSameInventory(slotDst, slotFrom) != toOtherInventory && (InventoryUtils.isStackEmpty(stackDst) || InventoryUtils.areStacksEqual(stackDst, player.field_71071_by.func_70445_o()))) {
                InventoryUtils.leftClickSlot(gui, slotDst.field_75222_d);
            }
            if (!InventoryUtils.isStackEmpty(player.field_71071_by.func_70445_o())) continue;
            return;
        }
        if (!InventoryUtils.isStackEmpty(player.field_71071_by.func_70445_o())) {
            InventoryUtils.leftClickSlot(gui, slotFrom.field_75222_d);
        }
    }

    private static boolean clickSlotsToMoveSingleItem(GuiContainer gui, int slotFrom, int slotTo) {
        ItemStack stack = ((Slot)gui.field_147002_h.field_75151_b.get(slotFrom)).func_75211_c();
        if (InventoryUtils.isStackEmpty(stack)) {
            return false;
        }
        if (InventoryUtils.getStackSize(stack) > 1) {
            InventoryUtils.rightClickSlot(gui, slotFrom);
        } else {
            InventoryUtils.leftClickSlot(gui, slotFrom);
        }
        InventoryUtils.rightClickSlot(gui, slotTo);
        if (!InventoryUtils.isStackEmpty(gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o())) {
            InventoryUtils.leftClickSlot(gui, slotFrom);
        }
        return true;
    }

    private static boolean clickSlotsToMoveSingleItemByShiftClick(GuiContainer gui, int slotFrom) {
        Slot slot = (Slot)gui.field_147002_h.field_75151_b.get(slotFrom);
        ItemStack stack = slot.func_75211_c();
        if (InventoryUtils.isStackEmpty(stack)) {
            return false;
        }
        if (InventoryUtils.getStackSize(stack) > 1) {
            InventoryUtils.leftClickSlot(gui, slotFrom);
            if (slot.func_75216_d()) {
                InventoryUtils.leftClickSlot(gui, slotFrom);
                return false;
            }
            InventoryUtils.rightClickSlot(gui, slotFrom);
        }
        InventoryUtils.shiftClickSlot(gui, slotFrom);
        if (!InventoryUtils.isStackEmpty(gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o())) {
            InventoryUtils.leftClickSlot(gui, slotFrom);
        }
        return true;
    }

    private static boolean clickSlotsToMoveItems(GuiContainer gui, int slotFrom, int slotTo) {
        EntityPlayerSP player = gui.field_146297_k.field_71439_g;
        InventoryUtils.leftClickSlot(gui, slotFrom);
        if (InventoryUtils.isStackEmpty(player.field_71071_by.func_70445_o())) {
            return false;
        }
        boolean ret = true;
        int size = InventoryUtils.getStackSize(player.field_71071_by.func_70445_o());
        InventoryUtils.leftClickSlot(gui, slotTo);
        if (!InventoryUtils.isStackEmpty(player.field_71071_by.func_70445_o())) {
            ret = InventoryUtils.getStackSize(player.field_71071_by.func_70445_o()) != size;
            InventoryUtils.leftClickSlot(gui, slotFrom);
        }
        return ret;
    }

    private static boolean shiftClickSlotWithCheck(GuiContainer gui, int slotNum) {
        Slot slot = gui.field_147002_h.func_75139_a(slotNum);
        if (slot == null || !slot.func_75216_d()) {
            return false;
        }
        int sizeOrig = InventoryUtils.getStackSize(slot.func_75211_c());
        InventoryUtils.shiftClickSlot(gui, slotNum);
        return !slot.func_75216_d() || InventoryUtils.getStackSize(slot.func_75211_c()) != sizeOrig;
    }

    public static void leftClickSlot(GuiContainer gui, int slot) {
        gui.field_146297_k.field_71442_b.func_187098_a(gui.field_147002_h.field_75152_c, slot, 0, ClickType.PICKUP, (EntityPlayer)gui.field_146297_k.field_71439_g);
    }

    private static void rightClickSlot(GuiContainer gui, int slot) {
        gui.field_146297_k.field_71442_b.func_187098_a(gui.field_147002_h.field_75152_c, slot, 1, ClickType.PICKUP, (EntityPlayer)gui.field_146297_k.field_71439_g);
    }

    public static void shiftClickSlot(GuiContainer gui, int slot) {
        gui.field_146297_k.field_71442_b.func_187098_a(gui.field_147002_h.field_75152_c, slot, 0, ClickType.QUICK_MOVE, (EntityPlayer)gui.field_146297_k.field_71439_g);
    }

    public static void dropItemsFromCursor(GuiContainer gui) {
        gui.field_146297_k.field_71442_b.func_187098_a(gui.field_147002_h.field_75152_c, -999, 0, ClickType.PICKUP, (EntityPlayer)gui.field_146297_k.field_71439_g);
    }

    private static void dropStack(GuiContainer gui, int slot) {
        gui.field_146297_k.field_71442_b.func_187098_a(gui.field_147002_h.field_75152_c, slot, 1, ClickType.THROW, (EntityPlayer)gui.field_146297_k.field_71439_g);
    }

    private static void dragSplitItemsIntoSlots(GuiContainer gui, List<Integer> targetSlots) {
        int slotNum;
        ItemStack stackInCursor = gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        if (InventoryUtils.isStackEmpty(stackInCursor)) {
            return;
        }
        if (targetSlots.size() == 1) {
            InventoryUtils.leftClickSlot(gui, targetSlots.get(0));
            return;
        }
        int numSlots = gui.field_147002_h.field_75151_b.size();
        int loops = targetSlots.size();
        gui.field_146297_k.field_71442_b.func_187098_a(gui.field_147002_h.field_75152_c, -999, 0, ClickType.QUICK_CRAFT, (EntityPlayer)gui.field_146297_k.field_71439_g);
        for (int i = 0; i < loops && (slotNum = targetSlots.get(i).intValue()) < numSlots; ++i) {
            gui.field_146297_k.field_71442_b.func_187098_a(gui.field_147002_h.field_75152_c, targetSlots.get(i).intValue(), 1, ClickType.QUICK_CRAFT, (EntityPlayer)gui.field_146297_k.field_71439_g);
        }
        gui.field_146297_k.field_71442_b.func_187098_a(gui.field_147002_h.field_75152_c, -999, 2, ClickType.QUICK_CRAFT, (EntityPlayer)gui.field_146297_k.field_71439_g);
    }

    public static boolean isStackEmpty(ItemStack stack) {
        return stack == null;
    }

    public static int getStackSize(ItemStack stack) {
        return stack.field_77994_a;
    }

    public static void setStackSize(ItemStack stack, int size) {
        stack.field_77994_a = size;
    }
}

