/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.sneaky;

import net.darkhax.darkutils.features.Feature;
import net.darkhax.darkutils.features.material.FeatureMaterial;
import net.darkhax.darkutils.features.sneaky.BlockColorSneaky;
import net.darkhax.darkutils.features.sneaky.BlockSneaky;
import net.darkhax.darkutils.features.sneaky.BlockSneakyBedrock;
import net.darkhax.darkutils.features.sneaky.BlockSneakyGhost;
import net.darkhax.darkutils.features.sneaky.BlockSneakyLever;
import net.darkhax.darkutils.features.sneaky.BlockSneakyPressurePlate;
import net.darkhax.darkutils.features.sneaky.BlockSneakyTorch;
import net.darkhax.darkutils.features.sneaky.ModelSneakyBlock;
import net.darkhax.darkutils.features.sneaky.StateMapSneaky;
import net.darkhax.darkutils.features.sneaky.TileEntitySneaky;
import net.darkhax.darkutils.libs.ModUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class FeatureSneaky
extends Feature {
    @SideOnly(value=Side.CLIENT)
    private static StateMapperBase sneakyStateMap;
    public static Block blockSneakyBlock;
    public static Block blockSneakyLever;
    public static Block blockSneakyGhost;
    public static Block blockSneakyTorch;
    public static Block blockSneakyObsidian;
    public static Block blockSneakyPlate;
    public static Block blockSneakyBedrock;
    public static boolean craftSneakyBlock;
    public static boolean craftSneakyLever;
    public static boolean craftSneakyGhost;
    public static boolean craftSneakyTorch;
    public static boolean craftSneakyObsidian;
    public static boolean craftSneakyPlate;
    public static boolean opacity;

    @Override
    public void onPreInit() {
        blockSneakyBlock = new BlockSneaky();
        ModUtils.registerBlock(blockSneakyBlock, "sneaky");
        GameRegistry.registerTileEntity(TileEntitySneaky.class, (String)"sneaky");
        blockSneakyLever = new BlockSneakyLever();
        ModUtils.registerBlock(blockSneakyLever, "sneaky_lever");
        blockSneakyGhost = new BlockSneakyGhost();
        ModUtils.registerBlock(blockSneakyGhost, "sneaky_ghost");
        blockSneakyTorch = new BlockSneakyTorch();
        ModUtils.registerBlock(blockSneakyTorch, "sneaky_torch");
        blockSneakyObsidian = new BlockSneaky().func_149711_c(20.0f).func_149752_b(2000.0f);
        ModUtils.registerBlock(blockSneakyObsidian, "sneaky_obsidian");
        blockSneakyPlate = new BlockSneakyPressurePlate();
        ModUtils.registerBlock(blockSneakyPlate, "sneaky_plate");
        blockSneakyBedrock = new BlockSneakyBedrock();
        ModUtils.registerBlock(blockSneakyBedrock, "sneaky_bedrock");
    }

    @Override
    public void setupConfiguration(Configuration config) {
        craftSneakyBlock = config.getBoolean("Craft Sneaky Block", this.configName, true, "Should the sneaky block be craftable?");
        craftSneakyLever = config.getBoolean("Craft Sneaky Lever", this.configName, true, "Should the sneaky lever be craftable?");
        craftSneakyGhost = config.getBoolean("Craft Sneaky False Block", this.configName, true, "Should the sneaky false block be craftable?");
        craftSneakyTorch = config.getBoolean("Craft Sneaky Torch", this.configName, true, "Should the sneaky torch be craftable?");
        craftSneakyObsidian = config.getBoolean("Craft Sneaky Obsidian", this.configName, true, "Should the sneaky obsidian be craftable?");
        craftSneakyPlate = config.getBoolean("Craft Sneaky Pressure Plate", this.configName, true, "Should the sneaky pressure plate be craftable?");
        opacity = config.getBoolean("Opacity", this.configName, true, "When true, all sneaky blocks will let no light through. When disabled, all light will be let through.");
    }

    @Override
    public void setupRecipes() {
        if (craftSneakyBlock) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockSneakyBlock, 8), new Object[]{"rrr", "rsr", "rrr", Character.valueOf('r'), "stone", Character.valueOf('s'), ModUtils.validateCrafting(new ItemStack(FeatureMaterial.itemMaterial, 1, 2))}));
            if (craftSneakyLever) {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(blockSneakyLever), (Object[])new Object[]{blockSneakyBlock, Blocks.field_150442_at});
            }
            if (craftSneakyGhost) {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(blockSneakyGhost), (Object[])new Object[]{blockSneakyBlock, Blocks.field_150325_L});
            }
            if (craftSneakyTorch) {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(blockSneakyTorch), (Object[])new Object[]{blockSneakyBlock, Blocks.field_150478_aa});
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(blockSneakyTorch), (Object[])new Object[]{blockSneakyBlock, Blocks.field_150429_aA});
            }
            if (craftSneakyObsidian) {
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(blockSneakyObsidian), new Object[]{blockSneakyBlock, "obsidian"}));
            }
            if (craftSneakyPlate) {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(blockSneakyPlate), (Object[])new Object[]{blockSneakyBlock, Blocks.field_150452_aw});
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientPreInit() {
        sneakyStateMap = new StateMapSneaky();
        this.registerSneakyModel(blockSneakyBlock, "sneaky_default", false);
        this.registerSneakyModel(blockSneakyLever, "sneaky_lever", false);
        this.registerSneakyModel(blockSneakyGhost, "sneaky_default", true);
        this.registerSneakyModel(blockSneakyTorch, "sneaky_torch", false);
        this.registerSneakyModel(blockSneakyObsidian, "sneaky_default", true);
        this.registerSneakyModel(blockSneakyPlate, "sneaky_plate", false);
        this.registerSneakyModel(blockSneakyBedrock, "sneaky_default", true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientInit() {
        Minecraft.func_71410_x().func_184125_al().func_186722_a((IBlockColor)new BlockColorSneaky(), new Block[]{blockSneakyBlock, blockSneakyLever, blockSneakyGhost, blockSneakyTorch, blockSneakyObsidian, blockSneakyPlate, blockSneakyBedrock});
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("darkutils:sneaky", "normal"), (Object)new ModelSneakyBlock());
    }

    @SideOnly(value=Side.CLIENT)
    public void registerSneakyModel(Block block, String name, boolean useDefault) {
        Item item = Item.func_150898_a((Block)block);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("darkutils:" + name, "inventory"));
        if (!useDefault) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("darkutils:" + name, "normal"));
        }
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)sneakyStateMap);
    }
}

