/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.shulkerpearl;

import net.darkhax.bookshelf.item.ItemBlockBasic;
import net.darkhax.darkutils.features.Feature;
import net.darkhax.darkutils.features.shulkerpearl.BlockShulkerPearl;
import net.darkhax.darkutils.features.shulkerpearl.ItemShulkerPearl;
import net.darkhax.darkutils.features.shulkerpearl.ShulkerDataHandler;
import net.darkhax.darkutils.libs.ModUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class FeatureShulkerPearlItem
extends Feature {
    public static Item itemShulkerPearl;
    public static Block blockShulkerPearl;
    private boolean harvestablePearls = true;
    private boolean craftEndRods = true;
    private boolean craftBlocks = true;
    private int maxCooldown = 6000;

    @Override
    public void onPreInit() {
        itemShulkerPearl = ModUtils.registerItem(new ItemShulkerPearl(), "shulker_pearl");
        blockShulkerPearl = new BlockShulkerPearl();
        ModUtils.registerBlock(blockShulkerPearl, (ItemBlock)new ItemBlockBasic(blockShulkerPearl, BlockShulkerPearl.types, false), "pearl_block");
        OreDictionary.registerOre((String)"blockPearl", (ItemStack)new ItemStack(blockShulkerPearl, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"gemPearl", (Item)itemShulkerPearl);
        if (this.harvestablePearls) {
            ShulkerDataHandler.init();
        }
    }

    @Override
    public void setupConfiguration(Configuration config) {
        this.harvestablePearls = config.getBoolean("Harvest Pearls", this.configName, true, "Should pearls be harvestable from shulkers?");
        this.craftEndRods = config.getBoolean("Craft End Rods", this.configName, true, "Can end rods be crafted?");
        this.maxCooldown = config.getInt("Shulker Cooldown", this.configName, 6000, 0, Integer.MAX_VALUE, "The pearl harvest cooldown tile, in ticks");
        this.craftBlocks = config.getBoolean("Craft Blocks", this.configName, true, "Can pearl blocks be crafted?");
    }

    @Override
    public void setupRecipes() {
        if (this.craftEndRods) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Blocks.field_185764_cQ), new Object[]{Items.field_185161_cS, "gemPearl"}));
        }
        if (this.craftBlocks) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockShulkerPearl, 32, 0), new Object[]{"xxx", "xsx", "xxx", Character.valueOf('x'), itemShulkerPearl, Character.valueOf('s'), "endstone"}));
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(blockShulkerPearl, 4, 1), (Object[])new Object[]{"xx ", "xx ", Character.valueOf('x'), new ItemStack(blockShulkerPearl, 1, 0)});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(blockShulkerPearl, 4, 2), (Object[])new Object[]{"xx ", "xx ", Character.valueOf('x'), new ItemStack(blockShulkerPearl, 1, 1)});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(blockShulkerPearl, 4, 3), (Object[])new Object[]{"xx ", "xx ", Character.valueOf('x'), new ItemStack(blockShulkerPearl, 1, 2)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(itemShulkerPearl), (Object[])new Object[]{new ItemStack(blockShulkerPearl, 1, Short.MAX_VALUE), new ItemStack(blockShulkerPearl, 1, Short.MAX_VALUE), new ItemStack(blockShulkerPearl, 1, Short.MAX_VALUE), new ItemStack(blockShulkerPearl, 1, Short.MAX_VALUE)});
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientPreInit() {
        ModUtils.registerItemInvModel(itemShulkerPearl);
        ModUtils.registerItemInvModel(Item.func_150898_a((Block)blockShulkerPearl), "pearl", BlockShulkerPearl.types);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ShulkerDataHandler.ICustomData data;
        if (event.getSide().equals((Object)Side.SERVER) && this.harvestablePearls && event.getTarget() instanceof EntityShulker && (data = ShulkerDataHandler.getData(event.getTarget())) != null && data.getCooldown() <= 0) {
            event.getTarget().func_70099_a(new ItemStack(itemShulkerPearl), 0.5f);
            data.setCooldown(this.maxCooldown);
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (this.harvestablePearls && event.getEntity() instanceof EntityShulker) {
            ShulkerDataHandler.ICustomData data = ShulkerDataHandler.getData(event.getEntity());
            int current = data.getCooldown();
            if (data != null && current > 0) {
                data.setCooldown(current - 1);
            }
        }
    }
}

