/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.endertether;

import net.darkhax.darkutils.features.Feature;
import net.darkhax.darkutils.features.endertether.BlockEnderTether;
import net.darkhax.darkutils.features.endertether.TileEntityEnderTether;
import net.darkhax.darkutils.features.material.FeatureMaterial;
import net.darkhax.darkutils.libs.ModUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class FeatureEnderTether
extends Feature {
    public static Block blockEnderTether;
    private static boolean craftable;
    protected static boolean affectPlayers;
    protected static double tetherRange;

    @Override
    public void onPreInit() {
        blockEnderTether = new BlockEnderTether();
        ModUtils.registerBlock(blockEnderTether, "ender_tether");
        GameRegistry.registerTileEntity(TileEntityEnderTether.class, (String)"ender_tether");
    }

    @Override
    public void setupConfiguration(Configuration config) {
        craftable = config.getBoolean("Craftable", this.configName, true, "Should the Ender Tether be craftable?");
        tetherRange = config.getFloat("Tether Range", this.configName, 32.0f, 0.0f, 512.0f, "The range of the effect given by the tether. Distance is measured in blocks.");
        affectPlayers = config.getBoolean("Affect Players", this.configName, true, "Should the Ender Tether catch players using ender teleportation?");
    }

    @Override
    public void setupRecipes() {
        if (craftable) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockEnderTether), new Object[]{" u ", "oto", Character.valueOf('u'), ModUtils.validateCrafting(new ItemStack(FeatureMaterial.itemMaterial, 1, 1)), Character.valueOf('o'), "obsidian", Character.valueOf('t'), Blocks.field_150429_aA, Character.valueOf('i'), "ingotIron"}));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientPreInit() {
        ModUtils.registerBlockInvModel(blockEnderTether);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onEnderTeleport(EnderTeleportEvent event) {
        if (event.getEntityLiving() instanceof EntityLivingBase && event.getEntityLiving().func_130014_f_() != null && !event.getEntityLiving().func_130014_f_().field_72995_K) {
            for (TileEntity tile : event.getEntityLiving().func_130014_f_().field_147482_g) {
                if (!(tile instanceof TileEntityEnderTether) || !((TileEntityEnderTether)tile).isEntityCloseEnough(event.getEntityLiving())) continue;
                BlockPos pos = tile.func_174877_v();
                event.setTargetX((double)((float)pos.func_177958_n() + 0.5f));
                event.setTargetY((double)pos.func_177956_o());
                event.setTargetZ((double)((float)pos.func_177952_p() + 0.5f));
                break;
            }
        }
    }

    static {
        craftable = true;
        affectPlayers = true;
        tetherRange = 32.0;
    }
}

