/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.xp;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.util.FluidUtil;
import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.xp.XpUtil;
import io.netty.buffer.ByteBuf;
import java.security.InvalidParameterException;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;

public class ExperienceContainer
extends FluidTank {
    private int experienceLevel;
    private float experience;
    private int experienceTotal;
    private boolean xpDirty;
    private final int maxXp;

    public ExperienceContainer() {
        this(Integer.MAX_VALUE);
    }

    public ExperienceContainer(int maxStored) {
        super(null, 0);
        this.maxXp = maxStored;
    }

    public int getMaximumExperiance() {
        return this.maxXp;
    }

    public int getExperienceLevel() {
        return this.experienceLevel;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getExperienceTotal() {
        return this.experienceTotal;
    }

    public boolean isDirty() {
        return this.xpDirty;
    }

    public void setDirty(boolean isDirty) {
        this.xpDirty = isDirty;
    }

    public void set(ExperienceContainer xpCon) {
        this.experienceTotal = xpCon.experienceTotal;
        this.experienceLevel = xpCon.experienceLevel;
        this.experience = xpCon.experience;
        this.onContentsChanged();
    }

    public int addExperience(int xpToAdd) {
        int j = this.maxXp - this.experienceTotal;
        if (xpToAdd > j) {
            xpToAdd = j;
        }
        this.experienceTotal += xpToAdd;
        this.experienceLevel = XpUtil.getLevelForExperience(this.experienceTotal);
        this.experience = (float)(this.experienceTotal - XpUtil.getExperienceForLevel(this.experienceLevel)) / (float)this.getXpBarCapacity();
        this.xpDirty = true;
        this.onContentsChanged();
        return xpToAdd;
    }

    private int getXpBarCapacity() {
        return XpUtil.getXpBarCapacity(this.experienceLevel);
    }

    public int getXpBarScaled(int scale) {
        int result = (int)(this.experience * (float)scale);
        return result;
    }

    public void givePlayerXp(EntityPlayer player, int levels) {
        for (int i = 0; i < levels && this.experienceTotal > 0; ++i) {
            this.givePlayerXpLevel(player);
        }
    }

    public void givePlayerXpLevel(EntityPlayer player) {
        int currentXP = XpUtil.getPlayerXP(player);
        int nextLevelXP = XpUtil.getExperienceForLevel(player.field_71068_ca + 1);
        int requiredXP = nextLevelXP - currentXP;
        requiredXP = Math.min(this.experienceTotal, requiredXP);
        XpUtil.addPlayerXP(player, requiredXP);
        int newXp = this.experienceTotal - requiredXP;
        this.experience = 0.0f;
        this.experienceLevel = 0;
        this.experienceTotal = 0;
        this.addExperience(newXp);
    }

    public void drainPlayerXpToReachContainerLevel(EntityPlayer player, int level) {
        int targetXP = XpUtil.getExperienceForLevel(level);
        int requiredXP = targetXP - this.experienceTotal;
        if (requiredXP <= 0) {
            return;
        }
        int drainXP = Math.min(requiredXP, XpUtil.getPlayerXP(player));
        this.addExperience(drainXP);
        XpUtil.addPlayerXP(player, -drainXP);
    }

    public void drainPlayerXpToReachPlayerLevel(EntityPlayer player, int level) {
        int targetXP = XpUtil.getExperienceForLevel(level);
        int drainXP = XpUtil.getPlayerXP(player) - targetXP;
        if (drainXP <= 0) {
            return;
        }
        if ((drainXP = this.addExperience(drainXP)) > 0) {
            XpUtil.addPlayerXP(player, -drainXP);
        }
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (resource == null || !this.canDrain(from, resource.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (Fluids.fluidXpJuice == null) {
            return null;
        }
        int available = this.getFluidAmount();
        int toDrain = Math.min(available, maxDrain);
        int xpAskedToExtract = XpUtil.liquidToExperience(toDrain);
        int fluidToExtract = XpUtil.experienceToLiquid(xpAskedToExtract);
        int xpToExtract = XpUtil.liquidToExperience(fluidToExtract);
        if (doDrain) {
            int newXp = this.experienceTotal - xpToExtract;
            this.experience = 0.0f;
            this.experienceLevel = 0;
            this.experienceTotal = 0;
            this.addExperience(newXp);
        }
        return new FluidStack(Fluids.fluidXpJuice, fluidToExtract);
    }

    public boolean canFill(EnumFacing from, Fluid fluidIn) {
        return this.canFill() && fluidIn != null && Fluids.fluidXpJuice != null && FluidUtil.areFluidsTheSame((Fluid)fluidIn, (Fluid)Fluids.fluidXpJuice);
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        int xpSpace;
        if (resource == null) {
            return 0;
        }
        if (resource.amount <= 0) {
            return 0;
        }
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        int xp = XpUtil.liquidToExperience(resource.amount);
        int canFillXP = Math.min(xp, xpSpace = this.getMaximumExperiance() - this.getExperienceTotal());
        if (canFillXP <= 0) {
            return 0;
        }
        if (doFill) {
            this.addExperience(canFillXP);
        }
        return XpUtil.experienceToLiquid(canFillXP);
    }

    public boolean canDrain(EnumFacing from, Fluid fluidIn) {
        return fluidIn != null && Fluids.fluidXpJuice != null && FluidUtil.areFluidsTheSame((Fluid)fluidIn, (Fluid)Fluids.fluidXpJuice);
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (Fluids.fluidXpJuice == null) {
            return new FluidTankInfo[0];
        }
        return new FluidTankInfo[]{new FluidTankInfo(new FluidStack(Fluids.fluidXpJuice, this.getFluidAmount()), this.getCapacity())};
    }

    public int getCapacity() {
        if (this.maxXp == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return XpUtil.experienceToLiquid(this.maxXp);
    }

    public int getFluidAmount() {
        return XpUtil.experienceToLiquid(this.experienceTotal);
    }

    public FluidTank readFromNBT(NBTTagCompound nbtRoot) {
        this.experienceLevel = nbtRoot.func_74762_e("experienceLevel");
        this.experienceTotal = nbtRoot.func_74762_e("experienceTotal");
        this.experience = nbtRoot.func_74760_g("experience");
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtRoot) {
        nbtRoot.func_74768_a("experienceLevel", this.experienceLevel);
        nbtRoot.func_74768_a("experienceTotal", this.experienceTotal);
        nbtRoot.func_74776_a("experience", this.experience);
        return nbtRoot;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.experienceTotal);
        buf.writeInt(this.experienceLevel);
        buf.writeFloat(this.experience);
    }

    public void fromBytes(ByteBuf buf) {
        this.experienceTotal = buf.readInt();
        this.experienceLevel = buf.readInt();
        this.experience = buf.readFloat();
    }

    public FluidStack getFluid() {
        return new FluidStack(Fluids.fluidXpJuice, this.getFluidAmount());
    }

    public FluidTankInfo getInfo() {
        return this.getTankInfo(null)[0];
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.fill(null, resource, doFill);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.drain(null, maxDrain, doDrain);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.drain(null, resource, doDrain);
    }

    public void setFluid(@Nullable FluidStack fluid) {
        this.experience = 0.0f;
        this.experienceLevel = 0;
        this.experienceTotal = 0;
        if (fluid != null && fluid.getFluid() != null) {
            if (Fluids.fluidXpJuice == fluid.getFluid()) {
                this.addExperience(XpUtil.liquidToExperience(fluid.amount));
            } else {
                throw new InvalidParameterException(fluid.getFluid() + " is no XP juice");
            }
        }
        this.xpDirty = true;
    }

    public void setCapacity(int capacity) {
        throw new InvalidParameterException();
    }

    protected void onContentsChanged() {
        super.onContentsChanged();
        if (this.tile instanceof ITankAccess) {
            ((ITankAccess)this.tile).setTanksDirty();
        } else if (this.tile != null) {
            this.tile.func_70296_d();
        }
    }
}

