/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.vat;

import com.enderio.core.common.util.FluidUtil;
import crazypants.enderio.Log;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.recipe.IRecipe;
import crazypants.enderio.machine.recipe.Recipe;
import crazypants.enderio.machine.recipe.RecipeConfig;
import crazypants.enderio.machine.recipe.RecipeConfigParser;
import crazypants.enderio.machine.recipe.RecipeInput;
import crazypants.enderio.machine.recipe.RecipeOutput;
import crazypants.enderio.machine.vat.VatMachineRecipe;
import crazypants.enderio.machine.vat.VatRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class VatRecipeManager {
    private static final String CORE_FILE_NAME = "VatRecipes_Core.xml";
    private static final String CUSTOM_FILE_NAME = "VatRecipes_User.xml";
    static final VatRecipeManager instance = new VatRecipeManager();
    private final List<IRecipe> recipes = new ArrayList<IRecipe>();

    public static VatRecipeManager getInstance() {
        return instance;
    }

    public void loadRecipesFromConfig() {
        RecipeConfig config = RecipeConfig.loadRecipeConfig(CORE_FILE_NAME, CUSTOM_FILE_NAME, null);
        if (config != null) {
            this.processConfig(config);
        } else {
            Log.error("Could not load recipes for Vat.");
        }
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockVat.getUnlocalisedName(), new VatMachineRecipe());
    }

    public void addCustomRecipes(String xmlDef) {
        RecipeConfig config;
        try {
            config = RecipeConfigParser.parse(xmlDef, null);
        }
        catch (Exception e) {
            Log.error("Error parsing custom xml");
            return;
        }
        if (config == null) {
            Log.error("Could process custom XML");
            return;
        }
        this.processConfig(config);
    }

    public IRecipe getRecipeForInput(MachineRecipeInput[] inputs) {
        if (inputs == null || inputs.length == 0) {
            return null;
        }
        for (IRecipe recipe : this.recipes) {
            if (!recipe.isInputForRecipe(inputs)) continue;
            return recipe;
        }
        return null;
    }

    private void processConfig(RecipeConfig config) {
        List<Recipe> newRecipes = config.getRecipes(false);
        Log.info("Found " + newRecipes.size() + " valid Vat recipes in config.");
        for (Recipe rec : newRecipes) {
            this.addRecipe(rec);
        }
        Log.info("Finished processing Vat recipes. " + this.recipes.size() + " recipes avaliable.");
    }

    public void addRecipe(IRecipe recipe) {
        if (recipe == null || !recipe.isValid()) {
            Log.debug("Could not add invalid Vat recipe: " + recipe);
            return;
        }
        this.recipes.add(new VatRecipe(recipe));
    }

    public List<IRecipe> getRecipes() {
        return this.recipes;
    }

    public boolean isValidInput(MachineRecipeInput input) {
        for (IRecipe recipe : this.recipes) {
            if (input.item != null && recipe.isValidInput(input.slotNumber, input.item)) {
                return true;
            }
            if (input.fluid == null || !recipe.isValidInput(input.fluid)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidInput(MachineRecipeInput[] inputs) {
        for (IRecipe recipe : this.recipes) {
            boolean allValid = true;
            for (MachineRecipeInput input : inputs) {
                if (input.item != null) {
                    allValid = recipe.isValidInput(input.slotNumber, input.item);
                } else if (input.fluid != null) {
                    allValid = recipe.isValidInput(input.fluid);
                }
                if (!allValid) break;
            }
            if (!allValid) continue;
            return true;
        }
        return false;
    }

    public float getMultiplierForInput(Fluid inputFluid, ItemStack input, Fluid output) {
        if (input != null || output != null) {
            for (IRecipe recipe : this.recipes) {
                RecipeOutput out = recipe.getOutputs()[0];
                RecipeInput in = recipe.getInputs()[recipe.getInputs().length - 1];
                if (inputFluid != null && (!FluidUtil.areFluidsTheSame((Fluid)in.getFluidInput().getFluid(), (Fluid)inputFluid) || output != null && !FluidUtil.areFluidsTheSame((Fluid)out.getFluidOutput().getFluid(), (Fluid)output))) continue;
                for (RecipeInput ri : recipe.getInputs()) {
                    if (!ri.isInput(input)) continue;
                    return ri.getMulitplier();
                }
            }
        }
        float found = -1.0f;
        for (IRecipe recipe : this.recipes) {
            for (RecipeInput ri : recipe.getInputs()) {
                if (!ri.isInput(input) || !(found < 0.0f) && !(found > ri.getMulitplier())) continue;
                found = ri.getMulitplier();
            }
        }
        return found > 0.0f ? found : 0.0f;
    }
}

