/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.vat;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.fluid.FluidWrapper;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.fluid.SmartTank;
import crazypants.enderio.fluid.SmartTankFluidHandler;
import crazypants.enderio.fluid.SmartTankFluidMachineHandler;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.IPoweredTask;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.vat.PacketTanks;
import crazypants.enderio.machine.vat.PacketVatProgress;
import crazypants.enderio.machine.vat.VatRecipeManager;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Storable
public class TileVat
extends AbstractPoweredTaskEntity
implements ITankAccess.IExtendedTankAccess,
IPaintable.IPaintableTileEntity {
    public static final int BUCKET_VOLUME = 1000;
    @Store
    final SmartTank inputTank = new SmartTank(8000);
    @Store
    final SmartTank outputTank = new SmartTank(8000);
    private static int IO_MB_TICK = 100;
    boolean tanksDirty = false;
    Fluid currentTaskInputFluid;
    Fluid currentTaskOutputFluid;
    private SmartTankFluidHandler smartTankFluidHandler;

    public TileVat() {
        super(new SlotDefinition(0, 1, -1, -1, -1, -1), ModObject.blockVat);
        this.inputTank.setTileEntity((TileEntity)this);
        this.inputTank.setCanDrain(false);
        this.outputTank.setTileEntity((TileEntity)this);
        this.outputTank.setCanFill(false);
    }

    @Override
    @Nonnull
    public String func_70005_c_() {
        return ModObject.blockVat.getUnlocalisedName();
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return ModObject.blockVat.getUnlocalisedName();
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        MachineRecipeInput[] inputs = this.getRecipeInputs();
        inputs[i] = new MachineRecipeInput(i, itemstack);
        return VatRecipeManager.getInstance().isValidInput(inputs);
    }

    @Override
    protected boolean doPush(@Nullable EnumFacing dir) {
        boolean res = super.doPush(dir);
        if (dir != null && this.outputTank.getFluidAmount() > 0 && FluidWrapper.transfer((FluidTank)this.outputTank, (IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (int)IO_MB_TICK) > 0) {
            this.setTanksDirty();
        }
        return res;
    }

    @Override
    protected boolean doPull(@Nullable EnumFacing dir) {
        boolean res = super.doPull(dir);
        if (dir != null && this.inputTank.getFluidAmount() < this.inputTank.getCapacity() && FluidWrapper.transfer((IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (FluidTank)this.inputTank, (int)IO_MB_TICK) > 0) {
            this.setTanksDirty();
        }
        return res;
    }

    @Override
    protected boolean processTasks(boolean redstoneChecksPassed) {
        boolean res = super.processTasks(redstoneChecksPassed);
        if (this.tanksDirty && this.shouldDoWorkThisTick(10)) {
            PacketHandler.sendToAllAround((IMessage)new PacketTanks(this), (TileEntity)this);
            this.tanksDirty = false;
        }
        return res;
    }

    protected void sendTaskProgressPacket() {
        PacketHandler.sendToAllAround((IMessage)new PacketVatProgress(this), (TileEntity)this);
        this.ticksSinceLastProgressUpdate = 0;
    }

    @Override
    protected void mergeFluidResult(IMachineRecipe.ResultStack result) {
        this.outputTank.fillInternal(result.fluid, true);
        this.setTanksDirty();
    }

    @Override
    protected void drainInputFluid(MachineRecipeInput fluid) {
        this.inputTank.removeFluidAmount(fluid.fluid.amount);
    }

    @Override
    protected boolean canInsertResultFluid(IMachineRecipe.ResultStack fluid) {
        int res = this.outputTank.fillInternal(fluid.fluid, false);
        return res >= fluid.fluid.amount;
    }

    @Override
    protected MachineRecipeInput[] getRecipeInputs() {
        MachineRecipeInput[] res = new MachineRecipeInput[this.slotDefinition.getNumInputSlots() + 1];
        int fromSlot = this.slotDefinition.minInputSlot;
        for (int i = 0; i < res.length - 1; ++i) {
            res[i] = new MachineRecipeInput(fromSlot, this.inventory[fromSlot]);
            ++fromSlot;
        }
        res[res.length - 1] = new MachineRecipeInput(0, this.inputTank.getFluid());
        return res;
    }

    @Override
    public int getPowerUsePerTick() {
        return Config.vatPowerUserPerTickRF;
    }

    @Override
    public String getSoundName() {
        return "machine.vat";
    }

    @Override
    public float getPitch() {
        return 0.3f;
    }

    @Override
    public float getVolume() {
        return super.getVolume() * 0.3f;
    }

    void setClientTask(IPoweredTask currentTask) {
        this.currentTask = currentTask;
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        MachineRecipeInput[] inputs = this.getRecipeInputs();
        inputs[inputs.length - 1] = new MachineRecipeInput(0, forFluidType);
        if (VatRecipeManager.getInstance().isValidInput(inputs)) {
            return this.inputTank;
        }
        return null;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.outputTank};
    }

    public void setTanksDirty() {
        if (!this.tanksDirty) {
            this.tanksDirty = true;
            this.func_70296_d();
        }
    }

    @Nonnull
    public List<ITankAccess.ITankData> getTankDisplayData() {
        ArrayList<ITankAccess.ITankData> result = new ArrayList<ITankAccess.ITankData>();
        result.add(new ITankAccess.ITankData(){

            @Nonnull
            public ITankAccess.ITankData.EnumTankType getTankType() {
                return ITankAccess.ITankData.EnumTankType.INPUT;
            }

            @Nullable
            public FluidStack getContent() {
                return TileVat.this.inputTank.getFluid();
            }

            public int getCapacity() {
                return TileVat.this.inputTank.getCapacity();
            }
        });
        result.add(new ITankAccess.ITankData(){

            @Nonnull
            public ITankAccess.ITankData.EnumTankType getTankType() {
                return ITankAccess.ITankData.EnumTankType.OUTPUT;
            }

            @Nullable
            public FluidStack getContent() {
                return TileVat.this.outputTank.getFluid();
            }

            public int getCapacity() {
                return TileVat.this.outputTank.getCapacity();
            }
        });
        return result;
    }

    protected SmartTankFluidHandler getSmartTankFluidHandler() {
        if (this.smartTankFluidHandler == null) {
            this.smartTankFluidHandler = new SmartTankFluidMachineHandler(this, new IFluidHandler[]{this.inputTank, this.outputTank});
        }
        return this.smartTankFluidHandler;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.getSmartTankFluidHandler().has(facingIn);
        }
        return super.hasCapability(capability, facingIn);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.getSmartTankFluidHandler().get(facingIn);
        }
        return super.getCapability(capability, facingIn);
    }
}

