/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter.blocks;

import com.enderio.core.common.BlockEnder;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.painter.blocks.BlockItemPaintedBlock;
import crazypants.enderio.machine.painter.blocks.TileEntityPaintedBlock;
import crazypants.enderio.machine.painter.recipe.BasicPainterTemplate;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.PainterUtil2;
import crazypants.enderio.paint.render.PaintHelper;
import crazypants.enderio.paint.render.PaintRegistry;
import crazypants.enderio.paint.render.UVLock;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.ICacheKey;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.ISmartRenderAwareBlock;
import crazypants.enderio.render.dummy.BlockMachineBase;
import crazypants.enderio.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.render.property.EnumRenderPart;
import crazypants.enderio.render.property.IOMode;
import crazypants.enderio.render.registry.SmartModelAttacher;
import crazypants.enderio.render.util.QuadCollector;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPaintedFence
extends BlockFence
implements ITileEntityProvider,
IPaintable.ITexturePaintableBlock,
ISmartRenderAwareBlock,
IRenderMapper.IBlockRenderMapper.IRenderLayerAware,
IRenderMapper.IItemRenderMapper.IItemModelMapper {
    private final String name;

    public static BlockPaintedFence create() {
        BlockPaintedFence woodFence = new BlockPaintedFence(Material.field_151575_d, BlockPlanks.EnumType.OAK.func_181070_c(), ModObject.blockPaintedFence.getUnlocalisedName(), SoundType.field_185848_a);
        woodFence.func_149711_c(2.0f).func_149752_b(5.0f);
        woodFence.init();
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPainter.getUnlocalisedName(), new BasicPainterTemplate<BlockPaintedFence>(woodFence, Blocks.field_180407_aO, Blocks.field_180405_aT, Blocks.field_180408_aP, Blocks.field_180404_aQ, Blocks.field_180403_aR, Blocks.field_180406_aS));
        return woodFence;
    }

    public static BlockPaintedFence create_stone() {
        BlockPaintedFence stoneFence = new BlockPaintedFence(Material.field_151576_e, MapColor.field_151655_K, ModObject.blockPaintedStoneFence.getUnlocalisedName(), SoundType.field_185851_d);
        stoneFence.func_149711_c(2.0f).func_149752_b(10.0f);
        stoneFence.init();
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPainter.getUnlocalisedName(), new BasicPainterTemplate<BlockPaintedFence>(stoneFence, Blocks.field_150386_bk));
        return stoneFence;
    }

    protected BlockPaintedFence(Material material, MapColor mapColor, String name, SoundType sound) {
        super(material, mapColor);
        this.func_149647_a(null);
        this.name = name;
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149672_a(sound);
    }

    private void init() {
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new BlockItemPaintedBlock((Block)this, this.name));
        SmartModelAttacher.registerNoProps((Block)this);
        PaintRegistry.registerModel("fence_post", new ResourceLocation("minecraft", "block/oak_fence_post"), PaintRegistry.PaintMode.ALL_TEXTURES);
        PaintRegistry.registerModel("fence_side", new ResourceLocation("minecraft", "block/oak_fence_side"), PaintRegistry.PaintMode.ALL_TEXTURES);
        PaintRegistry.registerModel("fence_inventory", new ResourceLocation("minecraft", "block/oak_fence_inventory"), PaintRegistry.PaintMode.ALL_TEXTURES);
    }

    public boolean func_176524_e(IBlockAccess worldIn, BlockPos pos) {
        if (super.func_176524_e(worldIn, pos)) {
            return true;
        }
        IBlockState blockState2 = worldIn.func_180495_p(pos);
        Block block = blockState2.func_177230_c();
        if (block instanceof BlockPaintedFence) {
            return true;
        }
        if (block instanceof IPaintable.IBlockPaintableBlock) {
            IBlockState paintSource = ((IPaintable.IBlockPaintableBlock)block).getPaintSource(blockState2, worldIn, pos);
            return paintSource != null && paintSource.func_177230_c() instanceof BlockFence && paintSource.func_185904_a() == this.field_149764_J;
        }
        return false;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityPaintedBlock();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        this.setPaintSource(state, (IBlockAccess)world, pos, PainterUtil2.getSourceBlock(stack));
        if (!world.field_72995_K) {
            world.func_184138_a(pos, state, state, 3);
        }
    }

    public boolean removedByPlayer(IBlockState bs, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(bs, world, pos, player, willHarvest);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        super.removedByPlayer(state, worldIn, pos, player, true);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List drops = super.getDrops(world, pos, state, fortune);
        for (ItemStack drop : drops) {
            PainterUtil2.setSourceBlock(drop, this.getPaintSource(state, world, pos));
        }
        return drops;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack pickBlock = super.getPickBlock(state, target, world, pos, player);
        PainterUtil2.setSourceBlock(pickBlock, this.getPaintSource(null, (IBlockAccess)world, pos));
        return pickBlock;
    }

    @Override
    public void setPaintSource(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable IBlockState paintSource) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IPaintable.IPaintableTileEntity) {
            ((IPaintable.IPaintableTileEntity)te).setPaintSource(paintSource);
        }
    }

    @Override
    public void setPaintSource(Block block, ItemStack stack, @Nullable IBlockState paintSource) {
        PainterUtil2.setSourceBlock(stack, paintSource);
    }

    @Override
    public IBlockState getPaintSource(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)pos);
        if (te instanceof IPaintable.IPaintableTileEntity) {
            return ((IPaintable.IPaintableTileEntity)te).getPaintSource();
        }
        return null;
    }

    @Override
    public IBlockState getPaintSource(Block block, ItemStack stack) {
        return PainterUtil2.getSourceBlock(stack);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state != null && world != null && pos != null) {
            BlockStateWrapperBase blockStateWrapper = new BlockStateWrapperBase(state, world, pos, this);
            blockStateWrapper.addCacheKey(this.getPaintSource(state, world, pos)).addCacheKey(state.func_177229_b((IProperty)BlockFence.field_176525_b)).addCacheKey(state.func_177229_b((IProperty)BlockFence.field_176526_a)).addCacheKey(state.func_177229_b((IProperty)BlockFence.field_176527_M)).addCacheKey(state.func_177229_b((IProperty)BlockFence.field_176528_N));
            blockStateWrapper.bakeModel();
            return blockStateWrapper;
        }
        return state;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    private List<IBakedModel> mapRender(IBlockState state, @Nullable IBlockState paint) {
        ArrayList<IBakedModel> result = new ArrayList<IBakedModel>();
        result.add(PaintRegistry.getModel(IBakedModel.class, "fence_post", paint, null));
        if (((Boolean)state.func_177229_b((IProperty)BlockFence.field_176526_a)).booleanValue()) {
            result.add(PaintRegistry.getModel(IBakedModel.class, "fence_side", paint, new UVLock(null)));
        }
        if (((Boolean)state.func_177229_b((IProperty)BlockFence.field_176525_b)).booleanValue()) {
            result.add(PaintRegistry.getModel(IBakedModel.class, "fence_side", paint, new UVLock((IModelState)ModelRotation.X0_Y90)));
        }
        if (((Boolean)state.func_177229_b((IProperty)BlockFence.field_176527_M)).booleanValue()) {
            result.add(PaintRegistry.getModel(IBakedModel.class, "fence_side", paint, new UVLock((IModelState)ModelRotation.X0_Y180)));
        }
        if (((Boolean)state.func_177229_b((IProperty)BlockFence.field_176528_N)).booleanValue()) {
            result.add(PaintRegistry.getModel(IBakedModel.class, "fence_side", paint, new UVLock((IModelState)ModelRotation.X0_Y270)));
        }
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ICacheKey getCacheKey(@Nonnull Block block, @Nonnull ItemStack stack, @Nonnull ICacheKey cacheKey) {
        return cacheKey.addCacheKey(this.getPaintSource(block, stack));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBakedModel> mapItemRender(Block block, ItemStack stack) {
        IBlockState paintSource = this.getPaintSource(block, stack);
        IBlockState stdOverlay = BlockMachineBase.block.func_176223_P().func_177226_a(EnumRenderPart.SUB, (Comparable)((Object)EnumRenderPart.PAINT_OVERLAY));
        IBakedModel model1 = PaintRegistry.getModel(IBakedModel.class, "fence_inventory", paintSource, new UVLock(null));
        IBakedModel model2 = PaintRegistry.getModel(IBakedModel.class, "fence_inventory", stdOverlay, PaintRegistry.OVERLAY_TRANSFORMATION2);
        ArrayList<IBakedModel> list = new ArrayList<IBakedModel>();
        list.add(model1);
        list.add(model2);
        return list;
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return true;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        IBlockState bs = world.func_180495_p(pos);
        return bs.func_185904_a() == Material.field_151575_d ? 20 : super.getFlammability(world, pos, face);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        IBlockState bs = world.func_180495_p(pos);
        return bs.func_185904_a() == Material.field_151575_d ? 5 : super.getFireSpreadSpeed(world, pos, face);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        IBlockState blockState2;
        if (side.func_176740_k() != EnumFacing.Axis.Y && (blockState2 = worldIn.func_180495_p(pos)).func_177230_c() instanceof BlockPaintedFence && this.getPaintSource(blockState2, worldIn, pos) == this.getPaintSource(blockState2, worldIn, pos.func_177972_a(side.func_176734_d()))) {
            return false;
        }
        return super.func_176225_a(state, worldIn, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        if (tab != null) {
            super.func_149666_a(itemIn, tab, list);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBlockState> mapBlockRender(IBlockStateWrapper state, IBlockAccess world, BlockPos pos, BlockRenderLayer blockLayer, QuadCollector quadCollector) {
        IBlockState paintSource = this.getPaintSource(state, world, pos);
        if (PainterUtil2.canRenderInLayer(paintSource, blockLayer)) {
            for (IBakedModel model : this.mapRender(state, paintSource)) {
                quadCollector.addFriendlybakedModel(blockLayer, model, paintSource, MathHelper.func_180186_a((Vec3i)pos));
            }
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumMap<EnumFacing, IOMode.EnumIOMode> mapOverlayLayer(IBlockStateWrapper state, IBlockAccess world, BlockPos pos, boolean isPainted) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager effectRenderer) {
        return PaintHelper.addHitEffects(state, world, target, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager effectRenderer) {
        return PaintHelper.addDestroyEffects(world, pos, effectRenderer);
    }
}

