/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk.weather;

import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.api.common.util.ITankAccess;
import crazypants.enderio.ModObject;
import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.fluid.SmartTank;
import crazypants.enderio.fluid.SmartTankFluidHandler;
import crazypants.enderio.fluid.SmartTankFluidMachineHandler;
import crazypants.enderio.machine.AbstractPowerConsumerEntity;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.obelisk.weather.EntityFluidLoadingFX;
import crazypants.enderio.machine.obelisk.weather.EntityWeatherRocket;
import crazypants.enderio.machine.obelisk.weather.PacketActivateWeather;
import crazypants.enderio.machine.obelisk.weather.PacketWeatherTank;
import crazypants.enderio.network.PacketHandler;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Storable
public class TileWeatherObelisk
extends AbstractPowerConsumerEntity
implements IProgressTile,
ITankAccess.IExtendedTankAccess {
    private int fluidUsed = 0;
    private WeatherTask activeTask = null;
    private boolean canBeActive = true;
    private boolean tanksDirty;
    @Store
    private SmartTank inputTank = new SmartTank(8000){

        @Override
        public boolean canFillFluidType(FluidStack resource) {
            return super.canFillFluidType(resource) && resource != null && TileWeatherObelisk.this.isValidFluid(resource.getFluid());
        }
    };
    private float progress = 0.0f;
    private boolean playedFuse = false;
    private SmartTankFluidHandler smartTankFluidHandler;

    public TileWeatherObelisk() {
        super(new SlotDefinition(1, 0, 0), CapacitorKey.WEATHER_POWER_INTAKE, CapacitorKey.WEATHER_POWER_BUFFER, CapacitorKey.WEATHER_POWER_USE);
        this.inputTank.setTileEntity((TileEntity)this);
        this.inputTank.setCanDrain(false);
    }

    @Override
    public void init() {
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return ModObject.blockWeatherObelisk.getUnlocalisedName();
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        return i == 0 && itemstack != null && itemstack.func_77973_b() == Items.field_151152_bP;
    }

    @Override
    public boolean isActive() {
        return this.canBeActive && this.getActiveTask() != null;
    }

    public float getProgress() {
        return this.isActive() ? (this.field_145850_b.field_72995_K ? this.progress : (float)this.fluidUsed / 1000.0f) : 0.0f;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    protected int getProgressUpdateFreq() {
        return 3;
    }

    public TileEntity getTileEntity() {
        return this;
    }

    public WeatherTask getActiveTask() {
        return this.activeTask;
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        if (this.field_145850_b.field_72995_K && this.isActive() && this.field_145850_b.func_82737_E() % 2L == 0L) {
            this.doLoadingParticles();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doLoadingParticles() {
        if (this.progress < 0.9f) {
            Color c = this.getActiveTask().color;
            double correction = 0.1;
            BlockPos pos1 = this.func_174877_v();
            double xf = (double)pos1.func_177958_n() + 0.5 + correction;
            double yf = (double)pos1.func_177956_o() + 0.8;
            double zf = (double)pos1.func_177952_p() + 0.5 + correction;
            IBlockState bs = this.field_145850_b.func_180495_p(this.field_174879_c);
            double yi = bs.func_185900_c((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c).field_72337_e - 1.0;
            double offset = 0.3;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new EntityFluidLoadingFX(this.field_145850_b, (double)pos1.func_177958_n() + offset + correction, yi, (double)pos1.func_177952_p() + offset + correction, xf, yf, zf, c));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new EntityFluidLoadingFX(this.field_145850_b, (double)pos1.func_177958_n() + (1.0 - offset) + correction, yi, (double)pos1.func_177952_p() + offset + correction, xf, yf, zf, c));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new EntityFluidLoadingFX(this.field_145850_b, (double)pos1.func_177958_n() + (1.0 - offset) + correction, yi, (double)pos1.func_177952_p() + (1.0 - offset) + correction, xf, yf, zf, c));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new EntityFluidLoadingFX(this.field_145850_b, (double)pos1.func_177958_n() + offset + correction, yi, (double)pos1.func_177952_p() + (1.0 - offset) + correction, xf, yf, zf, c));
        } else if (!this.playedFuse) {
            this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
            this.playedFuse = true;
        }
    }

    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        boolean res = false;
        if (!redstoneCheck) {
            if (this.canBeActive) {
                this.canBeActive = false;
                res = true;
            }
            return res;
        }
        this.canBeActive = true;
        if (this.isActive()) {
            if (this.getEnergyStored(null) > this.getPowerUsePerTick() && this.inputTank.getFluidAmount() > 3) {
                this.setEnergyStored(this.getEnergyStored(null) - this.getPowerUsePerTick());
                int toUse = 4;
                this.inputTank.removeFluidAmount(toUse);
                this.fluidUsed += toUse;
            }
            if (this.fluidUsed >= 1000) {
                EntityWeatherRocket e = new EntityWeatherRocket(this.field_145850_b, this.activeTask);
                e.func_70107_b((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
                this.field_145850_b.func_72838_d((Entity)e);
                this.stopTask();
                res = true;
            }
        }
        if (this.tanksDirty && this.shouldDoWorkThisTick(5)) {
            PacketHandler.sendToAllAround((IMessage)new PacketWeatherTank(this), (TileEntity)this);
            this.tanksDirty = false;
        }
        return res;
    }

    public boolean canStartTask(WeatherTask task) {
        return task != null && this.getActiveTask() == null && !WeatherTask.worldIsState(task, this.field_145850_b) && this.func_70301_a(0) != null && this.inputTank.getFluidAmount() >= 1000 && task == WeatherTask.fromFluid(this.inputTank.getFluid().getFluid());
    }

    public boolean startTask() {
        if (this.getActiveTask() == null && this.inputTank.getFluidAmount() > 0) {
            this.fluidUsed = 0;
            WeatherTask task = WeatherTask.fromFluid(this.inputTank.getFluid().getFluid());
            if (this.canStartTask(task)) {
                this.func_70298_a(0, 1);
                this.activeTask = task;
                return true;
            }
        }
        return false;
    }

    public void stopTask() {
        if (this.getActiveTask() != null) {
            this.activeTask = null;
            this.fluidUsed = 0;
            if (!this.field_145850_b.field_72995_K) {
                PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketActivateWeather(this), this.field_145850_b.field_73011_w.getDimension());
            } else {
                this.playedFuse = false;
            }
        }
    }

    private boolean isValidFluid(Fluid f) {
        return f == Fluids.fluidLiquidSunshine || f == Fluids.fluidCloudSeed || f == Fluids.fluidCloudSeedConcentrated;
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        return forFluidType != null && forFluidType.getFluid() != null && this.isValidFluid(forFluidType.getFluid()) ? this.inputTank : null;
    }

    FluidTank getInputTank() {
        return this.inputTank;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[0];
    }

    public void setTanksDirty() {
        this.tanksDirty = true;
    }

    @Nonnull
    public List<ITankAccess.ITankData> getTankDisplayData() {
        return Collections.singletonList(new ITankAccess.ITankData(){

            @Nonnull
            public ITankAccess.ITankData.EnumTankType getTankType() {
                return ITankAccess.ITankData.EnumTankType.INPUT;
            }

            @Nullable
            public FluidStack getContent() {
                return TileWeatherObelisk.this.inputTank.getFluid();
            }

            public int getCapacity() {
                return TileWeatherObelisk.this.inputTank.getCapacity();
            }
        });
    }

    protected SmartTankFluidHandler getSmartTankFluidHandler() {
        if (this.smartTankFluidHandler == null) {
            this.smartTankFluidHandler = new SmartTankFluidMachineHandler(this, new IFluidHandler[]{this.inputTank});
        }
        return this.smartTankFluidHandler;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.getSmartTankFluidHandler().has(facingIn);
        }
        return super.hasCapability(capability, facingIn);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.getSmartTankFluidHandler().get(facingIn);
        }
        return super.getCapability(capability, facingIn);
    }

    public static enum WeatherTask {
        CLEAR(Color.YELLOW){

            @Override
            void complete(World world) {
                this.rain(world, false);
                this.thunder(world, false);
            }
        }
        ,
        RAIN(new Color(120, 120, 255)){

            @Override
            void complete(World world) {
                this.rain(world, true);
                this.thunder(world, false);
            }
        }
        ,
        STORM(Color.DARK_GRAY){

            @Override
            void complete(World world) {
                this.rain(world, true);
                this.thunder(world, true);
            }
        };

        final Color color;

        private WeatherTask(Color color) {
            this.color = color;
        }

        abstract void complete(World var1);

        protected void rain(World world, boolean state) {
            world.func_72912_H().func_76084_b(state);
        }

        protected void thunder(World world, boolean state) {
            world.func_72912_H().func_76069_a(state);
        }

        public static boolean worldIsState(WeatherTask task, World world) {
            if (world.func_72896_J()) {
                return world.func_72911_I() ? task == STORM : task == RAIN;
            }
            return task == CLEAR;
        }

        public static WeatherTask fromFluid(Fluid f) {
            if (f == Fluids.fluidLiquidSunshine) {
                return CLEAR;
            }
            if (f == Fluids.fluidCloudSeed) {
                return RAIN;
            }
            if (f == Fluids.fluidCloudSeedConcentrated) {
                return STORM;
            }
            return null;
        }
    }
}

