/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk.attractor;

import com.mojang.authlib.GameProfile;
import crazypants.enderio.ModObject;
import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.machine.FakePlayerEIO;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.obelisk.PacketObeliskFx;
import crazypants.enderio.machine.obelisk.attractor.AttractionHandlers;
import crazypants.enderio.machine.obelisk.attractor.IMobAttractionHandler;
import crazypants.enderio.machine.obelisk.spawn.AbstractMobObelisk;
import info.loenwind.autosave.annotations.Storable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.util.FakePlayer;

@Storable
public class TileAttractor
extends AbstractMobObelisk {
    private Target target;
    private int maxMobsAttracted = 20;
    private Map<EntityLiving, IMobAttractionHandler> tracking = new HashMap<EntityLiving, IMobAttractionHandler>();

    public TileAttractor() {
        super(new SlotDefinition(12, 0), CapacitorKey.ATTRACTOR_POWER_INTAKE, CapacitorKey.ATTRACTOR_POWER_BUFFER, CapacitorKey.ATTRACTOR_POWER_USE);
    }

    @Override
    public float getRange() {
        return CapacitorKey.ATTRACTOR_RANGE.get(this.getCapacitorData());
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return ModObject.blockAttractor.getUnlocalisedName();
    }

    private void untrackAll() {
        for (Map.Entry<EntityLiving, IMobAttractionHandler> tracked : this.tracking.entrySet()) {
            tracked.getValue().release(this, tracked.getKey());
        }
        this.tracking.clear();
    }

    private void cleanTrackedEntities() {
        Iterator<Map.Entry<EntityLiving, IMobAttractionHandler>> iterator = this.tracking.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<EntityLiving, IMobAttractionHandler> next = iterator.next();
            if (next.getKey().field_70128_L) {
                iterator.remove();
                continue;
            }
            if (!this.canAttract(next.getKey())) {
                next.getValue().release(this, next.getKey());
                iterator.remove();
                continue;
            }
            if (next.getKey().field_70170_p.field_73012_v.nextInt(4) != 0) continue;
            PacketObeliskFx.create((Entity)next.getKey(), EnumParticleTypes.PORTAL, EnumParticleTypes.PORTAL, EnumParticleTypes.VILLAGER_HAPPY);
        }
    }

    private void tickTrackedEntities() {
        for (Map.Entry<EntityLiving, IMobAttractionHandler> tracked : this.tracking.entrySet()) {
            if (tracked.getKey().field_70128_L) continue;
            tracked.getValue().tick(this, tracked.getKey());
        }
    }

    private void collectEntities() {
        for (EntityLiving entity : this.field_145850_b.func_72872_a(EntityLiving.class, (AxisAlignedBB)this.getBounds())) {
            if (entity.field_70128_L || this.tracking.containsKey(entity) || !this.canAttract(entity)) continue;
            this.collectEntity(entity);
            if (this.tracking.size() < this.maxMobsAttracted) continue;
            return;
        }
    }

    private void collectEntity(EntityLiving ent) {
        for (IMobAttractionHandler handler : AttractionHandlers.instance.getRegistry()) {
            if (!handler.canAttract(this, ent)) continue;
            handler.startAttracting(this, ent);
            this.tracking.put(ent, handler);
            PacketObeliskFx.create((Entity)ent, EnumParticleTypes.HEART, EnumParticleTypes.PORTAL, EnumParticleTypes.PORTAL, EnumParticleTypes.PORTAL, EnumParticleTypes.PORTAL, EnumParticleTypes.PORTAL, EnumParticleTypes.VILLAGER_HAPPY);
            return;
        }
    }

    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        if (!redstoneCheck || !this.hasPower()) {
            this.untrackAll();
            return false;
        }
        this.usePower();
        if (this.shouldDoWorkThisTick(60, 5)) {
            this.cleanTrackedEntities();
        }
        if (this.shouldDoWorkThisTick(10)) {
            this.tickTrackedEntities();
        }
        if (this.tracking.size() < this.maxMobsAttracted && this.shouldDoWorkThisTick(20, 5)) {
            this.collectEntities();
        }
        return false;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.untrackAll();
    }

    FakePlayer getTarget() {
        if (this.target == null) {
            this.target = new Target();
            this.target.setOwner(this.owner);
        }
        return this.target;
    }

    public boolean canAttract(EntityLiving mob) {
        return this.isMobInFilter((EntityLivingBase)mob) && this.getBounds().func_72326_a(mob.func_174813_aQ());
    }

    @Override
    public AbstractMobObelisk.SpawnObeliskAction getSpawnObeliskAction() {
        return AbstractMobObelisk.SpawnObeliskAction.ATTRACT;
    }

    private class Target
    extends FakePlayerEIO {
        public Target() {
            super(TileAttractor.this.func_145831_w(), TileAttractor.this.getLocation(), new GameProfile(null, ModObject.blockAttractor.getUnlocalisedName() + ":" + TileAttractor.this.getLocation()));
            this.field_70163_u += 1.0;
        }
    }
}

