/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel.remote;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.transform.EnderCoreMethods;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.Log;
import crazypants.enderio.ModObject;
import crazypants.enderio.item.PowerBarOverlayRenderHelper;
import crazypants.enderio.machine.invpanel.TileInventoryPanel;
import crazypants.enderio.machine.invpanel.remote.ClientRemoteGuiManager;
import crazypants.enderio.machine.invpanel.remote.ItemRemoteInvAccessType;
import crazypants.enderio.machine.invpanel.remote.ServerRemoteGuiManager;
import crazypants.enderio.power.IInternalPoweredItem;
import crazypants.enderio.power.PowerDisplayUtil;
import crazypants.enderio.render.IHaveRenderers;
import crazypants.util.ClientUtil;
import crazypants.util.NbtValue;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRemoteInvAccess
extends Item
implements IAdvancedTooltipProvider,
EnderCoreMethods.IOverlayRenderAware,
IFluidContainerItem,
IInternalPoweredItem,
IHaveRenderers {
    public static ItemRemoteInvAccess create() {
        ClientRemoteGuiManager.create();
        ItemRemoteInvAccess result = new ItemRemoteInvAccess();
        result.init();
        return result;
    }

    protected ItemRemoteInvAccess() {
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        this.func_77655_b(ModObject.itemRemoteInvAccess.getUnlocalisedName());
        this.setRegistryName(ModObject.itemRemoteInvAccess.getUnlocalisedName());
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(1);
    }

    protected void init() {
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers() {
        for (ItemRemoteInvAccessType type : ItemRemoteInvAccessType.values()) {
            ResourceLocation resourceLocation = new ResourceLocation(EnderIO.DOMAIN, type.getUnlocalizedName(ModObject.itemRemoteInvAccess.getUnlocalisedName()));
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{resourceLocation});
            ClientUtil.regRenderer((Item)this, type.toMetadata(), resourceLocation);
        }
    }

    public String func_77667_c(ItemStack stack) {
        return ItemRemoteInvAccessType.fromStack(stack).getUnlocalizedName(this.func_77658_a());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        for (ItemRemoteInvAccessType type : ItemRemoteInvAccessType.values()) {
            if (!type.isVisible()) continue;
            par3List.add(new ItemStack(par1, 1, type.toMetadata()));
            par3List.add(this.setFull(new ItemStack(par1, 1, type.toMetadata())));
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return super.func_77636_d(stack) || NbtValue.GLINT.hasTag(stack);
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (world.field_72995_K || !player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileInventoryPanel) {
            NbtValue.REMOTE_X.setInt(stack, te.func_174877_v().func_177958_n());
            NbtValue.REMOTE_Y.setInt(stack, te.func_174877_v().func_177956_o());
            NbtValue.REMOTE_Z.setInt(stack, te.func_174877_v().func_177952_p());
            NbtValue.REMOTE_D.setInt(stack, te.func_145831_w().field_73011_w.getDimension());
            player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("remoteinv.chat.set")));
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack equipped, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            if (!(NbtValue.REMOTE_X.hasTag(equipped) && NbtValue.REMOTE_Y.hasTag(equipped) && NbtValue.REMOTE_Z.hasTag(equipped) && NbtValue.REMOTE_D.hasTag(equipped))) {
                player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("remoteinv.chat.notarget")));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)equipped);
            }
            int x = NbtValue.REMOTE_X.getInt(equipped);
            int y = NbtValue.REMOTE_Y.getInt(equipped);
            int z = NbtValue.REMOTE_Z.getInt(equipped);
            int d = NbtValue.REMOTE_D.getInt(equipped);
            ItemRemoteInvAccessType type = ItemRemoteInvAccessType.fromStack(equipped);
            if (!type.inRange(d, x, y, z, world.field_73011_w.getDimension(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v)) {
                player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("remoteinv.chat.outofrange")));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)equipped);
            }
            World targetWorld = world;
            if (world.field_73011_w.getDimension() != d && (targetWorld = DimensionManager.getWorld((int)d)) == null) {
                player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("remoteinv.chat.invalidtargetworld")));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)equipped);
            }
            BlockPos pos = new BlockPos(x, y, z);
            if (!targetWorld.func_175667_e(pos)) {
                player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("remoteinv.chat.notloaded")));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)equipped);
            }
            if (targetWorld.func_180495_p(pos).func_177230_c() != ModObject.blockInventoryPanel.getBlock()) {
                player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("remoteinv.chat.invalidtarget")));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)equipped);
            }
            if (!(world instanceof WorldServer) || !(player instanceof EntityPlayerMP)) {
                Log.warn("Unexpected world or player: " + world + " " + player);
                player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("remoteinv.chat.error")));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)equipped);
            }
            if (this.getEnergyStored(equipped) < type.getRfPerTick() * 10) {
                player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("remoteinv.chat.outofpower")));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)equipped);
            }
            if (!this.drain(equipped, type.getMbPerOpen())) {
                Fluid fluid = type.getFluidType();
                String fluidname = fluid.getLocalizedName(new FluidStack(fluid, 1));
                player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("remoteinv.chat.outoffluid").replace("{FLUIDNAME}", fluidname)));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)equipped);
            }
            ServerRemoteGuiManager.openGui((EntityPlayerMP)player, targetWorld, pos);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)equipped);
        }
        return super.func_77659_a(equipped, world, player, hand);
    }

    public boolean canInteractWith(ItemStack stack, EntityPlayer player) {
        if (this.getEnergyStored(stack) > 0) {
            return true;
        }
        player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localize("remoteinv.chat.outofpower")));
        return false;
    }

    public void tick(ItemStack stack, EntityPlayer player) {
        if (EnderIO.proxy.getServerTickCount() % 10L == 0L) {
            ItemRemoteInvAccessType type = ItemRemoteInvAccessType.fromStack(stack);
            this.extractInternal(stack, type.getRfPerTick() * 10);
        }
    }

    private boolean extractInternal(ItemStack item, int powerUse) {
        int stored = this.getEnergyStored(item);
        if (stored >= powerUse) {
            this.setEnergyStored(item, stored - powerUse);
            return true;
        }
        if (stored > 0) {
            this.setEnergyStored(item, 0);
        }
        return false;
    }

    public ItemStack setFull(ItemStack container) {
        this.setEnergyStored(container, this.getMaxEnergyStored(container));
        NbtValue.FLUIDAMOUNT.setInt(container, this.getCapacity(container));
        return container;
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        this.setEnergyStored(itemStack, 0);
    }

    public void renderItemOverlayIntoGUI(ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance_fluid.render(stack, xPosition, yPosition, PowerBarOverlayRenderHelper.instance.render(stack, xPosition, yPosition) ? 1 : 0);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged ? super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) : oldStack == null || newStack == null || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer par2EntityPlayer, List<String> list, boolean par4) {
        super.func_77624_a(itemStack, par2EntityPlayer, list, par4);
        list.add(PowerDisplayUtil.formatPower(this.getEnergyStored(itemStack)) + "/" + PowerDisplayUtil.formatPower(this.getMaxEnergyStored(itemStack)) + " " + PowerDisplayUtil.abrevation());
        list.add(NbtValue.FLUIDAMOUNT.getInt(itemStack, 0) + " " + EnderIO.lang.localize("fluid.millibucket.abr") + " " + PowerDisplayUtil.ofStr() + " " + this.getFluidType(itemStack).getLocalizedName(null));
    }

    public FluidStack getFluid(ItemStack container) {
        int amount = NbtValue.FLUIDAMOUNT.getInt(container, 0);
        if (amount > 0) {
            return new FluidStack(this.getFluidType(container), amount);
        }
        return null;
    }

    public int getCapacity(ItemStack container) {
        return ItemRemoteInvAccessType.fromStack(container).getFluidCapacity();
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (container == null || container.func_77973_b() != this || resource == null || resource.amount <= 0 || resource.getFluid() == null || resource.getFluid() != this.getFluidType(container)) {
            return 0;
        }
        int amount = NbtValue.FLUIDAMOUNT.getInt(container, 0);
        int capacity = this.getCapacity(container);
        int free = capacity - amount;
        int toFill = Math.min(resource.amount, free);
        if (toFill > 0 && doFill) {
            NbtValue.FLUIDAMOUNT.setInt(container, amount + toFill);
        }
        return toFill;
    }

    @Nonnull
    public Fluid getFluidType(ItemStack stack) {
        return ItemRemoteInvAccessType.fromStack(stack).getFluidType();
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        return null;
    }

    private boolean drain(ItemStack container, int toDrain) {
        int amount = NbtValue.FLUIDAMOUNT.getInt(container, 0);
        if (toDrain > amount) {
            return false;
        }
        NbtValue.FLUIDAMOUNT.setInt(container, amount - toDrain);
        return true;
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return ItemRemoteInvAccessType.fromStack(container).getRfCapacity();
    }

    @Override
    public void setEnergyStored(ItemStack container, int energy) {
        NbtValue.ENERGY.setInt(container, energy);
    }

    @Override
    public int getEnergyStored(ItemStack stack) {
        return NbtValue.ENERGY.getInt(stack);
    }

    @Override
    public int getMaxInput(ItemStack stack) {
        return ItemRemoteInvAccessType.fromStack(stack).getRfCapacity() / 100;
    }

    @Override
    public int getMaxOutput(ItemStack stack) {
        return 0;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new CapabilityProvider(stack);
    }

    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        SpecialTooltipHandler.addCommonTooltipFromResources(list, (String)this.func_77667_c(itemstack));
    }

    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        SpecialTooltipHandler.addBasicTooltipFromResources(list, (String)this.func_77667_c(itemstack));
    }

    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        ArrayList list0 = new ArrayList();
        SpecialTooltipHandler.addDetailedTooltipFromResources(list0, (String)this.func_77667_c(itemstack));
        Fluid fluid = this.getFluidType(itemstack);
        String fluidname = fluid.getLocalizedName(new FluidStack(fluid, 1));
        for (String string : list0) {
            list.add(string.replace("{FLUIDNAME}", fluidname));
        }
    }

    private class CapabilityProvider
    implements IFluidHandler,
    ICapabilityProvider {
        protected final ItemStack container;

        private CapabilityProvider(ItemStack container) {
            this.container = container;
        }

        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)this;
            }
            return null;
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{new IFluidTankProperties(){

                @Nullable
                public FluidStack getContents() {
                    return ItemRemoteInvAccess.this.getFluid(CapabilityProvider.this.container);
                }

                public int getCapacity() {
                    return ItemRemoteInvAccess.this.getCapacity(CapabilityProvider.this.container);
                }

                public boolean canFill() {
                    return true;
                }

                public boolean canDrain() {
                    return false;
                }

                public boolean canFillFluidType(FluidStack fluidStack) {
                    return fluidStack != null && fluidStack.getFluid() == ItemRemoteInvAccess.this.getFluidType(CapabilityProvider.this.container);
                }

                public boolean canDrainFluidType(FluidStack fluidStack) {
                    return false;
                }
            }};
        }

        public int fill(FluidStack resource, boolean doFill) {
            return ItemRemoteInvAccess.this.fill(this.container, resource, doFill);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }
    }
}

