/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.gui;

import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.RenderUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.AbstractPoweredMachineEntity;
import crazypants.enderio.machine.gui.GuiMachineBase;
import crazypants.enderio.power.PowerDisplayUtil;
import info.loenwind.scheduler.Celeb;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;

public abstract class GuiPoweredMachineBase<T extends AbstractPoweredMachineEntity>
extends GuiMachineBase<T> {
    protected static final int POWER_Y = 14;
    protected final int POWER_X = 15;
    protected static final int POWER_WIDTH = 10;
    protected static final int POWER_HEIGHT = 42;
    protected static final int BOTTOM_POWER_Y = 56;
    private static final List<String> lang = Arrays.asList("Krismasi Njema", "UKhisimusi omuhle", "Moni Wa Chikondwelero Cha Kristmasi", "\u06a9\u0631\u0633\u0645\u0633 \u0645\u0628\u0627\u0631\u06a9", "G\u00ebzuar Krishtlindjen", "\u0639\u064a\u062f \u0645\u064a\u0644\u0627\u062f \u0645\u062c\u064a\u062f", "\u0547\u0576\u0578\u0580\u0570\u0561\u057e\u0578\u0580 \u0531\u0574\u0561\u0576\u0578\u0580 \u0587 \u054d\u0578\u0582\u0580\u0562 \u053e\u0576\u0578\u0582\u0576\u0564", "Vrolijk Kerstfeest", "djoyeus Noy\u00e9", "'vesela 'koleda", "\u5723\u8bde\u5feb\u4e50", "\u8056\u8a95\u5feb\u6a02", "Sretan Bo\u017ei\u0107", "Prejeme Vam Vesele Vanoce", "Gl\u00e6delig Jul", "Mbotama Malamu", "Feli\u0109an Kristnaskon", "R\u00f5\u00f5msaid J\u00f5ulup\u00fchi", "Hyv\u00e4\u00e4 Joulua", "Joyeux No\u00ebl", "Nedeleg Laouen", "Bon Natale", "Frohe Weihnachten", "Ni ti Burunya Chou", "Afishapa", "\u039a\u03b1\u03bb\u03ac \u03a7\u03c1\u03b9\u03c3\u03c4\u03bf\u03cd\u03b3\u03b5\u03bd\u03bd\u03b1", "\u10d2\u10d8\u10da\u10dd\u10ea\u10d0\u10d5 \u10e8\u10dd\u10d1\u10d0-\u10d0\u10ee\u10d0\u10da \u10ec\u10d4\u10da\u10e1", "Juullimi Pilluarit", "Mele Kalikimaka", "Prettig Kerstfeest", "Kellemes kar\u00e1csonyi \u00fcnnepeket", "Gle\u00f0ileg j\u00f3l", "\u0936\u0941\u092d \u0915\u094d\u0930\u093f\u0938\u092e\u0938", "\u06a9\u0631\u0633\u0645\u0633", "Krismasasya shubhkaamnaa", "\u0a86\u0aa8\u0a82\u0aa6\u0ac0 \u0aa8\u0abe\u0aa4\u0abe\u0ab2", "\u09b6\u09c1\u09ad \u09ac\u09dc\u09a6\u09bf\u09a8", "\u0b95\u0bbf\u0bb1\u0bbf\u0bb8\u0bcd\u0ba4\u0bc1\u0bae\u0bb8\u0bcd \u0bb5\u0bbe\u0bb4\u0bcd\u0ba4\u0bcd\u0ba4\u0bc1\u0b95\u0bcd\u0b95\u0bb3\u0bcd", "Khushal Borit Natala", "\u0c95\u0ccd\u0cb0\u0cbf\u0cb8\u0ccd \u0cae\u0cb8\u0ccd \u0cb9\u0cac\u0ccd\u0cac\u0ca6 \u0cb6\u0cc1\u0cad\u0cbe\u0cb7\u0caf\u0c97\u0cb3\u0cc1", "Krismas Chibai", "\u0936\u0941\u092d \u0928\u093e\u0924\u093e\u0933", "\u0a15\u0a30\u0a3f\u0a38\u0a2e \u0a24\u0a47 \u0a28\u0a35\u0a3e\u0a70 \u0a38\u0a3e\u0a32 \u0a16\u0a41\u0a38\u0a3c\u0a3f\u0a2f\u0a3e\u0a70\u0a35\u0a3e\u0a32\u0a3e \u0a39\u0a4b\u0a35\u0a47", "Christmas inte mangalaashamsakal", "Christmas Subhakankshalu", "Selamat Natal", "Christmas MobArak", "Kir\u00eesmes u ser sala we p\u00eeroz be", "Nollaig Shona Dhuit", "\u05d7\u05d2 \u05de\u05d5\u05dc\u05d3 \u05e9\u05de\u05d7", "Buon Natale", "Bon Natali", "\u3081\u308a\u30fc\u304f\u308a\u3059\u307e\u3059", "\uba54\ub9ac \ud06c\ub9ac\uc2a4\ub9c8\uc2a4", "Priec\u00efgus Ziemassv\u00batkus", "Linksm\u0173 Kal\u0117d\u0173", "\u0421\u0440\u0435\u045c\u0435\u043d \u0411\u043e\u0436\u0438\u043a", "Tratra ny Noely", "Il-Milied it-Tajjeb", "Selamat Hari Natal", "Puthuvalsara Aashamsakal", "Gozhqq Keshmish", "Nizhonigo Keshmish", "Quvianagli Anaiyyuniqpaliqsi", "Alussistuakeggtaarmek", "\u0915\u094d\u0930\u0938\u094d\u092e\u0938\u0915\u094b \u0936\u0941\u092d\u0915\u093e\u092e\u0928\u093e", "Meri Kirihimete", "barka d\u00e0 Kirs\u00ecmat\u00ec", "E ku odun", "Jabbama be salla Kirismati", "E keresimesi Oma", "Iselogbe", "Idara ukapade isua", "God Jul", "Maligayang Pasko", "Naragsak Nga Paskua", "Malipayon nga Pascua", "Maayong Pasko", "Maugmang Pasko", "Maabig ya pasko", "Weso\u0142ych \u015awi\u0105t Bo\u017cego Narodzenia", "Feliz Natal", "Cr\u1eb7ciun Fericit", "C \u0440\u043e\u0436\u0434\u0435\u0441\u0442\u0432\u043e\u043c", "Noheli nziza", "Manuia Le Kerisimasi", "Blithe Yule", "Nollaig Chridheil", "\u0425\u0440\u0438\u0441\u0442\u043e\u0441 \u0441\u0435 \u0440\u043e\u0434\u0438", "Vesele Vianoce", "Vesel Bo\u017ei\u010d", "Kirismas Wacan", "Gese\u00ebnde Kersfees", "Feliz Navidad", "Bon Nadal", "Bo Nadal", "Eguberri on", "Sch\u00f6ni Wiehnachte", "Suk sarn warn Christmas", "Mutlu Noeller", "Seku Kulu", "\u0412\u0435\u0441\u0435\u043b\u043e\u0433\u043e \u0420\u0456\u0437\u0434\u0432\u0430 \u0456 \u0437 \u041d\u043e\u0432\u0438\u043c \u0420\u043e\u043a\u043e\u043c", "Chu\u0107 M\u01b0\u01f9g Gia\u0144g Sinh", "Nadolig Llawen", "Muve neKisimusi", "Izilokotho Ezihle Zamaholdeni", "toDwI'ma' qoS yItIvqu'", "Alass\u00eb a Hristomerend\u00eb", "Mereth Veren e-Doled Eruion", "Politically Correct Season Greetings");

    public GuiPoweredMachineBase(T machine, Container container, String ... guiTexture) {
        super(machine, container, guiTexture);
        if (this.renderPowerBar()) {
            this.addToolTip(new GuiToolTip(new Rectangle(this.getPowerX(), this.getPowerY(), this.getPowerWidth(), this.getPowerHeight()), new String[]{""}){

                protected void updateText() {
                    this.text.clear();
                    if (GuiPoweredMachineBase.this.renderPowerBar()) {
                        GuiPoweredMachineBase.this.updatePowerBarTooltip(this.text);
                    }
                }
            });
        }
    }

    protected String getPowerOutputLabel() {
        return I18n.func_135052_a((String)"enderio.gui.max", (Object[])new Object[0]);
    }

    protected int getPowerOutputValue() {
        return ((AbstractPoweredMachineEntity)this.getTileEntity()).getPowerUsePerTick();
    }

    protected void updatePowerBarTooltip(List<String> text) {
        if (Celeb.C24.isOn()) {
            int frame = (int)(EnderIO.proxy.getTickCount() / 30L % (long)(lang.size() - 1));
            if (frame == 0) {
                Collections.shuffle(lang);
            }
            text.add(lang.get(frame));
        }
        text.add(this.getPowerOutputLabel() + " " + PowerDisplayUtil.formatPower(this.getPowerOutputValue()) + " " + PowerDisplayUtil.abrevation() + PowerDisplayUtil.perTickStr());
        text.add(PowerDisplayUtil.formatStoredPower(((AbstractPoweredMachineEntity)this.getTileEntity()).getEnergyStored(), ((AbstractPoweredMachineEntity)this.getTileEntity()).getMaxEnergyStored()));
    }

    public void renderPowerBar(int k, int l) {
        if (this.renderPowerBar()) {
            int i1 = ((AbstractPoweredMachineEntity)this.getTileEntity()).getEnergyStoredScaled(this.getPowerHeight());
            this.func_73729_b(k + this.getPowerX(), l + (this.getPowerY() + this.getPowerHeight()) - i1, this.getPowerU(), this.getPowerV(), this.getPowerWidth(), i1);
            if (Celeb.C24.isOn()) {
                i1 = this.getPowerHeight();
                int frame = (int)(EnderIO.proxy.getTickCount() / 3L % 25L) * 10;
                RenderUtil.bindTexture((String)(EnderIO.DOMAIN + ":textures/gui/overlay.png"));
                this.func_73729_b(k + this.getPowerX(), l + (this.getPowerY() + this.getPowerHeight()) - i1, frame, 0, this.getPowerWidth(), i1);
                this.bindGuiTexture();
            }
        }
    }

    protected int getPowerX() {
        return 15;
    }

    protected int getPowerY() {
        return 14;
    }

    protected int getPowerWidth() {
        return 10;
    }

    protected int getPowerHeight() {
        return 42;
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        this.renderPowerBar(k, l);
        super.func_146976_a(par1, par2, par3);
    }

    protected int getPowerV() {
        return 31;
    }

    protected int getPowerU() {
        return 176;
    }

    protected boolean renderPowerBar() {
        return true;
    }
}

