/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.EntityUtil;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.ModObject;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.machine.IIoConfigurable;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.machine.capbank.CapBankType;
import crazypants.enderio.machine.capbank.InfoDisplayType;
import crazypants.enderio.machine.capbank.network.CapBankClientNetwork;
import crazypants.enderio.machine.capbank.network.ClientNetworkManager;
import crazypants.enderio.machine.capbank.network.EnergyReceptor;
import crazypants.enderio.machine.capbank.network.ICapBankNetwork;
import crazypants.enderio.machine.capbank.network.InventoryImpl;
import crazypants.enderio.machine.capbank.network.NetworkUtil;
import crazypants.enderio.machine.capbank.packet.PacketNetworkIdRequest;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.IInternalPowerReceiver;
import crazypants.enderio.power.IPowerInterface;
import crazypants.enderio.power.IPowerStorage;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.util.NbtValue;
import crazypants.util.NullHelper;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.handlers.enderio.HandleDisplayMode;
import info.loenwind.autosave.handlers.enderio.HandleIOMode;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Storable
public class TileCapBank
extends TileEntityEio
implements IInternalPowerReceiver,
IInventory,
IIoConfigurable,
IPowerStorage {
    @Store(handler=HandleIOMode.class)
    private Map<EnumFacing, IoMode> faceModes;
    @Store(handler=HandleDisplayMode.class)
    private Map<EnumFacing, InfoDisplayType> faceDisplayTypes;
    @Store
    private CapBankType type;
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.CLIENT})
    private int energyStored;
    @Store
    private int maxInput = -1;
    @Store
    private int maxOutput = -1;
    @Store
    private RedstoneControlMode inputControlMode = RedstoneControlMode.IGNORE;
    @Store
    private RedstoneControlMode outputControlMode = RedstoneControlMode.IGNORE;
    private boolean redstoneStateDirty = true;
    private final List<EnergyReceptor> receptors = new ArrayList<EnergyReceptor>();
    private boolean receptorsDirty = true;
    private ICapBankNetwork network;
    @Store
    private final ItemStack[] inventory = new ItemStack[4];
    private int networkId = -1;
    private int idRequestTimer = 0;
    private boolean dropItems;
    private boolean displayTypesDirty;
    private boolean revalidateDisplayTypes;
    private int lastComparatorState;

    public CapBankType getType() {
        if (this.type == null) {
            if (!this.func_145830_o()) {
                return CapBankType.VIBRANT;
            }
            this.type = CapBankType.getTypeFromMeta(this.func_145832_p());
        }
        return this.type;
    }

    public void onNeighborBlockChange(Block blockId) {
        this.redstoneStateDirty = true;
        this.revalidateDisplayTypes = true;
        this.updateReceptors();
    }

    @SideOnly(value=Side.CLIENT)
    public void setNetworkId(int networkId) {
        this.networkId = networkId;
        if (networkId != -1) {
            ClientNetworkManager.getInstance().addToNetwork(networkId, this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getNetworkId() {
        return this.networkId;
    }

    public ICapBankNetwork getNetwork() {
        return this.network;
    }

    public boolean setNetwork(ICapBankNetwork network) {
        this.network = network;
        return true;
    }

    public boolean canConnectTo(TileCapBank cap) {
        CapBankType myType = this.getType();
        return myType.isMultiblock() && myType == cap.getType();
    }

    public void onChunkUnload() {
        if (this.network != null) {
            this.network.destroyNetwork();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.network != null) {
            this.network.destroyNetwork();
        }
    }

    public void moveInventoryToNetwork() {
        if (this.network == null) {
            return;
        }
        if (this.network.getInventory().getCapBank() == this && !InventoryImpl.isInventoryEmtpy(this.inventory)) {
            for (TileCapBank cb : this.network.getMembers()) {
                if (cb == this) continue;
                for (int i = 0; i < this.inventory.length; ++i) {
                    cb.inventory[i] = this.inventory[i];
                    this.inventory[i] = null;
                }
                this.network.getInventory().setCapBank(cb);
                this.func_70296_d();
                cb.func_70296_d();
                break;
            }
        }
    }

    public void onBreakBlock() {
        this.moveInventoryToNetwork();
    }

    @Override
    public void doUpdate() {
        int comparatorState;
        if (this.field_145850_b.field_72995_K) {
            if (this.networkId == -1) {
                if (this.idRequestTimer <= 0) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketNetworkIdRequest(this));
                    this.idRequestTimer = 5;
                } else {
                    --this.idRequestTimer;
                }
            }
            return;
        }
        if (this.network == null) {
            NetworkUtil.ensureValidNetwork(this);
            if (this.network == null) {
                return;
            }
        }
        if (this.redstoneStateDirty) {
            int sig = this.field_145850_b.func_175687_A(this.func_174877_v());
            boolean recievingSignal = sig > 0;
            this.network.updateRedstoneSignal(this, recievingSignal);
            this.redstoneStateDirty = false;
        }
        if (this.receptorsDirty) {
            this.updateReceptors();
        }
        if (this.revalidateDisplayTypes) {
            this.validateDisplayTypes();
            this.revalidateDisplayTypes = false;
        }
        if (this.displayTypesDirty) {
            this.displayTypesDirty = false;
            IBlockState bs = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, bs, bs, 3);
        }
        if (this.lastComparatorState != (comparatorState = this.getComparatorOutput())) {
            this.field_145850_b.func_175666_e(this.func_174877_v(), this.func_145838_q());
            this.lastComparatorState = comparatorState;
        }
        this.doDropItems();
    }

    @Override
    @Nonnull
    public IoMode toggleIoModeForFace(@Nullable EnumFacing faceHit) {
        if (faceHit == null) {
            return IoMode.NONE;
        }
        IPowerInterface rec = this.getReceptorForFace(faceHit);
        IoMode curMode = this.getIoMode(faceHit);
        if (curMode == IoMode.PULL) {
            this.setIoMode(faceHit, IoMode.PUSH, true);
            return IoMode.PUSH;
        }
        if (curMode == IoMode.PUSH) {
            this.setIoMode(faceHit, IoMode.DISABLED, true);
            return IoMode.DISABLED;
        }
        if (curMode == IoMode.DISABLED && (rec == null || rec.getProvider() instanceof IConduitBundle)) {
            this.setIoMode(faceHit, IoMode.NONE, true);
            return IoMode.NONE;
        }
        this.setIoMode(faceHit, IoMode.PULL, true);
        return IoMode.PULL;
    }

    @Override
    public boolean supportsMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
        if (faceHit == null || mode == null) {
            return false;
        }
        IPowerInterface rec = this.getReceptorForFace(faceHit);
        if (mode == IoMode.NONE) {
            return rec == null || rec.getProvider() instanceof IConduitBundle;
        }
        return true;
    }

    @Override
    public void setIoMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
        if (faceHit != null && mode != null) {
            this.setIoMode(faceHit, mode, true);
        }
    }

    public void setIoMode(@Nonnull EnumFacing faceHit, @Nonnull IoMode mode, boolean updateReceptors) {
        if (mode == IoMode.NONE) {
            if (this.faceModes == null) {
                return;
            }
            this.faceModes.remove(faceHit);
            if (this.faceModes.isEmpty()) {
                this.faceModes = null;
            }
        } else {
            if (this.faceModes == null) {
                this.faceModes = new EnumMap<EnumFacing, IoMode>(EnumFacing.class);
            }
            this.faceModes.put(faceHit, mode);
        }
        if (updateReceptors) {
            this.validateModeForReceptor(faceHit);
            this.receptorsDirty = true;
        }
        if (this.func_145830_o()) {
            IBlockState bs = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, bs, bs, 3);
            this.field_145850_b.func_180496_d(this.func_174877_v(), this.func_145838_q());
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
        }
    }

    public void setDefaultIoMode(@Nonnull EnumFacing faceHit) {
        EnergyReceptor er = this.getEnergyReceptorForFace(faceHit);
        if (er == null || er.getConduit() != null) {
            this.setIoMode(faceHit, IoMode.NONE);
        } else if (er.getReceptor().canReceive()) {
            this.setIoMode(faceHit, IoMode.PUSH);
        } else {
            this.setIoMode(faceHit, IoMode.PULL);
        }
    }

    @Override
    public void clearAllIoModes() {
        if (this.network != null) {
            for (TileCapBank cb : this.network.getMembers()) {
                cb.doClearAllIoModes();
            }
        } else {
            this.doClearAllIoModes();
        }
    }

    private void doClearAllIoModes() {
        for (EnumFacing dir : EnumFacing.values()) {
            this.setDefaultIoMode(NullHelper.notnullJ(dir, "Enum.values()"));
        }
    }

    @Override
    @Nonnull
    public IoMode getIoMode(@Nullable EnumFacing face) {
        if (this.faceModes == null) {
            return IoMode.NONE;
        }
        IoMode res = this.faceModes.get(face);
        if (res == null) {
            return IoMode.NONE;
        }
        return res;
    }

    public boolean hasDisplayTypes() {
        return this.faceDisplayTypes != null && !this.faceDisplayTypes.isEmpty();
    }

    @Nonnull
    public InfoDisplayType getDisplayType(EnumFacing face) {
        if (this.faceDisplayTypes == null) {
            return InfoDisplayType.NONE;
        }
        InfoDisplayType res = this.faceDisplayTypes.get(face);
        return res == null ? InfoDisplayType.NONE : res;
    }

    public void setDisplayType(EnumFacing face, InfoDisplayType type) {
        this.setDisplayType(face, type, true);
    }

    public void setDisplayType(EnumFacing face, InfoDisplayType type, boolean markDirty) {
        if (type == null) {
            type = InfoDisplayType.NONE;
        }
        if (this.faceDisplayTypes == null && type == InfoDisplayType.NONE) {
            return;
        }
        InfoDisplayType cur = this.getDisplayType(face);
        if (cur == type) {
            return;
        }
        if (this.faceDisplayTypes == null) {
            this.faceDisplayTypes = new EnumMap<EnumFacing, InfoDisplayType>(EnumFacing.class);
        }
        if (type == InfoDisplayType.NONE) {
            this.faceDisplayTypes.remove(face);
        } else {
            this.faceDisplayTypes.put(face, type);
        }
        if (this.faceDisplayTypes.isEmpty()) {
            this.faceDisplayTypes = null;
        }
        this.displayTypesDirty = markDirty;
        this.invalidateDisplayInfoCache();
    }

    public void validateDisplayTypes() {
        if (this.faceDisplayTypes == null) {
            return;
        }
        ArrayList<EnumFacing> reset = new ArrayList<EnumFacing>();
        for (Map.Entry<EnumFacing, InfoDisplayType> entry : this.faceDisplayTypes.entrySet()) {
            IBlockState bs = this.field_145850_b.func_180495_p(this.func_174877_v().func_177972_a(NullHelper.notnullJ(entry.getKey(), "EnumMap.getKey()")));
            if (!bs.func_185914_p() && bs.func_177230_c() != ModObject.blockCapBank.getBlock()) continue;
            reset.add(entry.getKey());
        }
        for (EnumFacing dir : reset) {
            this.setDisplayType(dir, InfoDisplayType.NONE);
            this.setDefaultIoMode(NullHelper.notnullJ(dir, "Enum.values()"));
        }
    }

    private void invalidateDisplayInfoCache() {
        if (this.network != null) {
            this.network.invalidateDisplayInfoCache();
        }
    }

    public boolean shouldRenderInPass(int pass) {
        if (this.faceDisplayTypes == null) {
            return false;
        }
        return pass == 0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (!this.getType().isMultiblock() || !(this.network instanceof CapBankClientNetwork)) {
            return super.getRenderBoundingBox();
        }
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        int minX = xCoord;
        int minY = yCoord;
        int minZ = zCoord;
        int maxX = minX + 1;
        int maxY = minY + 1;
        int maxZ = minZ + 1;
        if (this.faceDisplayTypes != null) {
            CapBankClientNetwork.IOInfo info;
            CapBankClientNetwork cn = (CapBankClientNetwork)this.network;
            if (this.faceDisplayTypes.get(EnumFacing.NORTH) == InfoDisplayType.IO) {
                info = cn.getIODisplayInfo(xCoord, yCoord, zCoord, EnumFacing.NORTH);
                maxX = Math.max(maxX, xCoord + info.width);
                minY = Math.min(minY, yCoord + 1 - info.height);
            }
            if (this.faceDisplayTypes.get(EnumFacing.SOUTH) == InfoDisplayType.IO) {
                info = cn.getIODisplayInfo(xCoord, yCoord, zCoord, EnumFacing.SOUTH);
                minX = Math.min(minX, xCoord + 1 - info.width);
                minY = Math.min(minY, yCoord + 1 - info.height);
            }
            if (this.faceDisplayTypes.get(EnumFacing.EAST) == InfoDisplayType.IO) {
                info = cn.getIODisplayInfo(xCoord, yCoord, zCoord, EnumFacing.EAST);
                maxZ = Math.max(maxZ, zCoord + info.width);
                minY = Math.min(minY, yCoord + 1 - info.height);
            }
            if (this.faceDisplayTypes.get(EnumFacing.WEST) == InfoDisplayType.IO) {
                info = cn.getIODisplayInfo(xCoord, yCoord, zCoord, EnumFacing.WEST);
                minZ = Math.min(minZ, zCoord + 1 - info.width);
                minY = Math.min(minY, yCoord + 1 - info.height);
            }
        }
        return new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public RedstoneControlMode getInputControlMode() {
        return this.inputControlMode;
    }

    public void setInputControlMode(RedstoneControlMode inputControlMode) {
        this.inputControlMode = inputControlMode;
    }

    public RedstoneControlMode getOutputControlMode() {
        return this.outputControlMode;
    }

    public void setOutputControlMode(RedstoneControlMode outputControlMode) {
        this.outputControlMode = outputControlMode;
    }

    @Override
    public IPowerStorage getController() {
        return this.network;
    }

    @Override
    public long getEnergyStoredL() {
        if (this.network == null) {
            return this.getEnergyStored(null);
        }
        return this.network.getEnergyStoredL();
    }

    @Override
    public long getMaxEnergyStoredL() {
        if (this.network == null) {
            return this.getMaxEnergyStored(null);
        }
        return this.network.getMaxEnergyStoredL();
    }

    @Override
    public int getAverageIOPerTick() {
        return this.network == null ? 0 : this.network.getAverageIOPerTick();
    }

    @Override
    public boolean isOutputEnabled(@Nonnull EnumFacing direction) {
        IoMode mode = this.getIoMode(direction);
        return mode == IoMode.PUSH || mode == IoMode.NONE && this.isOutputEnabled();
    }

    private boolean isOutputEnabled() {
        if (this.network == null) {
            return true;
        }
        return this.network.isOutputEnabled();
    }

    @Override
    public boolean isInputEnabled(@Nonnull EnumFacing direction) {
        IoMode mode = this.getIoMode(direction);
        return mode == IoMode.PULL || mode == IoMode.NONE && this.isInputEnabled();
    }

    private boolean isInputEnabled() {
        if (this.network == null) {
            return true;
        }
        return this.network.isInputEnabled();
    }

    @Override
    public boolean isNetworkControlledIo(@Nonnull EnumFacing direction) {
        IoMode mode = this.getIoMode(direction);
        return mode == IoMode.NONE || mode == IoMode.PULL;
    }

    @Override
    public boolean isCreative() {
        return this.getType().isCreative();
    }

    public List<EnergyReceptor> getReceptors() {
        if (this.receptorsDirty) {
            this.updateReceptors();
        }
        return this.receptors;
    }

    private void updateReceptors() {
        if (this.network == null) {
            return;
        }
        this.network.removeReceptors(this.receptors);
        this.receptors.clear();
        for (EnumFacing dir : EnumFacing.values()) {
            IoMode ioMode;
            IPowerInterface pi = this.getReceptorForFace(NullHelper.notnullJ(dir, "Enum.values()"));
            if (pi == null || (ioMode = this.getIoMode(NullHelper.notnullJ(dir, "Enum.values()"))) == IoMode.DISABLED || ioMode == IoMode.PULL) continue;
            EnergyReceptor er = new EnergyReceptor(this, pi, NullHelper.notnullJ(dir, "Enum.values()"));
            this.validateModeForReceptor(er);
            this.receptors.add(er);
        }
        this.network.addReceptors(this.receptors);
        this.receptorsDirty = false;
    }

    private IPowerInterface getReceptorForFace(@Nonnull EnumFacing faceHit) {
        TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(faceHit));
        if (!(te instanceof TileCapBank)) {
            return PowerHandlerUtil.getPowerInterface((ICapabilityProvider)te, faceHit.func_176734_d());
        }
        TileCapBank other = (TileCapBank)te;
        if (other.getType() != this.getType()) {
            return PowerHandlerUtil.getPowerInterface((ICapabilityProvider)te, faceHit.func_176734_d());
        }
        return null;
    }

    private EnergyReceptor getEnergyReceptorForFace(@Nonnull EnumFacing dir) {
        IPowerInterface pi = this.getReceptorForFace(dir);
        if (pi == null || pi.getProvider() instanceof TileCapBank) {
            return null;
        }
        return new EnergyReceptor(this, pi, dir);
    }

    private void validateModeForReceptor(@Nonnull EnumFacing dir) {
        this.validateModeForReceptor(this.getEnergyReceptorForFace(dir));
    }

    private void validateModeForReceptor(EnergyReceptor er) {
        if (er == null) {
            return;
        }
    }

    @Override
    public void addEnergy(int energy) {
        if (this.network == null) {
            this.setEnergyStored(this.getEnergyStored(null) + energy);
        } else {
            this.network.addEnergy(energy);
        }
    }

    @Override
    public void setEnergyStored(int stored) {
        this.energyStored = MathHelper.func_76125_a((int)stored, (int)0, (int)this.getMaxEnergyStored(null));
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.energyStored;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.getType().getMaxEnergyStored();
    }

    @Override
    public int getMaxEnergyRecieved(EnumFacing dir) {
        return this.getMaxInput();
    }

    @Override
    public int getMaxInput() {
        if (this.network == null) {
            return this.getType().getMaxIO();
        }
        return this.network.getMaxInput();
    }

    public void setMaxInput(int maxInput) {
        if (this.maxInput == maxInput) {
            return;
        }
        this.maxInput = maxInput;
        this.func_70296_d();
    }

    public int getMaxInputOverride() {
        return this.maxInput;
    }

    @Override
    public int getMaxOutput() {
        if (this.network == null) {
            return this.getType().getMaxIO();
        }
        return this.network.getMaxOutput();
    }

    public void setMaxOutput(int maxOutput) {
        if (this.maxOutput == maxOutput) {
            return;
        }
        this.maxOutput = maxOutput;
        this.func_70296_d();
    }

    public int getMaxOutputOverride() {
        return this.maxOutput;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (this.network == null || from == null) {
            return 0;
        }
        IoMode mode = this.getIoMode(from);
        if (mode == IoMode.DISABLED || mode == IoMode.PUSH) {
            return 0;
        }
        return this.network.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return from != null && this.getIoMode(from) != IoMode.DISABLED;
    }

    public int getComparatorOutput() {
        double stored = this.getEnergyStored(null);
        return stored == 0.0 ? 0 : (int)(1.0 + stored / (double)this.getMaxEnergyStored(null) * 14.0);
    }

    @Override
    public boolean displayPower() {
        return true;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public ItemStack func_70301_a(int slot) {
        if (this.network == null) {
            return null;
        }
        return this.network.getInventory().func_70301_a(slot);
    }

    public ItemStack func_70298_a(int fromSlot, int amount) {
        if (this.network == null) {
            return null;
        }
        return this.network.getInventory().func_70298_a(fromSlot, amount);
    }

    public void func_70299_a(int slot, @Nullable ItemStack itemstack) {
        if (this.network == null) {
            return;
        }
        this.network.getInventory().func_70299_a(slot, itemstack);
    }

    public ItemStack func_70304_b(int index) {
        if (this.network == null) {
            return null;
        }
        return this.network.getInventory().func_70304_b(index);
    }

    public void func_174888_l() {
        if (this.network == null) {
            return;
        }
        this.network.getInventory().func_174888_l();
    }

    public int func_70302_i_() {
        return 4;
    }

    @Nonnull
    public String func_70005_c_() {
        return ModObject.blockCapBank.getBlock().func_149739_a() + ".name";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_174889_b(EntityPlayer e) {
    }

    public void func_174886_c(EntityPlayer e) {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        return PowerHandlerUtil.getCapability((ICapabilityProvider)itemstack, null) != null;
    }

    public ItemStack[] getInventory() {
        return this.inventory;
    }

    public void dropItems() {
        this.dropItems = true;
    }

    public void doDropItems() {
        if (!this.dropItems) {
            return;
        }
        EntityPlayer player = this.field_145850_b.func_184137_a((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 32.0, false);
        Vector3d dropLocation = player != null ? EntityUtil.getEntityPosition((Entity)player) : new Vector3d(this.func_174877_v());
        Util.dropItems((World)this.field_145850_b, (ItemStack[])this.inventory, (int)((int)dropLocation.x), (int)((int)dropLocation.y), (int)((int)dropLocation.z), (boolean)false);
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = null;
        }
        this.dropItems = false;
        this.func_70296_d();
    }

    @Override
    public void readContentsFromNBT(NBTTagCompound nbtRoot) {
        super.readContentsFromNBT(nbtRoot);
        this.energyStored = nbtRoot.func_74764_b("storedEnergyRF") ? nbtRoot.func_74762_e("storedEnergyRF") : NbtValue.ENERGY.getInt(nbtRoot);
    }

    @Override
    public void writeContentsToNBT(NBTTagCompound nbtRoot) {
        super.writeContentsToNBT(nbtRoot);
        NbtValue.ENERGY.setInt(nbtRoot, this.energyStored);
    }

    @Override
    public BlockCoord getLocation() {
        return new BlockCoord(this.field_174879_c);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    @Override
    protected void readCustomNBT(NBTTagCompound root) {
        super.readCustomNBT(root);
    }

    @Override
    protected void writeCustomNBT(NBTTagCompound root) {
        super.writeCustomNBT(root);
    }
}

