/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank;

import com.enderio.core.common.transform.EnderCoreMethods;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.PowerBarOverlayRenderHelper;
import crazypants.enderio.machine.capbank.BlockCapBank;
import crazypants.enderio.machine.capbank.CapBankType;
import crazypants.enderio.power.AbstractPoweredBlockItem;
import crazypants.enderio.power.forge.InternalPoweredItemWrapper;
import crazypants.util.NbtValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;

public class BlockItemCapBank
extends AbstractPoweredBlockItem
implements EnderCoreMethods.IOverlayRenderAware {
    public static ItemStack createItemStackWithPower(int meta, int storedEnergy) {
        ItemStack res = new ItemStack(ModObject.blockCapBank.getBlock(), 1, meta);
        if (storedEnergy > 0) {
            BlockItemCapBank.setStoredEnergyForItem(res, storedEnergy);
        }
        return res;
    }

    public static int getStoredEnergyForItem(ItemStack item) {
        return NbtValue.ENERGY.getInt(item);
    }

    public static void setStoredEnergyForItem(ItemStack item, int storedEnergy) {
        NbtValue.ENERGY.setInt(item, Math.max(0, storedEnergy));
    }

    public BlockItemCapBank(@Nonnull BlockCapBank blockCapBank, @Nonnull String name) {
        super((Block)blockCapBank, 0, 0, 0);
        this.func_77627_a(true);
        this.func_77637_a(EnderIOTab.tabEnderIOMachines);
        this.setRegistryName(name);
    }

    public int func_77647_b(int par1) {
        return par1;
    }

    @Nonnull
    public String func_77667_c(ItemStack par1ItemStack) {
        return CapBankType.getTypeFromMeta(par1ItemStack.func_77960_j()).getUnlocalizedName();
    }

    public void renderItemOverlayIntoGUI(ItemStack stack, int xPosition, int yPosition) {
        if (Config.capacitorBankRenderPowerOverlayOnItem) {
            PowerBarOverlayRenderHelper.instance.render(stack, xPosition, yPosition);
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return CapBankType.getTypeFromMeta(stack.func_77960_j()).isCreative() || super.func_77636_d(stack);
    }

    @Override
    public int getMaxEnergyStored(ItemStack stack) {
        return CapBankType.getTypeFromMeta(stack.func_77960_j()).getMaxEnergyStored();
    }

    @Override
    public int getMaxInput(ItemStack container) {
        return CapBankType.getTypeFromMeta(container.func_77960_j()).getMaxIO();
    }

    @Override
    public int getMaxOutput(ItemStack container) {
        return CapBankType.getTypeFromMeta(container.func_77960_j()).getMaxIO();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new InnerProv(stack);
    }

    private class CreativePowerCap
    extends InternalPoweredItemWrapper {
        public CreativePowerCap(ItemStack container) {
            super(container, BlockItemCapBank.this);
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            return maxReceive;
        }

        @Override
        public int extractEnergy(int maxExtract, boolean simulate) {
            return maxExtract;
        }
    }

    private class InnerProv
    implements ICapabilityProvider {
        private final ItemStack container;

        public InnerProv(ItemStack container) {
            this.container = container;
        }

        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityEnergy.ENERGY;
        }

        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityEnergy.ENERGY && CapBankType.getTypeFromMeta(this.container.func_77960_j()).isCreative()) {
                return (T)new CreativePowerCap(this.container);
            }
            return null;
        }
    }
}

