/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.alloy;

import crazypants.enderio.Log;
import crazypants.enderio.ModObject;
import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.capacitor.ICapacitorKey;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.alloy.AlloyRecipeManager;
import crazypants.enderio.machine.alloy.VanillaSmeltingRecipe;
import crazypants.enderio.machine.recipe.ManyToOneMachineRecipe;
import crazypants.enderio.paint.IPaintable;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

@Storable
public class TileAlloySmelter
extends AbstractPoweredTaskEntity
implements IPaintable.IPaintableTileEntity {
    @Store
    private Mode mode;

    public TileAlloySmelter() {
        super(new SlotDefinition(3, 1), CapacitorKey.ALLOY_SMELTER_POWER_INTAKE, CapacitorKey.ALLOY_SMELTER_POWER_BUFFER, CapacitorKey.ALLOY_SMELTER_POWER_USE);
        this.mode = Mode.ALL;
    }

    protected TileAlloySmelter(SlotDefinition slotDefinition, ICapacitorKey maxEnergyRecieved, ICapacitorKey maxEnergyStored, ICapacitorKey maxEnergyUsed) {
        super(slotDefinition, maxEnergyRecieved, maxEnergyStored, maxEnergyUsed);
    }

    @Override
    @Nonnull
    public String func_70005_c_() {
        return "Alloy Smelter";
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        if (mode == null) {
            mode = Mode.ALL;
        }
        if (this.mode != mode) {
            this.mode = mode;
            this.forceClientUpdate.set();
        }
    }

    @Override
    protected IMachineRecipe canStartNextTask(float chance) {
        if (this.mode == Mode.FURNACE) {
            VanillaSmeltingRecipe vr = AlloyRecipeManager.getInstance().vanillaRecipe;
            if (vr.isRecipe(this.getRecipeInputs())) {
                IMachineRecipe.ResultStack[] res = vr.getCompletedResult(chance, this.getRecipeInputs());
                if (res == null || res.length == 0) {
                    return null;
                }
                return this.canInsertResult(chance, vr) ? vr : null;
            }
            return null;
        }
        IMachineRecipe nextRecipe = this.getNextRecipe();
        if (this.mode == Mode.ALLOY && nextRecipe instanceof VanillaSmeltingRecipe) {
            nextRecipe = null;
        }
        if (nextRecipe == null) {
            return null;
        }
        return this.canInsertResult(chance, nextRecipe) ? nextRecipe : null;
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return ModObject.blockAlloySmelter.getUnlocalisedName();
    }

    @Override
    public boolean isMachineItemValidForSlot(int slot, ItemStack itemstack) {
        if (!this.slotDefinition.isInputSlot(slot)) {
            return false;
        }
        ItemStack currentStackInSlot = this.inventory[slot];
        if (currentStackInSlot != null) {
            return currentStackInSlot.func_77969_a(itemstack);
        }
        int numSlotsFilled = 0;
        for (int i = this.slotDefinition.getMinInputSlot(); i <= this.slotDefinition.getMaxInputSlot(); ++i) {
            if (i < 0 || i >= this.inventory.length || this.inventory[i] == null || this.inventory[i].field_77994_a <= 0) continue;
            ++numSlotsFilled;
        }
        List<IMachineRecipe> recipes = MachineRecipeRegistry.instance.getRecipesForInput(this.getMachineName(), MachineRecipeInput.create(slot, itemstack));
        if (this.mode == Mode.FURNACE) {
            return this.isValidInputForFurnaceRecipe(itemstack, numSlotsFilled, recipes);
        }
        if (this.mode == Mode.ALLOY) {
            return this.isValidInputForAlloyRecipe(slot, itemstack, numSlotsFilled, recipes);
        }
        return this.isValidInputForFurnaceRecipe(itemstack, numSlotsFilled, recipes) || this.isValidInputForAlloyRecipe(slot, itemstack, numSlotsFilled, recipes);
    }

    private boolean isValidInputForAlloyRecipe(int slot, ItemStack itemstack, int numSlotsFilled, List<IMachineRecipe> recipes) {
        if (numSlotsFilled == 0) {
            return this.containsAlloyRecipe(recipes);
        }
        for (IMachineRecipe recipe : recipes) {
            if (recipe instanceof VanillaSmeltingRecipe) continue;
            if (recipe instanceof ManyToOneMachineRecipe) {
                ItemStack[] resultInv = new ItemStack[this.slotDefinition.getNumInputSlots()];
                for (int i = this.slotDefinition.getMinInputSlot(); i <= this.slotDefinition.getMaxInputSlot(); ++i) {
                    if (i < 0 || i >= this.inventory.length) continue;
                    resultInv[i] = i == slot ? itemstack : this.inventory[i];
                }
                if (!((ManyToOneMachineRecipe)recipe).isValidRecipeComponents(resultInv)) continue;
                return true;
            }
            Log.warn("TileAlloySmelter.isMachineItemValidForSlot: A non alloy recipe was returned for the alloy smelter");
            return true;
        }
        return false;
    }

    private boolean isValidInputForFurnaceRecipe(ItemStack itemstack, int numSlotsFilled, List<IMachineRecipe> recipes) {
        if (numSlotsFilled == 0) {
            return this.containsFurnaceRecipe(recipes);
        }
        return this.containsFurnaceRecipe(recipes) && this.isItemAlreadyInASlot(itemstack);
    }

    private boolean isItemAlreadyInASlot(ItemStack itemstack) {
        ItemStack currentStackType = null;
        for (int i = this.slotDefinition.getMinInputSlot(); i <= this.slotDefinition.getMaxInputSlot() && currentStackType == null; ++i) {
            currentStackType = this.inventory[i];
            if (currentStackType == null || !currentStackType.func_77969_a(itemstack)) continue;
            return true;
        }
        return false;
    }

    private boolean containsFurnaceRecipe(List<IMachineRecipe> recipes) {
        for (IMachineRecipe rec : recipes) {
            if (!(rec instanceof VanillaSmeltingRecipe)) continue;
            return true;
        }
        return false;
    }

    private boolean containsAlloyRecipe(List<IMachineRecipe> recipes) {
        for (IMachineRecipe rec : recipes) {
            if (rec instanceof VanillaSmeltingRecipe) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    public static enum Mode {
        ALL,
        ALLOY,
        FURNACE;


        Mode next() {
            int nextOrd = this.ordinal() + 1;
            if (nextOrd >= Mode.values().length) {
                nextOrd = 0;
            }
            return Mode.values()[nextOrd];
        }
    }
}

