/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.EnderIO;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.api.redstone.IRedstoneConnectable;
import crazypants.enderio.capability.ItemTools;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.IIoConfigurable;
import crazypants.enderio.machine.IMachine;
import crazypants.enderio.machine.IRedstoneModeControlable;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.MachineSound;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.PainterUtil2;
import crazypants.enderio.paint.YetaUtil;
import crazypants.util.ResettingFlag;
import crazypants.util.UserIdent;
import info.loenwind.autosave.Reader;
import info.loenwind.autosave.Writer;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.handlers.enderio.HandleIOMode;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Storable
public abstract class AbstractMachineEntity
extends TileEntityEio
implements IMachine,
IRedstoneModeControlable,
IRedstoneConnectable,
IIoConfigurable {
    private static final ItemTools.Limit PULL_PUSH_LIMIT = new ItemTools.Limit(1, 64);
    @Store(value={Store.StoreFor.CLIENT, Store.StoreFor.SAVE})
    @Nonnull
    public EnumFacing facing = EnumFacing.SOUTH;
    protected int ticksSinceSync = -1;
    @Store(value={Store.StoreFor.CLIENT, Store.StoreFor.SAVE})
    protected ResettingFlag forceClientUpdate = new ResettingFlag();
    protected boolean lastActive;
    protected int ticksSinceActiveChanged = 0;
    @Store
    protected RedstoneControlMode redstoneControlMode = RedstoneControlMode.IGNORE;
    @Store(value={Store.StoreFor.CLIENT, Store.StoreFor.SAVE})
    protected boolean redstoneCheckPassed;
    private boolean redstoneStateDirty = true;
    @Store(handler=HandleIOMode.class)
    protected Map<EnumFacing, IoMode> faceModes;
    protected boolean notifyNeighbours = false;
    @SideOnly(value=Side.CLIENT)
    private MachineSound sound;
    @Store(value={Store.StoreFor.SAVE})
    @Nullable
    protected UserIdent owner;
    private final ResourceLocation soundRes = AbstractMachineEntity.getSoundFor(this.getSoundName());
    @Store
    private IBlockState paintSource = null;

    public static ResourceLocation getSoundFor(String sound) {
        return sound == null ? null : new ResourceLocation(EnderIO.DOMAIN + ":" + sound);
    }

    @Override
    @Nonnull
    public IoMode toggleIoModeForFace(@Nullable EnumFacing faceHit) {
        IoMode curMode = this.getIoMode(faceHit);
        IoMode mode = curMode.next();
        while (!this.supportsMode(faceHit, mode)) {
            mode = mode.next();
        }
        this.setIoMode(faceHit, mode);
        return mode != null ? mode : IoMode.NONE;
    }

    @Override
    public boolean supportsMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
        return true;
    }

    @Override
    public void setIoMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
        if (mode == IoMode.NONE && this.faceModes == null) {
            return;
        }
        if (this.faceModes == null) {
            this.faceModes = new EnumMap<EnumFacing, IoMode>(EnumFacing.class);
        }
        this.faceModes.put(faceHit, mode);
        this.forceClientUpdate.set();
        this.notifyNeighbours = true;
        this.updateBlock();
    }

    @Override
    public void clearAllIoModes() {
        if (this.faceModes != null) {
            this.faceModes = null;
            this.forceClientUpdate.set();
            this.notifyNeighbours = true;
            this.updateBlock();
        }
    }

    @Override
    @Nonnull
    public IoMode getIoMode(@Nullable EnumFacing face) {
        if (this.faceModes == null) {
            return IoMode.NONE;
        }
        IoMode res = this.faceModes.get(face);
        if (res == null) {
            return IoMode.NONE;
        }
        return res;
    }

    @Override
    public RedstoneControlMode getRedstoneControlMode() {
        return this.redstoneControlMode;
    }

    @Override
    public void setRedstoneControlMode(RedstoneControlMode redstoneControlMode) {
        this.redstoneControlMode = redstoneControlMode;
        this.redstoneStateDirty = true;
        this.updateBlock();
    }

    @Nonnull
    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing == null ? EnumFacing.SOUTH : facing;
        this.func_70296_d();
    }

    public abstract boolean isActive();

    public String getSoundName() {
        return null;
    }

    public boolean hasSound() {
        return this.getSoundName() != null;
    }

    public float getVolume() {
        return Config.machineSoundVolume;
    }

    public float getPitch() {
        return 1.0f;
    }

    protected boolean shouldPlaySound() {
        return this.isActive() && !this.func_145837_r();
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSound() {
        if (Config.machineSoundsEnabled && this.hasSound()) {
            if (this.shouldPlaySound()) {
                if (this.sound == null) {
                    this.sound = new MachineSound(this.soundRes, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f, this.getVolume(), this.getPitch());
                    FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)this.sound);
                }
            } else if (this.sound != null) {
                this.sound.endPlaying();
                this.sound = null;
            }
        }
    }

    @Override
    public void doUpdate() {
        if (this.field_145850_b.field_72995_K) {
            this.updateEntityClient();
            return;
        }
        boolean requiresClientSync = this.forceClientUpdate.peek();
        boolean prevRedCheck = this.redstoneCheckPassed;
        if (this.redstoneStateDirty) {
            this.redstoneCheckPassed = RedstoneControlMode.isConditionMet(this.redstoneControlMode, (TileEntity)this);
            this.redstoneStateDirty = false;
        }
        if (this.shouldDoWorkThisTick(5)) {
            requiresClientSync |= this.doSideIo();
        }
        requiresClientSync |= prevRedCheck != this.redstoneCheckPassed;
        if (requiresClientSync |= this.processTasks(this.redstoneCheckPassed)) {
            IBlockState bs = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, bs, bs, 3);
            this.func_70296_d();
        }
        if (this.notifyNeighbours) {
            this.field_145850_b.func_180496_d(this.field_174879_c, this.func_145838_q());
            this.notifyNeighbours = false;
        }
    }

    protected void updateEntityClient() {
        if (this.isActive() != this.lastActive) {
            ++this.ticksSinceActiveChanged;
            if (this.lastActive ? this.ticksSinceActiveChanged > 20 : this.ticksSinceActiveChanged > 4) {
                this.ticksSinceActiveChanged = 0;
                this.lastActive = this.isActive();
                this.forceClientUpdate.set();
            }
        } else {
            this.ticksSinceActiveChanged = 0;
        }
        if (this.hasSound()) {
            this.updateSound();
        }
        if (this.forceClientUpdate.read()) {
            IBlockState bs = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, bs, bs, 3);
        } else {
            YetaUtil.refresh((TileEntity)this);
        }
    }

    protected boolean doSideIo() {
        if (this.faceModes == null) {
            return false;
        }
        boolean res = false;
        Set<Map.Entry<EnumFacing, IoMode>> ents = this.faceModes.entrySet();
        for (Map.Entry<EnumFacing, IoMode> ent : ents) {
            IoMode mode = ent.getValue();
            if (mode.pulls()) {
                res |= this.doPull(ent.getKey());
            }
            if (!mode.pushes()) continue;
            res |= this.doPush(ent.getKey());
        }
        return res;
    }

    protected abstract boolean doPull(EnumFacing var1);

    protected abstract boolean doPush(EnumFacing var1);

    protected ItemTools.Limit getPullLimit() {
        return PULL_PUSH_LIMIT.copy();
    }

    protected ItemTools.Limit getPushLimit() {
        return PULL_PUSH_LIMIT.copy();
    }

    protected abstract boolean processTasks(boolean var1);

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            this.updateSound();
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtRoot) {
        super.readCustomNBT(nbtRoot);
        this.readCommon(nbtRoot);
    }

    public void readCommon(NBTTagCompound nbtRoot) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromItemStack(ItemStack stack) {
        if (stack == null) {
            return;
        }
        NBTTagCompound root = stack.func_77978_p();
        if (root == null) {
            return;
        }
        Reader.read(Store.StoreFor.ITEM, root, this);
        if (root.func_74764_b("eio.abstractMachine")) {
            try {
                this.doingOtherNbt = true;
                this.readCommon(root);
            }
            finally {
                this.doingOtherNbt = false;
            }
        }
        if (this instanceof IPaintable.IPaintableTileEntity) {
            this.paintSource = PainterUtil2.readNbt(root);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        super.writeCustomNBT(nbtRoot);
        this.writeCommon(nbtRoot);
    }

    public void writeCommon(NBTTagCompound nbtRoot) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToItemStack(ItemStack stack) {
        if (stack == null) {
            return;
        }
        NBTTagCompound root = stack.func_77978_p();
        if (root == null) {
            root = new NBTTagCompound();
            stack.func_77982_d(root);
        }
        root.func_74757_a("eio.abstractMachine", true);
        try {
            this.doingOtherNbt = true;
            this.writeCommon(root);
        }
        finally {
            this.doingOtherNbt = false;
        }
        Writer.write(Store.StoreFor.ITEM, root, this);
        if (this instanceof IPaintable.IPaintableTileEntity) {
            PainterUtil2.writeNbt(root, this.paintSource);
        }
        String name = stack.func_82837_s() ? stack.func_82833_r() : EnderIO.lang.localizeExact(stack.func_77977_a() + ".name");
        name = name + " " + EnderIO.lang.localize("machine.tooltip.configured");
        stack.func_151001_c(name);
    }

    public boolean isSideDisabled(EnumFacing dir) {
        return this.getIoMode(dir) == IoMode.DISABLED;
    }

    public void onNeighborBlockChange(Block blockId) {
        this.redstoneStateDirty = true;
    }

    @Override
    public boolean shouldRedstoneConduitConnect(World world, int x, int y, int z, EnumFacing from) {
        return true;
    }

    @Override
    public BlockCoord getLocation() {
        return new BlockCoord(this.field_174879_c);
    }

    @Override
    public boolean getRedstoneControlStatus() {
        return this.redstoneCheckPassed;
    }

    public void setPaintSource(@Nullable IBlockState paintSource) {
        this.paintSource = paintSource;
        this.func_70296_d();
        this.updateBlock();
    }

    public IBlockState getPaintSource() {
        return this.paintSource;
    }

    void setOwner(EntityPlayer player) {
        this.owner = UserIdent.create(player.func_146103_bH());
    }

    public UserIdent getOwner() {
        return this.owner;
    }
}

