/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import com.enderio.core.common.vecmath.VecmathUtil;
import crazypants.enderio.IModObject;
import crazypants.enderio.capability.EnderInventory;
import crazypants.enderio.capability.Filters;
import crazypants.enderio.capability.InventorySlot;
import crazypants.enderio.capacitor.ICapacitorData;
import crazypants.enderio.capacitor.ICapacitorKey;
import crazypants.enderio.machine.AbstractCapabilityMachineEntity;
import crazypants.enderio.power.EnergyTank;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;

@Storable
public abstract class AbstractCapabilityPoweredMachineEntity
extends AbstractCapabilityMachineEntity {
    protected static final String CAPSLOT = "cap";
    @Store
    @Nonnull
    private final EnergyTank energy;
    protected float lastSyncPowerStored = -1.0f;

    protected AbstractCapabilityPoweredMachineEntity() {
        this(null, null, null, null, null);
    }

    protected AbstractCapabilityPoweredMachineEntity(@Nullable IModObject modObject) {
        this(null, modObject, null, null, null);
    }

    protected AbstractCapabilityPoweredMachineEntity(@Nonnull ICapacitorKey maxEnergyRecieved, @Nonnull ICapacitorKey maxEnergyStored, @Nonnull ICapacitorKey maxEnergyUsed) {
        this(null, null, maxEnergyRecieved, maxEnergyStored, maxEnergyUsed);
    }

    protected AbstractCapabilityPoweredMachineEntity(@Nullable EnderInventory subclassInventory, IModObject modObject) {
        this(null, modObject, null, null, null);
    }

    protected AbstractCapabilityPoweredMachineEntity(@Nullable EnderInventory subclassInventory, @Nonnull ICapacitorKey maxEnergyRecieved, @Nonnull ICapacitorKey maxEnergyStored, @Nonnull ICapacitorKey maxEnergyUsed) {
        this(null, null, maxEnergyRecieved, maxEnergyStored, maxEnergyUsed);
    }

    private AbstractCapabilityPoweredMachineEntity(@Nullable EnderInventory subclassInventory, @Nullable IModObject modObject, @Nullable ICapacitorKey maxEnergyRecieved, @Nullable ICapacitorKey maxEnergyStored, @Nullable ICapacitorKey maxEnergyUsed) {
        super(subclassInventory);
        this.getInventory().add(EnderInventory.Type.UPGRADE, CAPSLOT, new InventorySlot(Filters.CAPACITORS, null, 1));
        this.energy = modObject != null ? new EnergyTank((TileEntity)this, modObject) : (maxEnergyRecieved != null && maxEnergyStored != null && maxEnergyUsed != null ? new EnergyTank((TileEntity)this, maxEnergyRecieved, maxEnergyStored, maxEnergyUsed) : new EnergyTank((TileEntity)this));
        this.getEnergy().updateCapacitorFromSlot(this.getInventory().getSlot(CAPSLOT));
    }

    public boolean displayPower() {
        return true;
    }

    public boolean hasPower() {
        return this.getEnergy().getEnergyStored() > 0;
    }

    public ICapacitorData getCapacitorData() {
        return this.getEnergy().getCapacitorData();
    }

    public EnergyTank getEnergy() {
        return this.energy;
    }

    public int getEnergyStoredScaled(int scale) {
        int maxEnergyStored2 = this.getEnergy().getMaxEnergyStored();
        return maxEnergyStored2 == 0 ? 0 : VecmathUtil.clamp((int)Math.round((float)scale * ((float)this.getEnergy().getEnergyStored() / (float)maxEnergyStored2)), (int)0, (int)scale);
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.updateCapacitorFromSlot();
    }

    protected void onCapacitorDataChange() {
    }

    private void updateCapacitorFromSlot() {
        if (this.getEnergy().updateCapacitorFromSlot(this.getInventory().getSlot(CAPSLOT))) {
            this.forceClientUpdate.set();
            this.onCapacitorDataChange();
        }
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        super.readCommon(nbtRoot);
        this.updateCapacitorFromSlot();
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facingIn) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facingIn);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facingIn) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energy.get(facingIn);
        }
        return super.getCapability(capability, facingIn);
    }
}

