/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import com.google.common.collect.ImmutableList;
import crazypants.enderio.EnderIO;
import crazypants.enderio.item.darksteel.IDarkSteelItem;
import crazypants.enderio.item.darksteel.upgrade.ApiaristArmorUpgrade;
import crazypants.enderio.item.darksteel.upgrade.ElytraUpgrade;
import crazypants.enderio.item.darksteel.upgrade.EnergyUpgrade;
import crazypants.enderio.item.darksteel.upgrade.GliderUpgrade;
import crazypants.enderio.item.darksteel.upgrade.IDarkSteelUpgrade;
import crazypants.enderio.item.darksteel.upgrade.JumpUpgrade;
import crazypants.enderio.item.darksteel.upgrade.NaturalistEyeUpgrade;
import crazypants.enderio.item.darksteel.upgrade.NightVisionUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SolarUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SoundDetectorUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SpeedUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SpoonUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SwimUpgrade;
import crazypants.enderio.item.darksteel.upgrade.TheOneProbeUpgrade;
import crazypants.enderio.item.darksteel.upgrade.TravelUpgrade;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Triple;

public class DarkSteelRecipeManager {
    public static DarkSteelRecipeManager instance = new DarkSteelRecipeManager();
    private List<IDarkSteelUpgrade> upgrades = new ArrayList<IDarkSteelUpgrade>();

    public DarkSteelRecipeManager() {
        this.upgrades.add(EnergyUpgrade.EMPOWERED);
        this.upgrades.add(EnergyUpgrade.EMPOWERED_TWO);
        this.upgrades.add(EnergyUpgrade.EMPOWERED_THREE);
        this.upgrades.add(EnergyUpgrade.EMPOWERED_FOUR);
        this.upgrades.add(JumpUpgrade.JUMP_ONE);
        this.upgrades.add(JumpUpgrade.JUMP_TWO);
        this.upgrades.add(JumpUpgrade.JUMP_THREE);
        this.upgrades.add(SpeedUpgrade.SPEED_ONE);
        this.upgrades.add(SpeedUpgrade.SPEED_TWO);
        this.upgrades.add(SpeedUpgrade.SPEED_THREE);
        this.upgrades.add(GliderUpgrade.INSTANCE);
        this.upgrades.add(ElytraUpgrade.INSTANCE);
        this.upgrades.add(SoundDetectorUpgrade.INSTANCE);
        this.upgrades.add(SwimUpgrade.INSTANCE);
        this.upgrades.add(NightVisionUpgrade.INSTANCE);
        this.upgrades.add(TravelUpgrade.INSTANCE);
        this.upgrades.add(SpoonUpgrade.INSTANCE);
        this.upgrades.add(SolarUpgrade.SOLAR_ONE);
        this.upgrades.add(SolarUpgrade.SOLAR_TWO);
        this.upgrades.add(SolarUpgrade.SOLAR_THREE);
        if (Loader.isModLoaded((String)"forestry")) {
            this.upgrades.add(NaturalistEyeUpgrade.INSTANCE);
            this.upgrades.add(ApiaristArmorUpgrade.HELMET);
            this.upgrades.add(ApiaristArmorUpgrade.CHEST);
            this.upgrades.add(ApiaristArmorUpgrade.LEGS);
            this.upgrades.add(ApiaristArmorUpgrade.BOOTS);
        }
        if (TheOneProbeUpgrade.INSTANCE.isAvailable()) {
            this.upgrades.add(TheOneProbeUpgrade.INSTANCE);
        }
    }

    @SubscribeEvent
    public void handleAnvilEvent(AnvilUpdateEvent evt) {
        if (evt.getLeft() == null || evt.getRight() == null) {
            return;
        }
        if (this.isRepair(evt)) {
            this.handleRepair(evt);
        } else {
            this.handleUpgrade(evt);
        }
    }

    private boolean isRepair(AnvilUpdateEvent evt) {
        IDarkSteelItem dsi;
        return evt.getLeft().func_77973_b() instanceof IDarkSteelItem && (dsi = (IDarkSteelItem)evt.getLeft().func_77973_b()).isItemForRepair(evt.getRight());
    }

    private void handleRepair(AnvilUpdateEvent evt) {
        ItemStack targetStack = evt.getLeft();
        ItemStack ingots = evt.getRight();
        IDarkSteelItem targetItem = (IDarkSteelItem)targetStack.func_77973_b();
        int maxIngots = targetItem.getIngotsRequiredForFullRepair();
        double damPerc = (double)targetStack.func_77952_i() / (double)targetStack.func_77958_k();
        int requiredIngots = (int)Math.ceil(damPerc * (double)maxIngots);
        if (ingots.field_77994_a > requiredIngots) {
            return;
        }
        int damageAddedPerIngot = (int)Math.ceil((double)targetStack.func_77958_k() / (double)maxIngots);
        int totalDamageRemoved = damageAddedPerIngot * ingots.field_77994_a;
        ItemStack resultStack = targetStack.func_77946_l();
        resultStack.func_77964_b(Math.max(0, resultStack.func_77952_i() - totalDamageRemoved));
        evt.setOutput(resultStack);
        evt.setCost(ingots.field_77994_a + (int)Math.ceil(DarkSteelRecipeManager.getEnchantmentRepairCost(resultStack) / 2));
    }

    private void handleUpgrade(AnvilUpdateEvent evt) {
        for (IDarkSteelUpgrade upgrade : this.upgrades) {
            if (!upgrade.isUpgradeItem(evt.getRight()) || !upgrade.canAddToItem(evt.getLeft())) continue;
            ItemStack res = new ItemStack(evt.getLeft().func_77973_b(), 1, evt.getLeft().func_77952_i());
            if (evt.getLeft().func_77978_p() != null) {
                res.func_77982_d(evt.getLeft().func_77978_p().func_74737_b());
            }
            upgrade.writeToItem(res);
            evt.setOutput(res);
            evt.setCost(upgrade.getLevelCost());
            return;
        }
    }

    public static int getEnchantmentRepairCost(ItemStack itemStack) {
        int res = 0;
        Map map1 = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
        Iterator iter = map1.keySet().iterator();
        while (iter.hasNext()) {
            Enchantment i1;
            Enchantment enchantment = i1 = (Enchantment)iter.next();
            int level = (Integer)map1.get(enchantment);
            if (!enchantment.func_92089_a(itemStack)) continue;
            if (level > enchantment.func_77325_b()) {
                level = enchantment.func_77325_b();
            }
            int costPerLevel = 0;
            switch (enchantment.func_77324_c()) {
                case VERY_RARE: {
                    costPerLevel = 8;
                    break;
                }
                case RARE: {
                    costPerLevel = 4;
                }
                case UNCOMMON: {
                    costPerLevel = 2;
                    break;
                }
                case COMMON: {
                    costPerLevel = 1;
                }
            }
            res += costPerLevel * level;
        }
        return res;
    }

    public List<IDarkSteelUpgrade> getUpgrades() {
        return this.upgrades;
    }

    public void addCommonTooltipEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        for (IDarkSteelUpgrade upgrade : this.upgrades) {
            if (!upgrade.hasUpgrade(itemstack)) continue;
            upgrade.addCommonEntries(itemstack, entityplayer, list, flag);
        }
    }

    public void addBasicTooltipEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        for (IDarkSteelUpgrade upgrade : this.upgrades) {
            if (!upgrade.hasUpgrade(itemstack)) continue;
            upgrade.addBasicEntries(itemstack, entityplayer, list, flag);
        }
    }

    public void addAdvancedTooltipEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        ArrayList<IDarkSteelUpgrade> applyableUpgrades = new ArrayList<IDarkSteelUpgrade>();
        for (IDarkSteelUpgrade upgrade : this.upgrades) {
            if (upgrade.hasUpgrade(itemstack)) {
                upgrade.addDetailedEntries(itemstack, entityplayer, list, flag);
                continue;
            }
            if (!upgrade.canAddToItem(itemstack)) continue;
            applyableUpgrades.add(upgrade);
        }
        if (!applyableUpgrades.isEmpty()) {
            list.add(TextFormatting.YELLOW + EnderIO.lang.localize("tooltip.anvilupgrades") + " ");
            for (IDarkSteelUpgrade up : applyableUpgrades) {
                list.add(TextFormatting.DARK_AQUA + "" + "" + EnderIO.lang.localizeExact(up.getUnlocalizedName() + ".name") + ": ");
                list.add(TextFormatting.DARK_AQUA + "" + TextFormatting.ITALIC + "  " + up.getUpgradeItemName() + " + " + up.getLevelCost() + " " + EnderIO.lang.localize("item.darkSteel.tooltip.lvs"));
            }
        }
    }

    public Iterator<IDarkSteelUpgrade> recipeIterator() {
        return ImmutableList.copyOf(this.upgrades).iterator();
    }

    public String getUpgradesAsString(ItemStack stack) {
        String result = "";
        for (IDarkSteelUpgrade upgrade : this.upgrades) {
            if (!upgrade.hasUpgrade(stack)) continue;
            result = result + upgrade.getUnlocalizedName();
        }
        return result.isEmpty() ? null : result;
    }

    public List<ItemStack> getRecipes(Set<String> seen, List<Triple<ItemStack, ItemStack, ItemStack>> list, List<ItemStack> input) {
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        for (ItemStack stack : input) {
            for (IDarkSteelUpgrade upgrade : this.upgrades) {
                if (!upgrade.canAddToItem(stack)) continue;
                ItemStack newStack = stack.func_77946_l();
                upgrade.writeToItem(newStack);
                String id = newStack.func_77973_b() + this.getUpgradesAsString(newStack);
                if (seen.contains(id)) continue;
                seen.add(id);
                list.add((Triple<ItemStack, ItemStack, ItemStack>)Triple.of((Object)stack, (Object)upgrade.getUpgradeItem(), (Object)newStack));
                output.add(newStack);
            }
        }
        return output;
    }

    public static List<Triple<ItemStack, ItemStack, ItemStack>> getAllRecipes(List<ItemStack> validItems) {
        ArrayList<Triple<ItemStack, ItemStack, ItemStack>> list = new ArrayList<Triple<ItemStack, ItemStack, ItemStack>>();
        HashSet<String> seen = new HashSet<String>();
        List<ItemStack> items = instance.getRecipes(seen, list, validItems);
        while (!items.isEmpty()) {
            items = instance.getRecipes(seen, list, items);
        }
        return list;
    }
}

