/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.fluid;

import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.fluid.Fluids;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class BlockFluidEio
extends BlockFluidClassic {
    protected final Fluid fluid;
    protected float fogColorRed = 1.0f;
    protected float fogColorGreen = 1.0f;
    protected float fogColorBlue = 1.0f;
    private static Field FfogColor1;
    private static Field FfogColor2;
    private static Field FbossColorModifier;
    private static Field FbossColorModifierPrev;
    private static Field FcloudFog;
    private static final ResourceLocation RES_UNDERFLUID_OVERLAY;

    public static BlockFluidEio create(Fluid fluid, Material material, int fogColor) {
        BlockFluidEio res = fluid == Fluids.fluidFireWater ? new FireWater(fluid, material, fogColor) : (fluid == Fluids.fluidHootch ? new Hootch(fluid, material, fogColor) : (fluid == Fluids.fluidRocketFuel ? new RocketFuel(fluid, material, fogColor) : (fluid == Fluids.fluidNutrientDistillation ? new NutrientDistillation(fluid, material, fogColor) : (fluid == Fluids.fluidLiquidSunshine ? new LiquidSunshine(fluid, material, fogColor) : (fluid == Fluids.fluidCloudSeedConcentrated ? new CloudSeedConcentrated(fluid, material, fogColor) : (fluid == Fluids.fluidVaporOfLevity ? new VaporOfLevity(fluid, material, fogColor) : new BlockFluidEio(fluid, material, fogColor)))))));
        res.init();
        fluid.setBlock((Block)res);
        return res;
    }

    public static BlockFluidEio createMetal(Fluid fluid, Material material, int fogColor) {
        MoltenMetal res = new MoltenMetal(fluid, material, fogColor);
        res.init();
        fluid.setBlock((Block)res);
        return res;
    }

    protected BlockFluidEio(Fluid fluid, Material material, int fogColor) {
        super(fluid, (Material)new MaterialLiquid(material.func_151565_r()){

            public boolean func_76230_c() {
                return true;
            }
        });
        this.fluid = fluid;
        float dim = 1.0f;
        while (this.fogColorRed > 0.2f || this.fogColorGreen > 0.2f || this.fogColorBlue > 0.2f) {
            this.fogColorRed = (float)(fogColor >> 16 & 0xFF) / 255.0f * dim;
            this.fogColorGreen = (float)(fogColor >> 8 & 0xFF) / 255.0f * dim;
            this.fogColorBlue = (float)(fogColor & 0xFF) / 255.0f * dim;
            dim *= 0.9f;
        }
        this.setNames(fluid);
    }

    protected void setNames(Fluid fluid) {
        this.func_149663_c(fluid.getUnlocalizedName());
        this.setRegistryName("block" + StringUtils.capitalize((String)fluid.getName()));
    }

    protected void init() {
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    @SideOnly(value=Side.CLIENT)
    private static float getNightVisionBrightness(EntityLivingBase entitylivingbaseIn, float partialTicks) {
        int i = entitylivingbaseIn.func_70660_b(MobEffects.field_76439_r).func_76459_b();
        return i > 200 ? 1.0f : 0.7f + MathHelper.func_76126_a((float)(((float)i - partialTicks) * (float)Math.PI * 0.2f)) * 0.3f;
    }

    public Boolean isEntityInsideMaterial(IBlockAccess world, BlockPos blockpos, IBlockState iblockstate, Entity entity, double yToTest, Material materialIn, boolean testingHead) {
        if (materialIn == Material.field_151586_h || materialIn == this.field_149764_J) {
            return Boolean.TRUE;
        }
        return super.isEntityInsideMaterial(world, blockpos, iblockstate, entity, yToTest, materialIn, testingHead);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onFOVModifier(EntityViewRenderEvent.FOVModifier event) {
        if (event.getState() instanceof BlockFluidEio) {
            event.setFOV(event.getFOV() * 60.0f / 70.0f);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onRenderBlockOverlay(RenderBlockOverlayEvent event) {
        BlockPos blockpos;
        EntityPlayer player;
        Block block;
        if (event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.WATER && (block = player.field_70170_p.func_180495_p(blockpos = new BlockPos(player.field_70165_t, player.field_70163_u + (double)(player = event.getPlayer()).func_70047_e(), player.field_70161_v)).func_177230_c()) instanceof BlockFluidEio) {
            float fogColorRed = ((BlockFluidEio)block).fogColorRed;
            float fogColorGreen = ((BlockFluidEio)block).fogColorGreen;
            float fogColorBlue = ((BlockFluidEio)block).fogColorBlue;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(RES_UNDERFLUID_OVERLAY);
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer vertexbuffer = tessellator.func_178180_c();
            float f = player.func_70013_c(event.getRenderPartialTicks());
            GlStateManager.func_179131_c((float)(f * fogColorRed), (float)(f * fogColorGreen), (float)(f * fogColorBlue), (float)0.5f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179094_E();
            float f7 = -player.field_70177_z / 64.0f;
            float f8 = player.field_70125_A / 64.0f;
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b(-1.0, -1.0, -0.5).func_187315_a((double)(4.0f + f7), (double)(4.0f + f8)).func_181675_d();
            vertexbuffer.func_181662_b(1.0, -1.0, -0.5).func_187315_a((double)(0.0f + f7), (double)(4.0f + f8)).func_181675_d();
            vertexbuffer.func_181662_b(1.0, 1.0, -0.5).func_187315_a((double)(0.0f + f7), (double)(0.0f + f8)).func_181675_d();
            vertexbuffer.func_181662_b(-1.0, 1.0, -0.5).func_187315_a((double)(4.0f + f7), (double)(0.0f + f8)).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onFogDensity(EntityViewRenderEvent.FogDensity event) throws IllegalArgumentException, IllegalAccessException {
        if (FcloudFog == null) {
            FcloudFog = ReflectionHelper.findField(EntityRenderer.class, (String[])new String[]{"cloudFog", "field_78500_U"});
        }
        if (event.getState() instanceof BlockFluidEio) {
            EntityRenderer renderer = event.getRenderer();
            Entity entity = event.getEntity();
            boolean cloudFog = FcloudFog.getBoolean(renderer);
            if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70644_a(MobEffects.field_76440_q)) {
                return;
            }
            if (cloudFog) {
                return;
            }
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            if (entity instanceof EntityLivingBase) {
                if (((EntityLivingBase)entity).func_70644_a(MobEffects.field_76427_o)) {
                    event.setDensity(0.01f);
                } else {
                    event.setDensity(0.1f - (float)EnchantmentHelper.func_185292_c((EntityLivingBase)((EntityLivingBase)entity)) * 0.03f);
                }
            } else {
                event.setDensity(0.1f);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onFogColor(EntityViewRenderEvent.FogColors event) throws IllegalArgumentException, IllegalAccessException {
        if (FfogColor1 == null || FfogColor2 == null || FbossColorModifier == null || FbossColorModifierPrev == null) {
            FfogColor1 = ReflectionHelper.findField(EntityRenderer.class, (String[])new String[]{"fogColor1", "field_78539_ae"});
            FfogColor2 = ReflectionHelper.findField(EntityRenderer.class, (String[])new String[]{"fogColor2", "field_78535_ad"});
            FbossColorModifier = ReflectionHelper.findField(EntityRenderer.class, (String[])new String[]{"bossColorModifier", "field_82831_U"});
            FbossColorModifierPrev = ReflectionHelper.findField(EntityRenderer.class, (String[])new String[]{"bossColorModifierPrev", "field_82832_V"});
        }
        if (event.getState().func_177230_c() instanceof BlockFluidEio) {
            float fogColorRed = ((BlockFluidEio)event.getState().func_177230_c()).fogColorRed;
            float fogColorGreen = ((BlockFluidEio)event.getState().func_177230_c()).fogColorGreen;
            float fogColorBlue = ((BlockFluidEio)event.getState().func_177230_c()).fogColorBlue;
            EntityRenderer renderer = event.getRenderer();
            float fogColor1 = FfogColor1.getFloat(renderer);
            float fogColor2 = FfogColor2.getFloat(renderer);
            float partialTicks = (float)event.getRenderPartialTicks();
            Entity entity = event.getEntity();
            World world = entity.func_130014_f_();
            float bossColorModifier = FbossColorModifier.getFloat(renderer);
            float bossColorModifierPrev = FbossColorModifierPrev.getFloat(renderer);
            float f12 = 0.0f;
            if (entity instanceof EntityLivingBase) {
                f12 = (float)EnchantmentHelper.func_185292_c((EntityLivingBase)((EntityLivingBase)entity)) * 0.2f;
                if (((EntityLivingBase)entity).func_70644_a(MobEffects.field_76427_o)) {
                    f12 = f12 * 0.3f + 0.6f;
                }
            }
            fogColorRed += f12;
            fogColorGreen += f12;
            fogColorBlue += f12;
            float f13 = fogColor2 + (fogColor1 - fogColor2) * partialTicks;
            fogColorRed *= f13;
            fogColorGreen *= f13;
            fogColorBlue *= f13;
            double d1 = (entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks) * world.field_73011_w.func_76565_k();
            if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70644_a(MobEffects.field_76440_q)) {
                int i = ((EntityLivingBase)entity).func_70660_b(MobEffects.field_76440_q).func_76459_b();
                d1 = i < 20 ? (d1 *= (double)(1.0f - (float)i / 20.0f)) : 0.0;
            }
            if (d1 < 1.0) {
                if (d1 < 0.0) {
                    d1 = 0.0;
                }
                d1 *= d1;
                fogColorRed = (float)((double)fogColorRed * d1);
                fogColorGreen = (float)((double)fogColorGreen * d1);
                fogColorBlue = (float)((double)fogColorBlue * d1);
            }
            if (bossColorModifier > 0.0f) {
                float f14 = bossColorModifierPrev + (bossColorModifier - bossColorModifierPrev) * partialTicks;
                fogColorRed = fogColorRed * (1.0f - f14) + fogColorRed * 0.7f * f14;
                fogColorGreen = fogColorGreen * (1.0f - f14) + fogColorGreen * 0.6f * f14;
                fogColorBlue = fogColorBlue * (1.0f - f14) + fogColorBlue * 0.6f * f14;
            }
            if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70644_a(MobEffects.field_76439_r)) {
                float f15 = BlockFluidEio.getNightVisionBrightness((EntityLivingBase)entity, partialTicks);
                float f6 = 1.0f / fogColorRed;
                if (f6 > 1.0f / fogColorGreen) {
                    f6 = 1.0f / fogColorGreen;
                }
                if (f6 > 1.0f / fogColorBlue) {
                    f6 = 1.0f / fogColorBlue;
                }
                fogColorRed = fogColorRed * (1.0f - f15) + fogColorRed * f6 * f15;
                fogColorGreen = fogColorGreen * (1.0f - f15) + fogColorGreen * f6 * f15;
                fogColorBlue = fogColorBlue * (1.0f - f15) + fogColorBlue * f6 * f15;
            }
            if (Minecraft.func_71410_x().field_71474_y.field_74337_g) {
                float f16 = (fogColorRed * 30.0f + fogColorGreen * 59.0f + fogColorBlue * 11.0f) / 100.0f;
                float f17 = (fogColorRed * 30.0f + fogColorGreen * 70.0f) / 100.0f;
                float f7 = (fogColorRed * 30.0f + fogColorBlue * 70.0f) / 100.0f;
                fogColorRed = f16;
                fogColorGreen = f17;
                fogColorBlue = f7;
            }
            event.setRed(fogColorRed);
            event.setGreen(fogColorGreen);
            event.setBlue(fogColorBlue);
        }
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        IBlockState bs = world.func_180495_p(pos);
        if (bs.func_185904_a().func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        IBlockState bs = world.func_180495_p(pos);
        if (bs.func_185904_a().func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        if (tab != null) {
            super.func_149666_a(itemIn, tab, list);
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register(BlockFluidEio.class);
        RES_UNDERFLUID_OVERLAY = new ResourceLocation(EnderIO.DOMAIN, "textures/misc/underfluid.png");
    }

    public static class MoltenEnder
    extends TicFluids {
        private static final Random rand = new Random();
        private static final ResourceLocation SOUND = new ResourceLocation("entity.endermen.teleport");

        public MoltenEnder(Fluid fluid, Material material, int fogColor) {
            super(fluid, material, fogColor);
        }

        public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
            if (!world.field_72995_K && entity.field_71088_bW == 0) {
                this.teleportEntity(world, entity);
            }
            super.func_180634_a(world, pos, state, entity);
        }

        private void teleportEntity(World world, Entity entity) {
            double origX = entity.field_70165_t;
            double origY = entity.field_70163_u;
            double origZ = entity.field_70161_v;
            for (int i = 0; i < 5; ++i) {
                double targetX = origX + rand.nextGaussian() * 16.0;
                double targetY = -1.0;
                while (targetY < 1.1) {
                    targetY = origY + rand.nextGaussian() * 8.0;
                }
                double targetZ = origZ + rand.nextGaussian() * 16.0;
                entity.func_70107_b(targetX, targetY, targetZ);
                if (!this.isClear(world, entity)) continue;
                entity.func_70107_b(origX, origY, origZ);
                if (entity instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)entity).field_71135_a.func_147364_a(targetX, targetY, targetZ, entity.field_70177_z, entity.field_70125_A);
                } else {
                    entity.func_70080_a(targetX, targetY, targetZ, entity.field_70177_z, entity.field_70125_A);
                }
                SoundEvent sound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)SOUND);
                if (sound != null) {
                    world.func_184148_a(null, origX, origY, origZ, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    world.func_184148_a(null, targetX, targetY, targetZ, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                entity.field_71088_bW = 5;
                return;
            }
            entity.func_70107_b(origX, origY, origZ);
        }

        private boolean isClear(World world, Entity entity) {
            return world.func_72917_a(entity.func_174813_aQ(), entity) && world.func_184144_a(entity, entity.func_174813_aQ()).isEmpty();
        }

        @Override
        public void init() {
            super.init();
        }
    }

    public static class MoltenRedstone
    extends TicFluids {
        public MoltenRedstone(Fluid fluid, Material material, int fogColor) {
            super(fluid, material, fogColor);
        }

        public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
            if (!world.field_72995_K && entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76422_e, 1200, 0, true, true));
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76430_j, 1200, 0, true, true));
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76424_c, 1200, 0, true, true));
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76438_s, 1200, 0, true, true));
            }
            super.func_180634_a(world, pos, state, entity);
        }

        @Override
        public void init() {
            super.init();
        }
    }

    public static class MoltenGlowstone
    extends TicFluids {
        public MoltenGlowstone(Fluid fluid, Material material, int fogColor) {
            super(fluid, material, fogColor);
        }

        public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
            if (!world.field_72995_K && entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_188424_y, 200, 0, true, true));
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_188423_x, 2400, 0, true, true));
            }
            super.func_180634_a(world, pos, state, entity);
        }

        @Override
        public void init() {
            super.init();
        }
    }

    public static abstract class TicFluids
    extends BlockFluidEio {
        protected TicFluids(Fluid fluid, Material material, int fogColor) {
            super(fluid, material, fogColor);
        }

        @Override
        protected void setNames(Fluid fluid) {
            this.func_149663_c(fluid.getUnlocalizedName());
            this.setRegistryName("fluid" + StringUtils.capitalize((String)fluid.getName()));
        }
    }

    private static class MoltenMetal
    extends BlockFluidEio {
        protected MoltenMetal(Fluid fluid, Material material, int fogColor) {
            super(fluid, material, fogColor);
        }

        public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
            if (!world.field_72995_K && !entity.func_70045_F()) {
                entity.func_70097_a(DamageSource.field_76371_c, 4.0f);
                entity.func_70015_d(15);
            }
            super.func_180634_a(world, pos, state, entity);
        }

        @Override
        public Boolean isEntityInsideMaterial(IBlockAccess world, BlockPos blockpos, IBlockState iblockstate, Entity entity, double yToTest, Material materialIn, boolean testingHead) {
            if (materialIn == Material.field_151587_i || materialIn == this.field_149764_J) {
                return Boolean.TRUE;
            }
            return super.isEntityInsideMaterial(world, blockpos, iblockstate, entity, yToTest, materialIn, testingHead);
        }
    }

    private static class VaporOfLevity
    extends BlockFluidEio {
        private static final int[] COLORS = new int[]{819920, 9488620, 5338349, 864101, 4902126};

        protected VaporOfLevity(Fluid fluid, Material material, int fogColor) {
            super(fluid, material, fogColor);
        }

        public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
            if (entity instanceof EntityPlayer || !world.field_72995_K && entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).field_70181_x += 0.1;
            }
            super.func_180634_a(world, pos, state, entity);
        }

        @SideOnly(value=Side.CLIENT)
        public void func_180655_c(IBlockState state, World worldIn, BlockPos pos, Random rand) {
            EnumFacing face;
            BlockPos neighborPos;
            IBlockState neighborState;
            if (rand.nextFloat() < 0.5f && !(neighborState = worldIn.func_180495_p(neighborPos = pos.func_177972_a(face = EnumFacing.values()[rand.nextInt(EnumFacing.values().length)]))).func_185917_h()) {
                double yd;
                double xd;
                double d = face.func_82601_c() == 0 ? rand.nextDouble() : (xd = face.func_82601_c() < 0 ? -0.05 : 1.05);
                double d2 = face.func_96559_d() == 0 ? rand.nextDouble() : (yd = face.func_96559_d() < 0 ? -0.05 : 1.05);
                double zd = face.func_82599_e() == 0 ? rand.nextDouble() : (face.func_82599_e() < 0 ? -0.05 : 1.05);
                double x = (double)pos.func_177958_n() + xd;
                double y = (double)pos.func_177956_o() + yd;
                double z = (double)pos.func_177952_p() + zd;
                int col = COLORS[rand.nextInt(COLORS.length)];
                worldIn.func_175688_a(EnumParticleTypes.REDSTONE, x, y, z, (double)(col >> 16 & 0xFF) / 255.0, (double)(col >> 8 & 0xFF) / 255.0, (double)(col & 0xFF) / 255.0, new int[0]);
            }
        }

        public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
            if (!world.field_72995_K && rand.nextFloat() < 0.1f) {
                BlockPos neighborPos = this.getNeighbor(pos, rand);
                IBlockState neighborState = world.func_180495_p(neighborPos);
                Block neighborBlock = neighborState.func_177230_c();
                BlockPos belowNeighborPos = neighborPos.func_177977_b();
                if (neighborBlock != Blocks.field_150431_aC && !(neighborBlock instanceof IFluidBlock) && !(neighborBlock instanceof BlockLiquid) && neighborBlock.func_176200_f((IBlockAccess)world, neighborPos) && world.func_180495_p(belowNeighborPos).isSideSolid((IBlockAccess)world, belowNeighborPos, EnumFacing.UP)) {
                    world.func_175656_a(neighborPos, Blocks.field_150431_aC.func_176223_P());
                } else if (neighborBlock == Blocks.field_150355_j && (Integer)neighborState.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0 && world.func_175716_a(Blocks.field_150432_aD, neighborPos, false, EnumFacing.DOWN, (Entity)null, (ItemStack)null)) {
                    world.func_175656_a(neighborPos, Blocks.field_150432_aD.func_176223_P());
                }
            }
            super.func_180650_b(world, pos, state, rand);
            if (!world.func_184145_b(pos, (Block)this)) {
                world.func_175684_a(pos, (Block)this, this.tickRate * 10);
            }
        }

        protected BlockPos getNeighbor(BlockPos pos, Random rand) {
            EnumFacing face = EnumFacing.values()[rand.nextInt(EnumFacing.values().length)];
            if (face.func_176740_k() != EnumFacing.Axis.Y && rand.nextBoolean()) {
                return pos.func_177972_a(face).func_177972_a(face.func_176746_e());
            }
            return pos.func_177972_a(face);
        }

        public float getFluidHeightForRender(IBlockAccess world, BlockPos pos) {
            IBlockState down = world.func_180495_p(pos.func_177977_b());
            if (down.func_185904_a().func_76224_d() || down.func_177230_c() instanceof IFluidBlock) {
                return 1.0f;
            }
            return 0.995f;
        }
    }

    private static class CloudSeedConcentrated
    extends BlockFluidEio {
        protected CloudSeedConcentrated(Fluid fluid, Material material, int fogColor) {
            super(fluid, material, fogColor);
        }

        public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
            if (!world.field_72995_K && entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 40, 0, true, true));
            }
            super.func_180634_a(world, pos, state, entity);
        }
    }

    private static class LiquidSunshine
    extends BlockFluidEio {
        protected LiquidSunshine(Fluid fluid, Material material, int fogColor) {
            super(fluid, material, fogColor);
        }

        public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
            if (!world.field_72995_K && entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_188424_y, 50, 0, true, true));
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_188423_x, 1200, 0, true, true));
            }
            super.func_180634_a(world, pos, state, entity);
        }
    }

    private static class NutrientDistillation
    extends BlockFluidEio {
        protected NutrientDistillation(Fluid fluid, Material material, int fogColor) {
            super(fluid, material, fogColor);
        }

        public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
            if (!world.field_72995_K && entity instanceof EntityPlayerMP) {
                long time = entity.field_70170_p.func_82737_E();
                EntityPlayerMP player = (EntityPlayerMP)entity;
                if (time % Config.nutrientFoodBoostDelay == 0L && player.getEntityData().func_74763_f("eioLastFoodBoost") != time) {
                    player.func_71024_bL().func_75122_a(1, 0.1f);
                    player.getEntityData().func_74772_a("eioLastFoodBoost", time);
                }
            }
            super.func_180634_a(world, pos, state, entity);
        }
    }

    private static class RocketFuel
    extends BlockFluidEio {
        protected RocketFuel(Fluid fluid, Material material, int fogColor) {
            super(fluid, material, fogColor);
        }

        public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
            if (!world.field_72995_K && entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76430_j, 150, 3, true, true));
            }
            super.func_180634_a(world, pos, state, entity);
        }

        public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
            return true;
        }

        public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
            return true;
        }

        public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
            return 60;
        }

        public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
            this.checkForFire(worldIn, pos);
            super.func_189540_a(state, worldIn, pos, blockIn);
        }

        protected void checkForFire(World worldIn, BlockPos pos) {
            if (Config.rocketFuelIsExplosive) {
                for (EnumFacing side : EnumFacing.values()) {
                    IBlockState neighbor = worldIn.func_180495_p(pos.func_177972_a(side));
                    if (!(neighbor.func_177230_c() instanceof BlockFire) || neighbor.func_177230_c() == ModObject.blockColdFire.getBlock() || !(worldIn.field_73012_v.nextFloat() < 0.5f)) continue;
                    ArrayList<BlockPos> explosions = new ArrayList<BlockPos>();
                    explosions.add(pos);
                    BlockPos up = pos.func_177984_a();
                    while (worldIn.func_180495_p(up).func_177230_c() == this) {
                        explosions.add(up);
                        up = up.func_177984_a();
                    }
                    if (this.isSourceBlock((IBlockAccess)worldIn, pos)) {
                        worldIn.func_72885_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), 2.0f, true, true);
                    }
                    float strength = 0.5f;
                    for (BlockPos explosion : explosions) {
                        worldIn.func_72885_a(null, (double)((float)explosion.func_177958_n() + 0.5f), (double)((float)explosion.func_177956_o() + 0.5f), (double)((float)explosion.func_177952_p() + 0.5f), strength, true, true);
                        strength = Math.min(strength * 1.05f, 7.0f);
                    }
                    return;
                }
            }
        }

        public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
            this.checkForFire(world, pos);
            super.func_180650_b(world, pos, state, rand);
        }
    }

    private static class Hootch
    extends BlockFluidEio {
        protected Hootch(Fluid fluid, Material material, int fogColor) {
            super(fluid, material, fogColor);
        }

        public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
            if (!world.field_72995_K && entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76431_k, 150, 0, true, true));
            }
            super.func_180634_a(world, pos, state, entity);
        }

        public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
            return true;
        }

        public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
            return true;
        }

        public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
            return 1;
        }

        public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
            return 60;
        }
    }

    private static class FireWater
    extends BlockFluidEio {
        protected FireWater(Fluid fluid, Material material, int fogColor) {
            super(fluid, material, fogColor);
        }

        public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
            if (!world.field_72995_K) {
                entity.func_70015_d(50);
            }
            super.func_180634_a(world, pos, state, entity);
        }

        public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
            return true;
        }

        public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
            return true;
        }

        public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
            return 60;
        }
    }
}

