/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.config;

import com.enderio.core.common.event.ConfigFileChangedEvent;
import com.enderio.core.common.vecmath.VecmathUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.config.PacketConfigSync;
import crazypants.enderio.network.PacketHandler;
import crazypants.util.Things;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public final class Config {
    public static final List<Section> sections = new ArrayList<Section>();
    public static Configuration config;
    public static final Section sectionPower;
    public static final Section sectionRecipe;
    public static final Section sectionItems;
    public static final Section sectionEfficiency;
    public static final Section sectionPersonal;
    public static final Section sectionAnchor;
    public static final Section sectionStaff;
    public static final Section sectionRod;
    public static final Section sectionDarkSteel;
    public static final Section sectionFarm;
    public static final Section sectionAesthetic;
    public static final Section sectionAdvanced;
    public static final Section sectionMagnet;
    public static final Section sectionFluid;
    public static final Section sectionSpawner;
    public static final Section sectionKiller;
    public static final Section sectionSoulBinder;
    public static final Section sectionAttractor;
    public static final Section sectionLootConfig;
    public static final Section sectionMobConfig;
    public static final Section sectionEnchantments;
    public static final Section sectionWeather;
    public static final Section sectionTelepad;
    public static final Section sectionInventoryPanel;
    public static final Section sectionMisc;
    public static final Section sectionCapacitor;
    public static final Section sectionTOP;
    public static final Section sectionHoes;
    public static final double DEFAULT_CONDUIT_SCALE = 0.6;
    public static final float EXPLOSION_RESISTANT = 1200.0f;
    public static boolean registerRecipes;
    public static boolean allowFovControlsInSurvivalMode;
    public static boolean jeiUseShortenedPainterRecipes;
    public static double conduitScale;
    public static double transceiverEnergyLoss;
    public static int transceiverBucketTransmissionCostRF;
    public static File configDirectory;
    public static int recipeLevel;
    public static boolean addPeacefulRecipes;
    public static boolean createSyntheticRecipes;
    public static boolean detailedPowerTrackingEnabled;
    public static boolean useSneakMouseWheelYetaWrench;
    public static boolean useSneakRightClickYetaWrench;
    public static int yetaWrenchOverlayMode;
    public static boolean itemConduitUsePhyscialDistance;
    public static boolean redstoneConduitsShowState;
    public static int enderFluidConduitExtractRate;
    public static int enderFluidConduitMaxIoRate;
    public static int advancedFluidConduitExtractRate;
    public static int advancedFluidConduitMaxIoRate;
    public static int fluidConduitExtractRate;
    public static int fluidConduitMaxIoRate;
    public static boolean fluidConduitDynamicLighting;
    public static boolean updateLightingWhenHidingFacades;
    public static boolean transparentFacesLetThroughBeaconBeam;
    public static int travelAnchorMaximumDistance;
    public static int travelAnchorCooldown;
    public static boolean travelAnchorSneak;
    public static boolean travelAnchorSkipWarning;
    public static int travelStaffMaximumDistance;
    public static float travelStaffPowerPerBlockRF;
    public static int travelStaffMaxBlinkDistance;
    public static int travelStaffBlinkPauseTicks;
    public static boolean travelStaffBlinkEnabled;
    public static boolean travelStaffBlinkThroughSolidBlocksEnabled;
    public static boolean travelStaffBlinkThroughClearBlocksEnabled;
    public static boolean travelStaffBlinkThroughUnbreakableBlocksEnabled;
    public static String[] travelStaffBlinkBlackList;
    public static boolean travelStaffOffhandBlinkEnabled;
    public static boolean travelStaffOffhandTravelEnabled;
    public static boolean travelStaffOffhandEnderIOEnabled;
    public static boolean travelStaffOffhandShowsTravelTargets;
    public static float travelAnchorZoomScale;
    public static boolean darkSteelRightClickPlaceEnabled;
    public static double[] darkSteelPowerDamgeAbsorptionRatios;
    public static int darkSteelPowerStorageBase;
    public static int darkSteelPowerStorageLevelOne;
    public static int darkSteelPowerStorageLevelTwo;
    public static int darkSteelPowerStorageLevelThree;
    public static float darkSteelSpeedOneWalkModifier;
    public static float darkSteelSpeedTwoWalkMultiplier;
    public static float darkSteelSpeedThreeWalkMultiplier;
    public static float darkSteelSpeedOneSprintModifier;
    public static float darkSteelSpeedTwoSprintMultiplier;
    public static float darkSteelSpeedThreeSprintMultiplier;
    public static int darkSteelSpeedOneCost;
    public static int darkSteelSpeedTwoCost;
    public static int darkSteelSpeedThreeCost;
    public static double darkSteelBootsJumpModifier;
    public static int darkSteelJumpOneCost;
    public static int darkSteelJumpTwoCost;
    public static int darkSteelJumpThreeCost;
    public static boolean slotZeroPlacesEight;
    public static int darkSteelWalkPowerCost;
    public static int darkSteelSprintPowerCost;
    public static boolean darkSteelDrainPowerFromInventory;
    public static int darkSteelBootsJumpPowerCost;
    public static int darkSteelFallDistanceCost;
    public static float darkSteelSwordPoweredDamageBonus;
    public static float darkSteelSwordPoweredSpeedBonus;
    public static float darkSteelSwordWitherSkullChance;
    public static float darkSteelSwordWitherSkullLootingModifier;
    public static float darkSteelSwordSkullChance;
    public static float darkSteelSwordSkullLootingModifier;
    public static float vanillaSwordSkullLootingModifier;
    public static float vanillaSwordSkullChance;
    public static float ticCleaverSkullDropChance;
    public static float ticBeheadingSkullModifier;
    public static float fakePlayerSkullChance;
    public static int darkSteelSwordPowerUsePerHit;
    public static double darkSteelSwordEnderPearlDropChance;
    public static double darkSteelSwordEnderPearlDropChancePerLooting;
    public static float darkSteelBowDamageBonus;
    public static double[] darkSteelBowForceMultipliers;
    public static int[] darkSteelBowDrawSpeeds;
    public static double[] darkSteelBowFovMultipliers;
    public static int darkSteelBowPowerUsePerDamagePoint;
    public static int darkSteelBowPowerUsePerDraw;
    public static int darkSteelBowPowerUsePerTickDrawn;
    public static int darkSteelPickEffeciencyObsidian;
    public static int darkSteelPickPowerUseObsidian;
    public static float darkSteelPickApplyObsidianEffeciencyAtHardess;
    public static int darkSteelPickPowerUsePerDamagePoint;
    public static float darkSteelPickEffeciencyBoostWhenPowered;
    public static boolean darkSteelPickMinesTiCArdite;
    public static int darkSteelAxePowerUsePerDamagePoint;
    public static int darkSteelAxePowerUsePerDamagePointMultiHarvest;
    public static float darkSteelAxeEffeciencyBoostWhenPowered;
    public static float darkSteelAxeSpeedPenaltyMultiHarvest;
    public static int darkSteelShearsDurabilityFactor;
    public static int darkSteelShearsPowerUsePerDamagePoint;
    public static float darkSteelShearsEffeciencyBoostWhenPowered;
    public static int darkSteelShearsBlockAreaBoostWhenPowered;
    public static float darkSteelShearsEntityAreaBoostWhenPowered;
    public static int darkSteelUpgradeVibrantCost;
    public static int darkSteelUpgradePowerOneCost;
    public static int darkSteelUpgradePowerTwoCost;
    public static int darkSteelUpgradePowerThreeCost;
    public static int darkSteelGliderCost;
    public static double darkSteelGliderHorizontalSpeed;
    public static double darkSteelGliderVerticalSpeed;
    public static double darkSteelGliderVerticalSpeedSprinting;
    public static int darkSteelElytraCost;
    public static int darkSteelGogglesOfRevealingCost;
    public static int darkSteelApiaristArmorCost;
    public static int darkSteelSwimCost;
    public static int darkSteelNightVisionCost;
    public static int darkSteelTOPCost;
    public static int darkSteelSoundLocatorCost;
    public static int darkSteelSoundLocatorRange;
    public static int darkSteelSoundLocatorLifespan;
    public static int darkSteelTravelCost;
    public static int darkSteelSpoonCost;
    public static int darkSteelSolarOneGen;
    public static int darkSteelSolarOneCost;
    public static int darkSteelSolarTwoGen;
    public static int darkSteelSolarTwoCost;
    public static int darkSteelSolarThreeGen;
    public static int darkSteelSolarThreeCost;
    public static boolean darkSteelSolarChargeOthers;
    public static float darkSteelAnvilDamageChance;
    public static int darkSteelAnvilMaxLevel;
    public static float darkSteelLadderSpeedBoost;
    public static int hootchPowerPerCycleRF;
    public static int hootchPowerTotalBurnTime;
    public static int rocketFuelPowerPerCycleRF;
    public static int rocketFuelPowerTotalBurnTime;
    public static int fireWaterPowerPerCycleRF;
    public static int fireWaterPowerTotalBurnTime;
    public static int vatPowerUserPerTickRF;
    public static int maxPhotovoltaicOutputRF;
    public static int maxPhotovoltaicAdvancedOutputRF;
    public static int maxPhotovoltaicVibrantOutputRF;
    public static int zombieGeneratorRfPerTick;
    public static int zombieGeneratorTicksPerBucketFuel;
    public static boolean addFuelTooltipsToAllFluidContainers;
    public static boolean addFurnaceFuelTootip;
    public static boolean addDurabilityTootip;
    public static int farmActionEnergyUseRF;
    public static int farmAxeActionEnergyUseRF;
    public static int farmBonemealActionEnergyUseRF;
    public static int farmBonemealTryEnergyUseRF;
    public static boolean farmAxeDamageOnLeafBreak;
    public static float farmToolTakeDamageChance;
    public static boolean disableFarmNotification;
    public static boolean farmEssenceBerriesEnabled;
    public static boolean farmManaBeansEnabled;
    public static boolean farmHarvestJungleWhenCocoa;
    public static String[] hoeStrings;
    public static Things farmHoes;
    public static int farmSaplingReserveAmount;
    public static boolean farmStopOnNoOutputSlots;
    public static boolean farmEvictEmptyRFTools;
    public static int magnetPowerUsePerSecondRF;
    public static int magnetPowerCapacityRF;
    public static int magnetRange;
    public static String[] magnetBlacklist;
    public static int magnetMaxItems;
    public static boolean magnetAllowInMainInventory;
    public static boolean magnetAllowInBaublesSlot;
    public static boolean magnetAllowDeactivatedInBaublesSlot;
    public static String magnetBaublesType;
    public static int crafterRfPerCraft;
    public static int capacitorBankMaxIoRF;
    public static int capacitorBankMaxStorageRF;
    public static int capacitorBankTierOneMaxIoRF;
    public static int capacitorBankTierOneMaxStorageRF;
    public static int capacitorBankTierTwoMaxIoRF;
    public static int capacitorBankTierTwoMaxStorageRF;
    public static int capacitorBankTierThreeMaxIoRF;
    public static int capacitorBankTierThreeMaxStorageRF;
    public static boolean capacitorBankRenderPowerOverlayOnItem;
    public static int poweredSpawnerMinDelayTicks;
    public static int poweredSpawnerMaxDelayTicks;
    public static int poweredSpawnerMaxPlayerDistance;
    public static int poweredSpawnerDespawnTimeSeconds;
    public static int poweredSpawnerSpawnCount;
    public static int poweredSpawnerSpawnRange;
    public static int poweredSpawnerMaxNearbyEntities;
    public static int poweredSpawnerMaxSpawnTries;
    public static boolean poweredSpawnerUseVanillaSpawChecks;
    public static double brokenSpawnerDropChance;
    public static String[] brokenSpawnerToolBlacklist;
    public static int powerSpawnerAddSpawnerCost;
    public static int painterEnergyPerTaskRF;
    public static int vacuumChestRange;
    public static int wirelessChargerRange;
    public static long nutrientFoodBoostDelay;
    public static boolean rocketFuelIsExplosive;
    public static int enchanterBaseLevelCost;
    public static double enchanterLevelCostFactor;
    public static double enchanterLapisCostFactor;
    public static boolean machineSoundsEnabled;
    public static float machineSoundVolume;
    public static int killerJoeNutrientUsePerAttackMb;
    public static double killerJoeAttackHeight;
    public static double killerJoeAttackWidth;
    public static double killerJoeAttackLength;
    public static double killerJoeHooverXpWidth;
    public static double killerJoeHooverXpLength;
    public static boolean killerJoeMustSee;
    public static boolean killerPvPoffDisablesSwing;
    public static boolean killerPvPoffIsIgnored;
    public static boolean killerMendingEnabled;
    public static boolean killerProvokesCreeperExpolosions;
    public static double xpVacuumRange;
    public static boolean allowTileEntitiesAsPaintSource;
    public static boolean enableMEConduits;
    public static boolean enableOCConduits;
    public static boolean enableOCConduitsAnimatedTexture;
    public static List<String> soulVesselBlackList;
    public static List<String> soulVesselUnspawnableList;
    public static boolean soulVesselCapturesBosses;
    public static int soulBinderBrokenSpawnerRF;
    public static int soulBinderBrokenSpawnerLevels;
    public static int soulBinderReanimationRF;
    public static int soulBinderReanimationLevels;
    public static int soulBinderEnderCystalRF;
    public static int soulBinderEnderCystalLevels;
    public static int soulBinderPrecientCystalRF;
    public static int soulBinderPrecientCystalLevels;
    public static int soulBinderAttractorCystalRF;
    public static int soulBinderAttractorCystalLevels;
    public static int soulBinderTunedPressurePlateLevels;
    public static int soulBinderTunedPressurePlateRF;
    public static int soulBinderMaxXpLevel;
    public static boolean powerConduitCanDifferentTiersConnect;
    public static int powerConduitTierOneRF;
    public static int powerConduitTierTwoRF;
    public static int powerConduitTierThreeRF;
    public static boolean spawnGuardStopAllSlimesDebug;
    public static boolean spawnGuardStopAllSquidSpawning;
    public static int weatherObeliskClearFluid;
    public static int weatherObeliskRainFluid;
    public static int weatherObeliskThunderFluid;
    public static boolean lootDarkSteel;
    public static boolean lootItemConduitProbe;
    public static boolean lootQuartz;
    public static boolean lootNetherWart;
    public static boolean lootEnderPearl;
    public static boolean lootElectricSteel;
    public static boolean lootRedstoneAlloy;
    public static boolean lootPhasedIron;
    public static boolean lootPhasedGold;
    public static boolean lootTravelStaff;
    public static boolean lootTheEnder;
    public static boolean lootDarkSteelBoots;
    public static boolean dumpMobNames;
    public static int xpObeliskMaxXpLevel;
    public static String xpJuiceName;
    public static boolean clearGlassConnectToFusedQuartz;
    public static boolean glassConnectToTheirVariants;
    public static boolean glassConnectToTheirColorVariants;
    public static Enchantment.Rarity enchantmentSoulBoundRarity;
    public static boolean enchantmentSoulBoundEnabled;
    public static boolean telepadLockDimension;
    public static boolean telepadLockCoords;
    public static int telepadPowerCoefficient;
    public static int telepadPowerInterdimensional;
    public static boolean telepadShrinkEffect;
    public static boolean telepadIsTravelAnchor;
    public static int telepadEnergyBufferRF;
    public static int telepadEnergyUsePerTickRF;
    public static String telepadFluidType;
    public static int telepadFluidUse;
    public static boolean rodOfReturnCanTargetAnywhere;
    public static int rodOfReturnTicksToActivate;
    public static int rodOfReturnPowerStorage;
    public static int rodOfReturnMinTicksToRecharge;
    public static int rodOfReturnRfPerTick;
    public static int rodOfReturnFluidUsePerTeleport;
    public static int rodOfReturnFluidStorage;
    public static String rodOfReturnFluidType;
    public static boolean inventoryPanelFree;
    public static float inventoryPanelPowerPerMB;
    public static float inventoryPanelScanCostPerSlot;
    public static float inventoryPanelExtractCostPerItem;
    public static float inventoryPanelExtractCostPerOperation;
    public static boolean inventoryPanelScaleText;
    public static int[] remoteInventoryMBPerOpen;
    public static int[] remoteInventoryRFPerTick;
    public static int[] remoteInventoryMBCapacity;
    public static int[] remoteInventoryRFCapacity;
    public static String[] remoteInventoryFluidTypes;
    public static String coldFireIgniterFluidType;
    public static int coldFireIgniterMbPerUse;
    public static boolean photovoltaicCanTypesJoins;
    public static int photovoltaicRecalcSunTick;
    public static boolean debugUpdatePackets;
    public static boolean topEnabled;
    public static boolean topShowProgressByDefault;
    public static boolean topShowPowerByDefault;
    public static boolean topShowRedstoneByDefault;
    public static boolean topShowSideConfigByDefault;
    public static boolean topShowRangeByDefault;
    public static boolean topShowMobsByDefault;
    public static boolean topShowTanksByDefault;
    public static boolean topShowXPByDefault;
    public static boolean topShowItemCountDefault;
    public static boolean paintedGlowstoneRequireSilkTouch;
    public static boolean enableBaublesIntegration;
    public static String leversEnabled;

    public static void preInit(FMLPreInitializationEvent event) {
        PacketHandler.INSTANCE.registerMessage(PacketConfigSync.class, PacketConfigSync.class, PacketHandler.nextID(), Side.CLIENT);
        MinecraftForge.EVENT_BUS.register((Object)new Config());
        configDirectory = new File(event.getModConfigurationDirectory(), EnderIO.DOMAIN);
        if (!configDirectory.exists()) {
            configDirectory.mkdir();
        }
        File configFile = new File(configDirectory, "EnderIO.cfg");
        config = new Configuration(configFile);
        Config.syncConfig(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncConfig(boolean load) {
        try {
            if (load) {
                config.load();
            }
            Config.processConfig(config);
        }
        catch (Exception e) {
            Log.error("EnderIO has a problem loading it's configuration");
            e.printStackTrace();
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("EnderIO")) {
            Log.info("Updating config...");
            Config.syncConfig(false);
            Config.init(null);
            Config.postInit();
        }
    }

    @SubscribeEvent
    public void onConfigFileChanged(ConfigFileChangedEvent event) {
        if (event.getModID().equals("EnderIO")) {
            Log.info("Updating config...");
            Config.syncConfig(true);
            event.setSuccessful();
            Config.init(null);
            Config.postInit();
        }
    }

    @SubscribeEvent
    public void onPlayerLoggon(PlayerEvent.PlayerLoggedInEvent evt) {
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketConfigSync(), (EntityPlayerMP)evt.player);
    }

    public static void processConfig(Configuration config) {
        capacitorBankMaxIoRF = config.get(Config.sectionPower.name, "capacitorBankMaxIoRF", capacitorBankMaxIoRF, "The maximum IO for a single capacitor in RF/t").getInt(capacitorBankMaxIoRF);
        capacitorBankMaxStorageRF = config.get(Config.sectionPower.name, "capacitorBankMaxStorageRF", capacitorBankMaxStorageRF, "The maximum storage for a single capacitor in RF").getInt(capacitorBankMaxStorageRF);
        capacitorBankTierOneMaxIoRF = config.get(Config.sectionPower.name, "capacitorBankTierOneMaxIoRF", capacitorBankTierOneMaxIoRF, "The maximum IO for a single tier one capacitor in RF/t").getInt(capacitorBankTierOneMaxIoRF);
        capacitorBankTierOneMaxStorageRF = config.get(Config.sectionPower.name, "capacitorBankTierOneMaxStorageRF", capacitorBankTierOneMaxStorageRF, "The maximum storage for a single tier one capacitor in RF").getInt(capacitorBankTierOneMaxStorageRF);
        capacitorBankTierTwoMaxIoRF = config.get(Config.sectionPower.name, "capacitorBankTierTwoMaxIoRF", capacitorBankTierTwoMaxIoRF, "The maximum IO for a single tier two capacitor in RF/t").getInt(capacitorBankTierTwoMaxIoRF);
        capacitorBankTierTwoMaxStorageRF = config.get(Config.sectionPower.name, "capacitorBankTierTwoMaxStorageRF", capacitorBankTierTwoMaxStorageRF, "The maximum storage for a single tier two capacitor in RF").getInt(capacitorBankTierTwoMaxStorageRF);
        capacitorBankTierThreeMaxIoRF = config.get(Config.sectionPower.name, "capacitorBankTierThreeMaxIoRF", capacitorBankTierThreeMaxIoRF, "The maximum IO for a single tier three capacitor in RF/t").getInt(capacitorBankTierThreeMaxIoRF);
        capacitorBankTierThreeMaxStorageRF = config.get(Config.sectionPower.name, "capacitorBankTierThreeMaxStorageRF", capacitorBankTierThreeMaxStorageRF, "The maximum storage for a single tier three capacitor in RF").getInt(capacitorBankTierThreeMaxStorageRF);
        capacitorBankRenderPowerOverlayOnItem = config.getBoolean("capacitorBankRenderPowerOverlayOnItem", Config.sectionAesthetic.name, capacitorBankRenderPowerOverlayOnItem, "When true the the capacitor bank item wil get a power bar in addition to the gauge on the bank");
        powerConduitTierOneRF = config.get(Config.sectionPower.name, "powerConduitTierOneRF", powerConduitTierOneRF, "The maximum IO for the tier 1 power conduit").getInt(powerConduitTierOneRF);
        powerConduitTierTwoRF = config.get(Config.sectionPower.name, "powerConduitTierTwoRF", powerConduitTierTwoRF, "The maximum IO for the tier 2 power conduit").getInt(powerConduitTierTwoRF);
        powerConduitTierThreeRF = config.get(Config.sectionPower.name, "powerConduitTierThreeRF", powerConduitTierThreeRF, "The maximum IO for the tier 3 power conduit").getInt(powerConduitTierThreeRF);
        powerConduitCanDifferentTiersConnect = config.getBoolean("powerConduitCanDifferentTiersConnect", Config.sectionPower.name, powerConduitCanDifferentTiersConnect, "If set to false power conduits of different tiers cannot be connected. in this case a block such as a cap. bank is needed to bridge different tiered networks");
        painterEnergyPerTaskRF = config.get(Config.sectionPower.name, "painterEnergyPerTaskRF", painterEnergyPerTaskRF, "The total amount of RF required to paint one block").getInt(painterEnergyPerTaskRF);
        recipeLevel = config.get(Config.sectionRecipe.name, "recipeLevel", recipeLevel, "How expensive should the crafting recipes be? 0=cheapest, 1=cheaper, 2=normal, 3=expensive").getInt(recipeLevel);
        registerRecipes = config.get(Config.sectionRecipe.name, "registerRecipes", registerRecipes, "If set to false: No crafting recipes (crafting table and furnace) will be registered. You need to use Creative mode or something like minetweaker to add them yourself.").getBoolean(registerRecipes);
        addPeacefulRecipes = config.get(Config.sectionRecipe.name, "addPeacefulRecipes", addPeacefulRecipes, "When enabled peaceful recipes are added for soulbinder based crafting components.").getBoolean(addPeacefulRecipes);
        allowTileEntitiesAsPaintSource = config.get(Config.sectionRecipe.name, "allowTileEntitiesAsPaintSource", allowTileEntitiesAsPaintSource, "When enabled blocks with tile entities (e.g. machines) can be used as paint targets.").getBoolean(allowTileEntitiesAsPaintSource);
        createSyntheticRecipes = config.get(Config.sectionRecipe.name, "createSyntheticRecipes", createSyntheticRecipes, "Automatically create alloy smelter recipes with double and triple inputs and different slot allocations (1+1+1, 2+1, 1+2, 3 and 2) for single-input recipes.").getBoolean(createSyntheticRecipes);
        redstoneConduitsShowState = config.get(Config.sectionMisc.name, "redstoneConduitsShowState", redstoneConduitsShowState, "If set to false redstone conduits will look the same whether they are recieving a signal or not. This can help with performance.").getBoolean(redstoneConduitsShowState);
        enchanterBaseLevelCost = config.get(Config.sectionRecipe.name, "enchanterBaseLevelCost", enchanterBaseLevelCost, "Base level cost added to all recipes in the enchanter.").getInt(enchanterBaseLevelCost);
        enchanterLevelCostFactor = config.get(Config.sectionRecipe.name, "enchanterLevelCostFactor", enchanterLevelCostFactor, "The final XP cost for an enchantment is multiplied by this value. To halve costs set to 0.5, to double them set it to 2").getDouble(enchanterLevelCostFactor);
        enchanterLapisCostFactor = config.get(Config.sectionRecipe.name, "enchanterLapisCostFactor", enchanterLapisCostFactor, "The lapis cost is enchant level multiplied by this value").getDouble(enchanterLapisCostFactor);
        maxPhotovoltaicOutputRF = config.get(Config.sectionPower.name, "maxPhotovoltaicOutputRF", maxPhotovoltaicOutputRF, "Maximum output in RF/t of the Photovoltaic Panels.").getInt(maxPhotovoltaicOutputRF);
        maxPhotovoltaicAdvancedOutputRF = config.get(Config.sectionPower.name, "maxPhotovoltaicAdvancedOutputRF", maxPhotovoltaicAdvancedOutputRF, "Maximum output in RF/t of the Advanced Photovoltaic Panels.").getInt(maxPhotovoltaicAdvancedOutputRF);
        maxPhotovoltaicVibrantOutputRF = config.get(Config.sectionPower.name, "maxPhotovoltaicVibrantOutputRF", maxPhotovoltaicVibrantOutputRF, "Maximum output in RF/t of the Vibrant Photovoltaic Panels.").getInt(maxPhotovoltaicVibrantOutputRF);
        photovoltaicCanTypesJoins = config.get(Config.sectionPower.name, "photovoltaicCanTypesJoins", photovoltaicCanTypesJoins, "When enabled Photovoltaic Panels of different kinds can join together as a multi-block").getBoolean(photovoltaicCanTypesJoins);
        photovoltaicRecalcSunTick = config.get(Config.sectionPower.name, "photovoltaicRecalcSunTick", photovoltaicRecalcSunTick, "How often (in ticks) the Photovoltaic Panels should check the sun's angle.").getInt(photovoltaicRecalcSunTick);
        conduitScale = config.get(Config.sectionAesthetic.name, "conduitScale", 0.6, "Valid values are between 0-1, smallest conduits at 0, largest at 1.\nIn SMP, all clients must be using the same value as the server.").getDouble(0.6);
        conduitScale = VecmathUtil.clamp((double)conduitScale, (double)0.0, (double)1.0);
        wirelessChargerRange = config.get(Config.sectionEfficiency.name, "wirelessChargerRange", wirelessChargerRange, "The range of the wireless charger").getInt(wirelessChargerRange);
        fluidConduitExtractRate = config.get(Config.sectionEfficiency.name, "fluidConduitExtractRate", fluidConduitExtractRate, "Number of millibuckets per tick extracted by a fluid conduits auto extracting").getInt(fluidConduitExtractRate);
        fluidConduitDynamicLighting = config.get(Config.sectionEfficiency.name, "fluidConduitDynamicLighting", fluidConduitDynamicLighting, "If enabled, conduits will change their light levels based on their contents.").getBoolean(false);
        fluidConduitMaxIoRate = config.get(Config.sectionEfficiency.name, "fluidConduitMaxIoRate", fluidConduitMaxIoRate, "Number of millibuckets per tick that can pass through a single connection to a fluid conduit.").getInt(fluidConduitMaxIoRate);
        advancedFluidConduitExtractRate = config.get(Config.sectionEfficiency.name, "advancedFluidConduitExtractRate", advancedFluidConduitExtractRate, "Number of millibuckets per tick extracted by pressurized fluid conduits auto extracting").getInt(advancedFluidConduitExtractRate);
        advancedFluidConduitMaxIoRate = config.get(Config.sectionEfficiency.name, "advancedFluidConduitMaxIoRate", advancedFluidConduitMaxIoRate, "Number of millibuckets per tick that can pass through a single connection to an pressurized fluid conduit.").getInt(advancedFluidConduitMaxIoRate);
        enderFluidConduitExtractRate = config.get(Config.sectionEfficiency.name, "enderFluidConduitExtractRate", enderFluidConduitExtractRate, "Number of millibuckets per tick extracted by ender fluid conduits auto extracting").getInt(enderFluidConduitExtractRate);
        enderFluidConduitMaxIoRate = config.get(Config.sectionEfficiency.name, "enderFluidConduitMaxIoRate", enderFluidConduitMaxIoRate, "Number of millibuckets per tick that can pass through a single connection to an ender fluid conduit.").getInt(enderFluidConduitMaxIoRate);
        transceiverEnergyLoss = config.get(Config.sectionPower.name, "transceiverEnergyLoss", transceiverEnergyLoss, "Amount of energy lost when transfered by Dimensional Transceiver; 0 is no loss, 1 is 100% loss").getDouble(transceiverEnergyLoss);
        transceiverBucketTransmissionCostRF = config.get(Config.sectionEfficiency.name, "transceiverBucketTransmissionCostRF", transceiverBucketTransmissionCostRF, "The cost in RF of transporting a bucket of fluid via a Dimensional Transceiver.").getInt(transceiverBucketTransmissionCostRF);
        vatPowerUserPerTickRF = config.get(Config.sectionPower.name, "vatPowerUserPerTickRF", vatPowerUserPerTickRF, "Power use (RF/t) used by the vat.").getInt(vatPowerUserPerTickRF);
        detailedPowerTrackingEnabled = config.get(Config.sectionAdvanced.name, "perInterfacePowerTrackingEnabled", detailedPowerTrackingEnabled, "Enable per tick sampling on individual power inputs and outputs. This allows slightly more detailed messages from the RF Reader but has a negative impact on server performance.").getBoolean(detailedPowerTrackingEnabled);
        jeiUseShortenedPainterRecipes = config.get(Config.sectionPersonal.name, "jeiUseShortenedPainterRecipes", jeiUseShortenedPainterRecipes, "If true, only a handful of sample painter recipes will be shown in JEI. Enable this if you have timing problems starting a world or logging into a server.").getBoolean(jeiUseShortenedPainterRecipes);
        useSneakMouseWheelYetaWrench = config.get(Config.sectionPersonal.name, "useSneakMouseWheelYetaWrench", useSneakMouseWheelYetaWrench, "If true, shift-mouse wheel will change the conduit display mode when the YetaWrench is equipped.").getBoolean(useSneakMouseWheelYetaWrench);
        useSneakRightClickYetaWrench = config.get(Config.sectionPersonal.name, "useSneakRightClickYetaWrench", useSneakRightClickYetaWrench, "If true, shift-clicking the YetaWrench on a null or non wrenchable object will change the conduit display mode.").getBoolean(useSneakRightClickYetaWrench);
        yetaWrenchOverlayMode = config.getInt("yetaWrenchOverlayMode", Config.sectionPersonal.name, yetaWrenchOverlayMode, 0, 2, "What kind of overlay to use when holding the yeta wrench\n\n0 - Sideways scrolling in ceter of screen\n1 - Vertical icon bar in bottom right\n2 - Old-style group of icons in bottom right");
        machineSoundsEnabled = config.get(Config.sectionPersonal.name, "useMachineSounds", machineSoundsEnabled, "If true, machines will make sounds.").getBoolean(machineSoundsEnabled);
        machineSoundVolume = (float)config.get(Config.sectionPersonal.name, "machineSoundVolume", (double)machineSoundVolume, "Volume of machine sounds.").getDouble((double)machineSoundVolume);
        itemConduitUsePhyscialDistance = config.get(Config.sectionEfficiency.name, "itemConduitUsePhyscialDistance", itemConduitUsePhyscialDistance, "If true, 'line of sight' distance rather than conduit path distance is used to calculate priorities.").getBoolean(itemConduitUsePhyscialDistance);
        vacuumChestRange = config.get(Config.sectionEfficiency.name, "vacumChestRange", vacuumChestRange, "The range of the vacuum chest").getInt(vacuumChestRange);
        travelAnchorMaximumDistance = config.get(Config.sectionAnchor.name, "travelAnchorMaxDistance", travelAnchorMaximumDistance, "Maximum number of blocks that can be traveled from one travel anchor to another.").getInt(travelAnchorMaximumDistance);
        travelAnchorCooldown = config.get(Config.sectionAnchor.name, "travelAnchorCooldown", travelAnchorCooldown, "Number of ticks cooldown between activations (1 sec = 20 ticks)").getInt(travelAnchorCooldown);
        travelAnchorSneak = config.get(Config.sectionAnchor.name, "travelAnchorSneak", travelAnchorSneak, "Add sneak as an option to activate travel anchors").getBoolean(travelAnchorSneak);
        travelAnchorSkipWarning = config.get(Config.sectionAnchor.name, "travelAnchorSkipWarning", travelAnchorSkipWarning, "Travel Anchors send a chat warning when skipping inaccessible anchors").getBoolean(travelAnchorSkipWarning);
        travelStaffMaximumDistance = config.get(Config.sectionStaff.name, "travelStaffMaxDistance", travelStaffMaximumDistance, "Maximum number of blocks that can be traveled using the Staff of Traveling.").getInt(travelStaffMaximumDistance);
        travelStaffPowerPerBlockRF = (float)config.get(Config.sectionStaff.name, "travelStaffPowerPerBlockRF", (double)travelStaffPowerPerBlockRF, "Number of RF required per block traveled using the Staff of Traveling.").getDouble((double)travelStaffPowerPerBlockRF);
        travelStaffMaxBlinkDistance = config.get(Config.sectionStaff.name, "travelStaffMaxBlinkDistance", travelStaffMaxBlinkDistance, "Max number of blocks teleported when shift clicking the staff.").getInt(travelStaffMaxBlinkDistance);
        travelStaffBlinkPauseTicks = config.get(Config.sectionStaff.name, "travelStaffBlinkPauseTicks", travelStaffBlinkPauseTicks, "Minimum number of ticks between 'blinks'. Values of 10 or less allow a limited sort of flight.").getInt(travelStaffBlinkPauseTicks);
        travelStaffBlinkEnabled = config.get(Config.sectionStaff.name, "travelStaffBlinkEnabled", travelStaffBlinkEnabled, "If set to false: the travel staff can not be used to shift-right click teleport, or blink.").getBoolean(travelStaffBlinkEnabled);
        travelStaffBlinkThroughSolidBlocksEnabled = config.get(Config.sectionStaff.name, "travelStaffBlinkThroughSolidBlocksEnabled", travelStaffBlinkThroughSolidBlocksEnabled, "If set to false: the travel staff can be used to blink through any block.").getBoolean(travelStaffBlinkThroughSolidBlocksEnabled);
        travelStaffBlinkThroughClearBlocksEnabled = config.get(Config.sectionItems.name, "travelStaffBlinkThroughClearBlocksEnabled", travelStaffBlinkThroughClearBlocksEnabled, "If travelStaffBlinkThroughSolidBlocksEnabled is set to false and this is true: the travel staff can only be used to blink through transparent or partial blocks (e.g. torches). If both are false: only air blocks may be teleported through.").getBoolean(travelStaffBlinkThroughClearBlocksEnabled);
        travelStaffBlinkThroughUnbreakableBlocksEnabled = config.get(Config.sectionItems.name, "travelStaffBlinkThroughUnbreakableBlocksEnabled", travelStaffBlinkThroughUnbreakableBlocksEnabled, "Allows the travel staff to blink through unbreakable blocks such as warded blocks and bedrock.").getBoolean();
        travelStaffBlinkBlackList = config.getStringList("travelStaffBlinkBlackList", Config.sectionStaff.name, travelStaffBlinkBlackList, "Lists the blocks that cannot be teleported through in the form 'modID:blockName'");
        travelAnchorZoomScale = config.getFloat("travelAnchorZoomScale", Config.sectionStaff.name, travelAnchorZoomScale, 0.0f, 1.0f, "Set the max zoomed size of a travel anchor as an aprox. percentage of screen height");
        travelStaffOffhandBlinkEnabled = config.get(Config.sectionStaff.name, "travelStaffOffhandBlinkEnabled", travelStaffOffhandBlinkEnabled, "If set to false: the travel staff can not be used to shift-right click teleport, or blink, when held in the off-hand.").getBoolean(travelStaffOffhandBlinkEnabled);
        travelStaffOffhandTravelEnabled = config.get(Config.sectionStaff.name, "travelStaffOffhandTravelEnabled", travelStaffOffhandTravelEnabled, "If set to false: the travel staff can not be used to click teleport to Travel Anchors, when held in the off-hand.").getBoolean(travelStaffOffhandTravelEnabled);
        travelStaffOffhandEnderIOEnabled = config.get(Config.sectionStaff.name, "travelStaffOffhandEnderIOEnabled", travelStaffOffhandEnderIOEnabled, "If set to false: the travel staff can not be used to activate the Ender IO, when held in the off-hand.").getBoolean(travelStaffOffhandEnderIOEnabled);
        travelStaffOffhandShowsTravelTargets = config.get(Config.sectionStaff.name, "travelStaffOffhandShowsTravelTargets", travelStaffOffhandShowsTravelTargets, "If set to false: Teleportation targets will not be highlighted for travel items held in the off-hand.").getBoolean(travelStaffOffhandShowsTravelTargets);
        rodOfReturnCanTargetAnywhere = config.get(Config.sectionRod.name, "rodOfReturnCanTargetAnywhere", rodOfReturnCanTargetAnywhere, "If set to false the rod of return can only target a telepad.").getBoolean(rodOfReturnCanTargetAnywhere);
        rodOfReturnTicksToActivate = config.get(Config.sectionRod.name, "rodOfReturnTicksToActivate", rodOfReturnTicksToActivate, "Number of ticks the rod must be used before teleporting").getInt(rodOfReturnTicksToActivate);
        rodOfReturnPowerStorage = config.get(Config.sectionRod.name, "rodOfReturnPowerStorage", rodOfReturnPowerStorage, "Internal RF buffer for rod").getInt(rodOfReturnPowerStorage);
        rodOfReturnRfPerTick = config.get(Config.sectionRod.name, "rodOfReturnRfPerTick", rodOfReturnRfPerTick, "RF used per tick").getInt(rodOfReturnRfPerTick);
        rodOfReturnMinTicksToRecharge = config.get(Config.sectionRod.name, "rodOfReturnMinTicksToRecharge", rodOfReturnMinTicksToRecharge, "Min number of ticks required to recharge the internal RF buffer").getInt(rodOfReturnMinTicksToRecharge);
        rodOfReturnFluidStorage = config.get(Config.sectionRod.name, "rodOfReturnFluidStorage", rodOfReturnFluidStorage, "How much fluid the rod can store").getInt(rodOfReturnFluidStorage);
        rodOfReturnFluidUsePerTeleport = config.get(Config.sectionRod.name, "rodOfReturnFluidUsePerTeleport", rodOfReturnFluidUsePerTeleport, "How much fluid is used per teleport").getInt(rodOfReturnFluidUsePerTeleport);
        rodOfReturnFluidType = config.getString("rodOfReturnFluidType", Config.sectionRod.name, rodOfReturnFluidType, "The type of fluid used by the rod.");
        updateLightingWhenHidingFacades = config.get(Config.sectionEfficiency.name, "updateLightingWhenHidingFacades", updateLightingWhenHidingFacades, "When true: correct lighting is recalculated (client side) for conduit bundles when transitioning to from being hidden behind a facade. This produces better quality rendering but can result in frame stutters when switching to/from a wrench.").getBoolean(updateLightingWhenHidingFacades);
        transparentFacesLetThroughBeaconBeam = config.get(Config.sectionAdvanced.name, "transparentFacesLetThroughBeaconBeam", transparentFacesLetThroughBeaconBeam, "If true, transparent facades will not block the Beacon's beam. As side effect they will also let through a tiny amount of light.").getBoolean(transparentFacesLetThroughBeaconBeam);
        darkSteelRightClickPlaceEnabled = config.get(Config.sectionDarkSteel.name, "darkSteelRightClickPlaceEnabled", darkSteelRightClickPlaceEnabled, "Enable / disable right click to place block using dark steel tools.").getBoolean(darkSteelRightClickPlaceEnabled);
        darkSteelPowerDamgeAbsorptionRatios = config.get(Config.sectionDarkSteel.name, "darkSteelPowerDamgeAbsorptionRatios", darkSteelPowerDamgeAbsorptionRatios, "A list of the amount of durability damage absorbed when items are powered. In order of upgrade level. 1=100% so items take no durability damage when powered.").getDoubleList();
        darkSteelPowerStorageBase = config.get(Config.sectionDarkSteel.name, "darkSteelPowerStorageBase", darkSteelPowerStorageBase, "Base amount of power stored by dark steel items.").getInt(darkSteelPowerStorageBase);
        darkSteelPowerStorageLevelOne = config.get(Config.sectionDarkSteel.name, "darkSteelPowerStorageLevelOne", darkSteelPowerStorageLevelOne, "Amount of power stored by dark steel items with a level 1 upgrade.").getInt(darkSteelPowerStorageLevelOne);
        darkSteelPowerStorageLevelTwo = config.get(Config.sectionDarkSteel.name, "darkSteelPowerStorageLevelTwo", darkSteelPowerStorageLevelTwo, "Amount of power stored by dark steel items with a level 2 upgrade.").getInt(darkSteelPowerStorageLevelTwo);
        darkSteelPowerStorageLevelThree = config.get(Config.sectionDarkSteel.name, "darkSteelPowerStorageLevelThree", darkSteelPowerStorageLevelThree, "Amount of power stored by dark steel items with a level 3 upgrade.").getInt(darkSteelPowerStorageLevelThree);
        darkSteelUpgradeVibrantCost = config.get(Config.sectionDarkSteel.name, "darkSteelUpgradeVibrantCost", darkSteelUpgradeVibrantCost, "Number of levels required for the 'Empowered.").getInt(darkSteelUpgradeVibrantCost);
        darkSteelUpgradePowerOneCost = config.get(Config.sectionDarkSteel.name, "darkSteelUpgradePowerOneCost", darkSteelUpgradePowerOneCost, "Number of levels required for the 'Power 1.").getInt(darkSteelUpgradePowerOneCost);
        darkSteelUpgradePowerTwoCost = config.get(Config.sectionDarkSteel.name, "darkSteelUpgradePowerTwoCost", darkSteelUpgradePowerTwoCost, "Number of levels required for the 'Power 2.").getInt(darkSteelUpgradePowerTwoCost);
        darkSteelUpgradePowerThreeCost = config.get(Config.sectionDarkSteel.name, "darkSteelUpgradePowerThreeCost", darkSteelUpgradePowerThreeCost, "Number of levels required for the 'Power 3' upgrade.").getInt(darkSteelUpgradePowerThreeCost);
        darkSteelJumpOneCost = config.get(Config.sectionDarkSteel.name, "darkSteelJumpOneCost", darkSteelJumpOneCost, "Number of levels required for the 'Jump 1' upgrade.").getInt(darkSteelJumpOneCost);
        darkSteelJumpTwoCost = config.get(Config.sectionDarkSteel.name, "darkSteelJumpTwoCost", darkSteelJumpTwoCost, "Number of levels required for the 'Jump 2' upgrade.").getInt(darkSteelJumpTwoCost);
        darkSteelJumpThreeCost = config.get(Config.sectionDarkSteel.name, "darkSteelJumpThreeCost", darkSteelJumpThreeCost, "Number of levels required for the 'Jump 3' upgrade.").getInt(darkSteelJumpThreeCost);
        darkSteelSpeedOneCost = config.get(Config.sectionDarkSteel.name, "darkSteelSpeedOneCost", darkSteelSpeedOneCost, "Number of levels required for the 'Speed 1' upgrade.").getInt(darkSteelSpeedOneCost);
        darkSteelSpeedTwoCost = config.get(Config.sectionDarkSteel.name, "darkSteelSpeedTwoCost", darkSteelSpeedTwoCost, "Number of levels required for the 'Speed 2' upgrade.").getInt(darkSteelSpeedTwoCost);
        darkSteelSpeedThreeCost = config.get(Config.sectionDarkSteel.name, "darkSteelSpeedThreeCost", darkSteelSpeedThreeCost, "Number of levels required for the 'Speed 3' upgrade.").getInt(darkSteelSpeedThreeCost);
        slotZeroPlacesEight = config.get(Config.sectionDarkSteel.name, "shouldSlotZeroWrap", slotZeroPlacesEight, "Should the dark steel placement, when in the first (0th) slot, place the item in the last slot. If false, will place what's in the second slot.").getBoolean();
        darkSteelSpeedOneWalkModifier = (float)config.get(Config.sectionDarkSteel.name, "darkSteelSpeedOneWalkModifier", (double)darkSteelSpeedOneWalkModifier, "Speed modifier applied when walking in the Dark Steel Boots with Speed I.").getDouble((double)darkSteelSpeedOneWalkModifier);
        darkSteelSpeedTwoWalkMultiplier = (float)config.get(Config.sectionDarkSteel.name, "darkSteelSpeedTwoWalkMultiplier", (double)darkSteelSpeedTwoWalkMultiplier, "Speed modifier applied when walking in the Dark Steel Boots with Speed I.").getDouble((double)darkSteelSpeedTwoWalkMultiplier);
        darkSteelSpeedThreeWalkMultiplier = (float)config.get(Config.sectionDarkSteel.name, "darkSteelSpeedThreeWalkMultiplier", (double)darkSteelSpeedThreeWalkMultiplier, "Speed modifier applied when walking in the Dark Steel Boots with Speed I.").getDouble((double)darkSteelSpeedThreeWalkMultiplier);
        darkSteelSpeedOneSprintModifier = (float)config.get(Config.sectionDarkSteel.name, "darkSteelSpeedOneSprintModifier", (double)darkSteelSpeedOneSprintModifier, "Speed modifier applied when walking in the Dark Steel Boots with Speed I.").getDouble((double)darkSteelSpeedOneSprintModifier);
        darkSteelSpeedTwoSprintMultiplier = (float)config.get(Config.sectionDarkSteel.name, "darkSteelSpeedTwoSprintMultiplier", (double)darkSteelSpeedTwoSprintMultiplier, "Speed modifier applied when walking in the Dark Steel Boots with Speed I.").getDouble((double)darkSteelSpeedTwoSprintMultiplier);
        darkSteelSpeedThreeSprintMultiplier = (float)config.get(Config.sectionDarkSteel.name, "darkSteelSpeedThreeSprintMultiplier", (double)darkSteelSpeedThreeSprintMultiplier, "Speed modifier applied when walking in the Dark Steel Boots with Speed I.").getDouble((double)darkSteelSpeedThreeSprintMultiplier);
        darkSteelBootsJumpModifier = config.get(Config.sectionDarkSteel.name, "darkSteelBootsJumpModifier", darkSteelBootsJumpModifier, "Jump height modifier applied when jumping with Dark Steel Boots equipped").getDouble(darkSteelBootsJumpModifier);
        darkSteelPowerStorageBase = config.get(Config.sectionDarkSteel.name, "darkSteelPowerStorage", darkSteelPowerStorageBase, "Amount of power stored (RF) per crystal in the armor items recipe.").getInt(darkSteelPowerStorageBase);
        darkSteelWalkPowerCost = config.get(Config.sectionDarkSteel.name, "darkSteelWalkPowerCost", darkSteelWalkPowerCost, "Amount of power stored (RF) per block walked when wearing the dark steel boots.").getInt(darkSteelWalkPowerCost);
        darkSteelSprintPowerCost = config.get(Config.sectionDarkSteel.name, "darkSteelSprintPowerCost", darkSteelWalkPowerCost, "Amount of power stored (RF) per block walked when wearing the dark steel boots.").getInt(darkSteelSprintPowerCost);
        darkSteelDrainPowerFromInventory = config.get(Config.sectionDarkSteel.name, "darkSteelDrainPowerFromInventory", darkSteelDrainPowerFromInventory, "If true, dark steel armor will drain power stored (RF) in power containers in the players inventory.").getBoolean(darkSteelDrainPowerFromInventory);
        darkSteelBootsJumpPowerCost = config.get(Config.sectionDarkSteel.name, "darkSteelBootsJumpPowerCost", darkSteelBootsJumpPowerCost, "Base amount of power used per jump (RF) dark steel boots. The second jump in a 'double jump' uses 2x this etc").getInt(darkSteelBootsJumpPowerCost);
        darkSteelFallDistanceCost = config.get(Config.sectionDarkSteel.name, "darkSteelFallDistanceCost", darkSteelFallDistanceCost, "Amount of power used (RF) per block height of fall distance damage negated.").getInt(darkSteelFallDistanceCost);
        darkSteelSwimCost = config.get(Config.sectionDarkSteel.name, "darkSteelSwimCost", darkSteelSwimCost, "Number of levels required for the 'Swim' upgrade.").getInt(darkSteelSwimCost);
        darkSteelNightVisionCost = config.get(Config.sectionDarkSteel.name, "darkSteelNightVisionCost", darkSteelNightVisionCost, "Number of levels required for the 'Night Vision' upgrade.").getInt(darkSteelNightVisionCost);
        darkSteelTOPCost = config.get(Config.sectionDarkSteel.name, "darkSteelTOPCost", darkSteelTOPCost, "Number of levels required for the 'The One Probe' upgrade.").getInt(darkSteelTOPCost);
        darkSteelGliderCost = config.get(Config.sectionDarkSteel.name, "darkSteelGliderCost", darkSteelGliderCost, "Number of levels required for the 'Glider' upgrade.").getInt(darkSteelGliderCost);
        darkSteelGliderHorizontalSpeed = config.get(Config.sectionDarkSteel.name, "darkSteelGliderHorizontalSpeed", darkSteelGliderHorizontalSpeed, "Horizontal movement speed modifier when gliding.").getDouble(darkSteelGliderHorizontalSpeed);
        darkSteelGliderVerticalSpeed = config.get(Config.sectionDarkSteel.name, "darkSteelGliderVerticalSpeed", darkSteelGliderVerticalSpeed, "Rate of altitude loss when gliding.").getDouble(darkSteelGliderVerticalSpeed);
        darkSteelGliderVerticalSpeedSprinting = config.get(Config.sectionDarkSteel.name, "darkSteelGliderVerticalSpeedSprinting", darkSteelGliderVerticalSpeedSprinting, "Rate of altitude loss when sprinting and gliding.").getDouble(darkSteelGliderVerticalSpeedSprinting);
        darkSteelElytraCost = config.get(Config.sectionDarkSteel.name, "darkSteelElytraCost", darkSteelElytraCost, "Number of levels required for the 'Elytra' upgrade.").getInt(darkSteelElytraCost);
        darkSteelSoundLocatorCost = config.get(Config.sectionDarkSteel.name, "darkSteelSoundLocatorCost", darkSteelSoundLocatorCost, "Number of levels required for the 'Sound Locator' upgrade.").getInt(darkSteelSoundLocatorCost);
        darkSteelSoundLocatorRange = config.get(Config.sectionDarkSteel.name, "darkSteelSoundLocatorRange", darkSteelSoundLocatorRange, "Range of the 'Sound Locator' upgrade.").getInt(darkSteelSoundLocatorRange);
        darkSteelSoundLocatorLifespan = config.get(Config.sectionDarkSteel.name, "darkSteelSoundLocatorLifespan", darkSteelSoundLocatorLifespan, "Number of ticks the 'Sound Locator' icons are displayed for.").getInt(darkSteelSoundLocatorLifespan);
        darkSteelGogglesOfRevealingCost = config.get(Config.sectionDarkSteel.name, "darkSteelGogglesOfRevealingCost", darkSteelGogglesOfRevealingCost, "Number of levels required for the Goggles of Revealing upgrade.").getInt(darkSteelGogglesOfRevealingCost);
        darkSteelApiaristArmorCost = config.get(Config.sectionDarkSteel.name, "darkSteelApiaristArmorCost", darkSteelApiaristArmorCost, "Number of levels required for the Apiarist Armor upgrade.").getInt(darkSteelApiaristArmorCost);
        darkSteelTravelCost = config.get(Config.sectionDarkSteel.name, "darkSteelTravelCost", darkSteelTravelCost, "Number of levels required for the 'Travel' upgrade.").getInt(darkSteelTravelCost);
        darkSteelSpoonCost = config.get(Config.sectionDarkSteel.name, "darkSteelSpoonCost", darkSteelSpoonCost, "Number of levels required for the 'Spoon' upgrade.").getInt(darkSteelSpoonCost);
        darkSteelSolarOneCost = config.get(Config.sectionDarkSteel.name, "darkSteelSolarOneCost", darkSteelSolarOneCost, "Cost in XP levels of the Solar I upgrade.").getInt();
        darkSteelSolarOneGen = config.get(Config.sectionDarkSteel.name, "darkSteelSolarOneGen", darkSteelSolarOneGen, "RF per SECOND generated by the Solar I upgrade. Split between all equipped DS armors.").getInt();
        darkSteelSolarTwoCost = config.get(Config.sectionDarkSteel.name, "darkSteelSolarTwoCost", darkSteelSolarTwoCost, "Cost in XP levels of the Solar II upgrade.").getInt();
        darkSteelSolarTwoGen = config.get(Config.sectionDarkSteel.name, "darkSteelSolarTwoGen", darkSteelSolarTwoGen, "RF per SECOND generated by the Solar II upgrade. Split between all equipped DS armors.").getInt();
        darkSteelSolarThreeCost = config.get(Config.sectionDarkSteel.name, "darkSteelSolarThreeCost", darkSteelSolarThreeCost, "Cost in XP levels of the Solar III upgrade.").getInt();
        darkSteelSolarThreeGen = config.get(Config.sectionDarkSteel.name, "darkSteelSolarThreeGen", darkSteelSolarThreeGen, "RF per SECOND generated by the Solar III upgrade. Split between all equipped DS armors.").getInt();
        darkSteelSolarChargeOthers = config.get(Config.sectionDarkSteel.name, "darkSteelSolarChargeOthers", darkSteelSolarChargeOthers, "If enabled allows the solar upgrade to charge non-darksteel armors that the player is wearing.").getBoolean();
        darkSteelSwordSkullChance = (float)config.get(Config.sectionDarkSteel.name, "darkSteelSwordSkullChance", (double)darkSteelSwordSkullChance, "The base chance that a skull will be dropped when using a powered dark steel sword (0 = no chance, 1 = 100% chance)").getDouble((double)darkSteelSwordSkullChance);
        darkSteelSwordSkullLootingModifier = (float)config.get(Config.sectionDarkSteel.name, "darkSteelSwordSkullLootingModifier", (double)darkSteelSwordSkullLootingModifier, "The chance per looting level that a skull will be dropped when using a powered dark steel sword (0 = no chance, 1 = 100% chance)").getDouble((double)darkSteelSwordSkullLootingModifier);
        darkSteelSwordPoweredDamageBonus = (float)config.get(Config.sectionDarkSteel.name, "darkSteelSwordPoweredDamageBonus", (double)darkSteelSwordPoweredDamageBonus, "The extra damage dealt when the sword is powered").getDouble((double)darkSteelSwordPoweredDamageBonus);
        darkSteelSwordPoweredSpeedBonus = (float)config.get(Config.sectionDarkSteel.name, "darkSteelSwordPoweredSpeedBonus", (double)darkSteelSwordPoweredSpeedBonus, "The increase in attack speed when powered").getDouble((double)darkSteelSwordPoweredSpeedBonus);
        darkSteelSwordWitherSkullChance = (float)config.get(Config.sectionDarkSteel.name, "darkSteelSwordWitherSkullChance", (double)darkSteelSwordWitherSkullChance, "The base chance that a wither skull will be dropped when using a powered dark steel sword (0 = no chance, 1 = 100% chance)").getDouble((double)darkSteelSwordWitherSkullChance);
        darkSteelSwordWitherSkullLootingModifier = (float)config.get(Config.sectionDarkSteel.name, "darkSteelSwordWitherSkullLootingModifie", (double)darkSteelSwordWitherSkullLootingModifier, "The chance per looting level that a wither skull will be dropped when using a powered dark steel sword (0 = no chance, 1 = 100% chance)").getDouble((double)darkSteelSwordWitherSkullLootingModifier);
        vanillaSwordSkullChance = (float)config.get(Config.sectionDarkSteel.name, "vanillaSwordSkullChance", (double)vanillaSwordSkullChance, "The base chance that a skull will be dropped when using a non dark steel sword (0 = no chance, 1 = 100% chance)").getDouble((double)vanillaSwordSkullChance);
        vanillaSwordSkullLootingModifier = (float)config.get(Config.sectionPersonal.name, "vanillaSwordSkullLootingModifier", (double)vanillaSwordSkullLootingModifier, "The chance per looting level that a skull will be dropped when using a non-dark steel sword (0 = no chance, 1 = 100% chance)").getDouble((double)vanillaSwordSkullLootingModifier);
        ticCleaverSkullDropChance = (float)config.get(Config.sectionDarkSteel.name, "ticCleaverSkullDropChance", (double)ticCleaverSkullDropChance, "The base chance that an Enderman Skull will be dropped when using TiC Cleaver").getDouble((double)ticCleaverSkullDropChance);
        ticBeheadingSkullModifier = (float)config.get(Config.sectionPersonal.name, "ticBeheadingSkullModifier", (double)ticBeheadingSkullModifier, "The chance per level of Beheading that a skull will be dropped when using a TiC weapon").getDouble((double)ticBeheadingSkullModifier);
        fakePlayerSkullChance = (float)config.get(Config.sectionDarkSteel.name, "fakePlayerSkullChance", (double)fakePlayerSkullChance, "The ratio of skull drops when a mob is killed by a 'FakePlayer', such as Killer Joe. When set to 0 no skulls will drop, at 1 the rate of skull drops is not modified").getDouble((double)fakePlayerSkullChance);
        darkSteelSwordPowerUsePerHit = config.get(Config.sectionDarkSteel.name, "darkSteelSwordPowerUsePerHit", darkSteelSwordPowerUsePerHit, "The amount of power (RF) used per hit.").getInt(darkSteelSwordPowerUsePerHit);
        darkSteelSwordEnderPearlDropChance = config.get(Config.sectionDarkSteel.name, "darkSteelSwordEnderPearlDropChance", darkSteelSwordEnderPearlDropChance, "The chance that an ender pearl will be dropped when using a dark steel sword (0 = no chance, 1 = 100% chance)").getDouble(darkSteelSwordEnderPearlDropChance);
        darkSteelSwordEnderPearlDropChancePerLooting = config.get(Config.sectionDarkSteel.name, "darkSteelSwordEnderPearlDropChancePerLooting", darkSteelSwordEnderPearlDropChancePerLooting, "The chance for each looting level that an additional ender pearl will be dropped when using a dark steel sword (0 = no chance, 1 = 100% chance)").getDouble(darkSteelSwordEnderPearlDropChancePerLooting);
        darkSteelBowDamageBonus = (float)config.get(Config.sectionDarkSteel.name, "darkSteelBowDamageBonus", (double)darkSteelBowDamageBonus, "The damage bonus applied to arrows fire from the bow.").getDouble((double)darkSteelBowDamageBonus);
        darkSteelBowForceMultipliers = config.get(Config.sectionDarkSteel.name, "darkSteelBowForceMultipliers", darkSteelBowForceMultipliers, "Multiplier that effects the speed with which arrows leave the bow.").getDoubleList();
        darkSteelBowFovMultipliers = config.get(Config.sectionDarkSteel.name, "darkSteelBowFovMultiplier", darkSteelBowFovMultipliers, "The reduction in FOV when the bow is fullen drawn (the zoom level). A 'vanilla' bow has a value of 0.15").getDoubleList();
        darkSteelBowPowerUsePerDamagePoint = config.get(Config.sectionDarkSteel.name, "darkSteelBowPowerUsePerDamagePoint", darkSteelBowPowerUsePerDamagePoint, "The amount of power (RF) used per hit.").getInt(darkSteelBowPowerUsePerDamagePoint);
        darkSteelBowDrawSpeeds = config.get(Config.sectionDarkSteel.name, "darkSteelBowDrawSpeeds", darkSteelBowDrawSpeeds, "A list of the amount of draw speeds at the different upgrade levels. A vanilla bow draw speed is 20").getIntList();
        darkSteelBowPowerUsePerDraw = config.get(Config.sectionDarkSteel.name, "darkSteelBowPowerUsePerDraw", darkSteelBowPowerUsePerDraw, "The power used to fully draw the bow").getInt(darkSteelBowPowerUsePerDraw);
        darkSteelBowPowerUsePerTickDrawn = config.get(Config.sectionDarkSteel.name, "darkSteelBowPowerUsePerTickDrawn", darkSteelBowPowerUsePerTickDrawn, "The power used per tick to hold the boy fully drawn").getInt(darkSteelBowPowerUsePerTickDrawn);
        darkSteelPickPowerUseObsidian = config.get(Config.sectionDarkSteel.name, "darkSteelPickPowerUseObsidian", darkSteelPickPowerUseObsidian, "The amount of power (RF) used to break an obsidian block.").getInt(darkSteelPickPowerUseObsidian);
        darkSteelPickEffeciencyObsidian = config.get(Config.sectionDarkSteel.name, "darkSteelPickEffeciencyObsidian", darkSteelPickEffeciencyObsidian, "The efficiency when breaking obsidian with a powered Dark Pickaxe.").getInt(darkSteelPickEffeciencyObsidian);
        darkSteelPickApplyObsidianEffeciencyAtHardess = (float)config.get(Config.sectionDarkSteel.name, "darkSteelPickApplyObsidianEffeciencyAtHardess", (double)darkSteelPickApplyObsidianEffeciencyAtHardess, "If set to a value > 0, the obsidian speed and power use will be used for all blocks with hardness >= to this value.").getDouble((double)darkSteelPickApplyObsidianEffeciencyAtHardess);
        darkSteelPickPowerUsePerDamagePoint = config.get(Config.sectionDarkSteel.name, "darkSteelPickPowerUsePerDamagePoint", darkSteelPickPowerUsePerDamagePoint, "Power use (RF) per damage/durability point avoided.").getInt(darkSteelPickPowerUsePerDamagePoint);
        darkSteelPickEffeciencyBoostWhenPowered = (float)config.get(Config.sectionDarkSteel.name, "darkSteelPickEffeciencyBoostWhenPowered", (double)darkSteelPickEffeciencyBoostWhenPowered, "The increase in efficiency when powered.").getDouble((double)darkSteelPickEffeciencyBoostWhenPowered);
        darkSteelPickMinesTiCArdite = config.getBoolean("darkSteelPickMinesTiCArdite", Config.sectionDarkSteel.name, darkSteelPickMinesTiCArdite, "When true the dark steel pick will be able to mine TiC Ardite and Cobalt");
        darkSteelAxePowerUsePerDamagePoint = config.get(Config.sectionDarkSteel.name, "darkSteelAxePowerUsePerDamagePoint", darkSteelAxePowerUsePerDamagePoint, "Power use (RF) per damage/durability point avoided.").getInt(darkSteelAxePowerUsePerDamagePoint);
        darkSteelAxePowerUsePerDamagePointMultiHarvest = config.get(Config.sectionDarkSteel.name, "darkSteelPickAxeUsePerDamagePointMultiHarvest", darkSteelAxePowerUsePerDamagePointMultiHarvest, "Power use (RF) per damage/durability point avoided when shift-harvesting multiple logs").getInt(darkSteelAxePowerUsePerDamagePointMultiHarvest);
        darkSteelAxeSpeedPenaltyMultiHarvest = (float)config.get(Config.sectionDarkSteel.name, "darkSteelAxeSpeedPenaltyMultiHarvest", (double)darkSteelAxeSpeedPenaltyMultiHarvest, "How much slower shift-harvesting logs is.").getDouble((double)darkSteelAxeSpeedPenaltyMultiHarvest);
        darkSteelAxeEffeciencyBoostWhenPowered = (float)config.get(Config.sectionDarkSteel.name, "darkSteelAxeEffeciencyBoostWhenPowered", (double)darkSteelAxeEffeciencyBoostWhenPowered, "The increase in efficiency when powered.").getDouble((double)darkSteelAxeEffeciencyBoostWhenPowered);
        darkSteelShearsDurabilityFactor = config.get(Config.sectionDarkSteel.name, "darkSteelShearsDurabilityFactor", darkSteelShearsDurabilityFactor, "How much more durable as vanilla shears they are.").getInt(darkSteelShearsDurabilityFactor);
        darkSteelShearsPowerUsePerDamagePoint = config.get(Config.sectionDarkSteel.name, "darkSteelShearsPowerUsePerDamagePoint", darkSteelShearsPowerUsePerDamagePoint, "Power use (RF) per damage/durability point avoided.").getInt(darkSteelShearsPowerUsePerDamagePoint);
        darkSteelShearsEffeciencyBoostWhenPowered = (float)config.get(Config.sectionDarkSteel.name, "darkSteelShearsEffeciencyBoostWhenPowered", (double)darkSteelShearsEffeciencyBoostWhenPowered, "The increase in efficiency when powered.").getDouble((double)darkSteelShearsEffeciencyBoostWhenPowered);
        darkSteelShearsBlockAreaBoostWhenPowered = config.get(Config.sectionDarkSteel.name, "darkSteelShearsBlockAreaBoostWhenPowered", darkSteelShearsBlockAreaBoostWhenPowered, "The increase in effected area (radius) when powered and used on blocks.").getInt(darkSteelShearsBlockAreaBoostWhenPowered);
        darkSteelShearsEntityAreaBoostWhenPowered = (float)config.get(Config.sectionDarkSteel.name, "darkSteelShearsEntityAreaBoostWhenPowered", (double)darkSteelShearsEntityAreaBoostWhenPowered, "The increase in effected area (radius) when powered and used on sheep.").getDouble((double)darkSteelShearsEntityAreaBoostWhenPowered);
        darkSteelAnvilDamageChance = (float)config.get(Config.sectionDarkSteel.name, "darkSteelAnvilDamageChance", (double)darkSteelAnvilDamageChance, "Chance that the dark steel anvil will take damage after repairing something.").getDouble();
        darkSteelAnvilMaxLevel = config.get(Config.sectionDarkSteel.name, "darkSteelAnvilMaxLevel", darkSteelAnvilMaxLevel, "Max cost operation the anvil can perform. Vanilla limit is 40.").getInt();
        darkSteelLadderSpeedBoost = (float)config.get(Config.sectionDarkSteel.name, "darkSteelLadderSpeedBoost", (double)darkSteelLadderSpeedBoost, "Speed boost, in blocks per tick, that the DS ladder gives over the vanilla ladder.").getDouble();
        hootchPowerPerCycleRF = config.get(Config.sectionPower.name, "hootchPowerPerCycleRF", hootchPowerPerCycleRF, "The amount of power generated per BC engine cycle. Examples: BC Oil = 30, BC Fuel = 60").getInt(hootchPowerPerCycleRF);
        hootchPowerTotalBurnTime = config.get(Config.sectionPower.name, "hootchPowerTotalBurnTime", hootchPowerTotalBurnTime, "The total burn time. Examples: BC Oil = 5000, BC Fuel = 25000").getInt(hootchPowerTotalBurnTime);
        rocketFuelPowerPerCycleRF = config.get(Config.sectionPower.name, "rocketFuelPowerPerCycleRF", rocketFuelPowerPerCycleRF, "The amount of power generated per BC engine cycle. Examples: BC Oil = 3, BC Fuel = 6").getInt(rocketFuelPowerPerCycleRF);
        rocketFuelPowerTotalBurnTime = config.get(Config.sectionPower.name, "rocketFuelPowerTotalBurnTime", rocketFuelPowerTotalBurnTime, "The total burn time. Examples: BC Oil = 5000, BC Fuel = 25000").getInt(rocketFuelPowerTotalBurnTime);
        fireWaterPowerPerCycleRF = config.get(Config.sectionPower.name, "fireWaterPowerPerCycleRF", fireWaterPowerPerCycleRF, "The amount of power generated per BC engine cycle. Examples: BC Oil = 30, BC Fuel = 60").getInt(fireWaterPowerPerCycleRF);
        fireWaterPowerTotalBurnTime = config.get(Config.sectionPower.name, "fireWaterPowerTotalBurnTime", fireWaterPowerTotalBurnTime, "The total burn time. Examples: BC Oil = 5000, BC Fuel = 25000").getInt(fireWaterPowerTotalBurnTime);
        zombieGeneratorRfPerTick = config.get(Config.sectionPower.name, "zombieGeneratorRfPerTick", zombieGeneratorRfPerTick, "The amount of power generated per tick.").getInt(zombieGeneratorRfPerTick);
        zombieGeneratorTicksPerBucketFuel = config.get(Config.sectionPower.name, "zombieGeneratorTicksPerMbFuel", zombieGeneratorTicksPerBucketFuel, "The number of ticks one bucket of fuel lasts.").getInt(zombieGeneratorTicksPerBucketFuel);
        addFuelTooltipsToAllFluidContainers = config.get(Config.sectionPersonal.name, "addFuelTooltipsToAllFluidContainers", addFuelTooltipsToAllFluidContainers, "If true, the RF/t and burn time of the fuel will be displayed in all tooltips for fluid containers with fuel.").getBoolean(addFuelTooltipsToAllFluidContainers);
        addDurabilityTootip = config.get(Config.sectionPersonal.name, "addDurabilityTootip", addFuelTooltipsToAllFluidContainers, "If true, adds durability tooltips to tools and armor").getBoolean(addDurabilityTootip);
        addFurnaceFuelTootip = config.get(Config.sectionPersonal.name, "addFurnaceFuelTootip", addFuelTooltipsToAllFluidContainers, "If true, adds burn duration tooltips to furnace fuels").getBoolean(addFurnaceFuelTootip);
        farmActionEnergyUseRF = config.get(Config.sectionFarm.name, "farmActionEnergyUseRF", farmActionEnergyUseRF, "The amount of power used by a farm per action (eg plant, till, harvest) ").getInt(farmActionEnergyUseRF);
        farmAxeActionEnergyUseRF = config.get(Config.sectionFarm.name, "farmAxeActionEnergyUseRF", farmAxeActionEnergyUseRF, "The amount of power used by a farm per wood block 'chopped'").getInt(farmAxeActionEnergyUseRF);
        farmBonemealActionEnergyUseRF = config.get(Config.sectionFarm.name, "farmBonemealActionEnergyUseRF", farmBonemealActionEnergyUseRF, "The amount of power used by a farm per bone meal used").getInt(farmBonemealActionEnergyUseRF);
        farmBonemealTryEnergyUseRF = config.get(Config.sectionFarm.name, "farmBonemealTryEnergyUseRF", farmBonemealTryEnergyUseRF, "The amount of power used by a farm per bone meal try").getInt(farmBonemealTryEnergyUseRF);
        farmAxeDamageOnLeafBreak = config.get(Config.sectionFarm.name, "farmAxeDamageOnLeafBreak", farmAxeDamageOnLeafBreak, "Should axes in a farm take damage when breaking leaves?").getBoolean(farmAxeDamageOnLeafBreak);
        farmToolTakeDamageChance = (float)config.get(Config.sectionFarm.name, "farmToolTakeDamageChance", (double)farmToolTakeDamageChance, "The chance that a tool in the farm will take damage.").getDouble((double)farmToolTakeDamageChance);
        disableFarmNotification = config.get(Config.sectionFarm.name, "disableFarmNotifications", disableFarmNotification, "Disable the notification text above the farm block.").getBoolean();
        farmEssenceBerriesEnabled = config.get(Config.sectionFarm.name, "farmEssenceBerriesEnabled", farmEssenceBerriesEnabled, "This setting controls whether essence berry bushes from TiC can be harvested by the farm.").getBoolean();
        farmManaBeansEnabled = config.get(Config.sectionFarm.name, "farmManaBeansEnabled", farmManaBeansEnabled, "This setting controls whether mana beans from Thaumcraft can be harvested by the farm.").getBoolean();
        farmHarvestJungleWhenCocoa = config.get(Config.sectionFarm.name, "farmHarvestJungleWhenCocoa", farmHarvestJungleWhenCocoa, "If this is enabled the farm will harvest jungle wood even if it has cocoa beans in its inventory.").getBoolean();
        ConfigCategory hoes = config.getCategory(Config.sectionHoes.name);
        hoes.setComment("Each value of this category is an item that could be a hoe. You can add more values.");
        for (String hoe : hoeStrings) {
            config.get(Config.sectionHoes.name, hoe, true, "Is this item a hoe that can be used in the farming station?");
        }
        Property hoeProp = config.get(Config.sectionFarm.name, "farmHoes", new String[0], "Use this to add items that can be hoes in the farming station. They will be moved to the proper config section. Use the registry name (eg. modid:name).");
        for (String hoe : hoeProp.getStringList()) {
            if (config.hasKey(Config.sectionHoes.name, hoe)) continue;
            config.get(Config.sectionHoes.name, hoe, true, "Is this item a hoe that can be used in the farming station? (user added value)");
        }
        hoeProp.set(new String[0]);
        farmHoes = new Things(new String[0]);
        for (Map.Entry entry : hoes.entrySet()) {
            if (!((Property)entry.getValue()).getBoolean()) continue;
            farmHoes.add((String)entry.getKey());
        }
        farmSaplingReserveAmount = config.get(Config.sectionFarm.name, "farmSaplingReserveAmount", farmSaplingReserveAmount, "The amount of saplings the farm has to have in reserve to switch to shearing all leaves. If there are less saplings in store, it will only shear part the leaves and break the others for spalings. Set this to 0 to always shear all leaves.").getInt(farmSaplingReserveAmount);
        farmStopOnNoOutputSlots = config.get(Config.sectionFarm.name, "farmStopOnNoOutputSlots", farmStopOnNoOutputSlots, "If this is enabled the farm will stop if there is not at least one empty output slot. Otherwise it will only stop if all output slots are full.").getBoolean();
        farmEvictEmptyRFTools = config.get(Config.sectionFarm.name, "farmEvictEmptyRFTools", farmEvictEmptyRFTools, "If this is enabled the farm will move tools that can store RF and are empty to the output slots instead of using them.").getBoolean();
        magnetPowerUsePerSecondRF = config.get(Config.sectionMagnet.name, "magnetPowerUsePerTickRF", magnetPowerUsePerSecondRF, "The amount of RF power used per tick when the magnet is active").getInt(magnetPowerUsePerSecondRF);
        magnetPowerCapacityRF = config.get(Config.sectionMagnet.name, "magnetPowerCapacityRF", magnetPowerCapacityRF, "Amount of RF power stored in a fully charged magnet").getInt(magnetPowerCapacityRF);
        magnetRange = config.get(Config.sectionMagnet.name, "magnetRange", magnetRange, "Range of the magnet in blocks.").getInt(magnetRange);
        magnetMaxItems = config.get(Config.sectionMagnet.name, "magnetMaxItems", magnetMaxItems, "Maximum number of items the magnet can effect at a time. (-1 for unlimited)").getInt(magnetMaxItems);
        magnetBlacklist = config.getStringList("magnetBlacklist", Config.sectionMagnet.name, magnetBlacklist, "These items will not be picked up by the magnet.");
        magnetAllowInMainInventory = config.get(Config.sectionMagnet.name, "magnetAllowInMainInventory", magnetAllowInMainInventory, "If true the magnet will also work in the main inventory, not just the hotbar").getBoolean(magnetAllowInMainInventory);
        magnetAllowInBaublesSlot = config.get(Config.sectionMagnet.name, "magnetAllowInBaublesSlot", magnetAllowInBaublesSlot, "If true the magnet can be put into the 'amulet' Baubles slot (requires Baubles to be installed)").getBoolean(magnetAllowInBaublesSlot);
        magnetAllowDeactivatedInBaublesSlot = config.get(Config.sectionMagnet.name, "magnetAllowDeactivatedInBaublesSlot", magnetAllowDeactivatedInBaublesSlot, "If true the magnet can be put into the 'amulet' Baubles slot even if switched off (requires Baubles to be installed and magnetAllowInBaublesSlot to be on)").getBoolean(magnetAllowDeactivatedInBaublesSlot);
        magnetBaublesType = config.get(Config.sectionMagnet.name, "magnetBaublesType", magnetBaublesType, "The BaublesType the magnet should be, 'AMULET', 'RING' or 'BELT' (requires Baubles to be installed and magnetAllowInBaublesSlot to be on)").getString();
        crafterRfPerCraft = config.get("AutoCrafter Settings", "crafterRfPerCraft", crafterRfPerCraft, "RF used per autocrafted recipe").getInt(crafterRfPerCraft);
        poweredSpawnerMinDelayTicks = config.get(Config.sectionSpawner.name, "poweredSpawnerMinDelayTicks", poweredSpawnerMinDelayTicks, "Min tick delay between spawns for a non-upgraded spawner").getInt(poweredSpawnerMinDelayTicks);
        poweredSpawnerMaxDelayTicks = config.get(Config.sectionSpawner.name, "poweredSpawnerMaxDelayTicks", poweredSpawnerMaxDelayTicks, "Min tick delay between spawns for a non-upgraded spawner").getInt(poweredSpawnerMaxDelayTicks);
        poweredSpawnerMaxPlayerDistance = config.get(Config.sectionSpawner.name, "poweredSpawnerMaxPlayerDistance", poweredSpawnerMaxPlayerDistance, "Max distance of the closest player for the spawner to be active. A zero value will remove the player check").getInt(poweredSpawnerMaxPlayerDistance);
        poweredSpawnerDespawnTimeSeconds = config.get(Config.sectionSpawner.name, "poweredSpawnerDespawnTimeSeconds", poweredSpawnerDespawnTimeSeconds, "Number of seconds in which spawned entities are protected from despawning").getInt(poweredSpawnerDespawnTimeSeconds);
        poweredSpawnerSpawnCount = config.get(Config.sectionSpawner.name, "poweredSpawnerSpawnCount", poweredSpawnerSpawnCount, "Number of entities to spawn each time").getInt(poweredSpawnerSpawnCount);
        poweredSpawnerSpawnRange = config.get(Config.sectionSpawner.name, "poweredSpawnerSpawnRange", poweredSpawnerSpawnRange, "Spawning range in X/Z").getInt(poweredSpawnerSpawnRange);
        poweredSpawnerMaxNearbyEntities = config.get(Config.sectionSpawner.name, "poweredSpawnerMaxNearbyEntities", poweredSpawnerMaxNearbyEntities, "Max number of entities in the nearby area until no more are spawned. A zero value will remove this check").getInt(poweredSpawnerMaxNearbyEntities);
        poweredSpawnerMaxSpawnTries = config.get(Config.sectionSpawner.name, "poweredSpawnerMaxSpawnTries", poweredSpawnerMaxSpawnTries, "Number of tries to find a suitable spawning location").getInt(poweredSpawnerMaxSpawnTries);
        poweredSpawnerUseVanillaSpawChecks = config.get(Config.sectionSpawner.name, "poweredSpawnerUseVanillaSpawChecks", poweredSpawnerUseVanillaSpawChecks, "If true, regular spawn checks such as lighting level and dimension will be made before spawning mobs").getBoolean(poweredSpawnerUseVanillaSpawChecks);
        brokenSpawnerDropChance = (float)config.get(Config.sectionSpawner.name, "brokenSpawnerDropChance", brokenSpawnerDropChance, "The chance a broken spawner will be dropped when a spawner is broken. 1 = 100% chance, 0 = 0% chance").getDouble(brokenSpawnerDropChance);
        brokenSpawnerToolBlacklist = config.getStringList("brokenSpawnerToolBlacklist", Config.sectionSpawner.name, brokenSpawnerToolBlacklist, "When a spawner is broken with these tools they will not drop a broken spawner");
        powerSpawnerAddSpawnerCost = config.get(Config.sectionSpawner.name, "powerSpawnerAddSpawnerCost", powerSpawnerAddSpawnerCost, "The number of levels it costs to add a broken spawner").getInt(powerSpawnerAddSpawnerCost);
        nutrientFoodBoostDelay = config.get(Config.sectionFluid.name, "nutrientFluidFoodBoostDelay", (double)nutrientFoodBoostDelay, "The delay in ticks between when nutrient distillation boosts your food value.").getInt((int)nutrientFoodBoostDelay);
        rocketFuelIsExplosive = config.get(Config.sectionFluid.name, "rocketFuelIsExplosive", rocketFuelIsExplosive, "If enabled, Rocket Fuel will explode when in contact with fire.").getBoolean();
        killerJoeNutrientUsePerAttackMb = config.get(Config.sectionKiller.name, "killerJoeNutrientUsePerAttackMb", killerJoeNutrientUsePerAttackMb, "The number of millibuckets of nutrient fluid used per attack.").getInt(killerJoeNutrientUsePerAttackMb);
        killerJoeAttackHeight = config.get(Config.sectionKiller.name, "killerJoeAttackHeight", killerJoeAttackHeight, "The reach of attacks above and bellow Joe.").getDouble(killerJoeAttackHeight);
        killerJoeAttackWidth = config.get(Config.sectionKiller.name, "killerJoeAttackWidth", killerJoeAttackWidth, "The reach of attacks to each side of Joe.").getDouble(killerJoeAttackWidth);
        killerJoeAttackLength = config.get(Config.sectionKiller.name, "killerJoeAttackLength", killerJoeAttackLength, "The reach of attacks in front of Joe.").getDouble(killerJoeAttackLength);
        killerJoeHooverXpLength = config.get(Config.sectionKiller.name, "killerJoeHooverXpLength", killerJoeHooverXpLength, "The distance from which XP will be gathered to each side of Joe.").getDouble(killerJoeHooverXpLength);
        killerJoeHooverXpWidth = config.get(Config.sectionKiller.name, "killerJoeHooverXpWidth", killerJoeHooverXpWidth, "The distance from which XP will be gathered in front of Joe.").getDouble(killerJoeHooverXpWidth);
        killerJoeMustSee = config.get(Config.sectionKiller.name, "killerJoeMustSee", killerJoeMustSee, "Set whether the Killer Joe can attack through blocks.").getBoolean();
        killerPvPoffDisablesSwing = config.get(Config.sectionKiller.name, "killerPvPoffDisablesSwing", killerPvPoffDisablesSwing, "Set whether the Killer Joe swings even if PvP is off (that swing will do nothing unless killerPvPoffIsIgnored is enabled).").getBoolean();
        killerPvPoffIsIgnored = config.get(Config.sectionKiller.name, "killerPvPoffIsIgnored", killerPvPoffIsIgnored, "Set whether the Killer Joe ignores PvP settings and always hits players (killerPvPoffDisablesSwing must be off for this to work).").getBoolean();
        killerMendingEnabled = config.get(Config.sectionKiller.name, "killerMending", killerMendingEnabled, "If enabled, picked up XP will be used for the enchantement 'Mending' on the weapon.").getBoolean();
        killerProvokesCreeperExpolosions = config.get(Config.sectionKiller.name, "killerProvokesCreeperExpolosions", killerProvokesCreeperExpolosions, "If enabled, Creepers will explode for the Killer Joe just like for any player.").getBoolean();
        xpVacuumRange = config.get(Config.sectionAdvanced.name, "xpVacuumRange", xpVacuumRange, "The distance from which XP will be gathered by the XP vacuum.").getDouble(xpVacuumRange);
        enableMEConduits = config.getBoolean("enableMEConduits", Config.sectionItems.name, enableMEConduits, "Allows ME conduits. Only has an effect with AE2 installed.");
        enableOCConduits = config.getBoolean("enableOCConduits", Config.sectionItems.name, enableOCConduits, "Allows OC conduits. Only has an effect with OpenComputers installed.");
        enableOCConduitsAnimatedTexture = config.getBoolean("enableOCConduitsAnimatedTexture", Config.sectionItems.name, enableOCConduitsAnimatedTexture, "Use the animated texture for OC conduits.");
        soulVesselBlackList = Arrays.asList(config.getStringList("soulVesselBlackList", Config.sectionSoulBinder.name, soulVesselBlackList.toArray(new String[0]), "Entities listed here will can not be captured in a Soul Vial"));
        soulVesselUnspawnableList = Arrays.asList(config.getStringList("soulVesselUnspawnableList", Config.sectionSpawner.name, soulVesselUnspawnableList.toArray(new String[0]), "Entities listed here cannot be spawned and must be cloned from a captured entity instead (Attention: Possibility of item duping!)"));
        soulVesselCapturesBosses = config.getBoolean("soulVesselCapturesBosses", Config.sectionSoulBinder.name, soulVesselCapturesBosses, "When set to false, any mob with a 'boss bar' won't be able to be captured in the Soul Vial. Note: The Ender Dragon can not be captured, even with this enabled. This is a limitation of the dragon, not the Soul Vial.");
        soulBinderBrokenSpawnerRF = config.get(Config.sectionSoulBinder.name, "soulBinderBrokenSpawnerRF", soulBinderBrokenSpawnerRF, "The number of RF required to change the type of a broken spawner.").getInt(soulBinderBrokenSpawnerRF);
        soulBinderReanimationRF = config.get(Config.sectionSoulBinder.name, "soulBinderReanimationRF", soulBinderReanimationRF, "The number of RF required to to re-animated a mob head.").getInt(soulBinderReanimationRF);
        soulBinderEnderCystalRF = config.get(Config.sectionSoulBinder.name, "soulBinderEnderCystalRF", soulBinderEnderCystalRF, "The number of RF required to create an ender crystal.").getInt(soulBinderEnderCystalRF);
        soulBinderAttractorCystalRF = config.get(Config.sectionSoulBinder.name, "soulBinderAttractorCystalRF", soulBinderAttractorCystalRF, "The number of RF required to create an attractor crystal.").getInt(soulBinderAttractorCystalRF);
        soulBinderTunedPressurePlateRF = config.get(Config.sectionSoulBinder.name, "soulBinderTunedPressurePlateRF", soulBinderTunedPressurePlateRF, "The number of RF required to tune a pressure plate.").getInt(soulBinderTunedPressurePlateRF);
        soulBinderPrecientCystalRF = config.get(Config.sectionSoulBinder.name, "soulBinderPrecientCystalRF", soulBinderPrecientCystalRF, "The number of RF required to create a precient crystal.").getInt(soulBinderPrecientCystalRF);
        soulBinderAttractorCystalLevels = config.get(Config.sectionSoulBinder.name, "soulBinderAttractorCystalLevels", soulBinderAttractorCystalLevels, "The number of levels required to create an attractor crystal.").getInt(soulBinderAttractorCystalLevels);
        soulBinderEnderCystalLevels = config.get(Config.sectionSoulBinder.name, "soulBinderEnderCystalLevels", soulBinderEnderCystalLevels, "The number of levels required to create an ender crystal.").getInt(soulBinderEnderCystalLevels);
        soulBinderPrecientCystalLevels = config.get(Config.sectionSoulBinder.name, "soulBinderPrecientCystalLevels", soulBinderPrecientCystalLevels, "The number of levels required to create a precient crystal.").getInt(soulBinderPrecientCystalLevels);
        soulBinderReanimationLevels = config.get(Config.sectionSoulBinder.name, "soulBinderReanimationLevels", soulBinderReanimationLevels, "The number of levels required to re-animate a mob head.").getInt(soulBinderReanimationLevels);
        soulBinderBrokenSpawnerLevels = config.get(Config.sectionSoulBinder.name, "soulBinderBrokenSpawnerLevels", soulBinderBrokenSpawnerLevels, "The number of levels required to change the type of a broken spawner.").getInt(soulBinderBrokenSpawnerLevels);
        soulBinderTunedPressurePlateLevels = config.get(Config.sectionSoulBinder.name, "soulBinderTunedPressurePlateLevels", soulBinderTunedPressurePlateLevels, "The number of levels required to tune a pressure plate.").getInt(soulBinderTunedPressurePlateLevels);
        soulBinderMaxXpLevel = config.get(Config.sectionSoulBinder.name, "soulBinderMaxXPLevel", soulBinderMaxXpLevel, "Maximum level of XP the soul binder can contain.").getInt();
        spawnGuardStopAllSlimesDebug = config.getBoolean("spawnGuardStopAllSlimesDebug", Config.sectionAttractor.name, spawnGuardStopAllSlimesDebug, "When true slimes wont be allowed to spawn at all. Only added to aid testing in super flat worlds.");
        spawnGuardStopAllSquidSpawning = config.getBoolean("spawnGuardStopAllSquidSpawning", Config.sectionAttractor.name, spawnGuardStopAllSquidSpawning, "When true no squid will be spawned.");
        weatherObeliskClearFluid = config.get(Config.sectionWeather.name, "weatherObeliskClearFluid", weatherObeliskClearFluid, "The fluid required (in mB) to set the world to clear weather").getInt();
        weatherObeliskRainFluid = config.get(Config.sectionWeather.name, "weatherObeliskRainFluid", weatherObeliskRainFluid, "The fluid required (in mB) to set the world to rainy weather").getInt();
        weatherObeliskThunderFluid = config.get(Config.sectionWeather.name, "weatherObeliskThunderFluid", weatherObeliskThunderFluid, "The fluid required (in mB) to set the world to thundering weather").getInt();
        lootDarkSteel = config.getBoolean("lootDarkSteel", Config.sectionLootConfig.name, lootDarkSteel, "Adds Darksteel Ingots to loot tables");
        lootItemConduitProbe = config.getBoolean("lootItemConduitProbe", Config.sectionLootConfig.name, lootItemConduitProbe, "Adds ItemConduitProbe to loot tables");
        lootQuartz = config.getBoolean("lootQuartz", Config.sectionLootConfig.name, lootQuartz, "Adds quartz to loot tables");
        lootNetherWart = config.getBoolean("lootNetherWart", Config.sectionLootConfig.name, lootNetherWart, "Adds nether wart to loot tables");
        lootEnderPearl = config.getBoolean("lootEnderPearl", Config.sectionLootConfig.name, lootEnderPearl, "Adds ender pearls to loot tables");
        lootElectricSteel = config.getBoolean("lootElectricSteel", Config.sectionLootConfig.name, lootElectricSteel, "Adds Electric Steel Ingots to loot tables");
        lootRedstoneAlloy = config.getBoolean("lootRedstoneAlloy", Config.sectionLootConfig.name, lootRedstoneAlloy, "Adds Redstone Alloy Ingots to loot tables");
        lootPhasedIron = config.getBoolean("lootPhasedIron", Config.sectionLootConfig.name, lootPhasedIron, "Adds Phased Iron Ingots to loot tables");
        lootPhasedGold = config.getBoolean("lootPhasedGold", Config.sectionLootConfig.name, lootPhasedGold, "Adds Phased Gold Ingots to loot tables");
        lootTravelStaff = config.getBoolean("lootTravelStaff", Config.sectionLootConfig.name, lootTravelStaff, "Adds Travel Staff to loot tables");
        lootTheEnder = config.getBoolean("lootTheEnder", Config.sectionLootConfig.name, lootTheEnder, "Adds The Ender to loot tables");
        lootDarkSteelBoots = config.getBoolean("lootDarkSteelBoots", Config.sectionLootConfig.name, lootDarkSteelBoots, "Adds Darksteel Boots to loot tables");
        dumpMobNames = config.getBoolean("dumpMobNames", Config.sectionMobConfig.name, dumpMobNames, "When set to true a list of all registered mobs will be dumped to config/enderio/mobTypes.txt The names are in the format required by EIOs mob blacklists.");
        xpObeliskMaxXpLevel = config.get(Config.sectionMisc.name, "xpObeliskMaxXpLevel", xpObeliskMaxXpLevel, "Maximum level of XP the xp obelisk can contain.").getInt();
        xpJuiceName = config.getString("xpJuiceName", Config.sectionMisc.name, xpJuiceName, "Id of liquid XP fluid (WARNING: only for users who know what they are doing - changing this id can break worlds) - this should match with OpenBlocks when installed");
        glassConnectToTheirVariants = config.getBoolean("glassConnectToTheirVariants", Config.sectionMisc.name, glassConnectToTheirVariants, "If true, quite clear glass and fused quartz will connect textures with their respective enlightened and darkened variants.");
        clearGlassConnectToFusedQuartz = config.getBoolean("clearGlassConnectToFusedQuartz", Config.sectionMisc.name, clearGlassConnectToFusedQuartz, "If true, quite clear glass will connect textures with fused quartz.");
        glassConnectToTheirColorVariants = config.getBoolean("glassConnectToTheirColorVariants", Config.sectionMisc.name, glassConnectToTheirColorVariants, "If true, quite clear glass and fused quartz of different colors will connect textures.");
        paintedGlowstoneRequireSilkTouch = config.getBoolean("paintedGlowstoneRequireSilkTouch", Config.sectionMisc.name, paintedGlowstoneRequireSilkTouch, "If true, painted glowstone will drop dust unless broken with silk touch");
        enableBaublesIntegration = config.getBoolean("enableBaublesIntegration", Config.sectionMisc.name, enableBaublesIntegration, "If false baubles intergation will be disabled even if Baubles is installed");
        enchantmentSoulBoundEnabled = config.getBoolean("enchantmentSoulBoundEnabled", Config.sectionEnchantments.name, enchantmentSoulBoundEnabled, "If false the soul bound enchantment will not be available");
        String rareStr = config.get(Config.sectionEnchantments.name, "enchantmentSoulBoundWeight", enchantmentSoulBoundRarity.toString(), "The rarity of the enchantment. COMMON, UNCOMMON, RARE, VERY_RARE ").getString();
        try {
            enchantmentSoulBoundRarity = Enchantment.Rarity.valueOf((String)rareStr);
        }
        catch (Exception e) {
            Log.warn("Could not set value config entry enchantmentWitherArrowRarity Specified value " + rareStr);
            e.printStackTrace();
        }
        telepadLockDimension = config.get(Config.sectionTelepad.name, "lockDimension", telepadLockDimension, "If true, the dimension cannot be set via the GUI, the coord selector must be used.").getBoolean();
        telepadLockCoords = config.get(Config.sectionTelepad.name, "lockCoords", telepadLockCoords, "If true, the coordinates cannot be set via the GUI, the coord selector must be used.").getBoolean();
        telepadPowerCoefficient = config.get(Config.sectionTelepad.name, "powerCoefficient", telepadPowerCoefficient, "Power for a teleport is calculated by the formula:\npower = [this value] * ln(0.005*distance + 1)").getInt();
        telepadPowerInterdimensional = config.get(Config.sectionTelepad.name, "powerInterdimensional", telepadPowerInterdimensional, "The amount of RF required for an interdimensional teleport.").getInt();
        telepadEnergyBufferRF = config.get(Config.sectionTelepad.name, "telepadEnergyBufferRF", telepadEnergyBufferRF, "The amount of RF in the internal buffer.").getInt();
        telepadEnergyUsePerTickRF = config.get(Config.sectionTelepad.name, "telepadEnergyUsePerTickRF", telepadEnergyUsePerTickRF, "The max amount of RF that can be used per tick. Higher values allow faster teleporting.").getInt();
        telepadFluidType = config.getString("telepadFluidType", Config.sectionTelepad.name, telepadFluidType, "The type of fluid required to teleport entities");
        telepadFluidUse = config.get(Config.sectionTelepad.name, "telepadFluidUse", telepadFluidUse, "The max amount of fluid in mb used per teleport. If set to <= 0 fluid use will be disabled").getInt();
        telepadIsTravelAnchor = config.get(Config.sectionTelepad.name, "telepadIsTravelAnchor", telepadIsTravelAnchor, "If true, TelePads will also act as normal Travel Anchors.").getBoolean();
        telepadShrinkEffect = config.get(Config.sectionPersonal.name, "telepadShrinkEffect", telepadShrinkEffect, "Can be used to disable the 'shrinking' effect of the telepad in case of conflicts with other mods.").getBoolean();
        inventoryPanelFree = config.getBoolean("inventoryPanelFree", Config.sectionInventoryPanel.name, inventoryPanelFree, "If true, the inv panel will not accept fluids and will be active permanently.");
        inventoryPanelPowerPerMB = config.getFloat("powerPerMB", Config.sectionInventoryPanel.name, inventoryPanelPowerPerMB, 1.0f, 10000.0f, "Internal power generated per mB. The default of 800/mB matches the RF generation of the Zombie generator. A panel tries to refill only once every second - setting this value too low slows down the scanning speed.");
        inventoryPanelScanCostPerSlot = config.getFloat("scanCostPerSlot", Config.sectionInventoryPanel.name, inventoryPanelScanCostPerSlot, 0.0f, 10.0f, "Internal power used for scanning a slot");
        inventoryPanelExtractCostPerItem = config.getFloat("extractCostPerItem", Config.sectionInventoryPanel.name, inventoryPanelExtractCostPerItem, 0.0f, 10.0f, "Internal power used per item extracted (not a stack of items)");
        inventoryPanelExtractCostPerOperation = config.getFloat("extractCostPerOperation", Config.sectionInventoryPanel.name, inventoryPanelExtractCostPerOperation, 0.0f, 10000.0f, "Internal power used per extract operation (independent of stack size)");
        inventoryPanelScaleText = config.getBoolean("inventoryPanelScaleText", Config.sectionInventoryPanel.name, inventoryPanelScaleText, "If true stack sizes will be drawn at a smaller size with a little more detail.");
        remoteInventoryMBPerOpen = config.get(Config.sectionInventoryPanel.name, "remoteInventoryMBPerOpen", remoteInventoryMBPerOpen, "MB required to open the panel").getIntList();
        remoteInventoryRFPerTick = config.get(Config.sectionInventoryPanel.name, "remoteInventoryRFPerTick", remoteInventoryRFPerTick, "RF used per tick when the panel is open").getIntList();
        remoteInventoryMBCapacity = config.get(Config.sectionInventoryPanel.name, "remoteInventoryMBCapacity", remoteInventoryMBCapacity, "Capacity of the intrenal tank in MB").getIntList();
        remoteInventoryRFCapacity = config.get(Config.sectionInventoryPanel.name, "remoteInventoryRFCapacity", remoteInventoryRFCapacity, "Capacity of the intrenal energy storage in RF").getIntList();
        remoteInventoryFluidTypes = config.getStringList("remoteInventoryFluidTypes", Config.sectionInventoryPanel.name, remoteInventoryFluidTypes, "The type of fluid reqquired");
        coldFireIgniterFluidType = config.getString("coldFireIgniterFluidType", Config.sectionDarkSteel.name, coldFireIgniterFluidType, "The type of fluid required to ignite cold fire");
        coldFireIgniterMbPerUse = config.get(Config.sectionDarkSteel.name, "coldFireIgniterMbPerUse", coldFireIgniterMbPerUse, "The amount of fluid in mb used per usage. If set to <= 0 fluid use will be disabled").getInt();
        debugUpdatePackets = config.getBoolean("debugUpdatePackets", Config.sectionPersonal.name, debugUpdatePackets, "DEBUG: If true, TEs will flash when they recieve an update packet.");
        topEnabled = config.getBoolean("topEnabled", Config.sectionTOP.name, topEnabled, "If true, 'The One Probe' by McJty will be supported");
        topShowProgressByDefault = config.getBoolean("topShowProgressByDefault", Config.sectionTOP.name, topShowProgressByDefault, "If true, the progress will be shown always, otherwise only it will only be shown on 'extended' mode (e.g. with shift pressed)");
        topShowPowerByDefault = config.getBoolean("topShowPowerByDefault", Config.sectionTOP.name, topShowPowerByDefault, "If true, the power level will be shown always, otherwise only it will only be shown on 'extended' mode (e.g. with shift pressed)");
        topShowRedstoneByDefault = config.getBoolean("topShowRedstoneByDefault", Config.sectionTOP.name, topShowRedstoneByDefault, "If true, the resdstone status will be shown always, otherwise only it will only be shown on 'extended' mode (e.g. with shift pressed)");
        topShowSideConfigByDefault = config.getBoolean("topShowSideConfigByDefault", Config.sectionTOP.name, topShowSideConfigByDefault, "If true, the side config will be shown always, otherwise only it will only be shown on 'extended' mode (e.g. with shift pressed)");
        topShowRangeByDefault = config.getBoolean("topShowRangeByDefault", Config.sectionTOP.name, topShowRangeByDefault, "If true, the range will be shown always, otherwise only it will only be shown on 'extended' mode (e.g. with shift pressed)");
        topShowMobsByDefault = config.getBoolean("topShowMobsByDefault", Config.sectionTOP.name, topShowMobsByDefault, "If true, the mob list will be shown always, otherwise only it will only be shown on 'extended' mode (e.g. with shift pressed)");
        topShowTanksByDefault = config.getBoolean("topShowTanksByDefault", Config.sectionTOP.name, topShowTanksByDefault, "If true, the tank content will be shown always, otherwise only it will only be shown on 'extended' mode (e.g. with shift pressed)");
        topShowXPByDefault = config.getBoolean("topShowXPByDefault", Config.sectionTOP.name, topShowXPByDefault, "If true, the XP level will be shown always, otherwise only it will only be shown on 'extended' mode (e.g. with shift pressed)");
        topShowItemCountDefault = config.getBoolean("topShowItemCountDefault", Config.sectionTOP.name, topShowItemCountDefault, "If true, the item count will be shown always, otherwise only it will only be shown on 'extended' mode (e.g. with shift pressed)");
        allowFovControlsInSurvivalMode = config.getBoolean("allowFovControlsInSurvivalMode", Config.sectionMisc.name, allowFovControlsInSurvivalMode, "If true, the FOV keyboard controls can be used in survival and advanture mode. Otherwise they are limited to create and spectator modes.");
        leversEnabled = config.getString("leversEnabled", Config.sectionRecipe.name, leversEnabled, "A comma-seperated list of durations in seconds. For these, self-reseting levers will be created. Set to 0 to disable the lever. Please note that you also need to supply a resource pack with matching blockstates and a language file for this to work.");
        CapacitorKey.processConfig(config);
    }

    public static void checkYetaAccess() {
        if (!useSneakMouseWheelYetaWrench && !useSneakRightClickYetaWrench) {
            Log.warn("Both useSneakMouseWheelYetaWrench and useSneakRightClickYetaWrench are set to false. Enabling right click.");
            useSneakRightClickYetaWrench = true;
        }
    }

    public static void init(FMLInitializationEvent event) {
    }

    public static void postInit() {
        if (darkSteelPowerDamgeAbsorptionRatios == null || darkSteelPowerDamgeAbsorptionRatios.length != 4) {
            throw new IllegalArgumentException("Ender IO config value darkSteelPowerDamgeAbsorptionRatios must have exactly 4 values");
        }
        if (darkSteelBowForceMultipliers == null || darkSteelBowForceMultipliers.length != 5) {
            throw new IllegalArgumentException("Ender IO config value darkSteelBowForceMultipliers must have exactly 5 values");
        }
        if (darkSteelBowDrawSpeeds == null || darkSteelBowDrawSpeeds.length != 5) {
            throw new IllegalArgumentException("Ender IO config value darkSteelBowDrawSpeeds must have exactly 5 values");
        }
        if (darkSteelBowFovMultipliers == null || darkSteelBowFovMultipliers.length != 5) {
            throw new IllegalArgumentException("Ender IO config value darkSteelBowFovMultipliers must have exactly 5 values");
        }
        if (remoteInventoryMBPerOpen == null || remoteInventoryMBPerOpen.length != 3) {
            throw new IllegalArgumentException("Ender IO config value remoteInventoryMBPerOpen must have exactly 3 values");
        }
        if (remoteInventoryRFPerTick == null || remoteInventoryRFPerTick.length != 3) {
            throw new IllegalArgumentException("Ender IO config value remoteInventoryRFPerTick must have exactly 3 values");
        }
        if (remoteInventoryMBCapacity == null || remoteInventoryMBCapacity.length != 3) {
            throw new IllegalArgumentException("Ender IO config value remoteInventoryMBCapacity must have exactly 3 values");
        }
        if (remoteInventoryRFCapacity == null || remoteInventoryRFCapacity.length != 3) {
            throw new IllegalArgumentException("Ender IO config value remoteInventoryRFCapacity must have exactly 3 values");
        }
        if (remoteInventoryFluidTypes == null || remoteInventoryFluidTypes.length != 3) {
            throw new IllegalArgumentException("Ender IO config value remoteInventoryFluidTypes must have exactly 3 values");
        }
    }

    public static ItemStack getStackForString(String s) {
        String[] nameAndMeta = s.split(";");
        int meta = nameAndMeta.length == 1 ? 0 : Integer.parseInt(nameAndMeta[1]);
        String[] data = nameAndMeta[0].split(":");
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(data[0], data[1]));
        if (item == null) {
            return null;
        }
        return new ItemStack(item, 1, meta);
    }

    private Config() {
    }

    static {
        sectionPower = new Section("Power Settings", "power");
        sectionRecipe = new Section("Recipe Settings", "recipe");
        sectionItems = new Section("Item Enabling", "item");
        sectionEfficiency = new Section("Efficiency Settings", "efficiency");
        sectionPersonal = new Section("Personal Settings", "personal");
        sectionAnchor = new Section("Anchor Settings", "anchor");
        sectionStaff = new Section("Staff Settings", "staff");
        sectionRod = new Section("Rod of Return Settings", "rod");
        sectionDarkSteel = new Section("Dark Steel", "darksteel");
        sectionFarm = new Section("Farm Settings", "farm");
        sectionAesthetic = new Section("Aesthetic Settings", "aesthetic");
        sectionAdvanced = new Section("Advanced Settings", "advanced");
        sectionMagnet = new Section("Magnet Settings", "magnet");
        sectionFluid = new Section("Fluid Settings", "fluid");
        sectionSpawner = new Section("PoweredSpawner Settings", "spawner");
        sectionKiller = new Section("Killer Joe Settings", "killerjoe");
        sectionSoulBinder = new Section("Soul Binder Settings", "soulBinder");
        sectionAttractor = new Section("Mob Attractor Settings", "attractor");
        sectionLootConfig = new Section("Loot Config", "lootconfig");
        sectionMobConfig = new Section("Mob Config", "mobconfig");
        sectionEnchantments = new Section("Enchantments", "enchantments");
        sectionWeather = new Section("Weather", "weather");
        sectionTelepad = new Section("Telepad", "telepad");
        sectionInventoryPanel = new Section("InventoryPanel", "inventorypanel");
        sectionMisc = new Section("Misc", "misc");
        sectionCapacitor = new Section("Capacitor Values", "capacitor");
        sectionTOP = new Section("The One Probe integration", "top");
        sectionHoes = new Section("Farm Settings.Hoes", "hoes");
        registerRecipes = true;
        allowFovControlsInSurvivalMode = false;
        jeiUseShortenedPainterRecipes = true;
        conduitScale = 0.6;
        transceiverEnergyLoss = 0.1;
        transceiverBucketTransmissionCostRF = 100;
        recipeLevel = 2;
        addPeacefulRecipes = false;
        createSyntheticRecipes = true;
        detailedPowerTrackingEnabled = false;
        useSneakMouseWheelYetaWrench = true;
        useSneakRightClickYetaWrench = false;
        yetaWrenchOverlayMode = 0;
        itemConduitUsePhyscialDistance = false;
        redstoneConduitsShowState = true;
        enderFluidConduitExtractRate = 200;
        enderFluidConduitMaxIoRate = 800;
        advancedFluidConduitExtractRate = 100;
        advancedFluidConduitMaxIoRate = 400;
        fluidConduitExtractRate = 50;
        fluidConduitMaxIoRate = 200;
        fluidConduitDynamicLighting = true;
        updateLightingWhenHidingFacades = false;
        transparentFacesLetThroughBeaconBeam = true;
        travelAnchorMaximumDistance = 96;
        travelAnchorCooldown = 0;
        travelAnchorSneak = true;
        travelAnchorSkipWarning = true;
        travelStaffMaximumDistance = 256;
        travelStaffPowerPerBlockRF = 250.0f;
        travelStaffMaxBlinkDistance = 16;
        travelStaffBlinkPauseTicks = 10;
        travelStaffBlinkEnabled = true;
        travelStaffBlinkThroughSolidBlocksEnabled = true;
        travelStaffBlinkThroughClearBlocksEnabled = true;
        travelStaffBlinkThroughUnbreakableBlocksEnabled = false;
        travelStaffBlinkBlackList = new String[]{"minecraft:bedrock", "Thaumcraft:blockWarded"};
        travelStaffOffhandBlinkEnabled = true;
        travelStaffOffhandTravelEnabled = true;
        travelStaffOffhandEnderIOEnabled = true;
        travelStaffOffhandShowsTravelTargets = true;
        travelAnchorZoomScale = 0.2f;
        darkSteelRightClickPlaceEnabled = true;
        darkSteelPowerDamgeAbsorptionRatios = new double[]{0.5, 0.6, 0.7, 0.85};
        darkSteelPowerStorageBase = 100000;
        darkSteelPowerStorageLevelOne = 150000;
        darkSteelPowerStorageLevelTwo = 250000;
        darkSteelPowerStorageLevelThree = 1000000;
        darkSteelSpeedOneWalkModifier = 0.15f;
        darkSteelSpeedTwoWalkMultiplier = 0.3f;
        darkSteelSpeedThreeWalkMultiplier = 0.45f;
        darkSteelSpeedOneSprintModifier = 0.1f;
        darkSteelSpeedTwoSprintMultiplier = 0.3f;
        darkSteelSpeedThreeSprintMultiplier = 0.5f;
        darkSteelSpeedOneCost = 4;
        darkSteelSpeedTwoCost = 6;
        darkSteelSpeedThreeCost = 8;
        darkSteelBootsJumpModifier = 1.5;
        darkSteelJumpOneCost = 4;
        darkSteelJumpTwoCost = 6;
        darkSteelJumpThreeCost = 8;
        slotZeroPlacesEight = true;
        darkSteelWalkPowerCost = darkSteelPowerStorageLevelTwo / 3000;
        darkSteelSprintPowerCost = darkSteelWalkPowerCost * 4;
        darkSteelDrainPowerFromInventory = false;
        darkSteelBootsJumpPowerCost = 150;
        darkSteelFallDistanceCost = 75;
        darkSteelSwordPoweredDamageBonus = 1.0f;
        darkSteelSwordPoweredSpeedBonus = 0.4f;
        darkSteelSwordWitherSkullChance = 0.05f;
        darkSteelSwordWitherSkullLootingModifier = 0.05f;
        darkSteelSwordSkullChance = 0.1f;
        darkSteelSwordSkullLootingModifier = 0.075f;
        vanillaSwordSkullLootingModifier = 0.05f;
        vanillaSwordSkullChance = 0.05f;
        ticCleaverSkullDropChance = 0.1f;
        ticBeheadingSkullModifier = 0.075f;
        fakePlayerSkullChance = 0.5f;
        darkSteelSwordPowerUsePerHit = 750;
        darkSteelSwordEnderPearlDropChance = 1.05;
        darkSteelSwordEnderPearlDropChancePerLooting = 0.5;
        darkSteelBowDamageBonus = 0.0f;
        darkSteelBowForceMultipliers = new double[]{1.1f, 1.2f, 1.3f, 1.4f, 1.5};
        darkSteelBowDrawSpeeds = new int[]{30, 20, 18, 16, 14};
        darkSteelBowFovMultipliers = new double[]{0.25, 0.3, 0.35, 0.4, 0.45};
        darkSteelBowPowerUsePerDamagePoint = 1000;
        darkSteelBowPowerUsePerDraw = 750;
        darkSteelBowPowerUsePerTickDrawn = 5;
        darkSteelPickEffeciencyObsidian = 50;
        darkSteelPickPowerUseObsidian = 10000;
        darkSteelPickApplyObsidianEffeciencyAtHardess = 40.0f;
        darkSteelPickPowerUsePerDamagePoint = 750;
        darkSteelPickEffeciencyBoostWhenPowered = 2.0f;
        darkSteelPickMinesTiCArdite = true;
        darkSteelAxePowerUsePerDamagePoint = 750;
        darkSteelAxePowerUsePerDamagePointMultiHarvest = 1500;
        darkSteelAxeEffeciencyBoostWhenPowered = 2.0f;
        darkSteelAxeSpeedPenaltyMultiHarvest = 4.0f;
        darkSteelShearsDurabilityFactor = 5;
        darkSteelShearsPowerUsePerDamagePoint = 250;
        darkSteelShearsEffeciencyBoostWhenPowered = 2.0f;
        darkSteelShearsBlockAreaBoostWhenPowered = 4;
        darkSteelShearsEntityAreaBoostWhenPowered = 5.0f;
        darkSteelUpgradeVibrantCost = 4;
        darkSteelUpgradePowerOneCost = 6;
        darkSteelUpgradePowerTwoCost = 8;
        darkSteelUpgradePowerThreeCost = 12;
        darkSteelGliderCost = 4;
        darkSteelGliderHorizontalSpeed = 0.03;
        darkSteelGliderVerticalSpeed = -0.05;
        darkSteelGliderVerticalSpeedSprinting = -0.15;
        darkSteelElytraCost = 10;
        darkSteelGogglesOfRevealingCost = 4;
        darkSteelApiaristArmorCost = 4;
        darkSteelSwimCost = 4;
        darkSteelNightVisionCost = 4;
        darkSteelTOPCost = 4;
        darkSteelSoundLocatorCost = 4;
        darkSteelSoundLocatorRange = 40;
        darkSteelSoundLocatorLifespan = 40;
        darkSteelTravelCost = 16;
        darkSteelSpoonCost = 4;
        darkSteelSolarOneGen = 10;
        darkSteelSolarOneCost = 4;
        darkSteelSolarTwoGen = 40;
        darkSteelSolarTwoCost = 8;
        darkSteelSolarThreeGen = 80;
        darkSteelSolarThreeCost = 24;
        darkSteelSolarChargeOthers = true;
        darkSteelAnvilDamageChance = 0.024f;
        darkSteelAnvilMaxLevel = 80;
        darkSteelLadderSpeedBoost = 0.06f;
        hootchPowerPerCycleRF = 60;
        hootchPowerTotalBurnTime = 6000;
        rocketFuelPowerPerCycleRF = 160;
        rocketFuelPowerTotalBurnTime = 7000;
        fireWaterPowerPerCycleRF = 80;
        fireWaterPowerTotalBurnTime = 15000;
        vatPowerUserPerTickRF = 20;
        maxPhotovoltaicOutputRF = 10;
        maxPhotovoltaicAdvancedOutputRF = 40;
        maxPhotovoltaicVibrantOutputRF = 160;
        zombieGeneratorRfPerTick = 80;
        zombieGeneratorTicksPerBucketFuel = 10000;
        addFuelTooltipsToAllFluidContainers = true;
        addFurnaceFuelTootip = true;
        addDurabilityTootip = true;
        farmActionEnergyUseRF = 500;
        farmAxeActionEnergyUseRF = 1000;
        farmBonemealActionEnergyUseRF = 160;
        farmBonemealTryEnergyUseRF = 80;
        farmAxeDamageOnLeafBreak = false;
        farmToolTakeDamageChance = 1.0f;
        disableFarmNotification = false;
        farmEssenceBerriesEnabled = true;
        farmManaBeansEnabled = false;
        farmHarvestJungleWhenCocoa = false;
        hoeStrings = new String[]{"minecraft:wooden_hoe", "minecraft:stone_hoe", "minecraft:iron_hoe", "minecraft:diamond_hoe", "minecraft:golden_hoe", "MekanismTools:ObsidianHoe", "MekanismTools:LapisLazuliHoe", "MekanismTools:OsmiumHoe", "MekanismTools:BronzeHoe", "MekanismTools:GlowstoneHoe", "MekanismTools:SteelHoe", "Steamcraft:hoeBrass", "Steamcraft:hoeGildedGold", "TConstruct:mattock", "ProjRed|Exploration:projectred.exploration.hoeruby", "ProjRed|Exploration:projectred.exploration.hoesapphire", "ProjRed|Exploration:projectred.exploration.hoeperidot", "magicalcrops:magicalcrops_AccioHoe", "magicalcrops:magicalcrops_CrucioHoe", "magicalcrops:magicalcrops_ImperioHoe", "magicalcrops:magicalcropsarmor_AccioHoe", "magicalcrops:magicalcropsarmor_CrucioHoe", "magicalcrops:magicalcropsarmor_ImperioHoe", "BiomesOPlenty:hoeAmethyst", "BiomesOPlenty:hoeMud", "Eln:Eln.Copper Hoe", "Thaumcraft:ItemHoeThaumium", "Thaumcraft:ItemHoeElemental", "Thaumcraft:ItemHoeVoid", "ThermalFoundation:tool.hoeInvar", "ThermalFoundation:tool.hoeCopper", "ThermalFoundation:tool.hoeBronze", "ThermalFoundation:tool.hoeSilver", "ThermalFoundation:tool.hoeElectrum", "ThermalFoundation:tool.hoeTin", "ThermalFoundation:tool.hoeLead", "ThermalFoundation:tool.hoeNickel", "ThermalFoundation:tool.hoePlatinum", "TwilightForest:item.steeleafHoe", "TwilightForest:item.ironwoodHoe", "IC2:itemToolBronzeHoe", "techreborn:bronzeHoe", "techreborn:rubyHoe", "techreborn:sapphireHoe", "techreborn:peridotHoe", "basemetals:adamantine_hoe", "basemetals:aquarium_hoe", "basemetals:brass_hoe", "basemetals:bronze_hoe", "basemetals:coldiron_hoe", "basemetals:copper_hoe", "basemetals:cupronickel_hoe", "basemetals:electrum_hoe", "basemetals:invar_hoe", "basemetals:lead_hoe", "basemetals:mithril_hoe", "basemetals:nickel_hoe", "basemetals:platinum_hoe", "basemetals:silver_hoe", "basemetals:starsteel_hoe", "basemetals:steel_hoe", "basemetals:tin_hoe", "actuallyadditions:itemHoeQuartz", "actuallyadditions:itemHoeEmerald", "actuallyadditions:itemHoeObsidian", "actuallyadditions:itemHoeCrystalRed", "actuallyadditions:itemHoeCrystalBlue", "actuallyadditions:itemHoeCrystalLightBlue", "actuallyadditions:itemHoeCrystalBlack", "actuallyadditions:itemHoeCrystalGreen", "actuallyadditions:itemHoeCrystalWhite", "silentgems:Hoe", "ic2:bronze_hoe", "appliedenergistics2:nether_quartz_hoe", "appliedenergistics2:certus_quartz_hoe", "railcraft:tool_hoe_steel", "calculator:ReinforcedHoe", "calculator:EnrichedGoldHoe", "calculator:ReinforcedIronHoe", "calculator:RedstoneHoe", "calculator:WeakenedDiamondHoe", "calculator:FlawlessDiamondHoe", "calculator:FireDiamondHoe", "calculator:ElectricHoe", "embers:hoeDawnstone", "embers:hoeCopper", "embers:hoeSilver", "embers:hoeLead", "roots:livingHoe", "mysticalagriculture:inferium_hoe", "mysticalagriculture:prudentium_hoe", "mysticalagriculture:intermedium_hoe", "mysticalagriculture:superium_hoe", "mysticalagriculture:supremium_hoe"};
        farmHoes = new Things(new String[0]);
        farmSaplingReserveAmount = 8;
        farmStopOnNoOutputSlots = true;
        farmEvictEmptyRFTools = true;
        magnetPowerUsePerSecondRF = 1;
        magnetPowerCapacityRF = 100000;
        magnetRange = 5;
        magnetBlacklist = new String[]{"appliedenergistics2:item.ItemCrystalSeed", "Botania:livingrock", "Botania:manaTablet"};
        magnetMaxItems = 20;
        magnetAllowInMainInventory = false;
        magnetAllowInBaublesSlot = true;
        magnetAllowDeactivatedInBaublesSlot = false;
        magnetBaublesType = "AMULET";
        crafterRfPerCraft = 2500;
        capacitorBankMaxIoRF = 5000;
        capacitorBankMaxStorageRF = 5000000;
        capacitorBankTierOneMaxIoRF = 1000;
        capacitorBankTierOneMaxStorageRF = 1000000;
        capacitorBankTierTwoMaxIoRF = 5000;
        capacitorBankTierTwoMaxStorageRF = 5000000;
        capacitorBankTierThreeMaxIoRF = 25000;
        capacitorBankTierThreeMaxStorageRF = 25000000;
        capacitorBankRenderPowerOverlayOnItem = false;
        poweredSpawnerMinDelayTicks = 200;
        poweredSpawnerMaxDelayTicks = 800;
        poweredSpawnerMaxPlayerDistance = 0;
        poweredSpawnerDespawnTimeSeconds = 120;
        poweredSpawnerSpawnCount = 4;
        poweredSpawnerSpawnRange = 4;
        poweredSpawnerMaxNearbyEntities = 6;
        poweredSpawnerMaxSpawnTries = 3;
        poweredSpawnerUseVanillaSpawChecks = false;
        brokenSpawnerDropChance = 1.0;
        brokenSpawnerToolBlacklist = new String[]{"RotaryCraft:rotarycraft_item_bedpick"};
        powerSpawnerAddSpawnerCost = 16;
        painterEnergyPerTaskRF = 2000;
        vacuumChestRange = 6;
        wirelessChargerRange = 24;
        nutrientFoodBoostDelay = 400L;
        rocketFuelIsExplosive = true;
        enchanterBaseLevelCost = 2;
        enchanterLevelCostFactor = 0.75;
        enchanterLapisCostFactor = 3.0;
        machineSoundsEnabled = true;
        machineSoundVolume = 1.0f;
        killerJoeNutrientUsePerAttackMb = 5;
        killerJoeAttackHeight = 2.0;
        killerJoeAttackWidth = 2.0;
        killerJoeAttackLength = 4.0;
        killerJoeHooverXpWidth = 5.0;
        killerJoeHooverXpLength = 10.0;
        killerJoeMustSee = false;
        killerPvPoffDisablesSwing = false;
        killerPvPoffIsIgnored = false;
        killerMendingEnabled = true;
        killerProvokesCreeperExpolosions = false;
        xpVacuumRange = 10.0;
        allowTileEntitiesAsPaintSource = true;
        enableMEConduits = true;
        enableOCConduits = true;
        enableOCConduitsAnimatedTexture = true;
        soulVesselBlackList = Collections.emptyList();
        soulVesselUnspawnableList = new ArrayList<String>();
        soulVesselUnspawnableList.add("chickens.ChickensChicken");
        soulVesselCapturesBosses = false;
        soulBinderBrokenSpawnerRF = 2500000;
        soulBinderBrokenSpawnerLevels = 8;
        soulBinderReanimationRF = 100000;
        soulBinderReanimationLevels = 4;
        soulBinderEnderCystalRF = 150000;
        soulBinderEnderCystalLevels = 6;
        soulBinderPrecientCystalRF = 200000;
        soulBinderPrecientCystalLevels = 8;
        soulBinderAttractorCystalRF = 100000;
        soulBinderAttractorCystalLevels = 4;
        soulBinderTunedPressurePlateLevels = 2;
        soulBinderTunedPressurePlateRF = 250000;
        soulBinderMaxXpLevel = 40;
        powerConduitCanDifferentTiersConnect = false;
        powerConduitTierOneRF = 640;
        powerConduitTierTwoRF = 5120;
        powerConduitTierThreeRF = 20480;
        spawnGuardStopAllSlimesDebug = false;
        spawnGuardStopAllSquidSpawning = false;
        weatherObeliskClearFluid = 2000;
        weatherObeliskRainFluid = 500;
        weatherObeliskThunderFluid = 1000;
        lootDarkSteel = true;
        lootItemConduitProbe = true;
        lootQuartz = true;
        lootNetherWart = true;
        lootEnderPearl = true;
        lootElectricSteel = true;
        lootRedstoneAlloy = true;
        lootPhasedIron = true;
        lootPhasedGold = true;
        lootTravelStaff = true;
        lootTheEnder = true;
        lootDarkSteelBoots = true;
        dumpMobNames = false;
        xpObeliskMaxXpLevel = Integer.MAX_VALUE;
        xpJuiceName = "xpjuice";
        clearGlassConnectToFusedQuartz = false;
        glassConnectToTheirVariants = true;
        glassConnectToTheirColorVariants = true;
        enchantmentSoulBoundRarity = Enchantment.Rarity.VERY_RARE;
        enchantmentSoulBoundEnabled = true;
        telepadLockDimension = true;
        telepadLockCoords = true;
        telepadPowerCoefficient = 100000;
        telepadPowerInterdimensional = 100000;
        telepadShrinkEffect = true;
        telepadIsTravelAnchor = true;
        telepadEnergyBufferRF = 100000;
        telepadEnergyUsePerTickRF = 4000;
        telepadFluidType = "ender_distillation";
        telepadFluidUse = 50;
        rodOfReturnCanTargetAnywhere = false;
        rodOfReturnTicksToActivate = 50;
        rodOfReturnPowerStorage = 2000000;
        rodOfReturnMinTicksToRecharge = 100;
        rodOfReturnRfPerTick = 35000;
        rodOfReturnFluidUsePerTeleport = 200;
        rodOfReturnFluidStorage = 200;
        rodOfReturnFluidType = "ender_distillation";
        inventoryPanelFree = false;
        inventoryPanelPowerPerMB = 800.0f;
        inventoryPanelScanCostPerSlot = 0.1f;
        inventoryPanelExtractCostPerItem = 12.0f;
        inventoryPanelExtractCostPerOperation = 32.0f;
        inventoryPanelScaleText = true;
        remoteInventoryMBPerOpen = new int[]{100, 25, 15};
        remoteInventoryRFPerTick = new int[]{4, 6, 8};
        remoteInventoryMBCapacity = new int[]{2000, 1000, 1500};
        remoteInventoryRFCapacity = new int[]{60000, 120000, 150000};
        remoteInventoryFluidTypes = new String[]{"nutrient_distillation", "ender_distillation", "vapor_of_levity"};
        coldFireIgniterFluidType = "vapor_of_levity";
        coldFireIgniterMbPerUse = 10;
        photovoltaicCanTypesJoins = true;
        photovoltaicRecalcSunTick = 100;
        debugUpdatePackets = false;
        topEnabled = true;
        topShowProgressByDefault = true;
        topShowPowerByDefault = true;
        topShowRedstoneByDefault = false;
        topShowSideConfigByDefault = false;
        topShowRangeByDefault = false;
        topShowMobsByDefault = true;
        topShowTanksByDefault = true;
        topShowXPByDefault = true;
        topShowItemCountDefault = true;
        paintedGlowstoneRequireSilkTouch = false;
        enableBaublesIntegration = true;
        leversEnabled = "10,30,60,300";
    }

    public static class Section {
        public final String name;
        public final String lang;

        public Section(String name, String lang) {
            this.name = name;
            this.lang = lang;
            this.register();
        }

        private void register() {
            sections.add(this);
        }

        public String lc() {
            return this.name.toLowerCase(Locale.US);
        }
    }
}

