/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.power;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.IconUtil;
import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.AbstractConduit;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.IConduitComponent;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.geom.CollidableCache;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.conduit.power.PowerConduitNetwork;
import crazypants.enderio.conduit.render.BlockStateWrapperConduitBundle;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.PacketConduitProbe;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.power.IPowerInterface;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.tool.ToolUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PowerConduit
extends AbstractConduit
implements IPowerConduit,
IConduitComponent {
    static final Map<String, TextureAtlasSprite> ICONS = new HashMap<String, TextureAtlasSprite>();
    static final String[] POSTFIX = new String[]{"", "Enhanced", "Ender"};
    public static final float WIDTH = 0.075f;
    public static final float HEIGHT = 0.075f;
    public static final Vector3d MIN = new Vector3d((double)0.425f, 0.42499999701976776, 0.42499999701976776);
    public static final Vector3d MAX = new Vector3d(PowerConduit.MIN.x + (double)0.075f, PowerConduit.MIN.y + (double)0.075f, PowerConduit.MIN.z + (double)0.075f);
    public static final BoundingBox BOUNDS = new BoundingBox(MIN, MAX);
    protected PowerConduitNetwork network;
    private int energyStoredRF;
    private int subtype;
    protected final EnumMap<EnumFacing, RedstoneControlMode> rsModes = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, DyeColor> rsColors = new EnumMap(EnumFacing.class);
    protected EnumMap<EnumFacing, Long> recievedTicks;
    private final Map<EnumFacing, Integer> externalRedstoneSignals = new EnumMap<EnumFacing, Integer>(EnumFacing.class);
    private boolean redstoneStateDirty = true;

    static ItemStack createItemStackForSubtype(int subtype) {
        ItemStack result = new ItemStack(ModObject.itemPowerConduit.getItem(), 1, subtype);
        return result;
    }

    public static void initIcons() {
        IconUtil.addIconProvider((IconUtil.IIconProvider)new IconUtil.IIconProvider(){

            public void registerIcons(TextureMap register) {
                for (String pf : POSTFIX) {
                    ICONS.put("enderio:blocks/powerConduit" + pf, register.func_174942_a(new ResourceLocation("enderio:blocks/powerConduit" + pf)));
                    ICONS.put("enderio:blocks/powerConduitInput" + pf, register.func_174942_a(new ResourceLocation("enderio:blocks/powerConduitInput" + pf)));
                    ICONS.put("enderio:blocks/powerConduitOutput" + pf, register.func_174942_a(new ResourceLocation("enderio:blocks/powerConduitOutput" + pf)));
                    ICONS.put("enderio:blocks/powerConduitCore" + pf, register.func_174942_a(new ResourceLocation("enderio:blocks/powerConduitCore" + pf)));
                }
                ICONS.put("enderio:blocks/powerConduitTransmission", register.func_174942_a(new ResourceLocation("enderio:blocks/powerConduitTransmission")));
            }
        });
    }

    public PowerConduit() {
    }

    public PowerConduit(int meta) {
        this.subtype = meta;
    }

    @Override
    public boolean getConnectionsDirty() {
        return this.connectionsDirty;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, EnumHand hand, RaytraceResult res, List<RaytraceResult> all) {
        DyeColor col = DyeColor.getColorFromDye((ItemStack)player.func_184614_ca());
        if (ConduitUtil.isProbeEquipped(player, hand)) {
            if (!player.field_70170_p.field_72995_K) {
                PacketConduitProbe.sendInfoMessage(player, this);
            }
            return true;
        }
        if (col != null && res.component != null && this.isColorBandRendered(res.component.dir)) {
            this.setExtractionSignalColor(res.component.dir, col);
            return true;
        }
        if (ToolUtil.isToolEquipped(player, hand) && !this.getBundle().getEntity().func_145831_w().field_72995_K && res != null && res.component != null) {
            EnumFacing connDir = res.component.dir;
            EnumFacing faceHit = res.movingObjectPosition.field_178784_b;
            if (connDir == null || connDir == faceHit) {
                if (this.getConnectionMode(faceHit) == ConnectionMode.DISABLED) {
                    this.setConnectionMode(faceHit, this.getNextConnectionMode(faceHit));
                    return true;
                }
                return ConduitUtil.joinConduits(this, faceHit);
            }
            if (this.externalConnections.contains(connDir)) {
                this.setConnectionMode(connDir, this.getNextConnectionMode(connDir));
                return true;
            }
            if (this.containsConduitConnection(connDir)) {
                ConduitUtil.disconectConduits(this, connDir);
                return true;
            }
        }
        return false;
    }

    private boolean isColorBandRendered(EnumFacing dir) {
        return this.getConnectionMode(dir) != ConnectionMode.DISABLED && this.getExtractionRedstoneMode(dir) != RedstoneControlMode.IGNORE;
    }

    @Override
    public void setExtractionRedstoneMode(RedstoneControlMode mode, EnumFacing dir) {
        this.rsModes.put(dir, mode);
        this.setClientStateDirty();
    }

    @Override
    public RedstoneControlMode getExtractionRedstoneMode(EnumFacing dir) {
        RedstoneControlMode res = this.rsModes.get(dir);
        if (res == null) {
            res = RedstoneControlMode.IGNORE;
        }
        return res;
    }

    @Override
    public void setExtractionSignalColor(EnumFacing dir, DyeColor col) {
        this.rsColors.put(dir, col);
        this.setClientStateDirty();
    }

    @Override
    public DyeColor getExtractionSignalColor(EnumFacing dir) {
        DyeColor res = this.rsColors.get(dir);
        if (res == null) {
            res = DyeColor.RED;
        }
        return res;
    }

    @Override
    protected void readTypeSettings(EnumFacing dir, NBTTagCompound dataRoot) {
        this.setExtractionSignalColor(dir, DyeColor.values()[dataRoot.func_74765_d("extractionSignalColor")]);
        this.setExtractionRedstoneMode(RedstoneControlMode.values()[dataRoot.func_74765_d("extractionRedstoneMode")], dir);
    }

    @Override
    protected void writeTypeSettingsToNbt(EnumFacing dir, NBTTagCompound dataRoot) {
        dataRoot.func_74777_a("extractionSignalColor", (short)this.getExtractionSignalColor(dir).ordinal());
        dataRoot.func_74777_a("extractionRedstoneMode", (short)this.getExtractionRedstoneMode(dir).ordinal());
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        short ord;
        super.writeToNBT(nbtRoot);
        nbtRoot.func_74777_a("subtype", (short)this.subtype);
        nbtRoot.func_74768_a("energyStoredRF", this.energyStoredRF);
        for (Map.Entry<EnumFacing, RedstoneControlMode> entry : this.rsModes.entrySet()) {
            if (entry.getValue() == null) continue;
            ord = (short)entry.getValue().ordinal();
            nbtRoot.func_74777_a("pRsMode." + entry.getKey().name(), ord);
        }
        for (Map.Entry<EnumFacing, RedstoneControlMode> entry : this.rsColors.entrySet()) {
            if (entry.getValue() == null) continue;
            ord = (short)((DyeColor)entry.getValue()).ordinal();
            nbtRoot.func_74777_a("pRsCol." + entry.getKey().name(), ord);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot, short nbtVersion) {
        super.readFromNBT(nbtRoot, nbtVersion);
        this.subtype = nbtRoot.func_74765_d("subtype");
        if (nbtRoot.func_74764_b("energyStored")) {
            nbtRoot.func_74768_a("energyStoredRF", (int)(nbtRoot.func_74760_g("energyStored") * 10.0f));
        }
        this.setEnergyStored(nbtRoot.func_74762_e("energyStoredRF"));
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            short ord;
            String key = "pRsMode." + dir.name();
            if (nbtRoot.func_74764_b(key) && (ord = nbtRoot.func_74765_d(key)) >= 0 && ord < RedstoneControlMode.values().length) {
                this.rsModes.put(dir, RedstoneControlMode.values()[ord]);
            }
            if (!nbtRoot.func_74764_b(key = "pRsCol." + dir.name()) || (ord = nbtRoot.func_74765_d(key)) < 0 || ord >= DyeColor.values().length) continue;
            this.rsColors.put(dir, DyeColor.values()[ord]);
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.energyStoredRF;
    }

    @Override
    public void setEnergyStored(int energyStored) {
        this.energyStoredRF = MathHelper.func_76125_a((int)energyStored, (int)0, (int)this.getMaxEnergyStored(null));
    }

    private boolean isRedstoneEnabled(EnumFacing dir) {
        RedstoneControlMode mode = this.getExtractionRedstoneMode(dir);
        if (mode == RedstoneControlMode.NEVER) {
            return false;
        }
        if (mode == RedstoneControlMode.IGNORE) {
            return true;
        }
        DyeColor col = this.getExtractionSignalColor(dir);
        int signal = ConduitUtil.getInternalSignalForColor(this.getBundle(), col);
        int exSig = this.getExternalRedstoneSignalForDir(dir);
        boolean res = mode == RedstoneControlMode.OFF ? RedstoneControlMode.isConditionMet(mode, signal) && (col != DyeColor.RED || RedstoneControlMode.isConditionMet(mode, exSig)) : RedstoneControlMode.isConditionMet(mode, signal) || col == DyeColor.RED && RedstoneControlMode.isConditionMet(mode, exSig);
        return res;
    }

    private int getExternalRedstoneSignalForDir(EnumFacing dir) {
        int result;
        Integer cached;
        if (this.redstoneStateDirty) {
            this.externalRedstoneSignals.clear();
            this.redstoneStateDirty = false;
        }
        if ((cached = this.externalRedstoneSignals.get(dir)) == null) {
            TileEntity te = this.getBundle().getEntity();
            result = te.func_145831_w().func_175687_A(te.func_174877_v());
            this.externalRedstoneSignals.put(dir, result);
        } else {
            result = cached;
        }
        return result;
    }

    @Override
    public int getMaxEnergyRecieved(EnumFacing dir) {
        ConnectionMode mode = this.getConnectionMode(dir);
        if (mode == ConnectionMode.OUTPUT || mode == ConnectionMode.DISABLED || !this.isRedstoneEnabled(dir)) {
            return 0;
        }
        return PowerConduit.getMaxEnergyIO(this.subtype);
    }

    @Override
    public int getMaxEnergyExtracted(EnumFacing dir) {
        ConnectionMode mode = this.getConnectionMode(dir);
        if (mode == ConnectionMode.INPUT || mode == ConnectionMode.DISABLED || !this.isRedstoneEnabled(dir)) {
            return 0;
        }
        if (this.recievedRfThisTick(dir)) {
            return 0;
        }
        return PowerConduit.getMaxEnergyIO(this.subtype);
    }

    private boolean recievedRfThisTick(EnumFacing dir) {
        long recT;
        if (this.recievedTicks == null || dir == null || this.recievedTicks.get(dir) == null || this.getBundle() == null || this.getBundle().getBundleWorldObj() == null) {
            return false;
        }
        long curTick = this.getBundle().getBundleWorldObj().func_82737_E();
        return curTick - (recT = this.recievedTicks.get(dir).longValue()) <= 5L;
    }

    @Override
    public boolean onNeighborBlockChange(Block blockId) {
        this.redstoneStateDirty = true;
        if (this.network != null && this.network.powerManager != null) {
            this.network.powerManager.receptorsChanged();
        }
        return super.onNeighborBlockChange(blockId);
    }

    @Override
    public void setConnectionMode(EnumFacing dir, ConnectionMode mode) {
        super.setConnectionMode(dir, mode);
        this.recievedTicks = null;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (this.getMaxEnergyRecieved(from) == 0 || maxReceive <= 0) {
            return 0;
        }
        int freeSpace = this.getMaxEnergyStored(from) - this.getEnergyStored(from);
        int result = Math.min(maxReceive, freeSpace);
        if (!simulate && result > 0) {
            this.setEnergyStored(this.getEnergyStored(from) + result);
            if (this.getBundle() != null) {
                if (this.recievedTicks == null) {
                    this.recievedTicks = new EnumMap(EnumFacing.class);
                }
                if (from != null) {
                    this.recievedTicks.put(from, this.getBundle().getBundleWorldObj().func_82737_E());
                }
            }
        }
        return result;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public AbstractConduitNetwork<?, ?> getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(AbstractConduitNetwork<?, ?> network) {
        this.network = (PowerConduitNetwork)network;
        return true;
    }

    @Override
    public boolean canConnectToExternal(EnumFacing direction, boolean ignoreDisabled) {
        IPowerInterface rec = this.getExternalPowerReceptor(direction);
        return rec != null;
    }

    @Override
    public boolean canConnectToConduit(EnumFacing direction, IConduit conduit) {
        boolean res = super.canConnectToConduit(direction, conduit);
        if (!res) {
            return false;
        }
        if (Config.powerConduitCanDifferentTiersConnect) {
            return res;
        }
        if (!(conduit instanceof IPowerConduit)) {
            return false;
        }
        IPowerConduit pc = (IPowerConduit)conduit;
        return pc.getMaxEnergyStored(direction) == this.getMaxEnergyStored(direction);
    }

    @Override
    public void externalConnectionAdded(EnumFacing direction) {
        super.externalConnectionAdded(direction);
        if (this.network != null) {
            TileEntity te = this.bundle.getEntity();
            BlockPos p = te.func_174877_v().func_177972_a(direction);
            this.network.powerReceptorAdded(this, direction, p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), this.getExternalPowerReceptor(direction));
        }
    }

    @Override
    public void externalConnectionRemoved(EnumFacing direction) {
        super.externalConnectionRemoved(direction);
        if (this.network != null) {
            TileEntity te = this.bundle.getEntity();
            BlockPos p = te.func_174877_v().func_177972_a(direction);
            this.network.powerReceptorRemoved(p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
        }
    }

    @Override
    public IPowerInterface getExternalPowerReceptor(EnumFacing direction) {
        TileEntity te = this.bundle.getEntity();
        World world = te.func_145831_w();
        if (world == null) {
            return null;
        }
        TileEntity test = world.func_175625_s(te.func_174877_v().func_177972_a(direction));
        if (test == null) {
            return null;
        }
        if (test instanceof IConduitBundle) {
            return null;
        }
        return PowerHandlerUtil.getPowerInterface((ICapabilityProvider)test, direction.func_176734_d());
    }

    @Override
    public ItemStack createItem() {
        return PowerConduit.createItemStackForSubtype(this.subtype);
    }

    @Override
    public Class<? extends IConduit> getBaseConduitType() {
        return IPowerConduit.class;
    }

    @Override
    public TextureAtlasSprite getTextureForState(CollidableComponent component) {
        if (component.dir == null) {
            return ICONS.get("enderio:blocks/powerConduitCore" + POSTFIX[this.subtype]);
        }
        if ("ColorController".equals(component.data)) {
            return IconUtil.instance.whiteTexture;
        }
        return ICONS.get("enderio:blocks/powerConduit" + POSTFIX[this.subtype]);
    }

    @Override
    public TextureAtlasSprite getTextureForInputMode() {
        return ICONS.get("enderio:blocks/powerConduitInput" + POSTFIX[this.subtype]);
    }

    @Override
    public TextureAtlasSprite getTextureForOutputMode() {
        return ICONS.get("enderio:blocks/powerConduitOutput" + POSTFIX[this.subtype]);
    }

    @Override
    public TextureAtlasSprite getTransmitionTextureForState(CollidableComponent component) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vector4f getTransmitionTextureColorForState(CollidableComponent component) {
        return null;
    }

    @Override
    public Collection<CollidableComponent> createCollidables(CollidableCache.CacheKey key) {
        Collection<CollidableComponent> baseCollidables = super.createCollidables(key);
        if (key.dir == null) {
            return baseCollidables;
        }
        BoundingBox bb = ConduitGeometryUtil.instance.createBoundsForConnectionController(key.dir, key.offset);
        CollidableComponent cc = new CollidableComponent(IPowerConduit.class, bb, key.dir, "ColorController");
        ArrayList<CollidableComponent> result = new ArrayList<CollidableComponent>();
        result.addAll(baseCollidables);
        result.add(cc);
        return result;
    }

    static int getMaxEnergyIO(int subtype) {
        switch (subtype) {
            case 1: {
                return Config.powerConduitTierTwoRF;
            }
            case 2: {
                return Config.powerConduitTierThreeRF;
            }
        }
        return Config.powerConduitTierOneRF;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return PowerConduit.getMaxEnergyIO(this.subtype);
    }

    @Override
    public boolean displayPower() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void hashCodeForModelCaching(IBlockStateWrapper wrapper, BlockStateWrapperConduitBundle.ConduitCacheKey hashCodes) {
        super.hashCodeForModelCaching(wrapper, hashCodes);
        if (this.subtype != 1) {
            hashCodes.add(this.subtype);
        }
        hashCodes.addEnum(this.rsModes);
        hashCodes.addEnum(this.rsColors);
    }

    public PowerConduitNetwork createNetworkForType() {
        return new PowerConduitNetwork();
    }
}

