/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.power;

import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.AbstractItemConduit;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.ItemConduitSubtype;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.conduit.power.PowerConduit;
import crazypants.enderio.power.PowerDisplayUtil;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPowerConduit
extends AbstractItemConduit {
    private static String PREFIX;
    private static String POSTFIX;
    static ItemConduitSubtype[] SUBTYPES;

    public static ItemPowerConduit create() {
        ItemPowerConduit result = new ItemPowerConduit();
        result.init();
        return result;
    }

    protected ItemPowerConduit() {
        super(ModObject.itemPowerConduit, SUBTYPES);
    }

    @Override
    public Class<? extends IConduit> getBaseConduitType() {
        return IPowerConduit.class;
    }

    @Override
    public IConduit createConduit(ItemStack stack, EntityPlayer player) {
        return new PowerConduit(stack.func_77952_i());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer par2EntityPlayer, List<String> list, boolean par4) {
        if (PREFIX == null) {
            POSTFIX = " " + PowerDisplayUtil.abrevation() + PowerDisplayUtil.perTickStr();
            PREFIX = EnderIO.lang.localize("power.maxOutput") + " ";
        }
        super.func_77624_a(itemStack, par2EntityPlayer, list, par4);
        int cap = PowerConduit.getMaxEnergyIO(itemStack.func_77960_j());
        list.add(PREFIX + PowerDisplayUtil.formatPower(cap) + POSTFIX);
    }

    @Override
    public boolean shouldHideFacades(ItemStack stack, EntityPlayer player) {
        return true;
    }

    static {
        SUBTYPES = new ItemConduitSubtype[]{new ItemConduitSubtype(ModObject.itemPowerConduit.name(), "enderio:itemPowerConduit"), new ItemConduitSubtype(ModObject.itemPowerConduit.name() + "Enhanced", "enderio:itemPowerConduitEnhanced"), new ItemConduitSubtype(ModObject.itemPowerConduit.name() + "Ender", "enderio:itemPowerConduitEnder")};
    }
}

