/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.packet;

import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.conduit.oc.IOCConduit;
import crazypants.enderio.conduit.packet.AbstractConduitPacket;
import crazypants.enderio.conduit.packet.ConTypeEnum;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketOCConduitSignalColor
extends AbstractConduitPacket<IOCConduit>
implements IMessageHandler<PacketOCConduitSignalColor, IMessage> {
    private EnumFacing dir;
    private DyeColor col;

    public PacketOCConduitSignalColor() {
    }

    public PacketOCConduitSignalColor(IOCConduit con, EnumFacing dir) {
        super(con.getBundle().getEntity(), ConTypeEnum.OC);
        this.dir = dir;
        this.col = con.getSignalColor(dir);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeShort(this.dir.ordinal());
        buf.writeShort(this.col.ordinal());
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.dir = EnumFacing.values()[buf.readShort()];
        this.col = DyeColor.values()[buf.readShort()];
    }

    public IMessage onMessage(PacketOCConduitSignalColor message, MessageContext ctx) {
        ((IOCConduit)message.getTileCasted(ctx)).setSignalColor(message.dir, message.col);
        IBlockState bs = message.getWorld(ctx).func_180495_p(message.getPos());
        message.getWorld(ctx).func_184138_a(message.getPos(), bs, bs, 3);
        return null;
    }
}

