/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.geom.ConnectionModeGeometry;
import crazypants.enderio.conduit.geom.Offset;
import crazypants.enderio.conduit.liquid.EnderLiquidConduit;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.render.DefaultConduitRenderer;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;

public class EnderLiquidConduitRenderer
extends DefaultConduitRenderer {
    @Override
    public boolean isRendererForConduit(IConduit conduit) {
        return conduit instanceof EnderLiquidConduit;
    }

    @Override
    protected void addConduitQuads(IConduitBundle bundle, IConduit conduit, TextureAtlasSprite tex, CollidableComponent component, float selfIllum, List<BakedQuad> quads) {
        super.addConduitQuads(bundle, conduit, tex, component, selfIllum, quads);
        EnderLiquidConduit pc = (EnderLiquidConduit)conduit;
        for (EnumFacing dir : conduit.getExternalConnections()) {
            TextureAtlasSprite daTex = null;
            if (conduit.getConnectionMode(dir) == ConnectionMode.INPUT) {
                daTex = pc.getTextureForInputMode();
            } else if (conduit.getConnectionMode(dir) == ConnectionMode.OUTPUT) {
                daTex = pc.getTextureForOutputMode();
            } else if (conduit.getConnectionMode(dir) == ConnectionMode.IN_OUT) {
                daTex = pc.getTextureForInOutMode();
            }
            if (daTex == null) continue;
            Offset offset = bundle.getOffset(ILiquidConduit.class, dir);
            ConnectionModeGeometry.addModeConnectorQuads(dir, offset, daTex, null, quads);
        }
    }
}

