/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.item;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.ItemConduit;
import crazypants.enderio.conduit.item.NetworkedInventory;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import crazypants.enderio.machine.invpanel.server.InventoryDatabaseServer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;

public class ItemConduitNetwork
extends AbstractConduitNetwork<IItemConduit, IItemConduit> {
    final List<NetworkedInventory> inventories = new ArrayList<NetworkedInventory>();
    private final Map<BlockCoord, List<NetworkedInventory>> invMap = new HashMap<BlockCoord, List<NetworkedInventory>>();
    final Map<BlockCoord, IItemConduit> conMap = new HashMap<BlockCoord, IItemConduit>();
    private boolean requiresSort = true;
    private boolean doingSend = false;
    private int changeCount;
    private InventoryDatabaseServer database;
    static int MAX_SLOT_CHECK_PER_TICK = 64;

    public ItemConduitNetwork() {
        super(IItemConduit.class, IItemConduit.class);
    }

    @Override
    public void addConduit(IItemConduit con) {
        super.addConduit(con);
        this.conMap.put(con.getLocation(), con);
        TileEntity te = con.getBundle().getEntity();
        if (te != null) {
            for (EnumFacing direction : con.getExternalConnections()) {
                IItemHandler extCon = con.getExternalInventory(direction);
                if (extCon == null) continue;
                BlockPos p = te.func_174877_v().func_177972_a(direction);
                this.inventoryAdded(con, direction, p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), extCon);
            }
        }
    }

    public void inventoryAdded(IItemConduit itemConduit, EnumFacing direction, int x, int y, int z, IItemHandler externalInventory) {
        BlockCoord bc = new BlockCoord(x, y, z);
        NetworkedInventory inv = new NetworkedInventory(this, itemConduit, direction, externalInventory, bc);
        this.inventories.add(inv);
        this.getOrCreate(bc).add(inv);
        this.requiresSort = true;
    }

    public NetworkedInventory getInventory(IItemConduit conduit, EnumFacing dir) {
        for (NetworkedInventory inv : this.inventories) {
            if (inv.con != conduit || inv.conDir != dir) continue;
            return inv;
        }
        return null;
    }

    public List<NetworkedInventory> getInventoryPanelSources() {
        ArrayList<NetworkedInventory> res = new ArrayList<NetworkedInventory>();
        for (NetworkedInventory inv : this.inventories) {
            if (!inv.con.hasInventoryPanelUpgrade(inv.conDir)) continue;
            res.add(inv);
        }
        return res;
    }

    private List<NetworkedInventory> getOrCreate(BlockCoord bc) {
        List<NetworkedInventory> res = this.invMap.get(bc);
        if (res == null) {
            res = new ArrayList<NetworkedInventory>();
            this.invMap.put(bc, res);
        }
        return res;
    }

    public void inventoryRemoved(ItemConduit itemConduit, int x, int y, int z) {
        BlockCoord bc = new BlockCoord(x, y, z);
        List<NetworkedInventory> invs = this.getOrCreate(bc);
        NetworkedInventory remove = null;
        for (NetworkedInventory ni : invs) {
            if (!ni.con.getLocation().equals((Object)itemConduit.getLocation())) continue;
            remove = ni;
            break;
        }
        if (remove != null) {
            invs.remove(remove);
            this.inventories.remove(remove);
            this.requiresSort = true;
        }
    }

    public void routesChanged() {
        this.requiresSort = true;
    }

    public void inventoryPanelSourcesChanged() {
        ++this.changeCount;
    }

    public int getChangeCount() {
        return this.changeCount;
    }

    public boolean hasDatabase() {
        return this.database != null;
    }

    public InventoryDatabaseServer getDatabase() {
        block4: {
            block3: {
                block2: {
                    if (this.database != null) break block2;
                    this.database = new InventoryDatabaseServer(this);
                    break block3;
                }
                if (this.database.isCurrent()) break block4;
            }
            this.database.updateNetworkSources();
        }
        return this.database;
    }

    @Override
    public void destroyNetwork() {
        super.destroyNetwork();
        if (this.database != null) {
            this.database.resetDatabase();
            this.database = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack sendItems(ItemConduit itemConduit, ItemStack item, EnumFacing side) {
        if (this.doingSend) {
            return item;
        }
        if (item == null) {
            return item;
        }
        try {
            this.doingSend = true;
            BlockCoord loc = itemConduit.getLocation().getLocation(side);
            ItemStack result = item.func_77946_l();
            List<NetworkedInventory> invs = this.getOrCreate(loc);
            for (NetworkedInventory inv : invs) {
                if (!inv.con.getLocation().equals((Object)itemConduit.getLocation())) continue;
                int numInserted = inv.insertIntoTargets(item.func_77946_l());
                if (numInserted >= item.field_77994_a) {
                    ItemStack itemStack = null;
                    return itemStack;
                }
                result.field_77994_a -= numInserted;
            }
            ItemStack itemStack = result;
            return itemStack;
        }
        finally {
            this.doingSend = false;
        }
    }

    public List<String> getTargetsForExtraction(BlockCoord extractFrom, IItemConduit con, ItemStack input) {
        ArrayList<String> result = new ArrayList<String>();
        List<NetworkedInventory> invs = this.getOrCreate(extractFrom);
        for (NetworkedInventory source : invs) {
            if (!source.con.getLocation().equals((Object)con.getLocation()) || source.sendPriority == null) continue;
            for (NetworkedInventory.Target t : source.sendPriority) {
                IItemFilter f = t.inv.con.getOutputFilter(t.inv.conDir);
                if (input != null && f != null && !f.doesItemPassFilter(t.inv, input)) continue;
                String s = t.inv.getLocalizedInventoryName() + " " + new BlockCoord(t.inv.location).chatString() + " Distance [" + t.distance + "] ";
                result.add(s);
            }
        }
        return result;
    }

    public List<String> getInputSourcesFor(IItemConduit con, EnumFacing dir, ItemStack input) {
        ArrayList<String> result = new ArrayList<String>();
        for (NetworkedInventory inv : this.inventories) {
            if (!inv.hasTarget(con, dir)) continue;
            IItemFilter f = inv.con.getInputFilter(inv.conDir);
            if (input != null && f != null && !f.doesItemPassFilter(inv, input)) continue;
            result.add(inv.getLocalizedInventoryName() + " " + new BlockCoord(inv.location).chatString());
        }
        return result;
    }

    @Override
    public void doNetworkTick() {
        for (NetworkedInventory ni : this.inventories) {
            if (this.requiresSort) {
                ni.updateInsertOrder();
            }
            ni.onTick();
        }
        if (this.requiresSort) {
            this.requiresSort = false;
            ++this.changeCount;
        }
        if (this.database != null) {
            this.database.tick();
        }
    }

    static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }
}

