/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.EnderIO;
import crazypants.enderio.GuiID;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.IConduitItem;
import crazypants.enderio.conduit.TileConduitBundle;
import crazypants.enderio.conduit.me.MEUtil;
import crazypants.enderio.conduit.oc.OCUtil;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduit.redstone.Signal;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.paint.YetaUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.SoundType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ConduitUtil {
    public static final Random RANDOM = new Random();

    public static void ensureValidNetwork(IConduit conduit) {
        TileEntity te = conduit.getBundle().getEntity();
        World world = te.func_145831_w();
        Collection<? extends IConduit> connections = ConduitUtil.getConnectedConduits(world, te.func_174877_v(), conduit.getBaseConduitType());
        if (ConduitUtil.reuseNetwork(conduit, connections, world)) {
            return;
        }
        AbstractConduitNetwork<?, ?> res = conduit.createNetworkForType();
        res.init(conduit.getBundle(), connections, world);
    }

    private static boolean reuseNetwork(IConduit con, Collection<? extends IConduit> connections, World world) {
        AbstractConduitNetwork<?, ?> network = null;
        for (IConduit iConduit : connections) {
            if (network == null) {
                network = iConduit.getNetwork();
                continue;
            }
            if (network == iConduit.getNetwork()) continue;
            return false;
        }
        if (network == null) {
            return false;
        }
        if (con.setNetwork(network)) {
            network.addConduit(con);
            return true;
        }
        return false;
    }

    public static <T extends IConduit> void disconectConduits(T con, EnumFacing connDir) {
        con.conduitConnectionRemoved(connDir);
        BlockCoord loc = con.getLocation().getLocation(connDir);
        IConduit neighbour = ConduitUtil.getConduit(con.getBundle().getEntity().func_145831_w(), loc.x, loc.y, loc.z, con.getBaseConduitType());
        if (neighbour != null) {
            neighbour.conduitConnectionRemoved(connDir.func_176734_d());
            if (neighbour.getNetwork() != null) {
                neighbour.getNetwork().destroyNetwork();
            }
        }
        if (con.getNetwork() != null) {
            con.getNetwork().destroyNetwork();
        }
        con.connectionsChanged();
        if (neighbour != null) {
            neighbour.connectionsChanged();
        }
    }

    public static <T extends IConduit> boolean joinConduits(T con, EnumFacing faceHit) {
        BlockCoord loc = con.getLocation().getLocation(faceHit);
        IConduit neighbour = ConduitUtil.getConduit(con.getBundle().getEntity().func_145831_w(), loc.x, loc.y, loc.z, con.getBaseConduitType());
        if (neighbour != null && con.canConnectToConduit(faceHit, neighbour) && neighbour.canConnectToConduit(faceHit.func_176734_d(), con)) {
            con.conduitConnectionAdded(faceHit);
            neighbour.conduitConnectionAdded(faceHit.func_176734_d());
            if (con.getNetwork() != null) {
                con.getNetwork().destroyNetwork();
            }
            if (neighbour.getNetwork() != null) {
                neighbour.getNetwork().destroyNetwork();
            }
            con.connectionsChanged();
            neighbour.connectionsChanged();
            return true;
        }
        return false;
    }

    public static boolean forceSkylightRecalculation(World worldObj, int xCoord, int yCoord, int zCoord) {
        return ConduitUtil.forceSkylightRecalculation(worldObj, new BlockPos(xCoord, yCoord, zCoord));
    }

    public static boolean forceSkylightRecalculation(World worldObj, BlockPos pos) {
        int height = worldObj.func_175645_m(pos).func_177956_o();
        if (height <= pos.func_177956_o()) {
            for (int i = 1; i < 12; ++i) {
                if (!worldObj.func_175623_d(pos)) continue;
                worldObj.func_180501_a(pos.func_177967_a(EnumFacing.UP, i), Blocks.field_150348_b.func_176223_P(), 3);
                worldObj.func_175698_g(pos.func_177967_a(EnumFacing.UP, i));
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static IConduitBundle.FacadeRenderState getRequiredFacadeRenderState(IConduitBundle bundle, EntityPlayer player) {
        if (!bundle.hasFacade()) {
            return IConduitBundle.FacadeRenderState.NONE;
        }
        if (YetaUtil.isFacadeHidden(bundle, player)) {
            return IConduitBundle.FacadeRenderState.WIRE_FRAME;
        }
        return IConduitBundle.FacadeRenderState.FULL;
    }

    public static boolean isConduitEquipped(EntityPlayer player) {
        return ConduitUtil.isConduitEquipped(player, EnumHand.MAIN_HAND);
    }

    public static boolean isConduitEquipped(EntityPlayer player, EnumHand hand) {
        EntityPlayer entityPlayer = player = player == null ? EnderIO.proxy.getClientPlayer() : player;
        if (player == null) {
            return false;
        }
        ItemStack equipped = player.func_184586_b(hand);
        if (equipped == null) {
            return false;
        }
        return equipped.func_77973_b() instanceof IConduitItem;
    }

    public static boolean isProbeEquipped(EntityPlayer player, EnumHand hand) {
        EntityPlayer entityPlayer = player = player == null ? EnderIO.proxy.getClientPlayer() : player;
        if (player == null) {
            return false;
        }
        ItemStack equipped = player.func_184586_b(hand);
        if (equipped == null) {
            return false;
        }
        return equipped.func_77973_b() == ModObject.itemConduitProbe.getItem();
    }

    public static <T extends IConduit> T getConduit(World world, int x, int y, int z, Class<T> type) {
        return ConduitUtil.getConduit(world, new BlockPos(x, y, z), type);
    }

    public static <T extends IConduit> T getConduit(World world, BlockPos pos, Class<T> type) {
        if (world == null) {
            return null;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IConduitBundle) {
            IConduitBundle con = (IConduitBundle)te;
            return con.getConduit(type);
        }
        return null;
    }

    public static <T extends IConduit> T getConduit(World world, TileEntity te, EnumFacing dir, Class<T> type) {
        return ConduitUtil.getConduit(world, te.func_174877_v().func_177958_n() + dir.func_82601_c(), te.func_174877_v().func_177956_o() + dir.func_96559_d(), te.func_174877_v().func_177952_p() + dir.func_82599_e(), type);
    }

    public static <T extends IConduit> Collection<T> getConnectedConduits(World world, int x, int y, int z, Class<T> type) {
        return ConduitUtil.getConnectedConduits(world, new BlockPos(x, y, z), type);
    }

    public static <T extends IConduit> Collection<T> getConnectedConduits(World world, BlockPos pos, Class<T> type) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof IConduitBundle)) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>();
        IConduitBundle root = (IConduitBundle)te;
        T con = root.getConduit(type);
        if (con != null) {
            for (EnumFacing dir : con.getConduitConnections()) {
                T connected = ConduitUtil.getConduit(world, root.getEntity(), dir, type);
                if (connected == null) continue;
                result.add(connected);
            }
        }
        return result;
    }

    public static void writeToNBT(IConduit conduit, NBTTagCompound conduitRoot) {
        if (conduit == null) {
            return;
        }
        NBTTagCompound conduitBody = new NBTTagCompound();
        conduit.writeToNBT(conduitBody);
        conduitRoot.func_74778_a("conduitType", conduit.getClass().getCanonicalName());
        conduitRoot.func_74782_a("conduit", (NBTBase)conduitBody);
    }

    public static IConduit readConduitFromNBT(NBTTagCompound conduitRoot, short nbtVersion) {
        IConduit result;
        String typeName = conduitRoot.func_74779_i("conduitType");
        NBTTagCompound conduitBody = conduitRoot.func_74775_l("conduit");
        if (typeName == null || conduitBody == null) {
            return null;
        }
        if (typeName.contains("conduit.oc") && !OCUtil.isOCEnabled() || typeName.contains("conduit.me") && !MEUtil.isMEEnabled()) {
            return null;
        }
        try {
            result = (IConduit)Class.forName(typeName).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create an instance of the conduit with name: " + typeName, e);
        }
        result.readFromNBT(conduitBody, nbtVersion);
        return result;
    }

    public static boolean isRedstoneControlModeMet(IConduitBundle bundle, RedstoneControlMode mode, DyeColor col) {
        if (mode == RedstoneControlMode.IGNORE) {
            return true;
        }
        if (mode == RedstoneControlMode.NEVER) {
            return false;
        }
        if (mode == null) {
            return false;
        }
        int signalStrength = ConduitUtil.getInternalSignalForColor(bundle, col);
        if (signalStrength < 15 && DyeColor.RED == col && bundle != null && bundle.getEntity() != null) {
            TileEntity te = bundle.getEntity();
            signalStrength = Math.max(signalStrength, te.func_145831_w().func_175687_A(te.func_174877_v()));
        }
        return RedstoneControlMode.isConditionMet(mode, signalStrength);
    }

    public static int getInternalSignalForColor(IConduitBundle bundle, DyeColor col) {
        int signalStrength = 0;
        if (bundle == null) {
            return 0;
        }
        IRedstoneConduit rsCon = bundle.getConduit(IRedstoneConduit.class);
        if (rsCon != null) {
            Collection<Signal> signals = rsCon.getNetworkOutputs(null);
            for (Signal sig : signals) {
                if (sig.color != col || sig.strength <= signalStrength) continue;
                signalStrength = sig.strength;
            }
        }
        return signalStrength;
    }

    public static boolean isFluidValid(FluidStack fluidStack) {
        String name;
        return fluidStack != null && (name = FluidRegistry.getFluidName((FluidStack)fluidStack)) != null && !name.trim().isEmpty();
    }

    public static void openConduitGui(World world, BlockPos pos, EntityPlayer player) {
        ConduitUtil.openConduitGui(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), player);
    }

    public static void openConduitGui(World world, int x, int y, int z, EntityPlayer player) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (!(te instanceof TileConduitBundle)) {
            return;
        }
        IConduitBundle cb = (IConduitBundle)te;
        HashSet<EnumFacing> cons = new HashSet<EnumFacing>();
        boolean hasInsulated = false;
        for (IConduit con : cb.getConduits()) {
            cons.addAll(con.getExternalConnections());
            if (!(con instanceof IRedstoneConduit)) continue;
            hasInsulated = true;
        }
        if (cons.isEmpty() && !hasInsulated) {
            return;
        }
        if (cons.size() == 1) {
            EnumFacing facing = (EnumFacing)cons.iterator().next();
            GuiID.facing2guiid(facing).openGui(world, new BlockPos(x, y, z), player, facing);
            return;
        }
        GuiID.GUI_ID_EXTERNAL_CONNECTION_SELECTOR.openClientGui(world, new BlockPos(x, y, z), player, null);
    }

    public static void playBreakSound(SoundType snd, World world, int x, int y, int z) {
        if (world.field_72995_K) {
            ConduitUtil.playClientBreakSound(snd);
        }
    }

    private static void playClientBreakSound(SoundType snd) {
        FMLClientHandler.instance().getClientPlayerEntity().func_184185_a(snd.func_185845_c(), (snd.func_185843_a() + 1.0f) / 2.0f, snd.func_185847_b() * 0.8f);
    }

    public static void playHitSound(SoundType snd, World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            world.func_184134_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, snd.func_185844_d(), SoundCategory.BLOCKS, (snd.func_185843_a() + 1.0f) / 2.0f, snd.func_185847_b() * 0.8f, false);
        } else {
            ConduitUtil.playClientHitSound(snd);
        }
    }

    private static void playClientHitSound(SoundType snd) {
        FMLClientHandler.instance().getClientPlayerEntity().func_184185_a(snd.func_185844_d(), (snd.func_185843_a() + 1.0f) / 8.0f, snd.func_185847_b() * 0.5f);
    }

    public static void playStepSound(SoundType snd, World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            world.func_184134_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, snd.func_185844_d(), SoundCategory.BLOCKS, (snd.func_185843_a() + 1.0f) / 2.0f, snd.func_185847_b() * 0.8f, false);
        } else {
            ConduitUtil.playClientStepSound(snd);
        }
    }

    private static void playClientStepSound(SoundType snd) {
        FMLClientHandler.instance().getClientPlayerEntity().func_184185_a(snd.func_185844_d(), (snd.func_185843_a() + 1.0f) / 8.0f, snd.func_185847_b());
    }

    public static void playPlaceSound(SoundType snd, World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            world.func_184134_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, snd.func_185841_e(), SoundCategory.BLOCKS, (snd.func_185843_a() + 1.0f) / 2.0f, snd.func_185847_b() * 0.8f, false);
        } else {
            ConduitUtil.playClientPlaceSound(snd);
        }
    }

    private static void playClientPlaceSound(SoundType snd) {
        FMLClientHandler.instance().getClientPlayerEntity().func_184185_a(snd.func_185841_e(), (snd.func_185843_a() + 1.0f) / 8.0f, snd.func_185847_b());
    }
}

