/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio;

import com.enderio.core.common.BlockEnder;
import com.enderio.core.common.TileEntityBase;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.api.tool.ITool;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.tool.ToolUtil;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;

public abstract class BlockEio<T extends TileEntityEio>
extends BlockEnder<T> {
    protected String permissionNodeWrenching;

    protected BlockEio(@Nonnull String name, @Nullable Class<T> teClass) {
        super(name, teClass);
        this.func_149647_a(EnderIOTab.tabEnderIOMachines);
    }

    public void preInit(FMLPreInitializationEvent event) {
    }

    public void init(FMLInitializationEvent event) {
        this.permissionNodeWrenching = PermissionAPI.registerNode((String)(EnderIO.DOMAIN + ".wrench." + this.name.toLowerCase(Locale.ENGLISH)), (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)("Permission to wrench-break the block " + this.name + " of Ender IO"));
    }

    protected BlockEio(@Nonnull String name, @Nullable Class<T> teClass, @Nonnull Material mat) {
        super(name, teClass, mat);
        this.func_149647_a(EnderIOTab.tabEnderIOMachines);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityPlayer, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        ITool tool;
        if (this.shouldWrench(world, pos, entityPlayer, side) && ToolUtil.breakBlockWithTool((Block)this, world, pos, side, entityPlayer, heldItem, this.permissionNodeWrenching)) {
            return true;
        }
        TileEntityBase te = this.getTileEntity((IBlockAccess)world, pos);
        if (te instanceof AbstractMachineEntity && (tool = ToolUtil.getToolFromStack(heldItem)) != null && !entityPlayer.func_70093_af() && tool.canUse(heldItem, entityPlayer, pos)) {
            ((AbstractMachineEntity)te).toggleIoModeForFace(side);
            IBlockState bs = world.func_180495_p(pos);
            world.func_184138_a(pos, bs, bs, 3);
            return true;
        }
        return super.func_180639_a(world, pos, state, entityPlayer, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public boolean shouldWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side) {
        return true;
    }
}

