/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.network.message;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.blay09.mods.cookingforblockheads.registry.RecipeType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageCraftRecipe
implements IMessage {
    private ItemStack outputItem;
    private RecipeType recipeType;
    private List<ItemStack> craftMatrix;
    private boolean stack;

    public MessageCraftRecipe() {
    }

    public MessageCraftRecipe(ItemStack outputItem, RecipeType recipeType, List<ItemStack> craftMatrix, boolean stack) {
        this.outputItem = outputItem;
        this.recipeType = recipeType;
        this.craftMatrix = craftMatrix;
        this.stack = stack;
    }

    public void fromBytes(ByteBuf buf) {
        this.outputItem = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.recipeType = RecipeType.fromId(buf.readByte());
        int ingredientCount = buf.readByte();
        this.craftMatrix = Lists.newArrayListWithCapacity((int)ingredientCount);
        for (int i = 0; i < ingredientCount; ++i) {
            this.craftMatrix.add(ByteBufUtils.readItemStack((ByteBuf)buf));
        }
        this.stack = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.outputItem);
        buf.writeByte(this.recipeType.ordinal());
        buf.writeByte(this.craftMatrix.size());
        for (ItemStack itemstack : this.craftMatrix) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)itemstack);
        }
        buf.writeBoolean(this.stack);
    }

    public List<ItemStack> getCraftMatrix() {
        return this.craftMatrix;
    }

    public boolean isStack() {
        return this.stack;
    }

    public RecipeType getRecipeType() {
        return this.recipeType;
    }

    public ItemStack getOutputItem() {
        return this.outputItem;
    }
}

