/*
 * Decompiled with CFR 0.152.
 */
package com.primetoxinz.stacksonstacks.logic;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictUtil {
    public static String[] getItemStackOreNames(ItemStack stack) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        String[] names = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            names[i] = OreDictionary.getOreName((int)ids[i]);
        }
        return names;
    }

    public static String getOreDictionaryNameStartingWith(ItemStack stack, String start) {
        String value = null;
        if (stack != null) {
            List<String> names = Arrays.asList(OreDictUtil.getItemStackOreNames(stack));
            if (names.size() == 1 && names.get(0).startsWith(start)) {
                value = names.get(0);
            } else {
                Optional<String> ore = names.stream().filter(name -> name.startsWith(start)).findFirst();
                if (ore.isPresent()) {
                    value = ore.get();
                }
            }
        }
        return value;
    }

    public static ItemStack getCompressIngotBlock(ItemStack stack) {
        List blocks;
        String ingot = OreDictUtil.getOreDictionaryNameStartingWith(stack, "ingot");
        if (ingot != null && (blocks = OreDictionary.getOres((String)ingot.replace("ingot", "block"))) != null && !blocks.isEmpty()) {
            return (ItemStack)blocks.get(0);
        }
        return null;
    }
}

