/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.tweaks.minecart;

import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.charset.lib.utils.ColorUtils;
import pl.asie.charset.tweaks.ModCharsetTweaks;
import pl.asie.charset.tweaks.Tweak;
import pl.asie.charset.tweaks.minecart.MinecartDyeable;
import pl.asie.charset.tweaks.minecart.PacketMinecartRequest;
import pl.asie.charset.tweaks.minecart.PacketMinecartUpdate;

public class TweakDyeableMinecarts
extends Tweak {
    @CapabilityInject(value=MinecartDyeable.class)
    public static Capability<MinecartDyeable> MINECART_DYEABLE;
    public static ResourceLocation MINECART_DYEABLE_KEY;

    public TweakDyeableMinecarts() {
        super("additions", "dyeableMinecarts", "Dye minecarts by right-clicking them!", true);
    }

    @Override
    public boolean canTogglePostLoad() {
        return false;
    }

    @Override
    public void enable() {
        CapabilityManager.INSTANCE.register(MinecartDyeable.class, (Capability.IStorage)new Capability.IStorage<MinecartDyeable>(){

            public NBTBase writeNBT(Capability<MinecartDyeable> capability, MinecartDyeable instance, EnumFacing side) {
                if (instance != null) {
                    NBTTagCompound compound = new NBTTagCompound();
                    compound.func_74768_a("color", instance.getColor());
                    return compound;
                }
                return null;
            }

            public void readNBT(Capability<MinecartDyeable> capability, MinecartDyeable instance, EnumFacing side, NBTBase nbt) {
                NBTTagCompound compound;
                if (nbt instanceof NBTTagCompound && instance != null && (compound = (NBTTagCompound)nbt).func_74764_b("color")) {
                    instance.setColor(compound.func_74762_e("color"));
                }
            }
        }, MinecartDyeable.class);
        ModCharsetTweaks.proxy.initMinecartTweakClient();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void disable() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent event) {
        if (event.getObject() instanceof EntityMinecart) {
            event.addCapability(MINECART_DYEABLE_KEY, (ICapabilityProvider)new CapabilityProvider());
        }
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityMinecart) {
            PacketMinecartRequest.send((EntityMinecart)event.getEntity());
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        MinecartDyeable properties;
        if (!event.getTarget().field_70170_p.field_72995_K && event.getTarget() instanceof EntityMinecart && ColorUtils.isDye(event.getEntityPlayer().func_184586_b(event.getHand())) && (properties = MinecartDyeable.get((EntityMinecart)event.getTarget())) != null) {
            properties.setColor(ColorUtils.getRGBColor(ColorUtils.getColorIDFromDye(event.getEntityPlayer().func_184586_b(event.getHand()))));
            event.setCanceled(true);
            event.getEntityPlayer().func_184609_a(event.getHand());
            PacketMinecartUpdate.send((EntityMinecart)event.getTarget());
        }
    }

    static {
        MINECART_DYEABLE_KEY = new ResourceLocation("charsettweaks:minecart_dyeable");
    }

    public static class CapabilityProvider
    implements ICapabilityProvider,
    INBTSerializable<NBTTagCompound> {
        private final MinecartDyeable dyeable = new MinecartDyeable();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == MINECART_DYEABLE;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(capability == MINECART_DYEABLE ? this.dyeable : null);
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)MINECART_DYEABLE.writeNBT((Object)this.dyeable, null);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            MINECART_DYEABLE.readNBT((Object)this.dyeable, null, (NBTBase)nbt);
        }
    }
}

