/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.tweaks;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.charset.lib.ModCharsetLib;
import pl.asie.charset.tweaks.Tweak;

public class TweakMobControl
extends Tweak {
    private Set<Class<? extends Entity>> disabledClasses = new HashSet<Class<? extends Entity>>();
    private Configuration config;

    public TweakMobControl() {
        super("mobs", "mobControl", "Control mob spawning. Upon enabling, refer to 'tweaks-mobcontrol.cfg'.", false);
    }

    private void reloadConfig() {
        this.config = new Configuration(ModCharsetLib.instance.getConfigFile("tweaks-mobcontrol.cfg"));
        for (String s : EntityList.func_180124_b()) {
            boolean enabled;
            Class entity = (Class)EntityList.field_75625_b.get(s);
            if (entity == null || !EntityLiving.class.isAssignableFrom(entity) || (enabled = this.config.get("allow", s, true, null).getBoolean())) continue;
            this.disabledClasses.add(entity);
        }
        this.config.save();
    }

    @Override
    public void enable() {
        this.reloadConfig();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void disable() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @SubscribeEvent
    public void checkSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (this.disabledClasses.contains(event.getEntity().getClass())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void checkJoinWorld(EntityJoinWorldEvent event) {
        if (this.disabledClasses.contains(event.getEntity().getClass())) {
            event.setCanceled(true);
        }
    }
}

