/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.tweaks;

import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public abstract class Tweak {
    protected final String configCategory;
    protected final String configKey;
    protected final String configComment;
    protected final boolean isDefault;
    protected final int maxMode;
    protected int mode;

    public Tweak(String configCategory, String configKey, String configComment, boolean isDefault) {
        this(configCategory, configKey, configComment, isDefault, 0);
    }

    public Tweak(String configCategory, String configKey, String configComment, boolean isDefault, int maxMode) {
        this.configCategory = configCategory;
        this.configKey = configKey;
        this.configComment = configComment;
        this.isDefault = isDefault;
        this.maxMode = maxMode;
        this.mode = isDefault ? 1 : 0;
    }

    protected void initConfig(Configuration config) {
        ConfigCategory cc = config.getCategory(this.configCategory);
        if (!cc.containsKey(this.configKey)) {
            Property prop = this.maxMode <= 0 ? new Property(this.configKey, this.isDefault ? "true" : "false", Property.Type.BOOLEAN) : new Property(this.configKey, new Integer(this.maxMode).toString(), Property.Type.INTEGER);
            prop.setRequiresMcRestart(!this.canTogglePostLoad());
            cc.put(this.configKey, prop);
        }
    }

    public void onConfigChanged(Configuration config, boolean firstLaunch) {
        if (firstLaunch) {
            this.initConfig(config);
            this.mode = this.maxMode > 0 ? config.getInt(this.configKey, this.configCategory, this.isDefault ? 1 : 0, 0, this.maxMode, this.configComment) : (config.getBoolean(this.configKey, this.configCategory, this.isDefault, this.configComment) ? 1 : 0);
        } else if (this.canTogglePostLoad()) {
            int newMode;
            int n = this.maxMode > 0 ? config.getInt(this.configKey, this.configCategory, this.isDefault ? 1 : 0, 0, this.maxMode, this.configComment) : (newMode = config.getBoolean(this.configKey, this.configCategory, this.isDefault, this.configComment) ? 1 : 0);
            if (newMode != this.mode) {
                if (this.mode > 0) {
                    this.mode = 0;
                    this.disable();
                }
                if (newMode > 0) {
                    this.mode = newMode;
                    this.enable();
                }
            }
        }
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isEnabled() {
        return this.mode > 0;
    }

    public boolean canTogglePostLoad() {
        return true;
    }

    public boolean preInit() {
        return true;
    }

    public boolean init() {
        return true;
    }

    public void enable() {
    }

    public void disable() {
    }
}

