/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.tweaks;

import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.charset.lib.ModCharsetLib;
import pl.asie.charset.lib.network.PacketRegistry;
import pl.asie.charset.tweaks.ProxyCommon;
import pl.asie.charset.tweaks.Tweak;
import pl.asie.charset.tweaks.TweakDisableVanillaTools;
import pl.asie.charset.tweaks.TweakDoubleDoors;
import pl.asie.charset.tweaks.TweakGraphite;
import pl.asie.charset.tweaks.TweakMobControl;
import pl.asie.charset.tweaks.TweakNoSprinting;
import pl.asie.charset.tweaks.minecart.PacketMinecartRequest;
import pl.asie.charset.tweaks.minecart.PacketMinecartUpdate;
import pl.asie.charset.tweaks.minecart.TweakDyeableMinecarts;
import pl.asie.charset.tweaks.neptune.TweakZorro;
import pl.asie.charset.tweaks.shard.TweakGlassShards;
import pl.asie.charset.tweaks.tnt.TweakImprovedTNT;

@Mod(modid="CharsetTweaks", name="*", version="0.3.0-pre15", dependencies="required-after:Forge@[11.15.0.1715,);required-after:CharsetLib@0.3.0-pre15;after:mcmultipart", updateJSON="http://charset.asie.pl/update.json", acceptedMinecraftVersions="[1.10]")
public class ModCharsetTweaks {
    public static final String MODID = "CharsetTweaks";
    public static final String NAME = "*";
    public static final String VERSION = "0.3.0-pre15";
    public static PacketRegistry packet;
    @Mod.Instance(value="CharsetTweaks")
    public static ModCharsetTweaks instance;
    @SidedProxy(clientSide="pl.asie.charset.tweaks.ProxyClient", serverSide="pl.asie.charset.tweaks.ProxyCommon")
    public static ProxyCommon proxy;
    private Configuration configuration;
    private final Set<Tweak> tweakSet = new HashSet<Tweak>();
    private boolean canAddTweaks = true;

    public void addTweak(Tweak tweak) {
        if (this.canAddTweaks) {
            this.tweakSet.add(tweak);
        } else {
            ModCharsetLib.logger.error("Tried to add tweak too late, ignoring: " + tweak.getClass().getName());
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (!ModCharsetLib.moduleEnabled("tweaks")) {
            return;
        }
        this.tweakSet.add(new TweakDisableVanillaTools());
        this.tweakSet.add(new TweakDoubleDoors());
        this.tweakSet.add(new TweakDyeableMinecarts());
        this.tweakSet.add(new TweakGlassShards());
        this.tweakSet.add(new TweakGraphite());
        this.tweakSet.add(new TweakImprovedTNT());
        this.tweakSet.add(new TweakMobControl());
        this.tweakSet.add(new TweakNoSprinting());
        this.tweakSet.add(new TweakZorro());
        this.configuration = new Configuration(ModCharsetLib.instance.getConfigFile("tweaks.cfg"));
        this.canAddTweaks = false;
        for (Tweak t : this.tweakSet) {
            t.onConfigChanged(this.configuration, true);
            if (!t.isEnabled() || t.preInit()) continue;
            ModCharsetLib.logger.error("Tweak " + t.getClass().getSimpleName() + " failed to load! Please disable it in the config.");
            this.tweakSet.remove(t);
        }
        this.configuration.save();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (!ModCharsetLib.moduleEnabled("tweaks")) {
            return;
        }
        packet = new PacketRegistry(MODID);
        packet.registerPacket(1, PacketMinecartUpdate.class);
        packet.registerPacket(2, PacketMinecartRequest.class);
        for (Tweak t : this.tweakSet) {
            if (!t.isEnabled() || t.init()) continue;
            ModCharsetLib.logger.error("Tweak " + t.getClass().getSimpleName() + " failed to load! Please disable it in the config.");
            this.tweakSet.remove(t);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (!ModCharsetLib.moduleEnabled("tweaks")) {
            return;
        }
        for (Tweak t : this.tweakSet) {
            if (!t.isEnabled()) continue;
            t.enable();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (MODID.equals(event.getModID())) {
            for (Tweak t : this.tweakSet) {
                t.onConfigChanged(this.configuration, false);
            }
        }
    }
}

