/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.storage.crate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import pl.asie.charset.storage.crate.TileEntityCrate;

public class CrateShapeCache {
    private List<TileEntityCrate> crates = new ArrayList<TileEntityCrate>();
    private Set<BlockPos> positions = new HashSet<BlockPos>();
    private BlockPos posMin;
    private BlockPos posMax;
    private TileEntityCrate master;
    private boolean isValid = true;
    private boolean dirty = false;

    public CrateShapeCache() {
    }

    public CrateShapeCache(TileEntityCrate crate) {
        this();
        this.addRecursively(crate);
    }

    public IItemHandler getHandler() {
        return new Handler();
    }

    public void checkDirty() {
        if (this.dirty) {
            for (TileEntityCrate crate : this.crates) {
                crate.markBlockForUpdate();
            }
            this.dirty = false;
        }
    }

    public boolean contains(TileEntity o) {
        return this.crates.contains(o);
    }

    public boolean contains(BlockPos o) {
        return this.positions.contains(o);
    }

    public void invalidate() {
        this.isValid = false;
    }

    public boolean isValid() {
        if (this.isValid) {
            for (TileEntityCrate crate : this.crates) {
                if (!crate.func_145837_r()) continue;
                this.isValid = false;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean matches(TileEntityCrate crate) {
        if (crate == null) {
            return false;
        }
        if (this.master == null) {
            return true;
        }
        return ItemStack.func_77989_b((ItemStack)this.master.getMaterial(), (ItemStack)crate.getMaterial());
    }

    public boolean add(TileEntityCrate crate) {
        if (!this.matches(crate)) {
            return false;
        }
        BlockPos pos = crate.func_174877_v();
        if (this.master == null) {
            this.master = crate;
            this.posMin = this.posMax = pos;
        }
        if (this.positions.add(pos)) {
            this.crates.add(crate);
            if (pos.func_177958_n() <= this.posMin.func_177958_n() && pos.func_177956_o() <= this.posMin.func_177956_o() && pos.func_177952_p() <= this.posMin.func_177952_p()) {
                this.posMin = pos;
                this.master = crate;
            }
            if (pos.func_177958_n() >= this.posMax.func_177958_n() && pos.func_177956_o() >= this.posMax.func_177956_o() && pos.func_177952_p() >= this.posMax.func_177952_p()) {
                this.posMax = pos;
            }
            crate.setCache(this);
            this.dirty = true;
            return true;
        }
        return false;
    }

    public void addRecursively(TileEntityCrate crate) {
        if (this.add(crate)) {
            this.addNeighborsRecursively(crate);
        }
    }

    public void addNeighborsRecursively(TileEntityCrate crate) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntity tile = crate.getNeighbourTile(facing);
            if (!(tile instanceof TileEntityCrate)) continue;
            this.addRecursively((TileEntityCrate)tile);
        }
    }

    public class Handler
    implements IItemHandler {
        private final List<Integer> slotLookup = new ArrayList<Integer>(this.getSlots());

        public Handler() {
            for (int i = 0; i < this.getSlots(); ++i) {
                this.slotLookup.add(i);
            }
            Collections.shuffle(this.slotLookup);
        }

        public int getSlots() {
            return CrateShapeCache.this.crates.size() * 18;
        }

        public ItemStack getStackInSlot(int slotPre) {
            int slotPost = this.slotLookup.get(slotPre);
            TileEntityCrate crate = (TileEntityCrate)((Object)CrateShapeCache.this.crates.get(slotPost / 18));
            int slot = slotPost % 18;
            return crate.handler.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slotPre, ItemStack stack, boolean simulate) {
            int slotPost = this.slotLookup.get(slotPre);
            TileEntityCrate crate = (TileEntityCrate)((Object)CrateShapeCache.this.crates.get(slotPost / 18));
            int slot = slotPost % 18;
            return crate.handler.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slotPre, int amount, boolean simulate) {
            int slotPost = this.slotLookup.get(slotPre);
            TileEntityCrate crate = (TileEntityCrate)((Object)CrateShapeCache.this.crates.get(slotPost / 18));
            int slot = slotPost % 18;
            return crate.handler.extractItem(slot, amount, simulate);
        }
    }
}

